!  potential for fitting upper Varandas pes
      SUBROUTINE potv(V,R1,R2,xcos)

      IMPLICIT DOUBLE PRECISION (A-H,O-Y),logical(z)
      COMMON /MASS/ XMASS(3),G1,G2,xmassr(3)
      dimension pv(20),u(20)
      dimension ht(20)
!      DATA RZ/0.9576257   /,RHO/75.48992362  /
      DATA RZ/0.958600d0   /,the/104.480d0  /
      DATA TOANG/0.5291772d0/
      DATA X1/1.0D0/,X0/0.0D0/,TINY/9.0D-15/,X2/2.0D0/
      DATA pv/1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,&
     0.0,0.0,0.0,0.0,0.0,0.0,0.0/
      dimension rij(3)
      real*8 :: xp39(1:300),xpBu(1:300),xp(1:700)
      integer :: i_t,npropin

      pi=dacos(-1.d0)

      IF (G1 .EQ. X0) THEN
         Q1 = R1
         Q2 = R2
         THETA = ACOS(XCOS)
      ELSE IF (G2 .EQ. X0) THEN
         XX = R1 * G1
         YY = R1 * (X1 - G1)
         IF (R2 .EQ. X0 .OR. XCOS .GE. (X1 - TINY)) THEN
            Q1 = ABS(XX - R2)
            Q2 = (YY + R2)
            COST = -X1
         ELSE IF (XCOS .LE. (TINY - X1)) THEN
            Q1 = (XX + R2)
            Q2 = ABS(YY + R2)
            COST = X1
         ELSE
            Q1 = SQRT(XX*XX + R2*R2 - X2*XX*R2*XCOS)
            Q2 = SQRT(YY*YY + R2*R2 + X2*YY*R2*XCOS)
            COST = (Q1**2 + Q2**2 - R1**2) / (X2 * Q1 * Q2)
         ENDIF
         THETA = ACOS(COST)
      ELSE
         F1= X1/G1
         F2= X1/G2
         F12= X1 - F1*F2
         P1= R1*(X1-F1)/(G2*F12)
         P2= R2*(X1-F2)/(G1*F12)
         S1= R1-P1
         S2= R2-P2
         Q1= SQRT(P1*P1 + S2*S2 + X2*P1*S2*XCOS)/(X1-G1)
         Q2= SQRT(P2*P2 + S1*S1 + X2*P2*S1*XCOS)/(X1-G2)
         Q3= SQRT(P1*P1 + P2*P2 - X2*P1*P2*XCOS)
         COST = (Q1*Q1 + Q2*Q2 - Q3*Q3)/(X2*Q1*Q2)
         THETA = ACOS(COST)
      ENDIF

      THETAeq = the*3.141592654/180.d0
      Req= RZ/TOANG
      Y1 = R1 - Req
      Y2 = Cos(THETA) - Cos(THETAeq)
      Y3 = R2 - Req

      S1 = (Y1 + Y3)/2.0d0
      S2 =  Y2
      S3 = (Y1 - Y3)/2.0d0


! VD   is the MVD2 CORRECTION IN A.U
! VQ   is the QED CORRECTION IN A.U

      CALL PESleq6(VQ,Q1,Q2,THETA)
      CALL pesd2x(Vd,Q1,Q2,THETA)


call poten(Vv,Q1,Q2,THETA)

v=Vv/219474.634d0 + VQ + Vd 
      
     
!      if(Vv.lt.-1000.d0) then
!        print 1,'problems',Vv,att1,att2,THETA
!1       format(f10.0,3f10.3)
!      end if

end 




SUBROUTINE PESd2x(VR,x,y,z)
IMPLICIT DOUBLE PRECISION (A-H,O-Z)

!c This subroutine contains corrections to the water NBO PES due to the Darwin
!c 2 electrons term. Those corrections have been computed by Gyorgy
!c tarczay@para.chem.elte.hu
!c Those corrections are computed on the P&S grid of 325 points.
!c  (see J. chem. phys., 106 (1997) 4618), to which a few x points have been
!c added in irder to account to high bending modes. The final grid containd 341
!c  points.
!
!c  The input are in u.a., and X,Y are the distances of the H atoms from
!c  the oxygen, and Z is the angle HOH in radiants. The final result is in
!c  Hartree.

Seq=1.8240445d0
pi = dacos(-1.0d0)
e=1.809645d0
h=0.5d0
x1=x
y1=y
if (x.gt.3.5d0) x1=3.5d0
if (y.gt.3.5d0) y1=3.5d0

xm=x1-y1
xp=x1+y1
xp2=-e+h*xp
zm=-Seq+z

!   Potential  symmetrical in S1,S2,S3. Full set of
!   derivatives for each order (1-4) and upper terms for others

v1=-3263.067522028298-9.17958228916955*xm**2-                 &
0.5165611032611932*xm**4-0.5157212949525876*xm**6+               &
18.31161578215203*xp2+                                           &
30.14193751791963*xm**2*xp2-13.62543868575853*xm**4*xp2-         &
43.37232019119388*xp2**2-50.50353364079294*xm**2*xp2**2+         &
70.36441193443143*xm**4*xp2**2+27.43935454999898*xp2**3+         &
123.751990625258*xm**2*xp2**3-76.80240321256033*xm**4*xp2**3-    &
9.50017804016001*xp2**4-363.4487347625543*xm**2*xp2**4+          &
113.1940248029751*xp2**5+376.6560011408163*xm**2*xp2**5-         &
164.6523756673548*xp2**6+9.16256842998227*zm                     &
-1.22230095639504*xm**2*zm+1.33032571356463*xp2*                &
zm-0.94822119654751*xm**2*xp2*zm+0.7645470802285307*xm**4*xp2*   &
zm-11.77270680473595*xp2**2*zm-0.4065994514809928*xm**4*xp2**2*  &
zm-2.113651214829342*xp2**3*zm-3.653921741665064*xm**2*xp2**4*   &
zm+26.53983199106825*xp2**6*zm+3.099164302936567*zm**2
v2=-0.4668245990549825*xm**2*zm**2+0.05845413180128318*xm**4*zm**2 &
+2.708722250876111*xp2*zm**2-2.578482367020144*xm**2*xp2*zm**2-    &
0.1605392233404811*xm**4*xp2*zm**2-10.57780429022803*xp2**2*       &
zm**2-3.496293826717189*xp2**3*zm**2+23.46280699747645*xp2**4*     &
zm**2+1.8547816858377*zm**3-0.4003662844685243*xm**2*zm**3+        &
3.040229985315839*xp2*zm**3-4.955739113923876*xp2**2*              &
zm**3+14.05364889791468*xp2**3*zm**3-21.6926320924828*xp2**4*      &
zm**3-1.321464834042384*zm**4+2.298844571392118*xm**2*zm**4-       &
2.633405421645483*xp2*zm**4+20.97178840867901*xp2**2*              &
zm**4-32.18658937476802*xp2**3*zm**4-0.5992225949734171*zm**5+     &
2.059827452250273*xp2*zm**5+0.6453850286056735*xp2**2*             &
zm**5-0.4620689505336259*zm**6+0.7465042626807512*xp2*             &
zm**6-0.1254018119377959*zm**7+0.01947721364782498*zm**8

VR=V1+V2

!     SCALE AND SHIFT THE ZERO
VR=VR*1.0d-6
RETURN
END

SUBROUTINE PESleq6(V1,x,y,z)
IMPLICIT DOUBLE PRECISION (A-H,O-Z)

V1=-3514.850376005703+1.189315215135138*(x-y)**2+              &
-  0.824157459531989*(x-y)**4+0.03853108456851828*(x-y)**6+       &
-  12.83265590340491*(-1.809659+0.5*(x+y))-                       &
-  9.51736455454466*(x-y)**2*(-1.809659+0.5*(x+y))-               &
-  3.027576695974858*(x-y)**4*(-1.809659+0.5*(x+y))+              &
-  10.94033338777717*(-1.809659+0.5*(x+y))**2+                    &
-  15.53332877554612*(x-y)**2*(-1.809659+0.5*(x+y))**2+           &
-  6.063907309056958*(x-y)**4*(-1.809659+0.5*(x+y))**2-           &
-  13.79644533708051*(-1.809659+0.5*(x+y))**3-                    &
-  26.67549601926293*(x-y)**2*(-1.809659+0.5*(x+y))**3-           &
-  6.200836894255189*(x-y)**4*(-1.809659+0.5*(x+y))**3+           &
-  5.688103460541242*(-1.809659+0.5*(x+y))**4+                    &
-  52.9835500898771*(x-y)**2*(-1.809659+0.5*(x+y))**4-            &
-  11.88910471926647*(-1.809659+0.5*(x+y))**5-                    &
-  43.99657824332825*(x-y)**2*(-1.809659+0.5*(x+y))**5+           &
-  15.874512160015*(-1.809659+0.5*(x+y))**6-                      &
-  8.60706112101134*(-1.824045+z)+                                &
-  1.264485336667462*(x-y)**2*(-1.824045+z)-                      &
-  0.915127202947929*(-1.809659+0.5*(x+y))*(-1.824045+z)
v1=v1+  0.6556566908758441*(x-y)**2*(-1.809659+0.5*(x+y))*      &
-   (-1.824045+z)-                                                 &
-  0.813078328219753*(x-y)**4*(-1.809659+0.5*(x+y))*               &
-   (-1.824045+z)+                                                 &
-  12.42234678727481*(-1.809659+0.5*(x+y))**2*                     &
-   (-1.824045+z)+                                                 &
-  2.805488560712774*(x-y)**4*(-1.809659+0.5*(x+y))**2*            &
-   (-1.824045+z)-                                                 &
-  4.937250627623143*(-1.809659+0.5*(x+y))**3*                     &
-   (-1.824045+z)-                                                 &
-  3.095201035295474*(x-y)**2*(-1.809659+0.5*(x+y))**4*            &
-   (-1.824045+z)+                                                 &
-  18.85309150691318*(-1.809659+0.5*(x+y))**6*                     &
-   (-1.824045+z)-                                                 &
-  3.209703208057476*(-1.824045+z)**2+                             &
-  0.5360421552708203*(x-y)**2*(-1.824045+z)**2-                   &
-  0.263467844585989*(x-y)**4*(-1.824045+z)**2-                    &
-  1.13298516075929*(-1.809659+0.5*(x+y))*(-1.824045+z)**2
v1=v1-  0.06909229322445753*(x-y)**2*(-1.809659+0.5*(x+y))*     &
-   (-1.824045+z)**2+                                              &
-  1.649063526503709*(x-y)**4*(-1.809659+0.5*(x+y))*               &
-   (-1.824045+z)**2+                                              &
-  3.603611347474725*(-1.809659+0.5*(x+y))**2*                     &
-   (-1.824045+z)**2+                                              &
-  3.757418764813337*(-1.809659+0.5*(x+y))**3*                     &
-   (-1.824045+z)**2+                                              &
-  4.607672502246032*(-1.809659+0.5*(x+y))**4*                     &
-   (-1.824045+z)**2-                                              &
-  0.7490414640610651*(-1.824045+z)**3-                            &
-  0.0888181500794012*(x-y)**2*(-1.824045+z)**3-                   &
-  5.334303151299991*(-1.809659+0.5*(x+y))*                        &
-   (-1.824045+z)**3+                                              &
-  1.37948603262339*(-1.809659+0.5*(x+y))**2*                      &
-   (-1.824045+z)**3+                                              &
-  11.24395154910416*(-1.809659+0.5*(x+y))**3*                     &
-   (-1.824045+z)**3 -                                             &
-  17.85690001161674*(-1.809659+0.5*(x+y))**4*(-1.824045+z)**3
v1=v1+  0.7694433624551493*(-1.824045+z)**4-                    &
-  0.939662303404418*(x-y)**2*(-1.824045+z)**4-                    &
-  2.296000209594694*(-1.809659+0.5*(x+y))*                        &
-   (-1.824045+z)**4-                                              &
-  4.514249057965571*(-1.809659+0.5*(x+y))**2*                     &
-   (-1.824045+z)**4-                                              &
-  2.324765391545952*(-1.809659+0.5*(x+y))**3*                     &
-   (-1.824045+z)**4+                                              &
-  0.223711667169141*(-1.824045+z)**5+                             &
-  1.164515013150094*(-1.809659+0.5*(x+y))*                        &
-   (-1.824045+z)**5-                                              &
-  2.825913168656484*(-1.809659+0.5*(x+y))**2*                     &
-   (-1.824045+z)**5+                                              &
-  0.4811142779617512*(-1.824045+z)**6+                            &
-  1.292817090808966*(-1.809659+0.5*(x+y))*                        &
-   (-1.824045+z)**6+                                              &
-  0.1657130839026308*(-1.824045+z)**7-                            &
-  0.02192338698614548*(-1.824045+z)**8

v1=v1/1000000.0d0
RETURN
END




      subroutine poten(v,r1,r2,th)
      implicit none
      double precision,intent(in) ::  r1,r2,th
      double precision,intent(out)::  v
      double precision            :: reoh,thetae,alpha,bravo,appa,delta1,delta2,alpha1,alpha2
      double precision            :: xs1,xs2,xst
      double precision            :: rr1,rr2
      double precision            :: rrh,vp0,vp1,vp2,vp3,xep1,xep2,xep4
      double precision            :: vp,pi,v0,angle,damp,beta
      parameter                    (pi = 4.0d0 * atan2(1.0d0,1.0d0))

double precision :: b1, alphaoh, phh2,xep3,vhh,damptheta,vpoka
double precision :: e_zero, gamma, gamma_one, gamma_zero, Vlow,delta_energy, switch,Vup

double precision :: att1,att2,de,E0,ga,ga1,ga0,ffu,ffl, Vme,Vup1,Vup2


reoh=1.8141d0

thetae= 104.52d0*pi/180.0d0

rr1=r1-reoh
rr2=r2-reoh
rrh=dsqrt(r1**2+r2**2-2.d0*r1*r2*dcos(th))
xs1=(r1+r2)*0.5d0-reoh
xs2=(r1-r2)*0.5d0
xst=dcos(th)-dcos(thetae)


alpha1=1.24d0
delta1=0.427784424210D+05


bravo=-3.0d0
appa=0.683479329404D+06


rrh=dsqrt(r1**2+r2**2-2.d0*r1*r2*dcos(th))

xep1=delta1*(( 1.0d0 - (dexp(-alpha1*rr1))   )**2)
xep2=delta1*(( 1.0d0 - (dexp(-alpha1*rr2))   )**2)
xep3=appa*dexp(bravo*rrh)

damp=(0.999821745456D+00)*(dexp((-0.81d0)* ((rr1**2) + (rr2**2)) )  )
damptheta=tanh((20.0d0)*(th/thetae)-3.002002002d0)/2.002002002d0 + 0.5d0


     vp0=+(-0.11952745416414d+03)  *xs1** 0*xs2**0*xst** 0
     vp1=+(-0.48798137074984d+03)  *xs1** 0*xs2**0*xst** 1 &  
         +( 0.18010670744070d+05)  *xs1** 0*xs2**0*xst** 2 &  
         +( 0.21467970386090d+03)  *xs1** 0*xs2**0*xst** 3 &  
         +( 0.25946461915640d+04)  *xs1** 0*xs2**0*xst** 4 &  
         +( 0.70791862221097d+02)  *xs1** 0*xs2**0*xst** 5 & 
         +( 0.24281429590828d+04)  *xs1** 0*xs2**0*xst** 6 & 
         +(-0.65973619354189d+04)  *xs1** 0*xs2**0*xst** 7 & 
         +(-0.12552853340888d+05)  *xs1** 0*xs2**0*xst** 8 & 
         +( 0.24693831663424d+05)  *xs1** 0*xs2**0*xst** 9 & 
         +( 0.37435996529752d+05)  *xs1** 0*xs2**0*xst**10 &  
         +(-0.60315623692517d+05)  *xs1** 0*xs2**0*xst**11 &  
         +(-0.58903527449305d+05)  *xs1** 0*xs2**0*xst**12 &  
         +( 0.76475893471493d+05)  *xs1** 0*xs2**0*xst**13 &  
         +( 0.36628125289856d+05)  *xs1** 0*xs2**0*xst**14 &  
         +(-0.41534781934350d+05)  *xs1** 0*xs2**0*xst**15 &  
         +(-0.12466559832126d+05)  *xs1** 0*xs2**2*xst** 0 &  
         +(-0.61903240540851d+04)  *xs1** 0*xs2**2*xst** 1 &  
         +( 0.25981018577294d+05)  *xs1** 0*xs2**2*xst** 2 &  
         +(-0.20739969091916d+02)  *xs1** 0*xs2**2*xst** 3 &  
         +( 0.55537585913279d+04)  *xs1** 0*xs2**2*xst** 4 &  
         +(-0.22989112770912d+04)  *xs1** 0*xs2**2*xst** 5 &  
         +( 0.11923426320033d+05)  *xs1** 0*xs2**2*xst** 6 &  
         +( 0.16884387325070d+04)  *xs1** 0*xs2**2*xst** 7 &  
         +(-0.19900298039782d+05)  *xs1** 0*xs2**4*xst** 0 &  
         +(-0.62784048637945d+04)  *xs1** 0*xs2**4*xst** 1 &  
         +( 0.16179276611884d+05)  *xs1** 0*xs2**4*xst** 2 &  
         +(-0.22789676155983d+05)  *xs1** 0*xs2**4*xst** 3 &  
         +( 0.41198915933503d+04)  *xs1** 0*xs2**4*xst** 4 &  
         +( 0.36536598498687d+05)  *xs1** 0*xs2**6*xst** 0 &  
         +(-0.27982792051218d+05)  *xs1** 0*xs2**6*xst** 1 &  
         +(-0.16139030903949d+06)  *xs1** 0*xs2**6*xst** 2 &  
         +( 0.37350881966652d+06)  *xs1** 0*xs2**6*xst** 3 &  
         +( 0.36143258873972d+06)  *xs1** 0*xs2**6*xst** 4 &  
         +(-0.14886989607427d+06)  *xs1** 0*xs2**6*xst** 5 &  
         +(-0.63668679190446d+04)  *xs1** 0*xs2**6*xst** 6 &  
         +(-0.41044059199385d+05)  *xs1** 0*xs2**8*xst** 0 &  
         +( 0.13114096894801d+06)  *xs1** 0*xs2**8*xst** 1 &  
         +( 0.70886275473954d+06)  *xs1** 0*xs2**8*xst** 2 &  
         +(-0.11082949431518d+07)  *xs1** 0*xs2**8*xst** 3 &  
         +(-0.47459288316440d+06)  *xs1** 0*xs2**8*xst** 4 &  
         +( 0.61349256871269d+06)  *xs1** 0*xs2**8*xst** 5 &  
         +(-0.63862533212719d+06)  *xs1** 0*xs2**8*xst** 6 &  
         +( 0.18708491987175d+07)  *xs1** 0*xs2**8*xst** 7 &  
         +( 0.19546555731776d+06)  *xs1** 0*xs2**8*xst** 8 &  
         +(-0.28571930023426d+07)  *xs1** 0*xs2**8*xst** 9 &  
         +( 0.15378433721438d+04)  *xs1** 1*xs2**0*xst** 0 &  
         +(-0.12278382596719d+05)  *xs1** 1*xs2**0*xst** 1 &  
         +(-0.38791381611198d+04)  *xs1** 1*xs2**0*xst** 2 & 
         +(-0.43080144236500d+04)  *xs1** 1*xs2**0*xst** 3 & 
         +( 0.99301664083134d+02)  *xs1** 1*xs2**0*xst** 4 & 
         +( 0.77725075742642d+04)  *xs1** 1*xs2**0*xst** 5 & 
         +( 0.45135479070396d+05)  *xs1** 1*xs2**0*xst** 6 & 
         +(-0.65798617111446d+05)  *xs1** 1*xs2**0*xst** 7 &  
         +(-0.17180371721994d+06)  *xs1** 1*xs2**0*xst** 8 &  
         +( 0.20337551095116d+06)  *xs1** 1*xs2**0*xst** 9 &  
         +( 0.30001151912666d+06)  *xs1** 1*xs2**0*xst**10 &  
         +(-0.29461140862458d+06)  *xs1** 1*xs2**0*xst**11 &  
         +(-0.18528772761441d+06)  *xs1** 1*xs2**0*xst**12 &  
         +( 0.15986273384819d+06)  *xs1** 1*xs2**0*xst**13 &  
         +( 0.60218052368491d+05)  *xs1** 1*xs2**2*xst** 0 &  
         +(-0.89801568022924d+04)  *xs1** 1*xs2**2*xst** 1 &  
         +(-0.18397599110840d+05)  *xs1** 1*xs2**2*xst** 2 &  
         +(-0.43673553817572d+04)  *xs1** 1*xs2**2*xst** 3 &  
         +( 0.11828656824924d+04)  *xs1** 1*xs2**2*xst** 4 &  
         +(-0.35066129014265d+05)  *xs1** 1*xs2**2*xst** 5 &  
         +( 0.55859113966098d+05)  *xs1** 1*xs2**2*xst** 6 &  
         +(-0.34010982792096d+05)  *xs1** 1*xs2**4*xst** 0 &  
         +( 0.93291391379008d+04)  *xs1** 1*xs2**4*xst** 1 &  
         +( 0.23106511410031d+06)  *xs1** 1*xs2**4*xst** 2 &  
         +(-0.15886443613142d+06)  *xs1** 1*xs2**4*xst** 3 &  
         +(-0.28233708796405d+06)  *xs1** 1*xs2**4*xst** 4 &  
         +(-0.23478698729567d+06)  *xs1** 1*xs2**6*xst** 0 &  
         +( 0.64243624040091d+05)  *xs1** 1*xs2**6*xst** 1 &  
         +(-0.69094687869292d+06)  *xs1** 1*xs2**6*xst** 2 &  
         +(-0.91575984444559d+06)  *xs1** 1*xs2**6*xst** 3 &  
         +( 0.10325202929688d+06)  *xs1** 1*xs2**8*xst** 0 &  
         +(-0.88235643656420d+06)  *xs1** 1*xs2**8*xst** 1 &  
         +(-0.16773245550062d+07)  *xs1** 1*xs2**8*xst** 2 &  
         +( 0.37051207810370d+07)  *xs1** 1*xs2**8*xst** 3 &  
         +( 0.16044745453871d+07)  *xs1** 1*xs2**8*xst** 4 &  
         +(-0.18724034965948d+07)  *xs1** 1*xs2**8*xst** 5 &  
         +(-0.16952493422937d+05)  *xs1** 2*xs2**0*xst** 0 &  
         +( 0.40914777873282d+04)  *xs1** 2*xs2**0*xst** 1 &  
         +( 0.25523930044739d+05)  *xs1** 2*xs2**0*xst** 2 &  
         +(-0.22125750231439d+04)  *xs1** 2*xs2**0*xst** 3 &  
         +( 0.21574212396389d+05)  *xs1** 2*xs2**0*xst** 4 &  
         +(-0.57336943922219d+05)  *xs1** 2*xs2**0*xst** 5 &  
         +(-0.19966563328992d+06)  *xs1** 2*xs2**0*xst** 6 &  
         +( 0.29169974606454d+06)  *xs1** 2*xs2**0*xst** 7 &  
         +( 0.72799556472364d+06)  *xs1** 2*xs2**0*xst** 8 &  
         +(-0.84113506812757d+06)  *xs1** 2*xs2**0*xst** 9 &  
         +(-0.10842437455391d+07)  *xs1** 2*xs2**0*xst**10 &  
         +( 0.11343141586975d+07)  *xs1** 2*xs2**0*xst**11 &  
         +( 0.58539052539098d+06)  *xs1** 2*xs2**0*xst**12 &  
         +(-0.58694384673572d+06)  *xs1** 2*xs2**0*xst**13 &  
         +(-0.43366618451891d+05)  *xs1** 2*xs2**2*xst** 0 &  
         +( 0.10789931495411d+05)  *xs1** 2*xs2**2*xst** 1 &  
         +(-0.25996855009617d+05)  *xs1** 2*xs2**2*xst** 2 &  
         +(-0.32495148487693d+05)  *xs1** 2*xs2**2*xst** 3 &  
         +( 0.36189349865883d+06)  *xs1** 2*xs2**2*xst** 4 &  
         +( 0.15449525172212d+06)  *xs1** 2*xs2**2*xst** 5 &  
         +(-0.68820484675423d+06)  *xs1** 2*xs2**2*xst** 6 &  
         +( 0.80201898079921d+05)  *xs1** 2*xs2**2*xst** 7 &  
         +( 0.62033228325655d+06)  *xs1** 2*xs2**2*xst** 8 &  
         +(-0.59167896205156d+06)  *xs1** 2*xs2**2*xst** 9 &  
         +(-0.27240672882810d+05)  *xs1** 2*xs2**2*xst**10 &  
         +( 0.44959105182727d+06)  *xs1** 2*xs2**4*xst** 0 &  
         +(-0.80367313902597d+05)  *xs1** 2*xs2**4*xst** 1 &  
         +( 0.97321273390513d+05)  *xs1** 2*xs2**4*xst** 2 &  
         +( 0.63400473687277d+06)  *xs1** 2*xs2**4*xst** 3 &  
         +(-0.58975942421467d+06)  *xs1** 2*xs2**4*xst** 4 &  
         +( 0.32324292460354d+06)  *xs1** 2*xs2**6*xst** 0 &  
         +( 0.88712400601827d+06)  *xs1** 2*xs2**6*xst** 1 &  
         +( 0.35258403164242d+07)  *xs1** 2*xs2**6*xst** 2 & 
         +(-0.32887951845601d+06)  *xs1** 2*xs2**6*xst** 3 & 
         +(-0.21963245327014d+07)  *xs1** 2*xs2**6*xst** 4 & 
         +(-0.69503925582495d+06)  *xs1** 2*xs2**6*xst** 5 & 
         +( 0.42233660933432d+07)  *xs1** 2*xs2**6*xst** 6 & 
         +(-0.19493288798689d+05)  *xs1** 2*xs2**8*xst** 0 &  
         +( 0.13161675589183d+07)  *xs1** 2*xs2**8*xst** 1 &  
         +( 0.54690813687714d+06)  *xs1** 2*xs2**8*xst** 2 &  
         +(-0.36838616689303d+07)  *xs1** 2*xs2**8*xst** 3 &  
         +( 0.23437781630801d+05)  *xs1** 3*xs2**0*xst** 0 &  
         +(-0.12310007489744d+05)  *xs1** 3*xs2**0*xst** 1 &  
         +(-0.59276140406660d+04)  *xs1** 3*xs2**0*xst** 2 &  
         +(-0.13302258910939d+04)  *xs1** 3*xs2**0*xst** 3 &  
         +(-0.10668277687739d+04)  *xs1** 3*xs2**0*xst** 4 &  
         +( 0.63314638672005d+05)  *xs1** 3*xs2**0*xst** 5 &  
         +( 0.12389652880393d+06)  *xs1** 3*xs2**0*xst** 6 &  
         +(-0.14497982631961d+06)  *xs1** 3*xs2**0*xst** 7 &  
         +(-0.31771358756907d+06)  *xs1** 3*xs2**0*xst** 8 &  
         +(-0.71762917050234d+05)  *xs1** 3*xs2**0*xst** 9 &  
         +( 0.35881976582514d+06)  *xs1** 3*xs2**0*xst**10 &  
         +( 0.13239893782120d+06)  *xs1** 3*xs2**0*xst**11 &  
         +(-0.10677123664353d+06)  *xs1** 3*xs2**2*xst** 0 &  
         +(-0.34865602659425d+05)  *xs1** 3*xs2**2*xst** 1 &  
         +( 0.34934654327418d+06)  *xs1** 3*xs2**2*xst** 2 &  
         +(-0.35691233394705d+06)  *xs1** 3*xs2**2*xst** 3 &  
         +(-0.95354460525791d+06)  *xs1** 3*xs2**2*xst** 4 &  
         +( 0.50545756609829d+06)  *xs1** 3*xs2**2*xst** 5 &  
         +( 0.76532847552509d+06)  *xs1** 3*xs2**2*xst** 6 &  
         +(-0.86067042864647d+06)  *xs1** 3*xs2**4*xst** 0 &  
         +(-0.47094692545055d+06)  *xs1** 3*xs2**4*xst** 1 &  
         +(-0.39580021999597d+07)  *xs1** 3*xs2**4*xst** 2 &  
         +( 0.27519490513700d+07)  *xs1** 3*xs2**4*xst** 3 &  
         +( 0.48366849305671d+07)  *xs1** 3*xs2**4*xst** 4 &  
         +(-0.38517418404241d+07)  *xs1** 3*xs2**4*xst** 5 &  
         +( 0.91202830191097d+06)  *xs1** 3*xs2**4*xst** 6 &  
         +(-0.20137177550958d+05)  *xs1** 3*xs2**6*xst** 0 &  
         +(-0.27636540758785d+07)  *xs1** 3*xs2**6*xst** 1 &  
         +(-0.22073909684795d+07)  *xs1** 3*xs2**6*xst** 2 &  
         +(-0.10083196684448d+07)  *xs1** 3*xs2**6*xst** 3 &  
         +(-0.15525163784706d+07)  *xs1** 3*xs2**6*xst** 4 &  
         +( 0.18015693361831d+07)  *xs1** 3*xs2**6*xst** 5 &  
         +(-0.44076991724346d+07)  *xs1** 3*xs2**6*xst** 6 &  
         +( 0.14744342861414d+07)  *xs1** 3*xs2**6*xst** 7 &  
         +(-0.27312030972226d+05)  *xs1** 4*xs2**0*xst** 0 &  
         +(-0.44139966691404d+04)  *xs1** 4*xs2**0*xst** 1 &  
         +( 0.65624168216129d+04)  *xs1** 4*xs2**0*xst** 2 &  
         +( 0.29532410007785d+05)  *xs1** 4*xs2**0*xst** 3 &  
         +( 0.11628630865767d+04)  *xs1** 4*xs2**0*xst** 4 &  
         +(-0.17175212255491d+06)  *xs1** 4*xs2**0*xst** 5 &  
         +( 0.43884319018374d+06)  *xs1** 4*xs2**0*xst** 6 &  
         +(-0.12036547946414d+06)  *xs1** 4*xs2**0*xst** 7 &  
         +(-0.12262673238383d+07)  *xs1** 4*xs2**0*xst** 8 &  
         +( 0.11645089424261d+07)  *xs1** 4*xs2**0*xst** 9 &  
         +( 0.69257075114256d+06)  *xs1** 4*xs2**0*xst**10 &  
         +(-0.12938402385571d+07)  *xs1** 4*xs2**0*xst**11   
     vp2=+( 0.40163644753543d+06)  *xs1** 4*xs2**2*xst** 0 &  
         +( 0.27554795448973d+04)  *xs1** 4*xs2**2*xst** 1 &  
         +( 0.23384145273921d+06)  *xs1** 4*xs2**2*xst** 2 &  
         +( 0.44589200563341d+06)  *xs1** 4*xs2**2*xst** 3 &  
         +(-0.65077868416082d+06)  *xs1** 4*xs2**2*xst** 4 &  
         +(-0.51588959017665d+06)  *xs1** 4*xs2**2*xst** 5 &  
         +(-0.24580397771687d+06)  *xs1** 4*xs2**2*xst** 6 &  
         +(-0.22613475624799d+05)  *xs1** 4*xs2**2*xst** 7 &  
         +( 0.58265322479185d+06)  *xs1** 4*xs2**4*xst** 0 &  
         +( 0.20353358646916d+07)  *xs1** 4*xs2**4*xst** 1 &  
         +( 0.62386953319142d+07)  *xs1** 4*xs2**4*xst** 2 &  
         +(-0.61899471978072d+07)  *xs1** 4*xs2**4*xst** 3 &  
         +(-0.20319840312097d+07)  *xs1** 4*xs2**4*xst** 4 &  
         +( 0.42060707949794d+07)  *xs1** 4*xs2**4*xst** 5 &  
         +(-0.30419666921825d+07)  *xs1** 4*xs2**4*xst** 6 &  
         +( 0.64557553911512d+06)  *xs1** 4*xs2**4*xst** 7 &  
         +( 0.32996414404871d+06)  *xs1** 4*xs2**4*xst** 8 &  
         +(-0.16179566324549d+06)  *xs1** 4*xs2**6*xst** 0 &  
         +( 0.17345135252462d+07)  *xs1** 4*xs2**6*xst** 1 &  
         +(-0.21282788079814d+07)  *xs1** 4*xs2**6*xst** 2 &  
         +( 0.58193275921906d+07)  *xs1** 4*xs2**6*xst** 3 &  
         +( 0.29096519314703d+07)  *xs1** 4*xs2**6*xst** 4 &  
         +( 0.44312603725805d+07)  *xs1** 4*xs2**6*xst** 5 &  
         +(-0.33988571388861d+07)  *xs1** 4*xs2**6*xst** 6 &  
         +( 0.12333219349658d+05)  *xs1** 5*xs2**0*xst** 0 &  
         +(-0.28051589468281d+05)  *xs1** 5*xs2**0*xst** 1 &  
         +( 0.52773210143393d+05)  *xs1** 5*xs2**0*xst** 2 &  
         +(-0.12724013582650d+06)  *xs1** 5*xs2**0*xst** 3 &  
         +(-0.14214405513990d+06)  *xs1** 5*xs2**0*xst** 4 &  
         +( 0.12972265321493d+06)  *xs1** 5*xs2**0*xst** 5 &  
         +(-0.14493376499643d+05)  *xs1** 5*xs2**0*xst** 6 &  
         +( 0.52896778603114d+06)  *xs1** 5*xs2**0*xst** 7 &  
         +( 0.35064325943442d+06)  *xs1** 5*xs2**0*xst** 8 &  
         +(-0.58703722289491d+06)  *xs1** 5*xs2**2*xst** 0 &  
         +(-0.31238691348976d+06)  *xs1** 5*xs2**2*xst** 1 &  
         +(-0.21262103433333d+07)  *xs1** 5*xs2**2*xst** 2 &   
         +( 0.16235644818588d+07)  *xs1** 5*xs2**2*xst** 3 &  
         +( 0.34174892302347d+07)  *xs1** 5*xs2**2*xst** 4 &  
         +(-0.10265350519651d+07)  *xs1** 5*xs2**2*xst** 5 &  
         +(-0.10226400844455d+06)  *xs1** 5*xs2**4*xst** 0 &  
         +(-0.13504241926522d+07)  *xs1** 5*xs2**4*xst** 1 &  
         +( 0.10423234014342d+07)  *xs1** 5*xs2**4*xst** 2 &  
         +(-0.46651350207158d+07)  *xs1** 5*xs2**4*xst** 3 &  
         +(-0.39586205043925d+07)  *xs1** 5*xs2**4*xst** 4 &  
         +( 0.15677683324093d+07)  *xs1** 5*xs2**4*xst** 5 &  
         +(-0.24229934448603d+05)  *xs1** 6*xs2**0*xst** 0 &  
         +( 0.15316301560057d+06)  *xs1** 6*xs2**0*xst** 1 &  
         +(-0.56192525177671d+05)  *xs1** 6*xs2**0*xst** 2 &  
         +( 0.97122582938789d+05)  *xs1** 6*xs2**0*xst** 3 &  
         +( 0.15400774517778d+06)  *xs1** 6*xs2**0*xst** 4 &  
         +( 0.19712820677774d+06)  *xs1** 6*xs2**0*xst** 5 &  
         +(-0.58552764465250d+06)  *xs1** 6*xs2**0*xst** 6 &  
         +(-0.13033596801793d+07)  *xs1** 6*xs2**0*xst** 7 &  
         +( 0.98021792275343d+06)  *xs1** 6*xs2**0*xst** 8   
     vp3=+( 0.42853871675348d+06)  *xs1** 6*xs2**2*xst** 0 &  
         +( 0.61701890738790d+06)  *xs1** 6*xs2**2*xst** 1 &  
         +( 0.15592206360354d+07)  *xs1** 6*xs2**2*xst** 2 &  
         +(-0.22462346474349d+07)  *xs1** 6*xs2**2*xst** 3 &  
         +(-0.10280014051669d+07)  *xs1** 6*xs2**2*xst** 4 &  
         +( 0.41898889853358d+05)  *xs1** 6*xs2**2*xst** 5 &  
         +( 0.10982533872693d+06)  *xs1** 6*xs2**4*xst** 0 &  
         +(-0.10819552830850d+07)  *xs1** 6*xs2**4*xst** 1 &  
         +(-0.27530304672383d+07)  *xs1** 6*xs2**4*xst** 2 &  
         +( 0.91398646751301d+07)  *xs1** 6*xs2**4*xst** 3 &  
         +(-0.24040201367364d+07)  *xs1** 6*xs2**4*xst** 4 &  
         +(-0.14829725759249d+07)  *xs1** 6*xs2**4*xst** 5 &  
         +(-0.16548637118203d+07)  *xs1** 6*xs2**4*xst** 6 &  
         +( 0.71198508358542d+07)  *xs1** 6*xs2**4*xst** 7 &  
         +( 0.57870765185840d+05)  *xs1** 7*xs2**0*xst** 0 &  
         +(-0.28797034764368d+05)  *xs1** 7*xs2**0*xst** 1 &   
         +(-0.51659550752517d+05)  *xs1** 7*xs2**0*xst** 2 &  
         +( 0.18992006008593d+05)  *xs1** 7*xs2**0*xst** 3 &  
         +( 0.40653603867573d+05)  *xs1** 8*xs2**0*xst** 0 &  
         +(-0.83702724132762d+06)  *xs1** 8*xs2**0*xst** 1 &  
         +(-0.19846154785062d+06)  *xs1** 8*xs2**2*xst** 0 &   
         +(-0.23552882417236d+06)  *xs1** 9*xs2**0*xst** 0 &  
         +( 0.14273823492766d+07)  *xs1** 9*xs2**0*xst** 1 &  
         +( 0.51380084413648d+06)  *xs1** 9*xs2**0*xst** 2 &  
         +( 0.17786103207976d+06)  *xs1**10*xs2**0*xst** 0 &  
         +(-0.77310235823443d+06)  *xs1**10*xs2**0*xst** 1 &  
         +(-0.46598271085774d+06)  *xs1**10*xs2**0*xst** 2   




      att1=r1*0.5291772d0
      att2=r2*0.5291772d0


!!  CALL POKAZATEL PES


call poka_pes_low(Vlow,att1,att2,th)
call poka_pes_up(Vup,att1,att2,th)

      E0 = 35000.d0
      de = Vup-E0
      ga0=1.d0/500.d0
      ga1=1.d0/(500.d0**3)
      ga=ga0+ga1*(de**2)
      ffu=0.5d0*(1+dtanh(ga*de))
      ffl=0.5d0*(1+dtanh(-ga*de))
      vpoka=ffl*Vlow + ffu*Vup

vp=vp1+vp2+vp3
Vme=vp0 + vp*damp*damptheta + xep1 + xep2 + xep3



e_zero = 30000.0d0
gamma_zero = 1.0d0/500.0d0
gamma_one = 1.0d0/(500.0d0**3)
delta_energy = vpoka - e_zero
gamma = gamma_zero + (gamma_one)*(delta_energy**2)
switch = 0.5d0*(1.0d0 + dtanh(gamma*delta_energy))

v=Vme*(1.0d0-switch) + switch*vpoka


end subroutine poten


      subroutine poka_pes_low(v,r1,r2,th)
implicit none 

      double precision,intent(in) ::  r1,r2,th
      double precision,intent(out)::  v
      double precision            :: reoh,thetae,b1,roh,alphaoh
      double precision            :: phh2,t0,ut,x0,ut2,x02,xs1,xs2,xst,rs,rm,rr1,rr2,xep1,xep2,xep3
      double precision            :: rhh,vhh,vpb1,vpb2,v0,vp1,vp2,vp3,vp,vps1,vps2,y1,y2,y12,y22,voh1,voh2
      integer(4) :: i 
double precision :: alpha
           
           reoh=0.9586d0
           thetae=104.48d0
           b1=2.15d0
           alphaoh=0.0d0
           phh2=6.20164303995d0

      thetae=thetae*.314159265358979312d01*.00555555555555555555d0

      xs1=(r1+r2)*0.5d0-reoh
      xs2=(r1-r2)*0.5d0
      xst=dcos(th)-dcos(thetae)

      rr1=r1-reoh
      rr2=r2-reoh

         alpha=2.2668d0
         xep1=(dexp(-2.d0*alpha*rr1)-2.d0*dexp(-alpha*rr1))* & 
        (( 0.4389830771267D+05 )           +                      & 
         (-0.8606164763375D+03 )*rr1       +                    &                
         (+0.1746549380317D+05 )*rr1**2    +                    & 
         (-0.3326053761996D+05 )*rr1**3    +                    & 
         (+0.4988743744461D+04 )*rr1**4    +                    & 
         (+0.8751979626215D+04 )*rr1**5    +                    & 
         (-0.3770596827415D+04 )*rr1**6    +                    & 
         (+0.4270854122634D+03 )*rr1**7) + (0.4389830771267D+05  )

         xep2=(dexp(-2.d0*alpha*rr2)-2.d0*dexp(-alpha*rr2))* &  
        (( 0.4389830771267D+05 )          +                      & 
         (-0.8606164763375D+03 )*rr2      +                     & 
         (+0.1746549380317D+05 )*rr2**2   +                     & 
         (-0.3326053761996D+05 )*rr2**3   +                     & 
         (+0.4988743744461D+04 )*rr2**4   +                     & 
         (+0.8751979626215D+04 )*rr2**5   +                     & 
         (-0.3770596827415D+04 )*rr2**6   +                     & 
         (+0.4270854122634D+03 )*rr2**7) + (0.4389830771267D+05 )

         xep3=dexp(-b1*((r1-reoh)**2+(r2-reoh)**2))
         rhh=dsqrt(r1**2+r2**2-2.d0*r1*r2*dcos(th))
         vhh=0.820894739261131734D+06*dexp(-phh2*rhh)

     v0 =+(-0.659953027595d+02)  *xs1**0 *xs2**0 *xst**0    
     vp1=+(-0.267626467053d+03)  *xs1**0 *xs2**0 *xst**1  & 
         +(-0.379671480439d+03)  *xs1**1 *xs2**0 *xst**0  & 
         +( 0.189041489450d+05)  *xs1**0 *xs2**0 *xst**2  & 
         +( 0.140460964326d+05)  *xs1**0 *xs2**2 *xst**0  & 
         +(-0.244773589258d+05)  *xs1**1 *xs2**0 *xst**1  & 
         +(-0.118082957373d+04)  *xs1**2 *xs2**0 *xst**0  &  
         +( 0.794206366785d+03)  *xs1**0 *xs2**0 *xst**3  &  
         +(-0.200038236606d+05)  *xs1**0 *xs2**2 *xst**1  &  
         +(-0.964459699741d+04)  *xs1**1 *xs2**0 *xst**2  &  
         +(-0.569234216915d+05)  *xs1**1 *xs2**2 *xst**0  &  
         +( 0.207770187756d+05)  *xs1**2 *xs2**0 *xst**1  &  
         +(-0.124352975569d+05)  *xs1**3 *xs2**0 *xst**0  &  
         +( 0.307089207812d+04)  *xs1**0 *xs2**0 *xst**4  &  
         +( 0.631039722826d+05)  *xs1**0 *xs2**2 *xst**2  &  
         +( 0.624164338792d+05)  *xs1**0 *xs2**4 *xst**0  &  
         +(-0.827377763750d+04)  *xs1**1 *xs2**0 *xst**3  &  
         +(-0.272878920115d+05)  *xs1**1 *xs2**2 *xst**1  &  
         +( 0.690825653791d+05)  *xs1**2 *xs2**0 *xst**2  &  
         +( 0.448771494021d+05)  *xs1**2 *xs2**2 *xst**0  &  
         +(-0.700297130808d+05)  *xs1**3 *xs2**0 *xst**1  &  
         +(-0.425295810171d+05)  *xs1**4 *xs2**0 *xst**0  &  
         +(-0.105203561801d+04)  *xs1**0 *xs2**0 *xst**5  &  
         +(-0.104193201906d+05)  *xs1**0 *xs2**2 *xst**3  &  
         +(-0.583271653609d+05)  *xs1**0 *xs2**4 *xst**1  &  
         +( 0.102736674333d+05)  *xs1**1 *xs2**0 *xst**4  &  
         +(-0.390903339233d+05)  *xs1**1 *xs2**2 *xst**2  &  
         +( 0.193815090236d+04)  *xs1**1 *xs2**4 *xst**0  &  
         +(-0.278233241367d+05)  *xs1**2 *xs2**0 *xst**3  &  
         +(-0.600726394421d+05)  *xs1**2 *xs2**2 *xst**1  &  
         +(-0.128955657575d+05)  *xs1**3 *xs2**0 *xst**2  &  
         +( 0.203346071653d+06)  *xs1**3 *xs2**2 *xst**0  &  
         +( 0.579099523941d+05)  *xs1**4 *xs2**0 *xst**1  &  
         +( 0.119508454093d+06)  *xs1**5 *xs2**0 *xst**0  &  
         +( 0.914045546439d+03)  *xs1**0 *xs2**0 *xst**6  &  
         +( 0.282778644257d+05)  *xs1**0 *xs2**2 *xst**4  &  
         +( 0.115072022895d+06)  *xs1**0 *xs2**4 *xst**2  &  
         +( 0.912491015342d+05)  *xs1**0 *xs2**6 *xst**0  &  
         +(-0.100569779614d+05)  *xs1**1 *xs2**0 *xst**5  &  
         +(-0.433468768117d+03)  *xs1**1 *xs2**2 *xst**3  &  
         +(-0.379077341081d+05)  *xs1**1 *xs2**4 *xst**1  &  
         +( 0.933359436158d+04)  *xs1**2 *xs2**0 *xst**4  &  
         +( 0.260904518698d+06)  *xs1**2 *xs2**2 *xst**2  &  
         +(-0.285199619823d+06)  *xs1**2 *xs2**4 *xst**0  &  
         +( 0.344509141500d+05)  *xs1**3 *xs2**0 *xst**3  &  
         +(-0.640873128018d+05)  *xs1**3 *xs2**2 *xst**1  &  
         +( 0.924469359327d+05)  *xs1**4 *xs2**0 *xst**2  &  
         +(-0.131742587453d+06)  *xs1**4 *xs2**2 *xst**0  &  
         +(-0.186335830773d+06)  *xs1**5 *xs2**0 *xst**1  &  
         +(-0.260704846844d+06)  *xs1**6 *xs2**0 *xst**0  &  
         +( 0.997058976452d+03)  *xs1**0 *xs2**0 *xst**7  &  
         +( 0.232633890308d+05)  *xs1**0 *xs2**2 *xst**5  &  
         +(-0.196052908342d+05)  *xs1**0 *xs2**4 *xst**3  &  
         +(-0.730401648470d+04)  *xs1**0 *xs2**6 *xst**1  &  
         +(-0.393745773509d+04)  *xs1**1 *xs2**0 *xst**6  &  
         +(-0.752888520820d+05)  *xs1**1 *xs2**2 *xst**4  &  
         +(-0.268034113638d+05)  *xs1**1 *xs2**4 *xst**2  &  
         +( 0.629265475057d+05)  *xs1**1 *xs2**6 *xst**0  &  
         +( 0.419308603612d+05)  *xs1**2 *xs2**0 *xst**5  &  
         +(-0.401260241167d+05)  *xs1**2 *xs2**2 *xst**3  &  
         +( 0.173117805574d+05)  *xs1**2 *xs2**4 *xst**1  &  
         +(-0.357920672236d+05)  *xs1**3 *xs2**0 *xst**4  &  
         +(-0.175632911624d+06)  *xs1**3 *xs2**2 *xst**2  &  
         +(-0.124119027044d+05)  *xs1**3 *xs2**4 *xst**0  &  
         +(-0.162327225347d+06)  *xs1**4 *xs2**0 *xst**3  &  
         +( 0.666111385374d+05)  *xs1**4 *xs2**2 *xst**1  &  
         +(-0.934941015036d+04)  *xs1**5 *xs2**0 *xst**2  &  
         +(-0.108930581619d+06)  *xs1**5 *xs2**2 *xst**0  &  
         +( 0.803430397080d+05)  *xs1**6 *xs2**0 *xst**1  &  
         +( 0.551216208020d+05)  *xs1**7 *xs2**0 *xst**0  &  
         +(-0.637131347940d+03)  *xs1**0 *xs2**0 *xst**8  &  
         +(-0.534236884995d+04)  *xs1**0 *xs2**2 *xst**6  &  
         +( 0.138381066792d+06)  *xs1**0 *xs2**4 *xst**4  &  
         +(-0.922486286763d+05)  *xs1**0 *xs2**6 *xst**2  &  
         +( 0.179764650403d+06)  *xs1**0 *xs2**8 *xst**0  &  
         +( 0.118898094426d+05)  *xs1**1 *xs2**0 *xst**7  &  
         +(-0.177215597032d+06)  *xs1**1 *xs2**2 *xst**5  &  
         +(-0.356930640892d+05)  *xs1**1 *xs2**4 *xst**3  &  
         +( 0.755041119364d+04)  *xs1**1 *xs2**6 *xst**1  &  
         +(-0.290392672514d+05)  *xs1**2 *xs2**0 *xst**6  &  
         +( 0.244159624991d+06)  *xs1**2 *xs2**2 *xst**4  &  
         +(-0.475812790268d+05)  *xs1**2 *xs2**4 *xst**2  &  
         +( 0.936270266953d+05)  *xs1**2 *xs2**6 *xst**0  &  
         +( 0.609975005813d+05)  *xs1**3 *xs2**0 *xst**5  &  
         +( 0.715142276749d+05)  *xs1**3 *xs2**2 *xst**3  &  
         +( 0.181012923482d+05)  *xs1**3 *xs2**4 *xst**1  &  
         +( 0.371402984974d+05)  *xs1**4 *xs2**0 *xst**4  &  
         +(-0.121023068573d+06)  *xs1**4 *xs2**2 *xst**2  &  
         +(-0.803285248691d+04)  *xs1**4 *xs2**4 *xst**0  &  
         +( 0.699293129706d+05)  *xs1**5 *xs2**0 *xst**3  &  
         +( 0.170439166831d+05)  *xs1**5 *xs2**2 *xst**1  &  
         +( 0.349210282406d+05)  *xs1**6 *xs2**0 *xst**2     
     vp2=+(-0.481731877958d+05)  *xs1**6 *xs2**2 *xst**0  &  
         +( 0.700504342926d+05)  *xs1**7 *xs2**0 *xst**1  &  
         +( 0.718145611664d+05)  *xs1**8 *xs2**0 *xst**0  &  
         +(-0.160801299102d+04)  *xs1**0 *xs2**0 *xst**9  &  
         +(-0.261505141105d+05)  *xs1**0 *xs2**2 *xst**7  &  
         +(-0.119083742803d+06)  *xs1**0 *xs2**4 *xst**5  &  
         +(-0.140394967276d+05)  *xs1**0 *xs2**6 *xst**3  &  
         +( 0.161367960587d+05)  *xs1**0 *xs2**8 *xst**1  &  
         +( 0.736867629679d+04)  *xs1**1 *xs2**0 *xst**8  &  
         +( 0.239484202937d+06)  *xs1**1 *xs2**2 *xst**6  &  
         +( 0.953962591537d+05)  *xs1**1 *xs2**4 *xst**4  &  
         +(-0.256451196387d+05)  *xs1**1 *xs2**6 *xst**2  &  
         +( 0.900281166220d+05)  *xs1**1 *xs2**8 *xst**0  &  
         +(-0.118683497326d+06)  *xs1**2 *xs2**0 *xst**7  &  
         +(-0.268008747548d+04)  *xs1**2 *xs2**2 *xst**5  &  
         +( 0.233681530161d+04)  *xs1**2 *xs2**4 *xst**3  &  
         +( 0.188047078585d+05)  *xs1**2 *xs2**6 *xst**1  &  
         +( 0.268002135964d+06)  *xs1**3 *xs2**0 *xst**6  &  
         +(-0.994061302498d+04)  *xs1**3 *xs2**2 *xst**4  &  
         +(-0.229201922586d+05)  *xs1**3 *xs2**4 *xst**2  &  
         +( 0.365258859028d+05)  *xs1**3 *xs2**6 *xst**0  &  
         +(-0.115494004753d+06)  *xs1**4 *xs2**0 *xst**5  &  
         +( 0.937920452168d+04)  *xs1**4 *xs2**2 *xst**3  &  
         +(-0.252654332588d+04)  *xs1**4 *xs2**4 *xst**1  &  
         +( 0.248598551118d+05)  *xs1**5 *xs2**0 *xst**4  &  
         +(-0.526427733797d+05)  *xs1**5 *xs2**2 *xst**2  &  
         +(-0.346349112933d+05)  *xs1**5 *xs2**4 *xst**0  &  
         +( 0.976370323248d+05)  *xs1**6 *xs2**0 *xst**3  &  
         +(-0.467899303572d+04)  *xs1**6 *xs2**2 *xst**1  &  
         +( 0.469168176621d+05)  *xs1**7 *xs2**0 *xst**2  &  
         +(-0.517896261518d+05)  *xs1**7 *xs2**2 *xst**0  &  
         +( 0.451708657972d+05)  *xs1**8 *xs2**0 *xst**1  &  
         +( 0.499370621569d+05)  *xs1**9 *xs2**0 *xst**0  &  
         +( 0.522705656566d+05)  *xs1**0 *xs2**2 *xst**8  &   
         +(-0.166949276855d+06)  *xs1**0 *xs2**4 *xst**6  &  
         +( 0.382170393021d+05)  *xs1**0 *xs2**6 *xst**4  &  
         +(-0.150879660998d+05)  *xs1**0 *xs2**8 *xst**2  &  
         +(-0.426712400425d+04)  *xs1**1 *xs2**0 *xst**9  &  
         +(-0.133679843800d+06)  *xs1**1 *xs2**2 *xst**7  &   
         +(-0.265276256217d+05)  *xs1**1 *xs2**4 *xst**5  &  
         +(-0.127467690103d+04)  *xs1**1 *xs2**6 *xst**3  &  
         +( 0.132298301894d+05)  *xs1**1 *xs2**8 *xst**1  &  
         +( 0.540120973102d+05)  *xs1**2 *xs2**0 *xst**8  &  
         +( 0.267909832663d+06)  *xs1**2 *xs2**2 *xst**6  &  
         +( 0.292671239452d+05)  *xs1**2 *xs2**4 *xst**4  &  
         +(-0.436068995487d+04)  *xs1**2 *xs2**6 *xst**2  &  
         +(-0.219906296322d+06)  *xs1**3 *xs2**0 *xst**7  &  
         +( 0.346706196241d+05)  *xs1**3 *xs2**2 *xst**5  &  
         +( 0.138100599987d+05)  *xs1**3 *xs2**4 *xst**3  &  
         +( 0.616066423890d+04)  *xs1**3 *xs2**6 *xst**1  &  
         +(-0.404306371164d+05)  *xs1**4 *xs2**0 *xst**6  &  
         +(-0.114955065272d+05)  *xs1**4 *xs2**2 *xst**4  &  
         +(-0.111526585220d+05)  *xs1**4 *xs2**4 *xst**2  &  
         +( 0.224134744735d+05)  *xs1**5 *xs2**0 *xst**5  &  
         +( 0.108232688886d+05)  *xs1**5 *xs2**2 *xst**3  &  
         +( 0.356907588711d+04)  *xs1**5 *xs2**4 *xst**1  &  
         +( 0.720001614702d+05)  *xs1**6 *xs2**0 *xst**4  &  
         +(-0.200209480357d+05)  *xs1**6 *xs2**2 *xst**2  &  
         +(-0.888067505885d+04)  *xs1**6 *xs2**4 *xst**0  &  
         +( 0.858859430470d+05)  *xs1**7 *xs2**0 *xst**3  &  
         +(-0.230430506950d+04)  *xs1**7 *xs2**2 *xst**1  &  
         +( 0.401640020631d+05)  *xs1**8 *xs2**0 *xst**2  &  
         +(-0.167062650942d+05)  *xs1**8 *xs2**2 *xst**0  &  
         +( 0.282618455196d+05)  *xs1**9 *xs2**0 *xst**1  &  
         +(-0.351455267238d+04)  *xs1**10*xs2**0 *xst**0  &  
         +( 0.535815245783d+04)  *xs1**0 *xs2**2 *xst**9  &  
         +( 0.872381885535d+04)  *xs1**0 *xs2**4 *xst**7  &  
         +( 0.168033263714d+04)  *xs1**0 *xs2**6 *xst**5  &  
         +( 0.827981464589d+03)  *xs1**0 *xs2**8 *xst**3  &   
         +( 0.633856765152d+03)  *xs1**0 *xs2**10*xst**1  &  
         +( 0.539027926754d+04)  *xs1**1 *xs2**0 *xst**10 &  
         +(-0.247731549508d+05)  *xs1**1 *xs2**2 *xst**8  &  
         +( 0.317697777160d+04)  *xs1**1 *xs2**4 *xst**6  &  
         +( 0.113909363756d+04)  *xs1**1 *xs2**6 *xst**4  &  
         +( 0.754385873292d+03)  *xs1**1 *xs2**8 *xst**2  &   
         +(-0.600546351529d+04)  *xs1**1 *xs2**10*xst**0  &  
         +(-0.134288826831d+03)  *xs1**2 *xs2**0 *xst**9  &  
         +( 0.174539538698d+04)  *xs1**2 *xs2**2 *xst**7  &  
         +( 0.171084750089d+04)  *xs1**2 *xs2**4 *xst**5  &  
         +(-0.144127458958d+03)  *xs1**2 *xs2**6 *xst**3  &  
         +( 0.594073986891d+03)  *xs1**2 *xs2**8 *xst**1  &   
         +(-0.298574274230d+05)  *xs1**3 *xs2**0 *xst**8     
     vp3=+( 0.125735696367d+04)  *xs1**3 *xs2**2 *xst**6  &  
         +( 0.356652162112d+04)  *xs1**3 *xs2**4 *xst**4  &  
         +(-0.112228339407d+04)  *xs1**3 *xs2**6 *xst**2  &  
         +(-0.379286800217d+04)  *xs1**3 *xs2**8 *xst**0  &  
         +(-0.797245034520d+04)  *xs1**4 *xs2**0 *xst**7  &  
         +( 0.850117168612d+03)  *xs1**4 *xs2**2 *xst**5  &  
         +( 0.655204975733d+03)  *xs1**4 *xs2**4 *xst**3  &  
         +(-0.172999333089d+04)  *xs1**4 *xs2**6 *xst**1  &  
         +(-0.580311488511d+03)  *xs1**5 *xs2**0 *xst**6  &  
         +( 0.602106533817d+04)  *xs1**5 *xs2**2 *xst**4  &  
         +(-0.643207468850d+03)  *xs1**5 *xs2**4 *xst**2  &  
         +(-0.388447460058d+04)  *xs1**5 *xs2**6 *xst**0  &  
         +(-0.568870068412d+03)  *xs1**6 *xs2**0 *xst**5  &  
         +( 0.185921288921d+04)  *xs1**6 *xs2**2 *xst**3  &  
         +(-0.158474975900d+04)  *xs1**6 *xs2**4 *xst**1  &  
         +( 0.253995524411d+04)  *xs1**7 *xs2**0 *xst**4  &  
         +( 0.245255583284d+03)  *xs1**7 *xs2**2 *xst**2  &  
         +( 0.334609754048d+03)  *xs1**8 *xs2**0 *xst**3  &  
         +(-0.136761213322d+04)  *xs1**8 *xs2**2 *xst**1  &  
         +( 0.199462447923d+04)  *xs1**9 *xs2**0 *xst**2  &  
         +(-0.381718226701d+04)  *xs1**9 *xs2**2 *xst**0  &  
         +(-0.195172248408d+04)  *xs1**10*xs2**0 *xst**1  &  
         +(-0.621280556249d+04)  *xs1**11*xs2**0 *xst**0  &  
         +(-0.588126213804d+03)  *xs1**0 *xs2**0 *xst**2  &  
         +(-0.136626406626d+04)  *xs1**0 *xs2**2 *xst**0  &  
         +( 0.300613895916d+04)  *xs1**0 *xs2**4 *xst**8  &  
         +( 0.590881741181d+03)  *xs1**0 *xs2**6 *xst**6  &  
         +( 0.222272447714d+03)  *xs1**0 *xs2**8 *xst**4  &   
         +( 0.268423744188d+03)  *xs1**0 *xs2**10*xst**2  &  
         +( 0.407353762269d+03)  *xs1**0 *xs2**12*xst**0  &  
         +(-0.103444184173d+05)  *xs1**1 *xs2**0 *xst**11 &  
         +( 0.103287422463d+04)  *xs1**1 *xs2**2 *xst**9  &  
         +( 0.168248908769d+04)  *xs1**1 *xs2**4 *xst**7  &  
         +( 0.326024860192d+03)  *xs1**1 *xs2**6 *xst**5  &  
         +( 0.138553671895d+03)  *xs1**1 *xs2**8 *xst**3  &  
         +( 0.176426982150d+03)  *xs1**1 *xs2**10*xst**1  &  
         +( 0.381560895223d+05)  *xs1**2 *xs2**0 *xst**10 &  
         +(-0.179193402836d+04)  *xs1**2 *xs2**2 *xst**8  &  
         +( 0.113976105068d+03)  *xs1**2 *xs2**4 *xst**6  &  
         +( 0.205856286554d+03)  *xs1**2 *xs2**6 *xst**4  &  
         +( 0.205645535612d+03)  *xs1**2 *xs2**8 *xst**2  &  
         +( 0.312170506022d+03)  *xs1**2 *xs2**10*xst**0  &  
         +(-0.241987377812d+04)  *xs1**3 *xs2**0 *xst**9  &  
         +(-0.271307185359d+03)  *xs1**3 *xs2**2 *xst**7  &  
         +( 0.185556848044d+03)  *xs1**3 *xs2**4 *xst**5  &  
         +( 0.106146090045d+03)  *xs1**3 *xs2**6 *xst**3  &  
         +( 0.144581177964d+03)  *xs1**3 *xs2**8 *xst**1  &  
         +(-0.687280201359d+04)  *xs1**4 *xs2**0 *xst**8  &  
         +(-0.613309111735d+03)  *xs1**4 *xs2**2 *xst**6  &  
         +( 0.193478580517d+03)  *xs1**4 *xs2**4 *xst**4  &  
         +( 0.193652770936d+03)  *xs1**4 *xs2**6 *xst**2  &  
         +( 0.214627213340d+03)  *xs1**4 *xs2**8 *xst**0  &  
         +(-0.243992596380d+04)  *xs1**5 *xs2**0 *xst**7  &  
         +(-0.176182322915d+03)  *xs1**5 *xs2**2 *xst**5  &  
         +( 0.734544203756d+02)  *xs1**5 *xs2**4 *xst**3  &  
         +( 0.161365430979d+03)  *xs1**5 *xs2**6 *xst**1  &  
         +(-0.405620941776d+03)  *xs1**6 *xs2**0 *xst**6  &  
         +( 0.830076925571d+02)  *xs1**6 *xs2**2 *xst**4  &  
         +( 0.157072485959d+03)  *xs1**6 *xs2**4 *xst**2  &  
         +( 0.961839158128d+02)  *xs1**6 *xs2**6 *xst**0  &  
         +( 0.346857663997d+03)  *xs1**7 *xs2**0 *xst**5  &  
         +( 0.130059723352d+03)  *xs1**7 *xs2**2 *xst**3  &  
         +( 0.131795093317d+03)  *xs1**7 *xs2**4 *xst**1  &  
         +( 0.806185674075d+03)  *xs1**8 *xs2**0 *xst**4  &  
         +( 0.240451004043d+03)  *xs1**8 *xs2**2 *xst**2  &  
         +( 0.172603600420d+03)  *xs1**8 *xs2**4 *xst**0  &  
         +( 0.569719449653d+03)  *xs1**9 *xs2**0 *xst**3  &        
         +( 0.161687174062d+03)  *xs1**9 *xs2**2 *xst**1  &       
         +( 0.603793707604d+03)  *xs1**10*xs2**0 *xst**2  &       
         +( 0.309950546065d+03)  *xs1**10*xs2**2 *xst**0  &       
         +( 0.466618064731d+03)  *xs1**11*xs2**0 *xst**1  &       
         +( 0.831515687244d+03)  *xs1**12*xs2**0 *xst**0          
                                       
       vp=vp1+vp2+vp3

        v=v0+vp*xep3+vhh+xep1+xep2

      end subroutine poka_pes_low

      subroutine poka_pes_up(v,r1,r2,th)
implicit none 

      double precision,intent(in) ::  r1,r2,th
      double precision,intent(out)::  v
      double precision            :: reoh,thetae,b1,roh,alphaoh
      double precision            :: phh2,t0,ut,x0,ut2,x02,xs1,xs2,xst,rs,rm,rr1,rr2,xep1,xep2,xep3
      double precision            :: rhh,vhh,vpb1,vpb2,v0,vp1,vp2,vp3,vp,vps1,vps2,y1,y2,y12,y22,voh1,voh2
      integer(4) :: i 
double precision :: alpha
      !
           reoh=0.9586d0
           thetae=104.48d0
           b1=2.15d0
           alphaoh=0.0d0
           phh2=6.20164303995d0

      thetae=thetae*.314159265358979312d01*.00555555555555555555d0

      xs1=(r1+r2)*0.5d0-reoh
      xs2=(r1-r2)*0.5d0
      xst=dcos(th)-dcos(thetae)

      rr1=r1-reoh
      rr2=r2-reoh


         alpha=2.2668d0
         xep1=(dexp(-2.d0*alpha*rr1)-2.d0*dexp(-alpha*rr1))* & 
        (( 0.4389830771267D+05 )           +                      & 
         (-0.8606164763375D+03 )*rr1       +                    &                
         (+0.1746549380317D+05 )*rr1**2    +                    & 
         (-0.3326053761996D+05 )*rr1**3    +                    & 
         (+0.4988743744461D+04 )*rr1**4    +                    & 
         (+0.8751979626215D+04 )*rr1**5    +                    & 
         (-0.3770596827415D+04 )*rr1**6    +                    & 
         (+0.4270854122634D+03 )*rr1**7) + (0.4389830771267D+05  )
                                   
         xep2=(dexp(-2.d0*alpha*rr2)-2.d0*dexp(-alpha*rr2))* &  
        (( 0.4389830771267D+05  )          +                      & 
         (-0.8606164763375D+03  )*rr2      +                     & 
         (+0.1746549380317D+05  )*rr2**2   +                     & 
         (-0.3326053761996D+05  )*rr2**3   +                     & 
         (+0.4988743744461D+04  )*rr2**4   +                     & 
         (+0.8751979626215D+04  )*rr2**5   +                     & 
         (-0.3770596827415D+04  )*rr2**6   +                     & 
         (+0.4270854122634D+03  )*rr2**7) + (0.4389830771267D+05 )

         xep3=dexp(-b1*((r1-reoh)**2+(r2-reoh)**2))
         rhh=dsqrt(r1**2+r2**2-2.d0*r1*r2*dcos(th))
         vhh=0.820894739261131734D+06*dexp(-phh2*rhh)
     

    v0 =+( 0.155309896574d+04)  *xs1**0 *xs2**0 *xst**0    
    vp1=+(-0.592359887182d+04)  *xs1**0 *xs2**0 *xst**1  & 
        +( 0.208736275790d+05)  *xs1**1 *xs2**0 *xst**0  & 
        +( 0.114344476201d+05)  *xs1**0 *xs2**0 *xst**2  & 
        +(-0.663089388658d+05)  *xs1**0 *xs2**2 *xst**0  & 
        +(-0.407919812865d+05)  *xs1**1 *xs2**0 *xst**1  & 
        +( 0.286361994766d+05)  *xs1**2 *xs2**0 *xst**0  &  
        +( 0.106465142842d+05)  *xs1**0 *xs2**0 *xst**3  &  
        +( 0.826183833337d+05)  *xs1**0 *xs2**2 *xst**1  &  
        +(-0.812328030057d+05)  *xs1**1 *xs2**0 *xst**2  &  
        +(-0.336101313815d+06)  *xs1**1 *xs2**2 *xst**0  &  
        +( 0.153195136788d+06)  *xs1**2 *xs2**0 *xst**1  &  
        +(-0.236857546376d+06)  *xs1**3 *xs2**0 *xst**0  &  
        +( 0.706951545251d+04)  *xs1**0 *xs2**0 *xst**4  &  
        +( 0.233715320399d+06)  *xs1**0 *xs2**2 *xst**2  &  
        +( 0.776664103537d+06)  *xs1**0 *xs2**4 *xst**0  &  
        +( 0.218200142422d+04)  *xs1**1 *xs2**0 *xst**3  &  
        +(-0.160368061729d+06)  *xs1**1 *xs2**2 *xst**1  &  
        +( 0.680130561984d+05)  *xs1**2 *xs2**0 *xst**2  &  
        +( 0.150605198145d+07)  *xs1**2 *xs2**2 *xst**0  &  
        +( 0.421293404023d+05)  *xs1**3 *xs2**0 *xst**1  &  
        +(-0.357288158782d+06)  *xs1**4 *xs2**0 *xst**0  &  
        +(-0.178952744574d+04)  *xs1**0 *xs2**0 *xst**5  &  
        +(-0.202714185058d+06)  *xs1**0 *xs2**2 *xst**3  &  
        +(-0.378509124077d+06)  *xs1**0 *xs2**4 *xst**1  &  
        +( 0.331092190035d+05)  *xs1**1 *xs2**0 *xst**4  &  
        +( 0.234671840326d+06)  *xs1**1 *xs2**2 *xst**2  &  
        +(-0.204397489446d+07)  *xs1**1 *xs2**4 *xst**0  &  
        +(-0.167855966014d+06)  *xs1**2 *xs2**0 *xst**3  &  
        +(-0.286086655340d+06)  *xs1**2 *xs2**2 *xst**1  &  
        +( 0.598460433258d+06)  *xs1**3 *xs2**0 *xst**2  &  
        +(-0.891987650581d+06)  *xs1**3 *xs2**2 *xst**0  &  
        +(-0.101925420449d+07)  *xs1**4 *xs2**0 *xst**1  &  
        +( 0.119569453069d+07)  *xs1**5 *xs2**0 *xst**0  &  
        +( 0.332958926752d+04)  *xs1**0 *xs2**0 *xst**6  &  
        +(-0.244741314929d+05)  *xs1**0 *xs2**2 *xst**4  &  
        +(-0.867881210576d+06)  *xs1**0 *xs2**4 *xst**2  &  
        +(-0.312939194500d+06)  *xs1**0 *xs2**6 *xst**0  &  
        +(-0.185348610325d+05)  *xs1**1 *xs2**0 *xst**5  &  
        +(-0.136403062153d+06)  *xs1**1 *xs2**2 *xst**3  &  
        +( 0.356825867701d+06)  *xs1**1 *xs2**4 *xst**1  &  
        +(-0.267736502169d+05)  *xs1**2 *xs2**0 *xst**4  &  
        +(-0.646514011175d+06)  *xs1**2 *xs2**2 *xst**2  &  
        +( 0.317169048015d+06)  *xs1**2 *xs2**4 *xst**0  &  
        +( 0.326127173290d+06)  *xs1**3 *xs2**0 *xst**3  &  
        +( 0.700270072803d+06)  *xs1**3 *xs2**2 *xst**1  &  
        +(-0.535021360352d+06)  *xs1**4 *xs2**0 *xst**2  &  
        +(-0.118865699818d+06)  *xs1**4 *xs2**2 *xst**0  &  
        +( 0.831422982905d+06)  *xs1**5 *xs2**0 *xst**1  &  
        +(-0.851653778223d+06)  *xs1**6 *xs2**0 *xst**0  &  
        +( 0.242282198768d+04)  *xs1**0 *xs2**0 *xst**7  &  
        +( 0.940813718932d+05)  *xs1**0 *xs2**2 *xst**5  &  
        +( 0.456631463906d+06)  *xs1**0 *xs2**4 *xst**3  &  
        +( 0.563196109317d+06)  *xs1**0 *xs2**6 *xst**1  &  
        +( 0.120480616390d+05)  *xs1**1 *xs2**0 *xst**6  &  
        +( 0.624636992257d+05)  *xs1**1 *xs2**2 *xst**4  &  
        +( 0.164960874725d+07)  *xs1**1 *xs2**4 *xst**2  &  
        +( 0.940576685170d+06)  *xs1**1 *xs2**6 *xst**0  &  
        +( 0.174581844470d+05)  *xs1**2 *xs2**0 *xst**5  &  
        +( 0.412862003857d+06)  *xs1**2 *xs2**2 *xst**3  &  
        +(-0.680807889462d+06)  *xs1**2 *xs2**4 *xst**1  &  
        +(-0.607598887061d+05)  *xs1**3 *xs2**0 *xst**4  &  
        +(-0.415526286791d+06)  *xs1**3 *xs2**2 *xst**2  &  
        +(-0.136403679025d+06)  *xs1**3 *xs2**4 *xst**0  &  
        +(-0.223523159865d+06)  *xs1**4 *xs2**0 *xst**3  &  
        +( 0.861320159836d+05)  *xs1**4 *xs2**2 *xst**1  &  
        +( 0.268464999939d+06)  *xs1**5 *xs2**0 *xst**2  &  
        +( 0.371913688751d+05)  *xs1**5 *xs2**2 *xst**0  &  
        +( 0.763578520425d+05)  *xs1**6 *xs2**0 *xst**1  &  
        +(-0.741575040588d+05)  *xs1**7 *xs2**0 *xst**0  &  
        +( 0.101543266245d+04)  *xs1**0 *xs2**0 *xst**8  &  
        +(-0.816379821083d+04)  *xs1**0 *xs2**2 *xst**6  &  
        +( 0.381319599874d+06)  *xs1**0 *xs2**4 *xst**4  &  
        +(-0.135897685858d+06)  *xs1**0 *xs2**6 *xst**2  &  
        +( 0.472086278960d+06)  *xs1**0 *xs2**8 *xst**0  &  
        +(-0.917261993510d+03)  *xs1**1 *xs2**0 *xst**7  &  
        +(-0.739537574003d+05)  *xs1**1 *xs2**2 *xst**5  &  
        +(-0.315807554686d+06)  *xs1**1 *xs2**4 *xst**3  &  
        +(-0.235295824967d+06)  *xs1**1 *xs2**6 *xst**1  &  
        +(-0.402353505139d+05)  *xs1**2 *xs2**0 *xst**6  &  
        +(-0.391753519725d+06)  *xs1**2 *xs2**2 *xst**4  &  
        +( 0.413190187855d+05)  *xs1**2 *xs2**4 *xst**2  &  
        +( 0.682169209461d+05)  *xs1**2 *xs2**6 *xst**0  &  
        +(-0.249914895945d+04)  *xs1**3 *xs2**0 *xst**5  &  
        +( 0.113923694930d+06)  *xs1**3 *xs2**2 *xst**3  &  
        +(-0.601388930185d+05)  *xs1**3 *xs2**4 *xst**1  &  
        +( 0.706674966718d+05)  *xs1**4 *xs2**0 *xst**4  &  
        +(-0.178592130235d+06)  *xs1**4 *xs2**2 *xst**2  &  
        +(-0.262592952548d+06)  *xs1**4 *xs2**4 *xst**0  &  
        +(-0.492381027740d+05)  *xs1**5 *xs2**0 *xst**3  &  
        +(-0.173663647744d+06)  *xs1**5 *xs2**2 *xst**1  &  
        +(-0.998636422746d+05)  *xs1**6 *xs2**0 *xst**2     
    vp2=+(-0.956691141185d+05)  *xs1**6 *xs2**2 *xst**0  &  
        +(-0.133546172259d+06)  *xs1**7 *xs2**0 *xst**1  &  
        +(-0.514024544670d+05)  *xs1**8 *xs2**0 *xst**0  &  
        +(-0.881387155691d+04)  *xs1**0 *xs2**0 *xst**9  &  
        +(-0.574312109678d+05)  *xs1**0 *xs2**2 *xst**7  &  
        +(-0.942983271677d+05)  *xs1**0 *xs2**4 *xst**5  &  
        +(-0.617017747843d+05)  *xs1**0 *xs2**6 *xst**3  &  
        +(-0.207131684016d+06)  *xs1**0 *xs2**8 *xst**1  &  
        +( 0.318561992935d+05)  *xs1**1 *xs2**0 *xst**8  &  
        +( 0.973183956113d+05)  *xs1**1 *xs2**2 *xst**6  &  
        +(-0.192478917206d+06)  *xs1**1 *xs2**4 *xst**4  &  
        +( 0.169411196264d+06)  *xs1**1 *xs2**6 *xst**2  &  
        +( 0.144962481787d+06)  *xs1**1 *xs2**8 *xst**0  &  
        +(-0.204361832818d+06)  *xs1**2 *xs2**0 *xst**7  &  
        +( 0.134621249990d+06)  *xs1**2 *xs2**2 *xst**5  &  
        +( 0.127362007093d+06)  *xs1**2 *xs2**4 *xst**3  &  
        +(-0.126522445015d+06)  *xs1**2 *xs2**6 *xst**1  &  
        +( 0.336695212387d+06)  *xs1**3 *xs2**0 *xst**6  &  
        +(-0.275610916865d+06)  *xs1**3 *xs2**2 *xst**4  &  
        +( 0.145098909642d+06)  *xs1**3 *xs2**4 *xst**2  &  
        +(-0.341595070120d+05)  *xs1**3 *xs2**6 *xst**0  &  
        +( 0.407712507947d+05)  *xs1**4 *xs2**0 *xst**5  &  
        +( 0.141080947335d+06)  *xs1**4 *xs2**2 *xst**3  &  
        +(-0.802999914110d+05)  *xs1**4 *xs2**4 *xst**1  &  
        +(-0.703984623825d+05)  *xs1**5 *xs2**0 *xst**4  &  
        +(-0.600623872584d+05)  *xs1**5 *xs2**2 *xst**2  &  
        +(-0.156540842026d+06)  *xs1**5 *xs2**4 *xst**0  &  
        +( 0.130873825998d+06)  *xs1**6 *xs2**0 *xst**3  &  
        +(-0.775023137061d+05)  *xs1**6 *xs2**2 *xst**1  &  
        +(-0.341722841187d+05)  *xs1**7 *xs2**0 *xst**2  &  
        +(-0.914109234537d+05)  *xs1**7 *xs2**2 *xst**0  &  
        +(-0.110148980271d+05)  *xs1**8 *xs2**0 *xst**1  &  
        +( 0.227558526030d+05)  *xs1**9 *xs2**0 *xst**0  &  
        +( 0.480020930143d+05)  *xs1**0 *xs2**2 *xst**8  &   
        +(-0.165802555273d+06)  *xs1**0 *xs2**4 *xst**6  &  
        +(-0.194306566258d+06)  *xs1**0 *xs2**6 *xst**4  &  
        +( 0.292778073627d+06)  *xs1**0 *xs2**8 *xst**2  &  
        +( 0.379482135645d+05)  *xs1**1 *xs2**0 *xst**9  &  
        +(-0.724856083397d+05)  *xs1**1 *xs2**2 *xst**7  &   
        +(-0.601494411960d+04)  *xs1**1 *xs2**4 *xst**5  &  
        +( 0.103450861371d+06)  *xs1**1 *xs2**6 *xst**3  &  
        +(-0.177796982869d+06)  *xs1**1 *xs2**8 *xst**1  &  
        +( 0.360547751397d+05)  *xs1**2 *xs2**0 *xst**8  &  
        +( 0.428127604226d+06)  *xs1**2 *xs2**2 *xst**6  &  
        +( 0.431114838300d+04)  *xs1**2 *xs2**4 *xst**4  &  
        +( 0.268806664725d+06)  *xs1**2 *xs2**6 *xst**2  &  
        +(-0.172100712587d+06)  *xs1**3 *xs2**0 *xst**7  &  
        +( 0.301025317821d+06)  *xs1**3 *xs2**2 *xst**5  &  
        +( 0.224128479757d+06)  *xs1**3 *xs2**4 *xst**3  &  
        +(-0.126386442558d+06)  *xs1**3 *xs2**6 *xst**1  &  
        +(-0.856781358003d+05)  *xs1**4 *xs2**0 *xst**6  &  
        +(-0.958355593736d+05)  *xs1**4 *xs2**2 *xst**4  &  
        +( 0.220644893971d+06)  *xs1**4 *xs2**4 *xst**2  &  
        +( 0.446056561803d+05)  *xs1**5 *xs2**0 *xst**5  &  
        +( 0.210437135858d+06)  *xs1**5 *xs2**2 *xst**3  &  
        +(-0.768347909194d+05)  *xs1**5 *xs2**4 *xst**1  &  
        +(-0.157447199203d+06)  *xs1**6 *xs2**0 *xst**4  &  
        +( 0.857302582650d+05)  *xs1**6 *xs2**2 *xst**2  &  
        +(-0.234568556166d+05)  *xs1**6 *xs2**4 *xst**0  &  
        +( 0.167626527572d+06)  *xs1**7 *xs2**0 *xst**3  &  
        +(-0.658452603492d+05)  *xs1**7 *xs2**2 *xst**1  &  
        +( 0.150659335376d+05)  *xs1**8 *xs2**0 *xst**2  &  
        +( 0.506664682202d+04)  *xs1**8 *xs2**2 *xst**0  &  
        +(-0.274410300715d+05)  *xs1**9 *xs2**0 *xst**1  &  
        +( 0.200788452138d+05)  *xs1**10*xs2**0 *xst**0  &  
        +( 0.253451138795d+05)  *xs1**0 *xs2**2 *xst**9  &  
        +( 0.872381885535d+04)  *xs1**0 *xs2**4 *xst**7  &  
        +( 0.168033263714d+04)  *xs1**0 *xs2**6 *xst**5  &  
        +( 0.827981464589d+03)  *xs1**0 *xs2**8 *xst**3  &   
        +( 0.633856765152d+03)  *xs1**0 *xs2**10*xst**1  &  
        +( 0.539027926754d+04)  *xs1**1 *xs2**0 *xst**10 &  
        +(-0.247731549508d+05)  *xs1**1 *xs2**2 *xst**8  &  
        +( 0.317697777160d+04)  *xs1**1 *xs2**4 *xst**6  &  
        +( 0.113909363756d+04)  *xs1**1 *xs2**6 *xst**4  &  
        +( 0.754385873292d+03)  *xs1**1 *xs2**8 *xst**2  &   
        +(-0.600546351529d+04)  *xs1**1 *xs2**10*xst**0  &  
        +(-0.134288826831d+03)  *xs1**2 *xs2**0 *xst**9  &  
        +( 0.174539538698d+04)  *xs1**2 *xs2**2 *xst**7  &  
        +( 0.171084750089d+04)  *xs1**2 *xs2**4 *xst**5  &  
        +(-0.144127458958d+03)  *xs1**2 *xs2**6 *xst**3  &  
        +( 0.594073986891d+03)  *xs1**2 *xs2**8 *xst**1  &   
        +(-0.298574274230d+05)  *xs1**3 *xs2**0 *xst**8     
    vp3=+( 0.125735696367d+04)  *xs1**3 *xs2**2 *xst**6  &  
        +( 0.356652162112d+04)  *xs1**3 *xs2**4 *xst**4  &  
        +(-0.112228339407d+04)  *xs1**3 *xs2**6 *xst**2  &  
        +(-0.379286800217d+04)  *xs1**3 *xs2**8 *xst**0  &  
        +(-0.797245034520d+04)  *xs1**4 *xs2**0 *xst**7  &  
        +( 0.850117168612d+03)  *xs1**4 *xs2**2 *xst**5  &  
        +( 0.655204975733d+03)  *xs1**4 *xs2**4 *xst**3  &  
        +(-0.172999333089d+04)  *xs1**4 *xs2**6 *xst**1  &  
        +(-0.580311488511d+03)  *xs1**5 *xs2**0 *xst**6  &  
        +( 0.602106533817d+04)  *xs1**5 *xs2**2 *xst**4  &  
        +(-0.643207468850d+03)  *xs1**5 *xs2**4 *xst**2  &  
        +(-0.388447460058d+04)  *xs1**5 *xs2**6 *xst**0  &  
        +(-0.568870068412d+03)  *xs1**6 *xs2**0 *xst**5  &  
        +( 0.185921288921d+04)  *xs1**6 *xs2**2 *xst**3  &  
        +(-0.158474975900d+04)  *xs1**6 *xs2**4 *xst**1  &  
        +( 0.253995524411d+04)  *xs1**7 *xs2**0 *xst**4  &  
        +( 0.245255583284d+03)  *xs1**7 *xs2**2 *xst**2  &  
        +( 0.334609754048d+03)  *xs1**8 *xs2**0 *xst**3  &  
        +(-0.136761213322d+04)  *xs1**8 *xs2**2 *xst**1  &  
        +( 0.199462447923d+04)  *xs1**9 *xs2**0 *xst**2  &  
        +(-0.381718226701d+04)  *xs1**9 *xs2**2 *xst**0  &  
        +(-0.195172248408d+04)  *xs1**10*xs2**0 *xst**1  &  
        +(-0.621280556249d+04)  *xs1**11*xs2**0 *xst**0  &  
        +(-0.588126213804d+03)  *xs1**0 *xs2**0 *xst**2  &  
        +(-0.136626406626d+04)  *xs1**0 *xs2**2 *xst**0  &  
        +( 0.300613895916d+04)  *xs1**0 *xs2**4 *xst**8  &  
        +( 0.590881741181d+03)  *xs1**0 *xs2**6 *xst**6  &  
        +(-0.455598948667d+05)  *xs1**0 *xs2**8 *xst**4  &   
        +( 0.464609288822d+05)  *xs1**0 *xs2**10*xst**2  &  
        +( 0.141371570629d+06)  *xs1**0 *xs2**12*xst**0  &  
        +(-0.325470888148d+05)  *xs1**1 *xs2**0 *xst**11 &  
        +( 0.103287422463d+04)  *xs1**1 *xs2**2 *xst**9  &  
        +( 0.168248908769d+04)  *xs1**1 *xs2**4 *xst**7  &  
        +( 0.326024860192d+03)  *xs1**1 *xs2**6 *xst**5  &  
        +( 0.138553671895d+03)  *xs1**1 *xs2**8 *xst**3  &  
        +( 0.176426982150d+03)  *xs1**1 *xs2**10*xst**1  &  
        +( 0.381560895223d+05)  *xs1**2 *xs2**0 *xst**10 &  
        +(-0.179193402836d+04)  *xs1**2 *xs2**2 *xst**8  &  
        +( 0.113976105068d+03)  *xs1**2 *xs2**4 *xst**6  &  
        +( 0.205856286554d+03)  *xs1**2 *xs2**6 *xst**4  &  
        +( 0.205645535612d+03)  *xs1**2 *xs2**8 *xst**2  &  
        +( 0.312170506022d+03)  *xs1**2 *xs2**10*xst**0  &  
        +(-0.241987377812d+04)  *xs1**3 *xs2**0 *xst**9  &  
        +(-0.271307185359d+03)  *xs1**3 *xs2**2 *xst**7  &  
        +( 0.185556848044d+03)  *xs1**3 *xs2**4 *xst**5  &  
        +( 0.106146090045d+03)  *xs1**3 *xs2**6 *xst**3  &  
        +(-0.342984205698d+05)  *xs1**3 *xs2**8 *xst**1  &  
        +(-0.687280201359d+04)  *xs1**4 *xs2**0 *xst**8  &  
        +(-0.613309111735d+03)  *xs1**4 *xs2**2 *xst**6  &  
        +( 0.193478580517d+03)  *xs1**4 *xs2**4 *xst**4  &  
        +( 0.730224034567d+05)  *xs1**4 *xs2**6 *xst**2  &  
        +( 0.214627213340d+03)  *xs1**4 *xs2**8 *xst**0  &  
        +(-0.243992596380d+04)  *xs1**5 *xs2**0 *xst**7  &  
        +(-0.176182322915d+03)  *xs1**5 *xs2**2 *xst**5  &  
        +( 0.734544203756d+02)  *xs1**5 *xs2**4 *xst**3  &  
        +(-0.127569442508d+05)  *xs1**5 *xs2**6 *xst**1  &  
        +(-0.405620941776d+03)  *xs1**6 *xs2**0 *xst**6  &  
        +( 0.830076925571d+02)  *xs1**6 *xs2**2 *xst**4  &  
        +( 0.853170031020d+05)  *xs1**6 *xs2**4 *xst**2  &  
        +( 0.961839158128d+02)  *xs1**6 *xs2**6 *xst**0  &  
        +( 0.346857663997d+03)  *xs1**7 *xs2**0 *xst**5  &  
        +( 0.130059723352d+03)  *xs1**7 *xs2**2 *xst**3  &  
        +( 0.101012447119d+05)  *xs1**7 *xs2**4 *xst**1  &  
        +( 0.806185674075d+03)  *xs1**8 *xs2**0 *xst**4  &  
        +( 0.240451004043d+03)  *xs1**8 *xs2**2 *xst**2  &  
        +( 0.172603600420d+03)  *xs1**8 *xs2**4 *xst**0  &  
        +( 0.569719449653d+03)  *xs1**9 *xs2**0 *xst**3  &        
        +( 0.161687174062d+03)  *xs1**9 *xs2**2 *xst**1  &       
        +( 0.603793707604d+03)  *xs1**10*xs2**0 *xst**2  &       
        +( 0.309950546065d+03)  *xs1**10*xs2**2 *xst**0  &       
        +( 0.466618064731d+03)  *xs1**11*xs2**0 *xst**1  &       
        +( 0.831515687244d+03)  *xs1**12*xs2**0 *xst**0          
                                       
       vp=vp1+vp2+vp3
           
        v=v0+vp*xep3+vhh+xep1+xep2
           
      end subroutine poka_pes_up
           
           
           
