c  PLOT UPWELLING BRIGHTNESS-TEMPERATURE SPECTRUM FROM U.S. STD. ATMOSPHERE
C  ABOVE AN OCEAN SURFACE.
c  FOR CALCULATION OF THE ZEEMAN SPLITTING, THE MAGNETIC FIELD IS CONSIDERED
C  CONSTANT OVER THE PROPAGATION PATH HERE.
C
      IMPLICIT NONE
      INTEGER N,M,I,J,NLV,NLVA,NLVTR,NM1,JU,JTEST
      PARAMETER (N=90,M=101)
      REAL FREQ,F1,F2,TEMP(N),PRES(N),RHO(N),O3NUM(N),CLD(N),FL(34)
      REAL ANGLE,TB1,TB2,TBC,E1,E2,RV,RH,SECANT1,SECANT2,H(N),PAV,TAV
      REAL TBv(M),TBh(M),TBlc(M),TBrc(M),ALT,TS,F(M),DELF,TBMIN,TBMAX
      REAL DELTB,BFIELD,BVEC(3),CTHN,CBTH,PHI,DH,DF,HTR
      COMPLEX EC,GM,GPI,GP,PHASEROTFAC,TBLIN
      LOGICAL ZCALC
c  O2 freq's from HITRAN96
      DATA FL/118.7503, 56.2648, 62.4863, 58.4466, 60.3061, 59.5910,
     2  59.1642, 60.4348, 58.3239, 61.1506, 57.6125, 61.8002,
     3  56.9682, 62.4112, 56.3634, 62.9980, 55.7838, 63.5685,
     4  55.2214, 64.1278, 54.6712, 64.6789, 54.1300, 65.2241,
     5  53.5958, 65.7648, 53.0669, 66.3021, 52.5424, 66.8368,
     6  52.0214, 67.3696, 51.5034, 67.9009/
      TBC = 2.7 !cosmic background temperature
      HTR = 40. !transition altitude between zeeman region & lower atmosphere
      NM1 = N-1

c  READ ATMOSPHERE PROFILE
      OPEN(1,FILE='std76.dat',FORM='FORMATTED')
      DO I=1,N
       READ(1,1)  H(I),TEMP(I),PRES(I),RHO(I),O3NUM(I)
C atmospheric profile starting at surface:
C H(km), TEMP(K), PRES(mb), H2OvaporRHO(g/m**3), O3NUMdensity(molecules/m**3)
1      FORMAT(2F8.2,3E12.3)
       CLD(I) = 0.
      END DO
      CLOSE(1)
      TS = TEMP(1)

C  READ PARAMETERS FOR THE CALCULATION
      WRITE(*,*) 'ENTER MAX.ALTITUDE (km), ANGLE FROM VERTICAL (deg)'
      READ(*,*) ALT,ANGLE
      CTHN = -COS(ANGLE/57.296)
      SECANT1 = -1./CTHN
      SECANT2 = SECANT1  !assume specular reflection
      BFIELD = 0.
      IF(ALT.GT.HTR) THEN
        WRITE(*,*) 'ENTER AZIMUTH ANGLE OF PROPAGATION',
     &   ' (deg from north toward east)'
        READ(*,*) PHI
        WRITE(*,*) 'ENTER B-FIELD COMPONENTS:',
     & ' NORTHWARD,EASTWARD,DOWNWARD (gauss)'
        READ(*,*) BVEC
        CALL E2ROT(CTHN,PHI,BVEC,PHASEROTFAC,CBTH,BFIELD)
          write(*,*) phaserotfac,cbth,bfield
      ENDIF
      WRITE(*,*) 'ENTER FREQUENCY LIMITS (GHz): lower,upper'
      READ(*,*) F1,F2
      IF(F2.LE.F1) STOP
      OPEN(2,FILE='spectrum.out',FORM='FORMATTED')
      WRITE(2,*) ALT,' km ',ANGLE,' deg ',BFIELD,' gauss'
      WRITE(2,*) '      freq     TBv         TBh',
     & '         TBlin            TBrc         TBlc'
      DF = (F2-F1)/100.
      TBMIN = 500.
      TBMAX = 0.
c  find indices corresponding to HTR and ALT
      DO I=2,N
       NLVA = I
       IF(H(I).LE.HTR) NLVTR = I
       IF(H(I).GE.ALT) GOTO 10
      END DO
10    CONTINUE

      DO 30 J=1,M  !frequency loop
       FREQ = F1 + (J-1)*DF
       F(J) = FREQ
       ZCALC = .TRUE.
       IF(ALT.LE.HTR) GOTO 12
       DO JTEST=1,34
         DELF = FREQ - FL(JTEST) 
         IF(ABS(DELF).LT.0.03) GOTO 15
       END DO
12     ZCALC = .FALSE. ! not near any line center, so don't do Zeeman
15     JU = JTEST

C  Scalar propagation
       IF(ZCALC) THEN
        NLV = NLVTR
       ELSE
        NLV = NLVA
       ENDIF
       CALL TBARRAY(NLV,TEMP,PRES,RHO,CLD,O3NUM,1,SECANT1,SECANT2,
     & FREQ,TB1,TB2,E1,E2)
       CALL DILEC10(EC,FREQ,TS,.035)
       CALL REF(RH,RV,EC,ANGLE)
       TBv(J) = TB2 + E2*((1.-Rv)*Ts + Rv*(TB1 + E1*TBc)) !vert.pol.
       TBh(J) = TB2 + E2*((1.-Rh)*Ts + Rh*(TB1 + E1*TBc)) !horiz.pol.
       TBlc(J) = (TBv(J)+TBh(J))/2.   !circ.pol.
       TBrc(J) = TBlc(J)
       TBLIN = (TBv(J) - TBh(J))/2.

       IF(ZCALC) THEN ! Polarized propagation
c   rotate phase to plane of B-field
        TBLIN = TBLIN*CONJG(PHASEROTFAC)
        DO  I=NLV,NM1 !altitude loop
         IF(H(I+1).GT.ALT) GOTO 20
         TAV = (TEMP(I) + TEMP(I+1))/2.
         PAV = SQRT(PRES(I)*PRES(I+1))
         DH = H(I+1)-H(I)
         CALL ZEEMAN(JU,TAV,PAV,DELF,BFIELD,GM,GPI,GP)
         CALL TBMX(TBRC(J),TBLC(J),TBLIN,DH,TAV,0.,GP,GM,GPI,CBTH)
        END DO
20      CONTINUE
C  rotate phase back to V-pol plane. note that TBv and TBh may be correlated
        TBLIN = TBLIN*PHASEROTFAC
        TBv(J) = (TBRC(J)+TBLC(J))/2. + REAL(TBLIN)
        TBh(J) = TBv(J) - 2.*REAL(TBLIN)
       ENDIF

25     TBMIN = AMIN1(TBMIN,TBv(J),TBh(J),TBRC(J),TBLC(J))
       TBMAX = AMAX1(TBMAX,TBv(J),TBh(J),TBRC(J),TBLC(J))
       WRITE(2,2) FREQ,TBv(J),TBh(J),TBLIN,TBRC(J),TBLC(J)
2      FORMAT(7F11.4)
30    CONTINUE
      CLOSE(2)

C  PLOT TB CURVES
      DELTB = (TBMAX-TBMIN)/10.
      CALL LINLIN('FREQUENCY, GHz?',F1,5,20.*DF,80.,1,'(F7.3)',
     & 'BRIGHTNESS TEMPERATURE, K?',TBMIN,10,DELTB,40.,1,'(F7.2)')
c  using gfortran syntax for hexadecimal
      CALL PLOTLINE(F,TBh,M,Z'4444')
      CALL PLOTLINE(F,TBv,M,Z'8444')
      IF(ZCALC) THEN
       CALL PLOTLINE(F,TBRC,M,0)
       CALL PLOTLINE(F,TBLC,M,Z'6262')
      ENDIF
      CALL ENDGRAPH
      END

