c  PLOT DOWNWELLING BRIGHTNESS-TEMPERATURE SPECTRUM FROM U.S. STD. ATMOSPHERE.
c  FOR CALCULATION OF THE ZEEMAN SPLITTING, THE MAGNETIC FIELD IS CONSIDERED
C  CONSTANT OVER THE PROPAGATION PATH HERE.
C
      IMPLICIT NONE
      INTEGER N,M,I,J,NLV,JU,JTEST
      PARAMETER (N=90,M=101)
      REAL FREQ,F1,F2,TEMP(N),PRES(N),RHO(N),O3NUM(N),CLD(N),FL(34)
      REAL ANGLE,TB1,TB2,TBC,E1,E2,SECANT,H(N),PAV,TAV
      REAL TBv(M),TBh(M),TBlc(M),TBrc(M),ALT,TS,F(M),DELF,TBMIN,TBMAX
      REAL DELTB,BFIELD,BVEC(3),CTHN,CBTH,PHI,DH,DF,HTR
      COMPLEX GM,GPI,GP,PHASEROTFAC,TBLIN
      LOGICAL ZCALC
c  O2 freq's from HITRAN96
      DATA FL/118.7503, 56.2648, 62.4863, 58.4466, 60.3061, 59.5910,
     2  59.1642, 60.4348, 58.3239, 61.1506, 57.6125, 61.8002,
     3  56.9682, 62.4112, 56.3634, 62.9980, 55.7838, 63.5685,
     4  55.2214, 64.1278, 54.6712, 64.6789, 54.1300, 65.2241,
     5  53.5958, 65.7648, 53.0669, 66.3021, 52.5424, 66.8368,
     6  52.0214, 67.3696, 51.5034, 67.9009/
      TBC = 2.7 !cosmic background temperature
      HTR = 40. !transition altitude between zeeman region & lower atmosphere

c  READ ATMOSPHERE PROFILE
      OPEN(1,FILE='std76.dat',FORM='FORMATTED')
      DO I=1,N
       READ(1,1)  H(I),TEMP(I),PRES(I),RHO(I),O3NUM(I)
C atmospheric profile starting at surface:
C H(km), TEMP(K), PRES(mb), H2OvaporRHO(g/m**3), O3NUMdensity(molecules/m**3)
1      FORMAT(2F8.2,3E12.3)
       CLD(I) = 0.
      END DO
      CLOSE(1)
      TS = TEMP(1)
      PHASEROTFAC = (1.,0.)
C  READ PARAMETERS FOR THE CALCULATION
      WRITE(*,*) 'ENTER MAX.ALTITUDE (km), ANGLE FROM VERTICAL (deg),'
      READ(*,*) ALT,ANGLE
      CTHN = COS(ANGLE/57.296)
      SECANT = 1./CTHN
      BFIELD = 0.
      IF(ALT.GT.HTR) THEN
        WRITE(*,*) 'ENTER AZIMUTH ANGLE OF PROPAGATION',
     &   ' (deg from north toward east)'
        READ(*,*) PHI
        WRITE(*,*) 'ENTER B-FIELD COMPONENTS:',
     & ' NORTHWARD,EASTWARD,DOWNWARD (gauss)'
        READ(*,*) BVEC
        CALL E2ROT(CTHN,PHI,BVEC,PHASEROTFAC,CBTH,BFIELD)
      ENDIF
      WRITE(*,*) 'ENTER FREQUENCY LIMITS (GHz): lower,upper'
      READ(*,*) F1,F2
      IF(F2.LE.F1) STOP
      OPEN(2,FILE='spectrum.out',FORM='FORMATTED')
      WRITE(2,*) ALT,' km ',ANGLE,' deg ',BFIELD,' gauss'
      WRITE(2,*) '      freq     TBv         TBh',
     & '         TBlin                TBrc     TBlc'
      DF = (F2-F1)/100.
      TBMIN = 500.
      TBMAX = 0.
      NLV = N
      DO 30 J=1,M  !frequency loop
       ZCALC = .TRUE.
       FREQ = F1 + (J-1)*DF
       F(J) = FREQ
       TBLIN = 0.
       TBRC(J) = TBC
       TBLC(J) = TBC
       IF(ALT.LE.HTR) GOTO 5
       DO JTEST=1,34
         DELF = FREQ - FL(JTEST) 
         IF(ABS(DELF).LT.0.03) GOTO 10
       END DO
5      ZCALC = .FALSE. ! not near any line center, so don't do Zeeman
10     JU = JTEST

       DO 20 I=N,2,-1 !altitude loop; find nlv for scalar prop
        IF(H(I).GT.ALT) GOTO 20

        IF(ZCALC) THEN ! Polarized propagation
         TAV = (TEMP(I) + TEMP(I-1))/2.
         PAV = SQRT(PRES(I)*PRES(I-1))
         DH = H(I)-H(I-1)
         CALL ZEEMAN(JU,TAV,PAV,DELF,BFIELD,GM,GPI,GP)
         CALL TBMX(TBRC(J),TBLC(J),TBLIN,DH,TAV,0.,GP,GM,GPI,CBTH)
        ELSE
         NLV = I
         GOTO 25
        ENDIF

        IF(H(I-1).LE.HTR) THEN
         NLV = I-1
         GOTO 25
        ENDIF

20    CONTINUE

25    CONTINUE
C  Scalar propagation
       CALL TBARRAY(NLV,TEMP,PRES,RHO,CLD,O3NUM,1,SECANT,SECANT,
     & FREQ,TB1,TB2,E1,E2)
       TBLC(J) = TB1 + E1*TBLC(J)
       TBRC(J) = TB1 + E1*TBRC(J)
       TBLIN = E1*TBLIN
C  rotate phase to V-pol plane. note that TBv and TBh may be correlated
       TBLIN = TBLIN*PHASEROTFAC
       TBv(J) = (TBRC(J)+TBLC(J))/2. + REAL(TBLIN)
       TBh(J) = TBv(J) - 2.*REAL(TBLIN)
       TBMIN = AMIN1(TBMIN,TBv(J),TBh(J),TBRC(J),TBLC(J))
       TBMAX = AMAX1(TBMAX,TBv(J),TBh(J),TBRC(J),TBLC(J))
       WRITE(2,2) FREQ,TBv(J),TBh(J),TBLIN,TBRC(J),TBLC(J)
2      FORMAT(7F11.4)
30    CONTINUE
      CLOSE(2)

C  PLOT TB CURVES
      DELTB = (TBMAX-TBMIN)/10.
      CALL LINLIN('FREQUENCY, GHz?',F1,5,20.*DF,80.,1,'(F7.3)',
     & 'BRIGHTNESS TEMPERATURE, K?',TBMIN,10,DELTB,40.,1,'(F7.2)')
c  using gfortran syntax for hexadecimal
      CALL PLOTLINE(F,TBh,M,Z'4444')
      CALL PLOTLINE(F,TBv,M,Z'8444')
      IF(ZCALC) THEN
       CALL PLOTLINE(F,TBRC,M,0)
       CALL PLOTLINE(F,TBLC,M,Z'6262')
      ENDIF
      CALL ENDGRAPH
      END

