      SUBROUTINE TBARRAY(NLEV, TEMP, PRES, H2OVAPOR, H2OLIQUID, OZONE,
     & NANG, SECANT1, SECANT2, FREQ, TB1, TB2, E1, E2)
C
C  COMPUTES MICROWAVE EMISSION AND TRANSMISSION FOR AN ATMOSPHERIC 
C  PROFILE FOR TWO PATHS, AT MULTIPLE ANGLES FOR EACH PATH: 
C  PATH 1: PROPAGATION FROM LEVEL NLEV TO LEVEL 1
C  PATH 2: PROPAGATION FROM LEVEL 1 TO LEVEL NLEV
C
C  REFLECTION AT BOUNDARIES AND THE COSMIC BACKGROUND ARE TO BE
C  CONSIDERED IN THE CALLING PROGRAM, E.G. FOR AN OBSERVER AT LEVEL 1
C  WITH SURFACE AT LEVEL NLEV,
C  TB = TB1 + E1*( (1.-Refl)*Tsurf + Refl*(TB2 + E2*TBcosmic) );
C  OR, FOR AN OBSERVER AT LEVEL NLEV WITH SURFACE AT LEVEL 1,
C  TB = TB2 + E2*( (1.-Refl)*Tsurf + Refl*(TB1 + E1*TBcosmic) );
c
C   PWR - Aug 1, 2000
c         Nov. 3, 2000 removed restriction on transmittance range
C         Aug. 28, 2003 Lambertian option
C         July 9, 2007 corrected bug in liquid calculation
C
      IMPLICIT NONE
C  ARGUMENTS
c  Note: H2OLIQUID and OZONE can be set to zeros if not needed.
C        For specular reflection at the surface, SECANT1 and
c        SECANT2 would be identical (both positive).
c        For Lambertian scattering at the surface, set the 
c        secant for the downward-propagating path to any value <1.
c
C   INPUTS
      INTEGER NLEV        !no. of atmospheric levels (<301)
      REAL TEMP(NLEV)     !temperature (K)
      REAL PRES(NLEV)     !pressure (hPa)
      REAL H2OVAPOR(NLEV) !H2O vapor density (g/m**3)
      REAL H2OLIQUID(NLEV)!H2O liquid density (g/m**3)
      REAL OZONE(NLEV)    !O3 number density (molecules/m**3)
      INTEGER NANG        !no. of angles
      REAL SECANT1(NANG)  !secant of propagation angle (measured from 
c                          vertical) along path 1
      REAL SECANT2(NANG)  !secant of propagation angle along path 2
      REAL FREQ           !frequency (GHz)
C   OUTPUTS
      REAL TB1(NANG)      !brightness temperature (K) for path 1; e.g.,
c                          emerging from the atmosphere at level 1
      REAL TB2(NANG)      !brightness temperature (K) for path 2; e.g.,
c                          emerging from the atmosphere at level NLEV
      REAL E1(NANG)       !total transmittance for path 1
      REAL E2(NANG)       !total transmittance for path 2
c
c---------------------------------------------------------------------
c   LOCAL VARIABLES
      INTEGER I,J
      REAL EM,TAV,PAV,WVAV,WLAV,O3AV,ABSCOEF,OPACITY(300),TRAN_SLAB
      REAL O2ABS,ABH2O,ABLIQ,ABSN2,ABSO3,RG,TOTOP1,SECL,SEC1,SEC2
C
      TOTOP1 = 0.
      DO I=2,NLEV
C  use the 'absorption-of-averages' method to compute optical
c  depth of each slab; see M.J. Schwartz, Ph.D. thesis pp. 84-87.
      TAV = (TEMP(I) + TEMP(I-1))/2.
      PAV = SQRT(PRES(I)*PRES(I-1))
      WVAV = (H2OVAPOR(I) + H2OVAPOR(I-1))/2.
      WLAV = (H2OLIQUID(I) + H2OLIQUID(I-1))/2.
      O3AV = (OZONE(I) + OZONE(I-1))/2.
      ABSCOEF =  O2ABS(TAV,PAV,WVAV,FREQ) + 
     & ABH2O(TAV,PAV,WVAV,FREQ) + ABSN2(TAV,PAV,FREQ) + 
     & ABLIQ(WLAV,FREQ,TAV) + ABSO3(TAV,PAV,O3AV,FREQ)
      RG = .0293*(1. + .00174*WVAV*TAV/PAV)
      OPACITY(I) = ABSCOEF*RG*TAV*ABS(ALOG(Pres(I)/Pres(I-1)))
      TOTOP1 = TOTOP1 + OPACITY(I)
      END DO
C  approximate Lambertian distribution by a single angle
      SECL = 1.55 - .16*ALOG(TOTOP1 + .06)
      SECL = AMAX1(SECL, 1.)
C
      DO 10 J=1,NANG
C  initialize at each angle
       TB1(J) = 0.
       TB2(J) = 0.
       E1(J) = 1.
       E2(J) = 1.
      SEC1 = SECANT1(J)
      IF(SEC1.LT.1.) SEC1 = SECL
      SEC2 = SECANT2(J)
      IF(SEC2.LT.1.) SEC2 = SECL
      DO 20 I=2,NLEV
      TAV = (TEMP(I) + TEMP(I-1))/2.
C   trace path 1 using integral form of RTE
      EM = E1(J)
      E1(J) = E1(J)*EXP(-SEC1*OPACITY(I))
      TB1(J) = TB1(J) + TAV*(EM-E1(J))
C   trace path 2 using differential form of RTE
      TRAN_SLAB = EXP(-SEC2*OPACITY(I))
      TB2(J) = TAV + TRAN_SLAB*(TB2(J)-TAV)
      E2(J) = E2(J)*TRAN_SLAB
20    CONTINUE
C
10    CONTINUE
      RETURN
      END
