      SUBROUTINE REF (RH,RV,EC,ANGLE)
C
C        PURPOSE
C           COMPUTE THE POWER REFLECTION COEFFICIENTS FOR A SPECULAR
C           DIELECTRIC SURFACE
C
C        DESCRIPTION OF ARGUMENTS
C           RH-CALCULATED REFLECTION COEFFICIENT FOR HORIZONTAL POLARIZA
C           RV-CALCULATED REFLECTION COEFFICIENT FOR VERTICAL POLARIZATI
C           EC-INPUT COMPLEX DIELECTRIC CONSTANT
C           ANGLE-ANGLE OF INCIDENCE (FROM NORMAL TO SURFACE)  IN DEGREE
C
      COMPLEX EC,Z,RV1,RH1
      THETA = ANGLE/57.296
      COSINE = COS(THETA)
      Z=CSQRT(EC-SIN(THETA)**2)
      RV1=(EC*COSINE    -Z)/(EC*COSINE    +Z)
      RH1=(COSINE    -Z)/(COSINE    +Z)
      RV = REAL(RV1)**2 +AIMAG(RV1)**2
      RH = REAL(RH1)**2 +AIMAG(RH1)**2
      RETURN
      END
