      subroutine textout(x,y,cw,string,termin,rotate)
c  Copyright © P.W. Rosenkranz  Dec. 26, 2014 Creative Commons license CC BY-SA

C    WRITE TEXT STRING STARTING AT PS VALUE x,y IF cw=0,
C     OR CENTERED ON x IF cw>0 (character spacing in PS units)
C     ROTATION CCW BY ANGLE rotate
C    MAXIMUM 64 CHARACTERS

      include 'common.inc'
      character*1 string(64) !text string ending with termin char.
      character*1 termin !termination character
      real x,y,cw,x1,y1
      integer rotate,i,n

      n = 1
      do i=2,64
       if(string(i).eq.termin) goto 20
       n = i
      end do
20    continue
      x1 = x
      y1 = y
      if(cw.gt.0.) then
        if(rotate.eq.0) x1 = x - n*cw/2.
        if(rotate.eq.90) y1 = y1 - n*cw/2.
      endif

      write(NUNIT,1) x1,y1
1     format(2f11.5,' m')
      if(rotate.ne.0) write(NUNIT,2) rotate
2     format(i4,' r')
      write(NUNIT,*) '(', (string(i),i=1,n), ') s'
      if(rotate.ne.0) write(NUNIT,2) -rotate
      return
      end
