      SUBROUTINE SETUPPS(ISIZE)
c Copyright © P.W. Rosenkranz May 7, 2016 Creative Commons license CC BY-SA

C   FUNCTION- OPENS FILE FOR PS OUTPUT AND SELECTS A FONT SIZE.
C   FORTRAN UNIT 92 IS USED FOR PLOTTING.
C   INPUT:
      integer isize ! font size

      include 'common.inc'
      CHARACTER*40 A
      wline = 1. !width of lines, in PS units

      IF(XMAX.GT.612 .OR. YMAX.GT.792) WRITE(*,*) 'WARNING: x=',
     & XMAX/72.,' in. OR y=',YMAX/72.,' in. >(letter size)'

      WRITE(*,*) 'ENTER FILENAME.eps:'
C  GET KEYBOARD INPUT, THEN OPEN OUTPUT FILE
      READ(*,1) A
1     FORMAT(A40)
      NUNIT = 92
      open(NUNIT,file=a,status='unknown',form='formatted')

C  WRITE PROLOG
      write(nunit,2) ifix(Xmax+.99),ifix(Ymax+.99),wline
2     format('%!PS-Adobe-3.0 EPSF-3.0'/'%%BoundingBox: 0 0',2i5/
     & '%%Pages: 1'/'%%LanguageLevel: 2'/ '%%EndComments'/
     & '%%BeginProlog'/ '%%BeginResource: procset SDRes-Prolog 1.0 0'/
     & '/b4_inc_state save def'/ '/dict_count countdictstack def'/
     & '/op_count count 1 sub def'/ 'userdict begin'/
     & '1 1 scale 0 setgray 0 setlinecap ',f4.1,' setlinewidth'/
     & '1 setlinejoin 10 setmiterlimit[] 0 setdash newpath')

      write(nunit,3) isize
3     format('/bd {bind def} bind def'/ '/l {lineto} bd'/
     & '/d {setdash} bd'/ '/m {moveto} bd'/
     & '/c {6 2 roll 6 2 roll 6 2 roll curveto} bd'/
     & '/r {rotate} bd'/ '/s {show} bd'/ '/p {closepath} bd'/ 
     & '/f {eofill} bd'/ '/k {stroke} bd'/ '%%EndResource'/
     & '%%EndProlog'/ '%%Page: 1 1'/ '/Courier-bold ',i3,' selectfont')

      RETURN
      END

