      SUBROUTINE PLOTPT(X,Y,ISYM,SIZE)
C
c  Copyright © May 7, 2016 P.W. Rosenkranz; Creative Commons license CC BY-SA
C
C  PROGRAMMER- phil.rosenkranz@alum.mit.edu
C
C  PURPOSE - PLOTS A SYMBOL AT LOCATION (X,Y)
C  NOTE: IF EITHER X OR Y SCALE IS LOGARITHMIC, USER UNITS ARE
C        LOG(BASE 10) OF DATA.
C
C  CALLING SEQUENCE PARAMETERS-
C
C  NAME     TYPE    I/O     DESCRIPTION
C
C   X        R*4     I      ABSCISSAA IN USER UNITS 
C   Y        R*4     I      ORDINATE IN USER UNITS
C   ISYM     I*4     I      SYMBOL IDENTIFIER:
C                           0=dot, 1=+, 2=x, 3=*, 
C                           4=square, 5=filled square,
C                           6=circle, 7=filled circle,
C                           8=triangle, 9= filled triangle
C   SIZE     R*4     I      SIZE OF SYMBOLS 1-7 IN PS UNITS;
C                           triangle slightly larger
C
C  COMMON PARAMETERS- PREVIOUSLY SET UP
C
C   UVALX,UVALY           COORDINATES OF ORIGIN IN USER UNITS
C   SCALEX,SCALEY         SCALING FACTORS (USER UNITS/PS)
C   ORX,ORY               PS COORDINATES OF ORIGIN
C   WLINE                 LINE WIDTH IN PS UNITS
C
C  SUBROUTINES CALLED- RECTANG, LINE, CIRCLE, CONVPT
C
C********************************************************************
C
      include 'common.inc'
      REAL*4 X,Y,SIZE
      INTEGER*4 ISYM
      REAL*4 X1,Y1,X2,Y2,X3,XP,YP,H,W2
      LOGICAL FILL
C
      H = SIZE/2.
      W2 = WLINE/2.
C
      CALL CONVPT(X,Y,XP,YP)
      X1 = XP-H
      Y1 = YP-H
      X2 = XP+H
      Y2 = YP+H
C
C     PLOT THE REQUESTED SYMBOL
      GOTO (100,10,20,10,40,40,60,60,80,80), ISYM+1
C
C     DOT
100   CALL LINE(XP-W2,YP,XP+W2,YP)
      RETURN
C
C     PLUS (or *)
10    CALL LINE(XP,Y1,XP,Y2)
      CALL LINE(X1,YP,X2,YP)
      IF(ISYM.EQ.1) RETURN
C
C     X
20    CALL LINE(X1,Y1,X2,Y2)
      CALL LINE(X1,Y2,X2,Y1)
      RETURN
C
C     SQUARE
40    FILL = ISYM.EQ.5
      CALL RECTANG(X1,Y1,X2,Y2,FILL)
      RETURN
C
C     CIRCLE
60    FILL = ISYM.EQ.7
      CALL CIRCLE(XP,YP,H,FILL)
      RETURN
C
C     INVERTED TRIANGLE
80    Y1 = YP-1.5*H
      X2 = XP+1.25*H
      Y2 = YP+.75*H
      X3 = XP-1.25*H
      if(isym.eq.8) then
        write(NUNIT,1) xp,y1,x2,y2,x3,y2
1       format(2f10.4,' m ',2(2f10.4,' l '),'p k')
      else
        write(NUNIT,3) xp,y1,x2,y2,x3,y2
3       format(2f10.4,' m ',2(2f10.4,' l '),'p f')
      endif
      RETURN
      END
