      SUBROUTINE PLOTLINE(XARRAY,YARRAY,LENGTH,STYLE)
c   Copyright © Feb.6, 2016 P.W. Rosenkranz; Creative Commons license CC BY-SA
C
C   PROGRAMMER- phil.rosenkranz@alum.mit.edu
C
C   FUNCTION- 
C     PLOTS LINE SEGMENTS THROUGH USER POINTS DEFINED BY XARRAY
C     AND YARRAY, USING SCALE PARAMETERS SET UP BY LINLOG, ETC.
C     NOTE: IF EITHER X OR Y SCALE IS LOGARITHMIC, USER UNITS ARE
C        LOG(BASE 10) OF DATA.
C
C   CALLING SEQUENCE PARAMETERS-
C
C   NAME   TYPE  I/O    DESCRIPTION
C
C   XARRAY  R*4   I     ARRAY OF ABSCISSA VALUES IN USER UNITS
C   YARRAY  R*4   I     ARRAY OF ORDINATE VALUES IN USER UNITS
C   LENGTH  I*4   I     LENGTH OF X AND Y ARRAYS
C   STYLE   I*2   I     LINE STYLE PACKED INTO 4 HEXDIGITS:
C       (dash_space_dash_space); e.g. (fort77) 16#ffff = LONG DASHES; 
C       16#f888 = LONG&SHORT DASHES; (in gfortran, write e.g. Z'ffff');
C       0 IMPLIES SOLID LINE.
C***************************************************************
      include 'common.inc'
      INTEGER*2 STYLE,NONOFF(4),MASK
      INTEGER*4 LENGTH,I
      LOGICAL SOLID
      REAL*4 XARRAY(LENGTH),YARRAY(LENGTH),XP,YP
      DATA MASK/15/
C
      CALL CONVPT(XARRAY(1),YARRAY(1),XP,YP)

C  determine line type and move to start position
      SOLID = STYLE.EQ.0
      IF(SOLID) THEN
        WRITE(NUNIT,1) XP,YP
1       FORMAT(2f10.4,' m')
      ELSE
        NONOFF(1) = IAND(ISHFT(STYLE,-12),MASK)
        NONOFF(2) = IAND(ISHFT(STYLE,-8),MASK)
        NONOFF(3) = IAND(ISHFT(STYLE,-4),MASK)
        NONOFF(4) = IAND(STYLE,MASK)
        WRITE(NUNIT,5) NONOFF,XP,YP
5       FORMAT('[',4I3,' ] 0 d ',2f10.4,' m')
      ENDIF

C  draw line
      DO 20 I=2,LENGTH
       CALL CONVPT(XARRAY(I),YARRAY(I),XP,YP)
       WRITE(NUNIT,2) XP,YP
2      FORMAT(2f10.4,' l')
20    CONTINUE
      WRITE(NUNIT,3)
3     FORMAT('k')
      IF(.NOT.SOLID) WRITE(NUNIT,6) !restore solid line type
6     FORMAT('[ ] 0 d')
      RETURN
      END

