      SUBROUTINE LOGLOG(STRINGX,OVALX,DECX,PX,FORMX,
     & STRINGY,OVALY,DECY,PY,FORMY)
C
c  Copyright © P.W. Rosenkranz Sept. 4, 2015 Creative Commons license CC BY-SA

C   PROGRAMMER- phil.rosenkranz@alum.mit.edu
C
C   FUNCTION- 
C     DRAWS AN ENCLOSED AND LABELED GRAPH WITH LOG (10 TICS/DIVISION)
C      SCALES ON X AND Y AXES.
C     TIC MARKS APPEAR ON ALL 4 SIDES OF THE BOX.
C     ALSO DEFINES VARIABLES IN COMMON /GRCOM/ FOR USE BY PLOTLINE,
C     PLOTPT, ETC.
C
C   CALLING SEQUENCE PARAMETERS (ALL INPUTS)-
C
C   NAME   TYPE    DESCRIPTION
C
C  STRINGX CHAR    TITLE FOR X AXIS, TERMINATED WITH ?
C  OVALX   REAL    ALOG(BASE10) OF USER VALUE AT X ORIGIN (LLC)
C  DECX    REAL    NUMBER OF DECADES ALONG X AXIS - POSITIVE/NEGATIVE
C                   FOR LOG SCALE INCREASING/DECREASING TOWARD RIGHT
C  PX      REAL    PS UNITS/DECADE ALONG X-AXIS
C  FORMX   CHAR    FORMAT SPEC. FOR X-AXIS,
C                  INT.EXPONENT-TYPE EXAMP. '(I3)' MAX.WIDTH = 3
C                  FLOATING-TYPE EXAMP. '(F7.3)' MAX.WIDTH = 7
C  STRINGY CHAR    TITLE FOR Y AXIS, TERMINATED WITH ?
C  OVALY   REAL    ALOG(BASE10) OF USER VALUE AT Y ORIGIN (LLC)
C  DECY    REAL    NUMBER OF DECADES ALONG Y AXIS - POSITIVE/NEGATIVE
C                  FOR LOG SCALE INCREASING/DECREASING TOWARD TOP
C  PY      REAL    PS UNITS/DECADE ALONG Y-AXIS
C  FORMY   CHAR    FORMAT SPEC. FOR Y-AXIS, INT.EXPONENT OR FLOATING
C
C   SUBROUTINES CALLED- SETUPPS, RECTANG, LINE, TEXTOUT
C***********************************************************************
C
      include 'common.inc'
      CHARACTER*64 STRINGX,STRINGY
      CHARACTER*8 BUFFER8
      CHARACTER*7 BUFFER
      EQUIVALENCE (BUFFER8,BUFFER)
      CHARACTER*6 FORMX,FORMY
      REAL OVALX,OVALY,DECX,DECY,X1,X2,Y1,Y2,CH,CW,PX,PY
      INTEGER LOVALX,LOVALY,ITICX,ITICY,IFS,LTOP,LRT
C
C     INITIALIZE AND SET PARAMETERS
C     THIS VERSION FOR HARDWARE Y VALUES INCREASING VERTICALLY
C
      IFS = 18 ! font size
      ch = 10. ! character height in PS units
      cw = 11. ! character spacing in PS units
      LOVALX = INT(OVALX)
      FX = OVALX - LOVALX
      IF(FX.LT.0.) THEN
        LOVALX = LOVALX -1
        FX = FX +1.
      ENDIF
      LRT = INT(OVALX+DECX)
      FRT = OVALX+DECX - LRT
      ITICX = INT(10.**FX) + 1
      ADECX = ABS(DECX)
      SGX = SIGN(1.,DECX)
      LOVALY = INT(OVALY)
      FY = OVALY - LOVALY
      IF(FY.LT.0.) THEN
        LOVALY = LOVALY -1
        FY = FY +1.
      ENDIF
      LTOP = INT(OVALY+DECY)
      FTOP = OVALY+DECY - LTOP
      ITICY = INT(10.**FY) + 1
      ADECY = ABS(DECY)
      SGY = SIGN(1.,DECY)
      CH2 = CH/2.
      FLT = CH2                    !length of tics
      IF(INDEX(FORMX,'I').EQ.0 .AND. INDEX(FORMX,'i').EQ.0) THEN
       FWX = 7.                     !max format field width
      ELSE
       FWX = 3.
      ENDIF
      IF(INDEX(FORMY,'I').EQ.0 .AND. INDEX(FORMY,'i').EQ.0) THEN
       FWY = 7.
      ELSE
       FWY = 3.
      ENDIF
      FNX = ADECX*PX               !width of frame
      FNY = ADECY*PY               !height of frame
      ORX = 2.*CH + (FWY+3.)*CW    ! PHYS COORD OF LLC
      ORY = 6.*CH                  ! PHYS COORD OF LLC
      FMX = ORX + FNX              ! right side of frame
      FMY = ORY + FNY              ! top of frame
      XMAX = FMX + FWX*CW          !LARGEST X COORD USED
      YMAX = FMY + 2.*CH           !LARGEST Y COORD USED
      CALL SETUPPS(IFS)
      UVALX = OVALX                ! USER COORD OF LLC
      UVALY = OVALY                ! USER COORD OF LLC
      SCALEX = SGX/PX              ! SCALE FACTOR (USER/PHYS)
      SCALEY = SGY/PY              ! SCALE FACTOR (USER/PHYS)
C
C     DRAW BOX
      CALL RECTANG(ORX,ORY,FMX,FMY,.FALSE.)
C
C     DRAW TIC MARKS AND LABEL X-AXIS
      A = 0.
      IF(SGX.LT.0.) A = 1.
      IF(ABS(FX).LT. .001 .AND. SGX.GT.0.) THEN  !label origin
        X1 = ORX
        LUX = LOVALX
        GOTO 12
      ENDIF
      IF(ABS(FRT).LT. .001 .AND. SGX.LT.0.) THEN  !label rightmost decade
        X1 = FMX
        LUX = LRT
        GOTO 12
      ENDIF
5     CONTINUE
      DO 10 J=ITICX,10
      X1 = ORX + (A+SGX*ALOG10(FLOAT(J))-FX)*PX
      IF(X1.GT.FMX) GOTO 14
      Y1 = ORY + FLT
      Y2 = ORY
      CALL LINE(X1,Y1,X1,Y2)
      Y1 = FMY
      Y2 = Y1 - FLT
      CALL LINE(X1,Y1,X1,Y2)
10    CONTINUE
      ITICX = 2
C
C     LABEL DECADE TICS
      A = A+1.
      LUX = LOVALX + A
      IF(SGX.LT.0.) LUX = LOVALX -A +2
12    BUFFER8 = '????????'
      IF(FWX.GT.3.) THEN
       FLUX = 10.**LUX
       WRITE(BUFFER,FORMX) FLUX
       XORIG_LABEL = X1 -((FWX+1.)*CW)/2.
      ELSE
       WRITE(BUFFER,FORMX) LUX
       XORIG_LABEL = X1 -((FWX-4.)*CW)/2.
      ENDIF
      YORIG_LABEL = ORY - 2.*CH
      CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,0.,BUFFER8,'?',0)
      IF(FWX.LE.3.) THEN
       XORIG_LABEL = XORIG_LABEL -2.*CW
       YORIG_LABEL = YORIG_LABEL - CH2
       CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,0.,'10?','?',0)
      ENDIF
      GO TO 5

C     WRITE X-AXIS STRING
14    XORIG_LABEL = ORX + FNX/2.
      YORIG_LABEL = ORY -4.5*CH
      CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,CW,STRINGX,'?',0)
C
C     DRAW TIC MARKS AND LABEL Y-AXIS
      A = 0.
      IF(SGY.LT.0.) A = 1.
      IF(ABS(FY).LT. .001 .AND. SGY.GT.0.) THEN  !label origin
        Y1 = ORY
        LUY = LOVALY
        GOTO 22
      ENDIF
      IF(ABS(FTOP).LT. .001 .AND. SGY.LT.0.) THEN  !label top decade
        Y1 = FMY
        LUY = LTOP
        GOTO 22
      ENDIF
15    CONTINUE
      DO 20 J=ITICY,10
      Y1 = ORY +(A+SGY*(ALOG10(FLOAT(J))-FY))*PY
      IF(Y1.GT.FMY) GOTO 30
      X1 = ORX
      X2 = ORX + FLT
      CALL LINE(X1,Y1,X2,Y1)
      X2 = FMX
      X1 = X2 - FLT
      CALL LINE(X1,Y1,X2,Y1)
20    CONTINUE
      ITICY = 2

C     LABEL DECADE TICS
      A = A+1.
      LUY = LOVALY + A
      IF(SGY.LT.0.) LUY = LOVALY -A +2
22    BUFFER8 = '????????'
      IF(FWY.GT.3.) THEN
       FLUY = 10.**LUY
       WRITE(BUFFER,FORMY) FLUY
       YORIG_LABEL = Y1 -CH2
      ELSE
       WRITE(BUFFER,FORMY) LUY
       YORIG_LABEL = Y1
      ENDIF
      XORIG_LABEL = ORX - FWY*CW
      CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,0.,BUFFER8,'?',0)
      IF(FWY.LE.3.) THEN
       XORIG_LABEL = XORIG_LABEL -2.*CW
       YORIG_LABEL = YORIG_LABEL - CH2
       CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,0.,'10?','?',0)
      ENDIF
      GOTO 15

C     WRITE Y-AXIS STRING
30    XORIG_LABEL = 1.5*CH
      YORIG_LABEL = ORY + FNY/2.
      CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,CW,STRINGY,'?',90)
      RETURN
      END
