      SUBROUTINE LOGLIN(STRINGX,OVALX,DECX,PX,FORMX,
     & STRINGY,OVALY,NDIVY,DELTAY,PY,NDLY,FORMY)
C
c  Copyright © P.W. Rosenkranz Sept. 4, 2015 Creative Commons license CC BY-SA

C   PROGRAMMER- phil.rosenkranz@alum.mit.edu
C
C   FUNCTION- 
C     DRAWS AN ENCLOSED AND LABELED GRAPH WITH LOG (10 TICS/DIVISION)
C     SCALE ON X-AXIS AND LINEAR (1 TIC/DIVISION) SCALE ON Y-AXIS.
C     TIC MARKS APPEAR ON ALL 4 SIDES OF THE BOX.
C     ALSO DEFINES VARIABLES IN COMMON /GRCOM/ FOR USE BY PLOTLINE,
C     PLOTPT, ETC.
C
C   CALLING SEQUENCE PARAMETERS (ALL INPUTS)-
C
C   NAME   TYPE    DESCRIPTION
C
C  STRINGX CHAR    TITLE FOR X AXIS, TERMINATED WITH ?
C  OVALX   REAL    ALOG(BASE10) OF USER VALUE AT X ORIGIN (LLC)
C  DECX    REAL    NUMBER OF DECADES ALONG X AXIS - POSITIVE/NEGATIVE
C                   FOR LOG SCALE INCREASING/DECREASING TOWARD RIGHT
C  PX      REAL    PS UNITS/DECADE ALONG X-AXIS
C  FORMX   CHAR    FORMAT SPEC. FOR X-AXIS,
C                  INT.EXPONENT-TYPE EXAMP. '(I3)' MAX.WIDTH = 3
C                  FLOATING-TYPE EXAMP. '(F7.3)' MAX.WIDTH = 7
C  STRINGY CHAR    TITLE FOR Y AXIS, TERMINATED WITH ?
C  OVALY   REAL    USER VALUE OF Y ORIGIN (LLC)
C  NDIVY   INT     NUMBER OF DIVISIONS ALONG Y AXIS
C  DELTAY  REAL    USER UNITS/DIVISION - POSITIVE/NEGATIVE IF
C                   INCREASING/DECREASING TOWARD TOP
C  PY      REAL    PS UNITS/DIVISION ALONG Y AXIS
C  NDLY    INT     NO. OF DIVISIONS BETWEEN LABELS FOR Y AXIS
C  FORMY   CHAR    FORMAT SPEC. (F-TYPE) FOR Y-AXIS 
C
C   SUBROUTINES CALLED- SETUPPS, RECTANG, LINE, TEXTOUT
C***********************************************************************
C
      include 'common.inc'
      CHARACTER*64 STRINGX,STRINGY
      CHARACTER*8 BUFFER8
      CHARACTER*7 BUFFER
      EQUIVALENCE (BUFFER8,BUFFER)
      CHARACTER*6 FORMX,FORMY
      REAL OVALX,OVALY,DECX,DELTAY,FX,X1,X2,Y1,Y2,CH,CW,PX,PY
      INTEGER LOVALX,ITICX,IFS,LRT
C
C     INITIALIZE AND SET PARAMETERS
C     THIS VERSION FOR HARDWARE Y VALUES INCREASING VERTICALLY
C
      IFS = 18 ! font size
      ch = 10. ! character height in PS units
      cw = 11. ! character spacing in PS units
      LOVALX = INT(OVALX)
      FX = OVALX - LOVALX
      IF(FX.LT.0.) THEN
        LOVALX = LOVALX -1
        FX = FX +1.
      ENDIF
      LRT = INT(OVALX+DECX)
      FRT = OVALX+DECX - LRT
      ITICX = INT(10.**FX) + 1
      ADECX = ABS(DECX)
      SGX = SIGN(1.,DECX)
      CH2 = CH/2.
      FLT = CH2                    !length of tics
      IF(INDEX(FORMX,'I').EQ.0 .AND. INDEX(FORMX,'i').EQ.0) THEN
       FWX = 7.                    !max format field width
      ELSE
       FWX = 3.
      ENDIF
      FWY = 7.
      FNX = ADECX*PX               !width of frame
      FNY = NDIVY*PY               !height of frame
      ORX = 2.*CH +FWY*CW          ! PHYS COORD OF LLC
      ORY = 6.*CH                  ! PHYS COORD OF LLC
      FMX = ORX + FNX              ! right side of frame
      FMY = ORY + FNY              ! top of frame
      XMAX = FMX + FWX*CW          !LARGEST X COORD USED
      YMAX = FMY + 2.*CH           !LARGEST Y COORD USED
      CALL SETUPPS(IFS)
      UVALX = OVALX                ! USER COORD OF LLC
      UVALY = OVALY                ! USER COORD OF LLC
      SCALEY = DELTAY/PY           ! SCALE FACTOR (USER/PHYS)
      SCALEX = SGX/PX              ! SCALE FACTOR (USER/PHYS)
C
C     DRAW BOX
      CALL RECTANG(ORX,ORY,FMX,FMY,.FALSE.)
C
C     DRAW TIC MARKS AND LABEL X-AXIS
      A = 0.
      IF(SGX.LT.0.) A = 1.
      IF(ABS(FX).LT. .001 .AND. SGX.GT.0.) THEN  !label origin
        X1 = ORX
        LUX = LOVALX
        GOTO 12
      ENDIF
      IF(ABS(FRT).LT. .001 .AND. SGX.LT.0.) THEN  !label rightmost decade
        X1 = FMX
        LUX = LRT
        GOTO 12
      ENDIF
5     CONTINUE
      DO 10 J=ITICX,10
      X1 = ORX + (A+SGX*ALOG10(FLOAT(J))-FX)*PX
      IF(X1.GT.FMX) GOTO 14
      Y1 = ORY + FLT
      Y2 = ORY
      CALL LINE(X1,Y1,X1,Y2)
      Y1 = FMY
      Y2 = Y1 - FLT
      CALL LINE(X1,Y1,X1,Y2)
10    CONTINUE
      ITICX = 2
C
C     LABEL DECADE TICS
      A = A+1.
      LUX = LOVALX + A
      IF(SGX.LT.0.) LUX = LOVALX -A +2
12    BUFFER8 = '????????'
      IF(FWX.GT.3.) THEN
       FLUX = 10.**LUX
       WRITE(BUFFER,FORMX) FLUX
       XORIG_LABEL = X1 -((FWX+1.)*CW)/2.
      ELSE
       WRITE(BUFFER,FORMX) LUX
       XORIG_LABEL = X1 -((FWX-4.)*CW)/2.
      ENDIF
      YORIG_LABEL = ORY - 2.*CH
      CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,0.,BUFFER8,'?',0)
      IF(FWX.LE.3.) THEN
       XORIG_LABEL = XORIG_LABEL -2.*CW
       YORIG_LABEL = YORIG_LABEL - CH2
       CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,0.,'10?','?',0)
      ENDIF
      GO TO 5

C     WRITE X-AXIS STRING
14    XORIG_LABEL = ORX + FNX/2.
      YORIG_LABEL = ORY -4.5*CH
      CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,CW,STRINGX,'?',0)
C
C     DRAW TIC MARKS AND LABEL Y-AXIS
      DO 20 I=1,NDIVY
      Y1 = ORY + I*PY
      X1 = ORX
      X2 = ORX +FLT
      CALL LINE(X1,Y1,X2,Y1)
      X2 = FMX
      X1 = X2 - FLT
      CALL LINE(X1,Y1,X2,Y1)
20    CONTINUE
C     LABEL TICS
      XORIG_LABEL = ORX -(FWY+.3)*CW 
      DO 30 I=0,NDIVY,NDLY
      YORIG_LABEL = ORY -CH2 +I*PY
      UY = OVALY + I*DELTAY
      BUFFER8 = '????????'
      WRITE(BUFFER,FORMY) UY
30    CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,0.,BUFFER8,'?',0)
C
C     WRITE Y-AXIS STRING
      XORIG_LABEL = 1.5*CH
      YORIG_LABEL = ORY + FNY/2.
      CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,CW,STRINGY,'?',90)
      RETURN
      END
