      SUBROUTINE LINLIN(STRINGX,OVALX,NDIVX,DELTAX,PX,NDLX,FORMX,
     & STRINGY,OVALY,NDIVY,DELTAY,PY,NDLY,FORMY)
C
c Copyright © Apr. 25, 2015 P.W. Rosenkranz; Creative Commons license CC BY-SA

C   PROGRAMMER- phil.rosenkranz@alum.mit.edu
C
C   FUNCTION- 
C     DRAWS AN ENCLOSED AND LABELED GRAPH WITH LINEAR (1 TIC/DIVISION)
C     SCALES ON BOTH AXES.
C     TIC MARKS APPEAR ON ALL 4 SIDES OF THE BOX.
C     ALSO DEFINES VARIABLES IN COMMON /GRCOM/ FOR USE BY PLOTLINE,
C     PLOTPT, ETC.
C
C   CALLING SEQUENCE PARAMETERS (ALL INPUTS)-
C
C   NAME   TYPE    DESCRIPTION
C
C  STRINGX CHAR    TITLE FOR X AXIS, TERMINATED WITH ?
C  OVALX   REAL    USER VALUE OF X ORIGIN (LLC)
C  NDIVX   INT     NUMBER OF DIVISIONS ALONG X AXIS
C  DELTAX  REAL    USER UNITS/DIVISION - POSITIVE/NEGATIVE IF
C                   INCREASING/DECREASING TOWARD RIGHT
C  PX      REAL    PS UNITS/DIVISION ALONG X AXIS
C  NDLX    INT     NO. OF DIVISIONS BETWEEN LABELS FOR X AXIS
C  FORMX   CHAR    FORMAT SPEC. (F-TYPE) FOR X-AXIS 
C                   EX: '(F7.3)' MAX.WIDTH = 7
C  STRINGY CHAR    TITLE FOR Y AXIS, TERMINATED WITH ?
C  OVALY   REAL    USER VALUE OF Y ORIGIN (LLC)
C  NDIVY   INT     NUMBER OF DIVISIONS ALONG Y AXIS
C  DELTAY  REAL    USER UNITS/DIVISION - POSITIVE/NEGATIVE IF
C                   INCREASING/DECREASING TOWARD TOP
C  PY      REAL    PS UNITS/DIVISION ALONG Y AXIS
C  NDLY    INT     NO. OF DIVISIONS BETWEEN LABELS FOR Y AXIS
C  FORMY   CHAR    FORMAT SPEC. (F-TYPE) FOR Y-AXIS 
C                   EX: '(F7.3)' MAX.WIDTH = 7
C
C   SUBROUTINES CALLED- SETUPPS, RECTANG, LINE, TEXTOUT
C***********************************************************************
C
      include 'common.inc'
      CHARACTER*64 STRINGX,STRINGY
      CHARACTER*8 BUFFER8
      CHARACTER*7 BUFFER
      EQUIVALENCE (BUFFER8,BUFFER)
      REAL OVALX,OVALY,DELTAX,DELTAY,X1,X2,Y1,Y2,CH,CW,PX,PY
      INTEGER NDIVX,NDIVY,NDLX,NDLY,IFS
      CHARACTER*6 FORMX,FORMY
C
C     INITIALIZE AND SET PARAMETERS
C     THIS VERSION FOR HARDWARE Y VALUES INCREASING VERTICALLY
C
      IFS = 18 ! font size
      ch = 10. ! character height in PS units
      cw = 11. ! character spacing in PS units
      CH2 = CH/2.
      FLT = CH2                    !length of tics
      FWX = 7.                     !max format field width
      FWY = 7.

      FNX = NDIVX*PX               !width of frame
      FNY = NDIVY*PY               !height of frame
      ORX = 2.*CH +FWY*CW          ! PHYS COORD OF LLC
      ORY = 5.*CH                  ! PHYS COORD OF LLC
      FMX = ORX + FNX              ! right side of frame
      FMY = ORY + FNY              ! top of frame
      XMAX = FMX + FWX*CW/2. + CW  !LARGEST X COORD USED
      YMAX = FMY + 2.*CH           !LARGEST Y COORD USED
      CALL SETUPPS(IFS)
      UVALX = OVALX                ! USER COORD OF LLC
      UVALY = OVALY                ! USER COORD OF LLC
      SCALEY = DELTAY/PY           ! SCALE FACTOR (USER/PHYS)
      SCALEX = DELTAX/PX           ! SCALE FACTOR (USER/PHYS)
C
C     DRAW BOX
      CALL RECTANG(ORX,ORY,FMX,FMY,.FALSE.)
C
C     DRAW TIC MARKS AND LABEL X-AXIS
      DO 10 I=1,NDIVX
      X1 = ORX +I*PX
      Y1 = ORY +FLT
      Y2 = ORY
      CALL LINE(X1,Y1,X1,Y2)
      Y1 = FMY
      Y2 = Y1 - FLT
      CALL LINE(X1,Y1,X1,Y2)
10    CONTINUE
C
C     LABEL TICS
      YORIG_LABEL = ORY - 2.*CH
      DO 12 I=0,NDIVX,NDLX
      XORIG_LABEL = ORX - (FWX*CW +CW)/2.  + I*PX
      UX = OVALX + I*DELTAX
      BUFFER8 = '????????'
      WRITE(BUFFER,FORMX) UX
      CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,0.,BUFFER8,'?',0)
12    CONTINUE
C     WRITE X-AXIS STRING
      XORIG_LABEL = ORX + FNX/2.
      YORIG_LABEL = ORY - 4.*CH
      CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,CW,STRINGX,'?',0)
C
C     DRAW TIC MARKS AND LABEL Y-AXIS
      DO 20 I=1,NDIVY
      Y1 = ORY + I*PY
      X1 = ORX
      X2 = ORX +FLT
      CALL LINE(X1,Y1,X2,Y1)
      X2 = FMX
      X1 = X2 - FLT
      CALL LINE(X1,Y1,X2,Y1)
20    CONTINUE
C     LABEL TICS
      XORIG_LABEL = ORX -(FWY+.3)*CW 
      DO 30 I=0,NDIVY,NDLY
      YORIG_LABEL = ORY -CH2 +I*PY
      UY = OVALY + I*DELTAY
      BUFFER8 = '????????'
      WRITE(BUFFER,FORMY) UY
30    CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,0.,BUFFER8,'?',0)
C
C     WRITE Y-AXIS STRING
      XORIG_LABEL = 1.5*CH
      YORIG_LABEL = ORY + FNY/2.
      CALL TEXTOUT(XORIG_LABEL,YORIG_LABEL,CW,STRINGY,'?',90)
      RETURN
      END
