      subroutine e2rot(cthn,phi,bvec,rotfac,cbth,bfield)
c  calculates angles and phase factor for tbmx
c  5/6/15  phil.rosenkranz@alum.mit.edu

      implicit none
c  inputs:
      real cthn  ! cos(angle of propagation, from nadir)
      real phi   ! azimuth angle of propagation, meas from north
c                 toward east, in deg
      real bvec(3) !northward, eastward, downward components of mag field
c  outputs:
      complex rotfac ! exp(i2 * rotation angle of projected B with respect
c                  to V-pol)
      real cbth  ! cos(angle between propagation vector and mag field
      real bfield ! magnitude of Bvec, in same units
c
c  local variables:
      real vpolvec(3),hpolvec(3),propvec(3),sth,sphi,cphi,sbv,cbv,
     & bdotv,bdoth,bdotprop,bfieldproj
      integer i

      sth = sqrt(1.-cthn*cthn)
      cphi = cos(phi/57.296)
      sphi = sin(phi/57.296)
      vpolvec(1) = cphi*cthn
      vpolvec(2) = sphi*cthn
      vpolvec(3) = -sth
      hpolvec(1) = -sphi
      hpolvec(2) = cphi
      hpolvec(3) = 0.
      propvec(1) = cphi*sth
      propvec(2) = sphi*sth
      propvec(3) = cthn
      bfield = 0.
      bdotv = 0.
      bdoth = 0.
      bdotprop = 0.
      do i=1,3
        bfield = bvec(i)**2 + bfield
        bdotv = bvec(i)*vpolvec(i) + bdotv
        bdoth = bvec(i)*hpolvec(i) + bdoth
        bdotprop = bvec(i)*propvec(i) + bdotprop
      end do
      bfield = sqrt(bfield)
      bfieldproj = sqrt(bdotv**2 + bdoth**2)
      cbv = bdotv/bfieldproj
      sbv = -bdoth/bfieldproj
      rotfac = cmplx(2.*cbv*cbv-1., 2.*sbv*cbv)
      cbth = bdotprop/bfield
      return
      end


