      SUBROUTINE DILEC9 (EPS,FREQ,TEMP,ICEFACTOR)
C     COMPUTES THE COMPLEX DIELECTRIC CONSTANT FOR FRESH-WATER ICE
C     IN AN AIR MATRIX
C     P.ROSENKRANZ, 6/1/04
C
      IMPLICIT NONE
C
c     ARGUMENTS 
c     INPUTS:
      REAL  FREQ ! (GHZ)  (VALID FOR .001 TO 1000 GHZ)
      REAL  TEMP ! TEMPERATURE  (KELVIN) (VALID RANGE 233-273)
      REAL ICEFACTOR ! volume filling factor of ice material;
c                      e.g. 1. for pure ice, 0.4 for graupel
C     OUTPUT:
      COMPLEX EPS ! DIELECTRIC CONSTANT (DEFINED WITH NEGATIVE
C                   IMAGINARY PART)
C
C     REFERENCE FOR ICE DIELECTRIC CONSTANT:
C     G. HUFFORD, INT. J. IR & MM WAVES V.12, pp.677-682 (1991).
C     REFERENCES FOR MIXING THEORY:
c     A. SHIVOLA, IEEE TRANS. GEOSCI. REM. SENS. V.27, PP.403-415 (1989),
C     K. KARKKAINEN, A. SHIVOLA, K. NIKOSKINEN, IEEE TRANS. GEOSCI. REM. 
C      SENS. V.39, PP.1013-1018 (2001).
c
C     LOCAL VARIABLES
      REAL THETA,ALPHA,BETA,EPSI
      REAL NU,B,C,EPSREAL,EPSIMAG
C
      THETA = 300./TEMP - 1.
      ALPHA = (50.4E-4 + 62.E-4*THETA)*EXP(-22.1*THETA)
      BETA = (.502E-4 - .131E-4*THETA)/(1.+THETA) + 
     & .542E-6*((1.+THETA)/(THETA+.0073))**2
      EPSI = ALPHA/FREQ + BETA*FREQ
C
C     Shivola's raisin-pudding model for ice (epsilon 3.15) in air matrix
      NU = ICEFACTOR*(2.5*ICEFACTOR -3.55) + 2.35
      B = 5.15 - 2.*NU - 2.15*ICEFACTOR*(1.+NU)
      C = 5.15 - NU + 2.15*ICEFACTOR*(2.-NU)
      EPSREAL = .5*(SQRT(B*B + 4.*NU*C) -B)/NU
      EPSIMAG = EPSI*((1.-EPSREAL) +
     & ICEFACTOR*(EPSREAL + 2. + NU*(EPSREAL-1.))) / 
     & (5.15 + 2.*NU*(EPSREAL-1.) - ICEFACTOR*(1.+NU)*2.15)
      EPS = CMPLX(EPSREAL,-EPSIMAG)
      RETURN
      END

