      subroutine dilec10(kappa,f,tk,sl)
C   Copyright (c) 2008 Massachusetts Institute of Technology

c   Purpose: Computes the complex dielectric constant for water,
c   with a negative imaginary part representing dissipation.
c
      implicit none
c   arguments-
c     output:
      complex kappa ! complex dielectric constant
c     inputs:
      real f  ! frequency in GHz, valid 0-1000
      real tk ! Kelvin temperature, valid 273-303
      real sl ! salinity fraction by weight, valid 0-.040
c               (for seawater, average sl=.035)

c   reference for equations: W. Ellison, section 5.2 in 
c   Thermal Microwave Radiation - Applications for Remote Sensing 
c   (C. Maetzler, ed.), IET, London, 2006.

c   coded 11/7/08 P. Rosenkranz

c   local variables: 
      real a(18)
      real epss,eps1,epsinf,tau1,tau2,sigma,tc,diss,spt,s35,p,q,s2
      complex den1, den2
      data a/.46606917e-2,-.26087876e-4,-.63926782e-5,.63000075e1,
     & .26242021e-2, -.42984155e-2, .34414691e-4, .1766742e-3,
     & -.2049156e-6, .58366888e3, .12634992e3, .69227972e-4,
     & .38957681e-6, .3074233e3, .12634992e3, .37245044e1,
     & .92609781e-2, -.26093754e-1/
c------------------------
      tc = tk - 273.15
      spt = sl*1000.
      s2 = spt**2
      epss = 87.85306*exp(-.00456992*tc -a(1)*spt -a(2)*s2 -a(3)*spt*tc)
      eps1 = a(4)*exp(-a(5)*tc -a(6)*spt -a(7)*spt*tc)
      tau1 = (a(8)+a(9)*spt)*exp(a(10)/(tc+a(11)))
      tau2 = (a(12)+a(13)*spt)*exp(a(14)/(tc+a(15)))
      epsinf = a(16) + a(17)*tc + a(18)*spt
      diss = 0.
      if(sl.le.0.) goto 10
c     conductivity calculation
      s35 = 2.903602 +8.607e-2*tc +4.738817e-4*tc**2 -2.991e-6*tc**3
     & +4.3041e-9*tc**4
      p = spt*(37.5109 +5.45216*spt +.014409*s2)/
     & (1004.75 +182.283*spt +s2)
      q = 1. + (tc-15.)*(6.9431 +3.2841*spt -.099486*s2)/
     & ((84.85 +69.024*spt +s2)*(tc +49.843 -.2276*spt +.00198*s2))
      sigma = s35*p*q
      diss = -17.9751*sigma/f
10    continue
      den1 = cmplx(1., 6.283185*f*tau1)
      den2 = cmplx(1., 6.283185*f*tau2)
      kappa = (epss-eps1)/den1 + (eps1-epsinf)/den2 + cmplx(epsinf,diss)
      return
      end

