      FUNCTION ABSO3 (T,P,O3N,F)
C     3/10/89  PWR
c     8/6/15  read line parameters from a file
C     phil.rosenkranz@alum.mit.edu
C
C      ABSO3 = POWER ABSORPTION COEFF. (NEPERS/KM) IN THE ATMOSPHERE DUE TO 
C            SELECTED LINES OF OZONE, READ FROM FILE o3_list.asc
C            Multiply ABSO3 by 4.343 to obtain dB/km.
C      T = TEMPERATURE (DEG K)
C      P = TOTAL PRESSURE (MILLIBARS)
C      O3N = OZONE NUMBER DENSITY (MOLECULES/M**3)
C      F = FREQUENCY (GHZ)
C
c     Line parameters will be read from file o3_list.asc

      IMPLICIT NONE
      INTEGER NLINES,I,MAXLINES
      PARAMETER (MAXLINES=100)
      REAL ABSO3,T,P,O3N,F
      REAL S1(MAXLINES),B(MAXLINES),W(MAXLINES),FL(MAXLINES),X(MAXLINES)
      REAL SR(MAXLINES),WAIR,REFTLINE,DEN,TI,TI2,QVINV,SUM,S,SHAPE,
     & WIDTHC,BETAD2,WIDTH
      SAVE INIT,REFTLINE,NLINES,S1,B,W,FL,X,SR
      LOGICAL INIT
      CHARACTER*4 HEAD
      DATA INIT/.TRUE./

C   initialization section
      IF(INIT) THEN
        OPEN(80,FILE='o3_list.asc',
     &   STATUS='OLD',FORM='FORMATTED')
        REFTLINE = 296. !reference T for lines
        READ(80,1) HEAD !header for linedata
1       FORMAT(A4)
        DO I=1,MAXLINES
C    LINE INTENSITIES FROM HITRAN INCLUDE ISOTOPOMER ABUNDANCE
C    read line parameters; units: GHz, Hz*cm^2, MHz/mb
          READ(80,2) FL(i),S1(i),B(i),WAIR,X(i),SR(i)
2         FORMAT(4X,F12.4,E12.4,2F7.3,F6.2,F8.4)
          IF(FL(I) .LE. 0.) GOTO 10
          NLINES = I
          W(I) = WAIR/1000.
        END DO
        WRITE(*,*) 'WARNING: maximum O3 lines reached'
10      CONTINUE
        CLOSE(80)
        INIT = .FALSE.
        WRITE(*,*) NLINES,' O3 lines used'
      ENDIF
C
      IF(O3N.LE.0.) THEN
        ABSO3 = 0.
        RETURN
      ENDIF

      DEN = 1.E-6*O3N
      TI = REFTLINE/T
      TI2 = TI**2.5
      QVINV = 1. -EXP(-1008./T)
C
C  ADD RESONANCES
      SUM = 0.
      DO 30 I=1,NLINES
      WIDTHC = W(I)*P*TI**X(I)
      BETAD2 = 3.85E-15*T*FL(I)**2
C  APPROXIMATE WIDTH COMBINES PRESSURE AND DOPPLER BROADENING:
      WIDTH = .5346*WIDTHC +SQRT(.2166*WIDTHC*WIDTHC+.6931*BETAD2)
      S = S1(I)*EXP(B(I)*(1.-TI))
C  LORENTZ SHAPE FACTOR IS OK FOR STRATOSPHERE, WHERE MOST OF THE OZONE IS.
      SHAPE = (F/FL(I))**2*WIDTH/((F-FL(I))**2 +WIDTH*WIDTH)
30    SUM = SUM + S*SHAPE
      ABSO3 = .3183E-4*SUM*QVINV*TI2*DEN
      RETURN
      END
