      FUNCTION ABLIQ(WATER,FREQ,TEMP)
C     COMPUTES POWER ABSORPTION COEFFICIENT IN NEPERS/KM 
C     BY SUSPENDED CLOUD LIQUID WATER DROPLETS. MULTIPLY ABLIQ BY
C     4.343 TO CONVERT TO DB/KM.
C
c     ARGUMENTS (INPUT):
C     WATER IN G/M**3
C     FREQ IN GHZ     (VALID FROM 0 TO 1000 GHZ)
C     TEMP IN KELVIN
C
C     REVISION HISTORY:
C        PWR 6/5/15   using dilec12 for complex dielectric constant
C
      COMPLEX EPS,RE,EPSSL
      IF(WATER.LE.0. .OR. TEMP.LT.233.) THEN
       ABLIQ = 0.
       RETURN
      ENDIF
      CALL DILEC12(EPS,FREQ,TEMP)

C    to extend valid range to 25 THz, un-comment the next two lines
C      CALL DILECSL(EPSSL,FREQ,TEMP)
C      EPS = EPS + EPSSL

      RE = (EPS-1.)/(EPS+2.)
      ABLIQ = -.06286*AIMAG(RE)*FREQ*WATER
      RETURN
      END



