      FUNCTION ABINTO3 (T,P,O3N,F1,F2)
c     12/13/05 pwr,  based on 4/14/05 version of abso3
C     8/6/15   read line parameters from a file
C     phil.rosenkranz@alum.mit.edu
C
C      ABINTO3 = INTEGRATED POWER ABSORPTION COEFFICIENT (GHZ/KM)
C          IN THE ATMOSPHERE DUE TO SELECTED LINES OF OZONE WITHIN
c          A RADIOMETER H2O PASSBAND
C      T = TEMPERATURE (DEG K)
C      P = TOTAL PRESSURE (MILLIBARS)
C      O3N = OZONE NUMBER DENSITY (MOLECULES/M**3)
C      F1,F2 = LOWER AND UPPER LIMITS OF PASSBAND (GHZ)
C
c     Line parameters will be read from file o3_list.asc
C     Reference for equations: P. W. Rosenkranz, "Satellite-based radiometer
c     measurements at 150 and 183 GHz compared with calculated brightness
c     temperatures", IGARSS 2006, Denver, CO. doi:10.1109/IGARSS.2006.263

      IMPLICIT NONE
      INTEGER NLINES,I,MAXLINES
      PARAMETER (MAXLINES=100)
      REAL ABINTO3,T,P,O3N,F1,F2
      REAL S1(MAXLINES),B(MAXLINES),W(MAXLINES),FL(MAXLINES),X(MAXLINES)
      REAL SR(MAXLINES),WAIR,REFTLINE,DEN,TI,TI2,QVINV,SUM,S,WIDTH
      SAVE INIT,REFTLINE,NLINES,S1,B,W,FL,X,SR
      LOGICAL INIT
      CHARACTER*4 HEAD
      DATA INIT/.TRUE./

C   initialization section
      IF(INIT) THEN
        OPEN(80,FILE='o3_list.asc',
     &   STATUS='OLD',FORM='FORMATTED')
        REFTLINE = 296. !reference T for lines
        READ(80,1) HEAD !header for linedata
1       FORMAT(A4)
        DO I=1,MAXLINES
C    LINE INTENSITIES FROM HITRAN INCLUDE ISOTOPOMER ABUNDANCE
C    read line parameters; units: GHz, Hz*cm^2, MHz/mb
C    lines should be in ascending order of frequency
          READ(80,2) FL(i),S1(i),B(i),WAIR,X(i),SR(i)
2         FORMAT(4X,F12.4,E12.4,2F7.3,F6.2,F8.4)
          IF(FL(I) .LE. 0.) GOTO 10
          NLINES = I
          W(I) = WAIR/1000.
        END DO
        WRITE(*,*) 'WARNING: maximum O3 lines reached'
10      CONTINUE
        CLOSE(80)
        INIT = .FALSE.
        WRITE(*,*) NLINES,' O3 lines used'
      ENDIF
C
      DEN = 1.E-6*O3N ! molecules/cm**3
      TI = REFTLINE/T
      TI2 = TI**2.5
      QVINV = 1. -EXP(-1008./T)
C
C     ADD RESONANCES
      SUM = 0.
      DO I=1,NLINES
        IF( FL(I).GT.(F2+1.) ) GOTO 20
        IF( FL(I).GT.(F1-1.) ) THEN
          WIDTH = W(I)*P*TI**X(I)
          S = S1(I)*EXP(B(I)*(1.-TI))
          SUM = SUM + S*(ATAN((F2-FL(I))/WIDTH)-ATAN((F1-FL(I))/WIDTH))
        ENDIF
      END DO
20    ABINTO3 = .3183E-4*SUM*QVINV*TI2*DEN
      RETURN
      END
