      FUNCTION ABH2O(T,P,RHO,F)
C
C  NAME- ABH2O_LIST    LANGUAGE- FORTRAN 77
C
C PURPOSE- COMPUTE ABSORPTION COEF IN ATMOSPHERE DUE TO WATER VAPOR
C 
      IMPLICIT NONE
C  CALLING SEQUENCE PARAMETERS-
C    SPECIFICATIONS
      REAL T,P,RHO,F,ABH2O
C      NAME    UNITS    I/O  DESCRIPTON            VALID RANGE
C      T       KELVIN    I   TEMPERATURE
C      P       MILLIBAR  I   PRESSURE              .1 TO 1000
C      RHO     G/M**3    I   WATER VAPOR DENSITY
C      F       GHZ       I   FREQUENCY             
C      ABH2O   NEPERS/KM O   POWER ABSORPTION COEFFICIENT
C
C   Multiply ABH2O by 4.343 to obtain dB/km.
c
c   Line parameters will be read from file h2o_list.asc; intensities should
c   include the isotope abundance factors.
C   This version uses a line-shape cutoff.
C
C   REVISION HISTORY-
C    DATE- OCT.6, 1988 EQS AS PUBL.: P.W. Rosenkranz, CHAP. 2 in 
C     ATMOSPHERIC REMOTE SENSING BY MICROWAVE RADIOMETRY 
C     (M.A. Janssen, ed., 1993) (http://hdl.handle.net/1721.1/68611).
C     OCT.4, 1995  PWR- USE CLOUGH'S DEFINITION OF LOCAL LINE
C                   CONTRIBUTION,  HITRAN INTENSITIES, ADD 7 LINES.
C     OCT. 24, 95  PWR -ADD 1 LINE.
C     JULY 7, 97   PWR -SEPARATE COEFF. FOR SELF-BROADENING, 
C                       REVISED CONTINUUM.
C     Mar. 2, 2003   PWR - LINE SHIFT
c     Nov. 3, 2012 intensities at base T=296K, get line param. from file.
c     Aug. 6, 2015 read continuum param from the file also. 
C
C   LOCAL VARIABLES:
      INTEGER NLINES,I,J,MAXLINES
      PARAMETER (MAXLINES=100)
      REAL DF(2),S1(MAXLINES),B2(MAXLINES),W3(MAXLINES),FL(MAXLINES),
     & WS(MAXLINES),X(MAXLINES),XS(MAXLINES),SR(MAXLINES)
      REAL PVAP,PDA,DEN,TI,TI2,SUM,WIDTH,WSQ,S,BASE,RES,CON,SHIFT
      REAL WIDTHF,WIDTHS,WAIR,WSELF,REFTLINE,REFTCON,CF,CS,XCF,XCS
      SAVE NLINES,S1,B2,W3,FL,WS,X,XS,SR,INIT,REFTLINE,REFTCON,
     & CF,CS,XCF,XCS
      LOGICAL INIT
      CHARACTER*4 HEAD
      DATA INIT/.TRUE./
C
C   initialization section
      IF(INIT) THEN
        OPEN(80,FILE='h2o_list.asc',
     &   STATUS='OLD',FORM='FORMATTED')
        REFTLINE = 296. !reference T for lines
        READ(80,1) HEAD !header for linedata
1       FORMAT(A4)
        DO I=1,MAXLINES
C    read line parameters; units: GHz, Hz*cm^2, MHz/mb
          READ(80,2) FL(i),S1(i),B2(i),WAIR,X(i),SR(i),WSELF,XS(i)
2         FORMAT(4X,F12.4,E12.4,2F7.3,F6.2,F8.4,2F7.2)
          IF(FL(I) .LE. 0.) GOTO 10
          NLINES = I
          W3(I) = WAIR/1000.
          WS(I) = WSELF/1000.
        END DO
        WRITE(*,*) 'WARNING: maximum H2O lines reached'
10      CONTINUE
C    read continuum parameters; units: Kelvin, 1/(km*mb^2*GHz^2)
        READ(80,3) REFTCON,CF,XCF,CS,XCS
3       FORMAT(20X,F15.0,E9.2,F4.1,E15.2,F7.2)
        CLOSE(80)
        INIT = .FALSE.
        WRITE(*,*) NLINES,' H2O lines used'
      ENDIF
C
      IF(RHO.LE.0.) THEN
        ABH2O = 0.
        RETURN
      ENDIF
      PVAP = RHO*T/217.
      PDA = P -PVAP
      DEN = 3.344E16*RHO  
C
C      CONTINUUM TERMS
      TI = REFTCON/T
c   XCF and XCS include 3 for conv. to density & stimulated emission
      CON = (CF*PDA*TI**XCF + CS*PVAP*TI**XCS)*PVAP*F*F 
C
C      ADD RESONANCES
      TI = REFTLINE/T
      TI2 = TI**2.5
      SUM = 0.
      DO 30 I=1,NLINES
      WIDTHF = W3(I)*PDA*TI**X(I)
      WIDTHS = WS(I)*PVAP*TI**XS(I)
      WIDTH = WIDTHF + WIDTHS
      SHIFT = SR(I)*WIDTHF  ! unknown temperature dependence for shift
      WSQ = WIDTH**2
c  line intensities include isotopic abundance
      S = S1(I)*TI2*EXP(B2(I)*(1.-TI)) 
      DF(1) = F - FL(I) - SHIFT
      DF(2) = F + FL(I) + SHIFT
C  USE CLOUGH'S DEFINITION OF LOCAL LINE CONTRIBUTION
      BASE = WIDTH/(562500. + WSQ)
C  DO FOR POSITIVE AND NEGATIVE RESONANCES
      RES = 0.
      DO  J=1,2
       IF(ABS(DF(J)).LT.750.) RES = RES + WIDTH/(DF(J)**2+WSQ) - BASE
      END DO
30    SUM = SUM + S*RES*(F/FL(I))**2
      ABH2O = .3183E-4*DEN*SUM + CON
      RETURN
      END
