FUNCTION next_line, l
    ; Skip comment lines
    x = '#'
    WHILE STRMID(x,0,1) EQ '#' AND NOT(EOF(l)) DO READF,l,x
    IF EOF(l) THEN x = -1
    RETURN, x
END




;+
 FUNCTION read_parameterisation_bcfa, file
;
; Provide a file name. If omitted  the default is assumed 
; to be ./parameterisation_BCFA.txt
;
; The returned idl structure will contain all of the information
; from parameterisation_BCFA.txt
;
; smith(at)atm.ox.ac.uk
;
;
;-

  ON_ERROR, 2

  CASE N_ELEMENTS( file ) OF
     0: file = './parameterisation_BCFA.txt'
     1: tmp=!NULL ; Nothing to do
     ELSE: MESSAGE,'Only one file please'
  ENDCASE

  IF FILE_TEST( file[0] ) THEN BEGIN

     OPENR, lun, /GET_LUN, file[0]

     line = NEXT_LINE( lun )
     ; First value is the number of wavelengths
     nwl = LONG( (STRSPLIT(/EXTRACT,line))[1] )

     line = NEXT_LINE( lun )
     ; First value is the number of wavelengths
     nDf = LONG( (STRSPLIT(/EXTRACT,line))[1] )

     line = NEXT_LINE( lun )
     ; Spherule radius
     spherule_radius = FLOAT( (STRSPLIT(/EXTRACT,line))[1] )

     line = NEXT_LINE( lun )
     ; Fractal prefactor
     kf = FLOAT( (STRSPLIT(/EXTRACT,line))[1] )

     ; Set up arrays.
     param_ext = FLTARR( 4, nDf, nwl )
     param_ssa = FLTARR( 3, nDf, nwl )
     param_asym= FLTARR( 3, nDf, nwl )

     wl = FLTARR( nwl )
     df = FLTARR( nDf )
     cm = COMPLEXARR( nwl )

     ; And now, the data
     FOR iwl=0, nwl-1 DO FOR iDf=0,nDf-1 DO BEGIN

        line = NEXT_LINE( lun )

        data = FLOAT( STRSPLIT( line, /EXTRACT ) )

        param_ext[ *, iDf, iwl ] = data[4:7]
        param_ssa[ *, iDf, iwl ] = data[8:10]
        param_asym[*, iDf, iwl ] = data[11:13]

        IF iwl EQ 0 THEN df[iDf] = data[1]

        IF iDf EQ 0 THEN BEGIN
           wl[iwl] = data[0]
           cm[iwl] = COMPLEX( data[2], data[3] )
        ENDIF

     ENDFOR


     CLOSE, lun
     FREE_LUN, lun



     RETURN, {file:file, $
              wl:wl, kf:kf, Df:df, $
              spherule_radius:spherule_radius, $
              refractive_index:cm,$
              param_ext:param_ext, $
              param_ssa:param_ssa, $
              param_asym:param_asym }


  ENDIF ELSE BEGIN

     MESSAGE,'File not found: '+file[0]

  ENDELSE

  RETURN, 0

 END
