;+
 FUNCTION cext_parameterisation_bcfa, n, FILE=file, PARAMETERISATION=p
;
; Generate extinction cross-sections (in nm^2) for fractal aggregates
; with n spherules.
;
; Values will be returned for all Df and wl ranges.
;-


   p = READ_PARAMETERISATION_BCFA( file )

   nn  = N_ELEMENTS( n )
   x   = DOUBLE( n )

   nDf = N_ELEMENTS( p.Df )
   nwl = N_ELEMENTS( p.wl )

   Cext = FLTARR( nn, nDf, nwl )
  
   FOR iDf=0, nDf-1 DO BEGIN
      FOR iwl=0, nwl-1 DO BEGIN
         
         f = REFORM( p.param_ext[ *, iDf, iwl ] )

         Cext[*, iDf, iwl] = x * 0 + f[0]
         xx  = x

         FOR i=1, N_ELEMENTS( f ) -1 DO BEGIN
            Cext[*, iDf,iwl] += f[i] * xx
            xx = xx * x
         ENDFOR
        
      ENDFOR
   ENDFOR
   RETURN, Cext

 END
