;+
 FUNCTION asym_parameterisation_bcfa, N, FILE=file, PARAMETERISATION=p
;
; Generate asymmetry parameter for fractal aggregates with N spherules.
;
; Values will be returned for all Df and wl ranges.
;-



   p = READ_PARAMETERISATION_BCFA( file )

   nn  = N_ELEMENTS( n )
   x   = DOUBLE( n )

   nDf = N_ELEMENTS( p.Df )
   nwl = N_ELEMENTS( p.wl )

   ASYM = FLTARR( nn, nDf, nwl )
  
   FOR iDf=0, nDf-1 DO BEGIN
      FOR iwl=0, nwl-1 DO BEGIN
         
         f = REFORM( p.param_asym[ *, iDf, iwl ] )

         ASYM[*, iDf, iwl] = f[0] + f[1] * x + f[2] * ALOG( x )
        
      ENDFOR
   ENDFOR
   RETURN, ASYM

 END
