      subroutine SIMUL( indic, nmax, x, cost, g, izs, rzs, dzs )

      use BGLIB, only : nmu, nlat_sg, NX, Ns, Lh, Lv, hcorr_model &
     &                , vcorr_model, SpectralGrid
      use VAR_DEF, only : nlon, nlat, nlev, xlon, ylat, nvmr &
     &                  , vmr, vmrfg, advmr, isimul, kobs, iobs, jobs &
     &                  , yobs, eobs
      implicit none
!-----------------------------------------------------------------------
!  Dummy arguments
!-----------------------------------------------------------------------
      integer, intent(out) :: indic
      integer, intent(in) :: nmax
      real*8, intent(inout), dimension(nmax) :: x
      real*8, intent(out) :: cost
      real*8, intent(out), dimension(nmax) :: g    ! gradient of the cost
      integer, intent(in) :: izs(*)
      real, intent(in) :: rzs(*)
      double precision, intent(in) :: dzs(*)

!-----------------------------------------------------------------------
!  Local variables
!-----------------------------------------------------------------------
      integer :: l,i,j,k,nobs,n,m,idx,ilev,ivmr,iP,PnmIndex
      real :: sec, sec_b, sec_m, sec_a, sec_adb, sec1, sec2, sec3
      real*8 :: ps, gnorm, bgterm, SPX
      real :: SECNDS   ! internal on aeolos, external on qbrick
      real*8, dimension(nlon,nlat_sg) :: vmr_sg, ad_sg
      complex*16, dimension(NX,nlev,nvmr) :: chi, adchi
      character(len=20) :: flnm
      complex*16 :: Xs,ADXs

!-----------------------------------------------------------------------
!  Simulator begin
!-----------------------------------------------------------------------
      isimul = isimul + 1

      print*,'In SIMUL'
      print*,'************* isimul = ',isimul,'***********************'
! --- 1: x_m1qn3 -> chi
      sec_b = SECNDS( 0.0 )
      sec = SECNDS( 0.0 )
      call RESHAPE_M1QN3('vec2mat',x,chi)
      print*,'  RESHAPE_M1QN3 in (sec):',SECNDS(sec)

! --- 2: Get J_b
      sec = SECNDS( 0.0 )
      call DOT_PROD_SPECTRAL(chi,chi,bgterm)
      bgterm = 0.5*bgterm
      print*,'  Jb in (sec):',SECNDS(sec)

! --- 3: Apply correlation on chi
      sec = SECNDS( 0.0 )
      do ivmr=1,nvmr
        call SQRT_CORREL(.false.,ivmr,chi(:,:,ivmr))
      enddo
      print*,'  SQRT_CORREL in (sec):',SECNDS(sec)

! --- 4: spectral transform, spectral grid transform, B std dev and 
! ---    get vmr from increments.
      sec = SECNDS( 0.0 )
      do ivmr=1,nvmr
      do ilev=1,nlev
        call S_DIRECT(chi(:,ilev,ivmr), vmr_sg )
        call SG2MG(vmr_sg, vmr(:,:,ilev,ivmr))
!        call S_DIRECT(chi(:,ilev,ivmr), vmr(:,:,ilev,ivmr) )
        call B_STDDEV(ilev, ivmr, vmr(:,:,ilev,ivmr) )
        if ( ANY( vmr(:,:,ilev,ivmr) /= vmr(:,:,ilev,ivmr) ) ) then
          print*, 'NaN found in vmr'
          call EXIT(1)
        endif
      enddo
      enddo
      print*,MAXVAL(vmr(1,:,:,:)),MINVAL(vmr(1,:,:,:))
      vmr = vmr + vmrfg
      print*,'  CHI2VMR in (sec):',SECNDS(sec)
      sec_b = SECNDS(sec_b)
      print*,'  Jb in (sec):',sec_b

! --- 5: Get J_o
      cost = bgterm
      nobs = 0
      sec_m = SECNDS( 0.0 )
!      call MODEL(cost, nobs)
      sec_m = SECNDS( sec_m )
      cost = cost + 0.5d0*( (yobs-vmr(kobs,iobs,jobs,1)) / eobs )**2
      nobs = nobs + 1

! --- 6: Get grad(J_o')
      advmr = 0.d0
      sec_a = SECNDS( 0.0 )
!      call ADMODEL()
      sec_a = SECNDS( sec_a )
      advmr(kobs,iobs,jobs,1) = advmr(kobs,iobs,jobs,1) - (yobs-vmr(kobs,iobs,jobs,1))/eobs**2

! --- 7: Adjoint of sequence 4.
      sec_adb = SECNDS( 0.0 )
      sec = SECNDS( 0.0 )
      do ivmr=nvmr,1,-1
      do ilev=nlev,1,-1
        call B_STDDEV(ilev, ivmr, advmr(:,:,ilev,ivmr) )
        call AD_SG2MG(advmr(:,:,ilev,ivmr),ad_sg)
        if ( ANY( ad_sg /= ad_sg ) ) then
          print*, ilev
          print*, 'NaN found in ad_gg'
          call EXIT(1)
        endif
        call S_ADJ(ad_sg,adchi(:,ilev,ivmr))
      enddo
      enddo
      print*,'  ADVMR2ADCHI in (sec):',SECNDS(sec)

! --- 10: Apply correlation on grad(J_o)
      sec = SECNDS( 0.0 )
      do ivmr=1,nvmr
        call SQRT_CORREL(.true.,ivmr,adchi(:,:,ivmr))
      enddo
      print*,'  SQRT_CORREL in (sec):',SECNDS(sec)

! --- 11: Get grad(J) = chi + grad(J_o)
      sec = SECNDS( 0.0 )
      adchi = chi + adchi

! --- 12: adchi -> m1qn3 shaping
      call RESHAPE_M1QN3('mat2vec',g,adchi)
      print*,'  RESHAPE_M1QN3 in (sec):',SECNDS(sec)
      sec_adb = SECNDS( sec_adb )
      print*,'  GRAD(Jb) in (sec):',sec_adb
!     g(1:nmax/2) = DBLE(adchi)
!     g(1+nmax/2:nmax) = IMAG(adchi)

!-----------------------------------------------------------------------
! Print outputs
!-----------------------------------------------------------------------
! --- Write vmr in file
      open(22,file='../output/vmr_'//SpectralGrid//'.dat')
      write(22,*) nlon, nlat, nlev
      write(22,*) kobs,iobs,jobs
      write(22,*) Lh, hcorr_model
      write(22,*) Lv, vcorr_model
      do k = 1,nlon
      do i = 1,nlat
      do l = 1,nlev
        write(22,'(3i5,100(2x,es11.4))')k,i,l,xlon(k),ylat(i),vmr(k,i,l,1)
      enddo
      enddo
      enddo
! --- Write power spectrum of chi in file
      open(22,file='../output/SPX_'//SpectralGrid//'.dat')
      write(22,*) Ns, nlev
      do l=1,nlev
      do n = 0,Ns
        iP = PnmIndex(n,0)
        SPX = DBLE(chi(iP,l,1))**2
        do m = 1,n
          iP = PnmIndex(n,m)
          SPX = SPX + 2*( DBLE(chi(iP,l,1))**2+IMAG(chi(iP,l,1))**2 )
        enddo
        write(22,'(2(i5,2x),es11.4)')n,l,SPX
      enddo
      enddo

!-----------------------------------------------------------------------
!   Compute gnorm, write (ASCII) cost and gnorm
!-----------------------------------------------------------------------
!      call DUCLID( nmax, g, g, gnorm )
!     ps = 0.5*DOT_PRODUCT(x,x)
      call DOT_PROD_SPECTRAL(adchi,adchi,gnorm)
      if ( gnorm /= gnorm) then
        print*,'Gnorm is NaN'
        if ( ANY( adchi /= adchi ) ) print*,'NaN found in adchi'
        if ( ANY( chi /= chi ) ) print*,'NaN found in chi'
        call EXIT(1)
      endif

      indic = 1
      write(15,'(2i5,100(2x,es16.9))')isimul,nobs,cost,bgterm,cost-bgterm,gnorm &
     &     ,vmr(kobs,iobs,jobs,1)

 998  format(i5,2x,i8,4es14.5,8x,4f9.3)

      end subroutine SIMUL



