      program MAIN
!-----------------------------------------------------------------------
! This is the main program that launches two tests of BGLIB_SH.
! Test 1: Test of the adjoint, see test_adj.f90.
! Test 2: Assimilation of a single pseudo-observation. For further details
!         on the initialization, see simul_sh.f90 and below.
!     
! Compiling and running the program is explained in the README file.
!
! Authors: quentin@oma.be
! Date:     Feb 2012
!-----------------------------------------------------------------------
      use VAR_DEF, only : nlon, nlat, nlev, xlon, ylat, nvmr, isimul &
     &                  , kobs, iobs, jobs, yobs, eobs, vmrfg
      use BGLIB, only : pi, nmax, lgg, PRECOMPUTE_BGLIB, Lh, Lv, hcorr_model &
     &                , vcorr_model, bg_std, bg_units, SpectralGrid, nmu, mu

      implicit none

!-----------------------------------------------------------------------
! Local variables
!-----------------------------------------------------------------------
      integer :: k, i, idx(1)
      real*8 :: dlon, dlat
      character(len=64) :: arg

!-----------------------------------------------------------------------
! Local variables for M1QN3 & SIMUL_SH
!-----------------------------------------------------------------------
      integer, parameter :: ndz = 3*nmax+10*(2*nmax+1)
      integer :: indic,impres,io,niter,nsim,iz(5),reverse,mode
      integer :: imode(3), omode(3)
      double precision :: ff, dxmin,df1,epsrel,epsf
      double precision, dimension(nmax) :: x = 0.d0, g = 0.d0
      double precision :: dz(ndz)
      integer :: izs(1)
      real  :: rzs(1)
      double precision :: dzs(1)
      external :: SIMUL, SIMUL_GG, EUCLID, CTONBE, CTCABE

!-----------------------------------------------------------------------
!     
!-----------------------------------------------------------------------
      print*,' Start TEST_SH'

!-----------------------------------------------------------------------
!     Make horizontal model grid
!-----------------------------------------------------------------------
      dlat=180.d0/(nlat-1)
      ylat(1) = -90.d0
      do i=2,nlat
        ylat(i) = ylat(i-1)+dlat
      enddo
      dlon = 360.d0/nlon
      xlon(1) = 0.d0
      do k=2,nlon
        xlon(k) = xlon(k-1)+dlon
      enddo

! ----------------------------------------------------------------------
!     Read the parameters of the Background error cov matrix given by
!     the command line.
! ----------------------------------------------------------------------
      ALLOCATE(bg_std(nlev,nvmr) )
      CALL GET_COMMAND_ARGUMENT(1, arg)
      read(arg,*)Lh
      CALL GET_COMMAND_ARGUMENT(2, hcorr_model)
      CALL GET_COMMAND_ARGUMENT(3, arg)
      read(arg,*)Lv
      CALL GET_COMMAND_ARGUMENT(4, vcorr_model)
      CALL GET_COMMAND_ARGUMENT(5, SpectralGrid)
      bg_std = 0.1d0                 ! in the units of bg_units
      bg_units='vmr'                 ! 2 options: 'vmr' or 'rel'
      vmrfg = 1.d0

!-----------------------------------------------------------------------
!     PRECOMPUTE BGLIB
!-----------------------------------------------------------------------
      call PRECOMPUTE_BGLIB(ylat)
      print*,'PRECOMPUTE_BGLIB ok'
      
!-----------------------------------------------------------------------
!     Adjoint test
!-----------------------------------------------------------------------
      call TEST_ADJ(.false.,2.d2)
      
!-----------------------------------------------------------------------
!     Define pseudo observations and its location
!-----------------------------------------------------------------------
      idx = MINLOC(ABS(ylat+60.01d0))
      kobs = nlon/2;  iobs = nlat/2;  jobs =nlev/2+1;
      yobs = 1.2d0;      eobs = 0.1d0
      write(*,'(a,3(2x,i4))')'Location of observations (ilon,ilat,ilev)=',kobs,iobs,jobs
      if (kobs>nlon .or. iobs>nlat .or. jobs>nlev) then
        print*,'Obs index out of grid'
        stop
      endif

!-----------------------------------------------------------------------
!     Prepare minimization
!-----------------------------------------------------------------------
      x(:) = 0.d0
      isimul = 0

!-----------------------------------------------------------------------
!     Minimization with M1QN3
!-----------------------------------------------------------------------
      open(15,file='../output/cost_'//SpectralGrid//'.dat')
      write(15,'(2(a5),100(2x,a16))')'isim','nobs','J','Jb'  &
     &     ,'   Jo','gnorm','H(x)'
      call SIMUL  ( indic, nmax, x, ff, g, izs, rzs, dzs )
      dxmin = 1.d-4
      df1 = 1.d0*ff
      epsrel = 1.d-4
      epsf = epsrel*df1
      impres = 0
      io = 11
      imode = (/ 0, 0, 1 /)
      niter = 50
      nsim = 50
      reverse = 0
      call M1QN3( SIMUL, EUCLID, CTONBE, CTCABE, nmax, x, ff, g, dxmin &
     &          , df1, epsf, 'two', impres, io, imode, omode, niter, nsim &
     &          , iz, dz, ndz, reverse, indic, izs, rzs, dzs   )
      call SIMUL  ( indic, nmax, x, ff, g, izs, rzs, dzs )

      end program MAIN
