PROGRAM test_vi
!
! *** automatically generated with test_vi.j ***
!
! AUTHOR
! ------
! Swen Metzger <swen.metzger@mpic.de>
!
!      Department of Atmospheric Chemistry,
!      Max Planck Institute for Chemistry, Mainz, Germany.
!      Copyright 2011+. All rights reserved.
!
!      References
!      ---------
!      [1] CRC Hanbook of Chemistry and Physics, 85th Edition, 2004-2005.
!
!      [2] Metzger et al., 2011;
!          Aerosol hygroscopic growth parameterizations, submitted to ACPD, 2011.
!------------------------------------------------------------------------------------
IMPLICIT NONE
!
INTEGER,PARAMETER  :: dp = SELECTED_REAL_KIND(12,307)
!--------------------------------------------------------------------------------
INTEGER              :: i,j,k                       ! loop indices
INTEGER, PARAMETER   :: imax = 686                  ! maximum loop count (100 + 586 of Rose et. al)
INTEGER, PARAMETER   :: IUNIT = 1                   ! I/O Unit number - read
INTEGER, PARAMETER   :: OUNIT = 2                   ! I/O Unit number - write
!--------------------------------------------------------------------------------
REAL(dp),PARAMETER   :: RHDrefT0=0.7528_dp     ! reference RHD [-]
REAL(dp),PARAMETER   :: RHDrefTc=25.00_dp     ! reference RHD T-coefficient [-]
!--------------------------------------------------------------------------------
REAL(dp),PARAMETER   :: Phi=3.141592653589793_dp    ! Phi [-]
REAL(dp),PARAMETER   :: T0=298.15_dp                ! reference temperature, T0 [K]
REAL(dp),PARAMETER   :: R=8.314_dp                  ! universal gas constant [J/K/mol]
REAL(dp),PARAMETER   :: sigma=0.0761_dp             ! surface tension of H2O at 273 K [N/m]
REAL(dp),PARAMETER   :: T=298.15_dp                 ! default 298.15 temperature, T [K]
!--------------------------------------------------------------------------------
! compound specification; thermodynamic data of [1]
REAL(dp),PARAMETER   :: ns=1.000e-6_dp                 ! solute "concentration" [mol] - w.r.t. per m3(air)
REAL(dp),PARAMETER   :: Ds=2170.000_dp                 ! solute density [kg/m3]
REAL(dp),PARAMETER   :: Dw=997.1_dp                 ! water  density [kg/m3]
REAL(dp),PARAMETER   :: Ms=0.058440_dp                 ! molar mass solute [kg/mol]
REAL(dp),PARAMETER   :: Mw=0.018015_dp              ! molar mass H2O  [kg/mol]
REAL(dp),PARAMETER   :: Ws=0.264700_dp                 ! mass fraction solubility [-]; Ws=ms/(ms+mw); ms=mw/(1/Ws-1)
REAL(dp),PARAMETER   :: mwat=1._dp                  ! initial mass of H20 [1 kg]
REAL(dp),PARAMETER   :: msat=mwat/(1._dp/Ws-1._dp)  ! saturation mass [kg] that completely dissolves at equilbrium RHD
REAL(dp),PARAMETER   :: nsat=msat/Ms                ! number of moles of solute in a saturated solution at RHD
REAL(dp)             :: RHD,RHDref                  ! calculated and reference RHD at T and T0 [-]
REAL(dp)             :: sm                          ! solute molality [mol/kg(H2O)]
REAL(dp)             :: aw                          ! water activity [-]
REAL(dp)             :: A                           ! A term [-], Eq.(15) of [2]
REAL(dp)             :: B                           ! B term [-], Eq.(15) of [2]
REAL(dp)             :: vi                          ! calculated ion-ion interaction parameter [-], Eq.(13) of [2]
REAL(dp)             :: GF                          ! diameter growth factor [0-1], Eq.(2) of [2]
REAL(dp)             :: Ke                          ! Kelvin term [-], Eq. (1) of [2]
!------------------------------------------------------------------------------------
! calculate T-dependency of RHDref - Eq. 16c of [2]
RHDref = MAX(0._dp,MIN(1._dp,RHDrefT0*EXP(RHDrefTc*(1._dp/T-1._dp/T0))))
!------------------------------------------------------------------------------------
WRITE(*,'(A,F12.6A)')' determine vi from RHD at T=',T,' with bisection - Eq. 16b of [2]'
!------------------------------------------------------------------------------------
CALL rtbis_rhd(vi,RHDref,nsat,Ke,A,B)
!-----------------------------------------------------------------
! (re-)calculate RHD - Eq. (16b) of [2]
RHD = Ke/(A+Mw*vi*(nsat+B)**vi)
WRITE(*,'(A,3F12.6)')' NaCl - RHDref,RHD,vi ',RHDref,RHD,vi
!
STOP
!_________________________________________________________________________________________________________________________________
CONTAINS
!_________________________________________________________________________________________________________________________________
SUBROUTINE rtbis_rhd(vi,RHD,sm,Ke,A,B)
   ! determine vi from RHD with bisection
   IMPLICIT NONE
   ! bisection parameter
   REAL(dp), PARAMETER    :: x1   =   0._dp, &   ! lower boundary of root intervall
                             x2   =  10._dp, &   ! upper boundary of root intervall
                             xacc =  1.E-06_dp   ! accuracy
   REAL(dp), INTENT(IN)   :: RHD,     &  ! relative humidity of deliquescence (0-1) [-]
                             sm          ! solute molality [mol/kg(H2O)]
   REAL(dp), INTENT(OUT)  :: vi,&        ! ion-interaction coefficient [-]
                             Ke,&        ! Ke-term [-]; Eq.( 1) of [2]
                             A,&         ! A-term  [-]; Eq.(18) of [2]
                             B           ! B-term  [-]; Eq.(19) of [2]
   REAL(dp)               :: GF          ! GF-term [0-1];Eq.(2) of [2]
   INTEGER, PARAMETER  :: jmax=40
   INTEGER             :: j
   REAL(dp)            :: fmid, f, dx, xmid
    fmid = rhd_func(x2,RHD,sm,Ke,A,B)
    f    = rhd_func(x1,RHD,sm,Ke,A,B)
    IF ( f*fmid >= 0._dp ) THEN
       WRITE(*,*) 'STOP: Root must be bracketed for bisection.'
       STOP
    END IF
    IF(f < 0._dp) THEN
       vi = x1
       dx = x2-x1
    ELSE
       vi = x2
       dx = x1-x2
    END IF
    DO j = 1,jmax
       dx   = dx  * 0.5_dp
       xmid = vi + dx
       fmid = rhd_func(xmid,RHD,sm,Ke,A,B)
       IF(fmid <= 0._dp ) vi = xmid
       IF((ABS(dx) < xacc) .OR. (fmid == 0._dp)) RETURN
    END DO
    WRITE(*,*)  'STOP: too many bisections'
    STOP
END SUBROUTINE rtbis_rhd
!_________________________________________________________________________________________________________________________________
REAL FUNCTION rhd_func(vi,RHD,sm,Ke,A,B)
   ! determine vi from RHD with bisection
   IMPLICIT NONE
   REAL(dp), INTENT(IN)   :: RHD,     &  ! relative humidity of deliquescence (0-1) [-]
                             sm          ! solute molality [mol/kg(H2O)]
   REAL(dp), INTENT(OUT)  :: Ke,&        ! Ke-term [-]; Eq.( 1) of [2]
                             A,&         ! A-term  [-]; Eq.(18) of [2]
                             B           ! B-term  [-]; Eq.(19) of [2]
   REAL(dp)               :: vi,&        ! ion-interaction coefficient [-]
                             GF,&        ! GF-term [0-1];Eq.(2) of [2]
                             rhd_det     ! calculated RHD [-]
   ! growth factor - Eq. (2) of [2]
   GF = (Ds/(Ms*Dw*sm)+1._dp)**(1._dp/3._dp)
   ! no Kelvin term required
   Ke = 1._dp
   ! calculate A-term from sm using Eq. (18) of [2]
   A = exp(-Mw*vi*sm**vi)*(1._dp+Mw*vi*sm)
   ! B-term - Eq. (19) of [2]
   B = 1._dp/(1._dp+1._dp/(Ms*vi*sm))*(vi*sm)**(-1._dp/vi)
   ! RHD - Eq. (16a) of [2]
   rhd_det  = Ke/(A+Mw*vi*(sm+B)**vi)
   rhd_func = rhd_det - RHD
END FUNCTION rhd_func
!_________________________________________________________________________________________________________________________________
END PROGRAM test_vi
