% SOLVING FOR TRUNCATED NORMAL MEAN AND VARIANCE TO BE x_a AND S_a
% REF: http://en.wikipedia.org/wiki/Truncated_normal_distribution
% CHIRANJIT MUKHERJEE, LAST EDITED OCT 22, 2010.

function [mu,sigma] = trunParaSolve(x_a,S_a_d)

p = length(x_a); mu = zeros(p,1); sigma = ones(p,1);

for i=1:p,
    a = 0.25*x_a(i); E = x_a(i); V = S_a_d(i); [theta,f,flag] = fsolve(@(theta) F(a,theta,E,V),[E;sqrt(V)]);
    mu(i) = theta(1); sigma(i) = theta(2);
end


function y = F(a,theta,E,V)

m = theta(1); s = theta(2); alpha = (a-m)/s; lambda = normpdf(alpha)/(1-normcdf(alpha)); delta = lambda*(lambda-alpha);
y = [m+s*lambda-E; (s^2)*(1-delta)-V];