% GREAT CIRCLE DISTANCE BETWEEN CENTROIDS OF GRID BOXES.
% REF: Haversine Formula (from R. W. Sinnott, "Virtues of the Haversine," Sky and Telescope, vol. 68, no. 2, 1984, p. 159) 

nr = 26; nc = 72; n = nr*nc;
D = zeros(n); R = 6367;

for i1=1:nr, i1, for j1=1:nc, for i2=1:nr, for j2=1:nc,
    lat1 = deg2rad(-90+4*(i1+10)); lon1 = deg2rad(5*(j1-1)); lat2 = deg2rad(-90+4*(i2+10)); lon2 = deg2rad(5*(j2-1));
	  dlon = lon2 - lon1; dlat = lat2 - lat1; a = (sin(dlat/2))^2+cos(lat1)*cos(lat2)*(sin(dlon/2))^2;
    D(i1+(j1-1)*nr,i2+(j2-1)*nr) = R*2*atan2(sqrt(a), sqrt(1-a));
end, end, end, end

save Diso D; return