% CODE COMPARING rho-CAR MODEL WITH NONSPATIAL MODEL OF ARELLANO ET AL. (2004) AND ARELLANO ET AL. (2004) WITH FLEXIBLE SCALE.
% SYNTHETIC/REAL DATA. MISSING VALUES. HOMOGENEOUS SPATIAL DEPENDENCE. POSTERIOR PREDICTIVE DISTRIBUTION.
%
% CHIRANJIT MUKHERJEE. LAST EDITED: DEC 14, 2010

% MCMC PARAMETERS
B = 1000; N = B+10000; q = 0.025; cv = 0.5; step = 100;

% MODEL DIMENTION PARAMETERS
T = 9; p = 16; nr = 26; nc = 72; n = nr*nc; nT = n*T; C = 0; trep = 9;

% ----------------------------------------------------- SYNTHETIC DATA SIMULATION / LOADING DATA  ----------------------------------------------
load data2000i; nHit = zeros(T,1); nMiss = zeros(T,1); for t=1:T, nHit(t) = length(hit{t}); nMiss(t) = length(miss{t}); end

% DATA SIMULATION

if(L>0),                                                            % SYNTHETIC DATA
    [mu,sigma] = trunParaSolve(x_a,S_a_d); xt = zeros(p,1);
    for i=1:p, a = 0.25*x_a(i); u = unifrnd(normcdf((a-mu(i))/sigma(i)),1); xt(i) = norminv(u,mu(i),sigma(i)); end
    c = 0.2; e = cell(T,1); Kx = K1*xt; sigma2True = (c*mean(Kx))^2; S = exp(-D./L); R = chol(sigma2True.*S);
    for t=1:T, e{t} = R'*randn(n,1); y{t} = K{t}*xt+e{t}; end
else
    xt = x_a; c = 0.2; Kx = K1*xt; sigma2True = (c*mean(Kx))^2;     % REAL DATA
end

% ----------------------------------------------------------------- NONSPATIAL MODEL ------------------------------------------------------------
% PRIORS
m = sigma2True; v = (m*cv)^2; alphas = (m^2/v)+2; lambdas = m*(alphas-1);

% INITIALIZATION
sigma2 = m; x = x_a; jj = zeros(p,p-1); for j=1:p, jj(j,:) = setdiff(1:p,j); end
X2 = zeros(N-B,p); ss2 = zeros(N-B,1); as = alphas + nT/2; iS_a = diag(1./S_a_d); yRep2 = zeros((N-B)/step,n); slL2 = zeros(N-B,1);

% MCMC
for i=1:N, if((i/100)==floor(i/100)), i, end
    
    % SAMPLING x_i
    for j=1:p, iVxi = 1/S_a_d(j); mxi = x_a(j)/S_a_d(j);
        for t=1:T, iVxi = iVxi+(K{t}(:,j)'*K{t}(:,j))/sigma2; mxi = mxi+K{t}(:,j)'*(y{t}-K{t}(:,jj(j,:))*x(jj(j,:)))/sigma2; end
        a = 0.25*x_a(j); mui = mxi/iVxi; sigmai = 1/sqrt(iVxi); u = min(unifrnd(normcdf((a-mui)/sigmai),1),0.9999); x(j) = max(a,norminv(u,mui,sigmai));
    end    
    
    % SAMPLING sigma2
    dpd = 0; for t=1:T, d = y{t}-K{t}*x; dpd = dpd+d'*d; end; sigma2 = 1/gamrnd(as,1/(lambdas+(0.5)*dpd));
    
    % SAMPLING MISSING y's
    dpd = 0; for t=1:T, y{t}(miss{t}) = K{t}(miss{t},:)*x + sqrt(sigma2).*randn(nMiss(t),1); d = y{t}-K{t}*x; dpd = dpd+d'*d; end   
   
    % SAVING
    iB = i-B; if(iB>0), X2(iB,:) = x'; ss2(iB) = sigma2; slL2(iB) = -(nT*log(sigma2)+dpd/sigma2)/2;
    iBf = iB/step; if(iBf==floor(iBf)), yRep2(iBf,miss{trep}) = (y{trep}(miss{trep}))';
        yRep2(iBf,hit{trep}) = (K{trep}(hit{trep},:)*x+sqrt(sigma2).*randn(nHit(trep),1))'; end; end
end

xhat2 = mean(X2,1)'; q2 = quantile(X2,[q,1-q]);

% ---------------------------------------------------------------- CAR -------------------------------------------------------------------------
% PRIORS
m = sigma2True*8; v = (m*cv)^2; alphas = (m^2/v)+2; lambdas = m*(alphas-1); load Wdecay; dw = sum(W,2); ldw = sum(log(dw));

% INITIALIZATION
sigma2 = m; x = x_a; rho = 0.5;

X3 = zeros(N-B,p); ss3 = zeros(N-B,1); sr3 = zeros(N-B,1); iS_a = diag(1./S_a_d); d = cell(T,1);
iS = (Dw - rho.*W); ldiS = log(det(bsxfun(@rdivide,iS,dw))); as = alphas + nT/2; L1 = cell(T,1); Rmiss = cell(T,1);
yRep3 = zeros((N-B)/step,n); slL3 = zeros(N-B,1); jj = zeros(p,p-1); for j=1:p, jj(j,:) = setdiff(1:p,j); end

% MCMC
for i=1:N, if((i/10)==floor(i/10)), i, end
    
    % SAMPLING x_i
    for j=1:p, iVxi = 1/S_a_d(j); mxi = x_a(j)/S_a_d(j); a = 0.25*x_a(j);
        for t=1:T, L1{t} = K{t}(:,j)'*iS./sigma2; mxi = mxi + L1{t}*(y{t}-K{t}(:,jj(j,:))*x(jj(j,:))); iVxi = iVxi + L1{t}*K{t}(:,j); end
        mui = mxi/iVxi; sigmai = 1/sqrt(iVxi); u = min(unifrnd(normcdf((a-mui)/sigmai),1),0.9999); x(j) = norminv(u,mui,sigmai); end
    
    % SAMPLING sigma2
    lam = lambdas; for t=1:T, d{t} = y{t}-K{t}*x; lam = lam + (0.5)*(d{t}'*iS*d{t}); end, sigma2 = 1/gamrnd(as,1/lam);    
    
    % SAMPLING MISSING y's
    for t=1:T, Rmiss{t} = chol(iS(miss{t},miss{t})./sigma2);
    y{t}(miss{t}) = K{t}(miss{t},:)*x + Rmiss{t}\randn(nMiss(t),1)+Rmiss{t}\(Rmiss{t}'\(-iS(miss{t},hit{t})*(d{t}(hit{t}))./sigma2)); 
    d{t}(miss{t}) = y{t}(miss{t}) - K{t}(miss{t},:)*x; end   
           
    % SAMPLING rho -- M-H
    if (i<=B*0.2), s = 0.0005; elseif (i<B*0.8), b = binornd(1,0.95); s =  b*std(sr3((i-B*0.2):(i-1)))+(1-b)*(0.0005); ...
    elseif(i==B*0.8), s = std(sr3((i-B*0.2):(i-1))); end
    rho1 = normrnd(rho,s); lP = 0; lP1 = 0; iS1 = Dw - rho1.*W; ldiS1 = log(det(bsxfun(@rdivide,iS1,dw)));
    for t=1:T, lP = lP+(0.5)*(ldiS-(d{t}'*iS*d{t})/sigma2); lP1 = lP1+(0.5)*(ldiS1-(d{t}'*iS1*d{t})/sigma2); end; lR = lP1-lP;
    if((log(rand(1))<lR)&&(rho1<1)&&(rho1>0)), rho = rho1; iS = iS1; ldiS = ldiS1; lP = lP1; end; if(i<B), sr3(i) = rho; end
   
   % SAVING
   iB = i-B; if(iB>0), X3(iB,:) = x'; ss3(iB) = sigma2; sr3(iB) = rho; R = chol(iS./sigma2); slL3(iB) = lP+T*(ldw-n*log(sigma2))/2;
   iBf = iB/step; if(iBf==floor(iBf)), yRep3(iBf,miss{trep}) = (y{trep}(miss{trep}))'; Rhit = chol(iS(hit{trep},hit{trep})./sigma2);
       yRep3(iBf,hit{trep}) = (K{t}(hit{trep},:)*x + Rhit\randn(nHit(trep),1)+Rhit\(Rhit'\(-iS(hit{trep},miss{trep})*(d{t}(miss{trep}))./sigma2)))'; end; end 
end

xhat3 = mean(X3,1)'; q3 = quantile(X3,[q,1-q]);

% ------------------------------------------------------------------ BAYES FACTOR -------------------------------------------------------------------
lm2 = max(slL2); lm3 = max(slL3); ML2 = mean(exp(slL2-lm2)); ML3 = mean(exp(slL3-lm3)); lBF32 = lm3-lm2+log(ML3/ML2);

% %-------------------------------------------------------------- SAVING RELEVANT VALUES ----------------------------------------------------------
save(strcat('results','_L',num2str(L),'.mat')); return