function [Fv] = ventilation_coefficient_mass(vt,D,T,rhoa,p)

if T<100
  error('Input temperature should be in Kelvin')
end

% Diffusivity of water vapor in air, Pruppacher and Klett, 1997,
Dva = diffusivity_water_vapor_in_air(T,p);

mu = viscosity_air(T);
nu = mu./rhoa;
Sc = nu./Dva;
Re = vt.*D./nu;

% ventilation coefficient of mass, Salamalikis
xx = Sc.^(1/3).*Re.^(1/2);

% compute first assuming xx < 1.4
Fv = 1 + 0.108*xx.^2;

% correct for values of xx > 1.4
ind = find(xx>1.4);
Fv(ind) = 0.78 + 0.308*xx(ind);
