function [Fh] = ventilation_coefficient_heat(vt,D,T,rhoa)

if T<100
  error('Input temperature should be in Kelvin')
end

Cp = 1005.7;

% Thermal conductivity
ka = thermal_conductivity_air(T);

mu = viscosity_air(T);
nu = mu./rhoa;
Pr = Cp*rhoa.*nu./ka; % Prandtl number, Graf eqn C3.8
Re = vt.*D./nu;

% ventilation coefficient of heat, Salamalikis
xx = Pr.^(1/3).*Re.^(1/2);

% compute first assuming xx < 1.4
Fh = 1 + 0.108*xx.^2;

% correct for values of xx > 1.4
ind = find(xx>1.4);
Fh(ind) = 0.78 + 0.308*xx(ind);
