function [out] = terminal_velocity_rain(D,rhoair)

if D>1e-1
  error('Input diameter should be in meters');
end

%(m/s) Terminal velocity, +dn,-up, Graf 2017, eq. 3.10
out=(9.43.*(1-exp(-(((D.*1e3)./1.77).^1.147))).*((1.2038./rhoair(1)).^.4)); 

% $$$ % terminal velocity of a raindrop [units, m/s]
% $$$ % from Salamalikis et al (2016)
% $$$ out = 9.65 - 9.8*exp(-600*D); % Salamalikis
% $$$ 
% $$$ % alternate fall speed relationship for drizzle-sized drops
% $$$ %   up to 
% $$$ % out = 2.2e5*(D/2).^1.4; % Comstock et al (2004, eqn 6)
