function [Dva] = diffusivity_water_vapor_in_air(T,p)

 % FUNCTION [DVA] = DIFFUSIVITY_WATER_VAPOR_IN_AIR(T,p)
 % (m^2 s-1) Diffusivity of vapor, Graf 2017, eq. C3.1
 % Inputs: T, absolute temperature [K]
 %         p, pressure [Pa]
  
if T<160
  error('Input temperature should be in Kelvin');
end

% (m^2 s-1) Diffusivity of vapor, Graf 2017, eq. C3.1
Dva = 0.211e-4 .* (101325./p) .* (T./273.15).^1.94; 

% $$$ % diffisivity_water_vapor_in_air [units, m2/s]
% $$$ % from Salamalikis et al (2016)
% $$$ out = 21.2e-6*(1 + 7e-3*T);
