function [out] = alphaD(T)

% FUNCTION [OUT] = ALPHAD(T)
% alphaD, equilibrium fractionation factor of HDO over liquid
% (Majoube, 1971b)
  
if T<160
  error('Input temperature should be in Kelvin');
end

out = exp( (24844./(T.^2)) - (76.248./T) + .05261); %Majoube (1971b)
