      SUBROUTINE PES_PO2(R1,R2,R3,ENER)
c	R1=roo;R2=rpo;R3=rpo
      IMPLICIT  REAL * 8 (A-H,O-Z)
      DOUBLE PRECISION :: R1,R2,R3,V3 
      DOUBLE PRECISION, DIMENSION(3) :: R
      DOUBLE PRECISION :: E12,E13,E23
      R(1)=R1
      R(2)=R2
      R(3)=R3
      CALL CHIPR_O2(R1,E12)
      CALL CHIPR_PO(R2,E13)
      CALL CHIPR_PO(R3,E23)
      CALL TRIAT(R1,R2,R3,V3)
      ENER=E12+E13+E23+V3
      RETURN 
      END
!######################################################################################################
! CALL THREE-BODY TERM
!######################################################################################################      
      SUBROUTINE TRIAT(R1,R2,R3,V)
      IMPLICIT NONE
      DOUBLE PRECISION, DIMENSION(3) :: R
      DOUBLE PRECISION :: R1,R2,R3,V1
      DOUBLE PRECISION :: V3,V
      R(1)=R1
      R(2)=R2
      R(3)=R3
      CALL CHIPR_TRIAT(R,V3)
      V=V3
      RETURN 
      END
!######################################################################################################
!POTENTIAL ENERGY CURVE OF GROUND STATE O2
!######################################################################################################
      SUBROUTINE CHIPR_O2(R,POT)
      IMPLICIT NONE
      INTEGER, PARAMETER :: NC=18
      INTEGER :: I,J
      INTEGER :: BSORDER
      INTEGER :: POLORDER
      INTEGER :: NCBAS,NCPOL
      DOUBLE PRECISION, DIMENSION(2) :: Z
      DOUBLE PRECISION, DIMENSION(NC) :: C
      DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:) :: BS
      DOUBLE PRECISION :: Y   
      DOUBLE PRECISION :: R,POT

      Z( 1)= 0.800000000000000000D+01
      Z( 2)= 0.800000000000000000D+01

       C(   1)= -0.13300166578940587295415420854283184D-02
       C(   2)=  0.56542260053978185205258988332843728D-02
       C(   3)= -0.21503398249186050222858668234948709D-01
       C(   4)=  0.24065543388051585660392106547078583D-01
       C(   5)= -0.13511335800146701685564565309505269D-01
       C(   6)=  0.41517883436838418087511115572851850D-02
       C(   7)= -0.65481734065055868018040419187286716D-03
       C(   8)=  0.41380347860898215341367983866049940D-04
       C(   9)=  0.45153733543889849499919364461675286D+02
       C(  10)= -0.10780755522621436881536283181048930D+02
       C(  11)= -0.28076072203793060566567874047905207D+02
       C(  12)= -0.49407444253879817551933228969573975D+05
       C(  13)=  0.32065767410079465404848519938241225D+00
       C(  14)=  0.78699470552401928902241934338235296D+00
       C(  15)=  0.32007128040061766371948692722071428D+00
       C(  16)=  0.51185205279665002553457497924682684D+00
       C(  17)=  0.22000297224141323049195761996088549D+01
       C(  18)=  0.38045229058726731663497844238008838D+00

      BSORDER=4

      POLORDER=8

      NCBAS=2*BSORDER+2

      NCPOL=POLORDER

      ALLOCATE(BS(NCBAS))

      DO I=1,NCBAS
        BS(I)=0.00D+00
      END DO

      DO I=1,NCBAS
        J=NCPOL+I
        BS(I)=C(J)
      END DO
 
      Y=0.00D+00
      POT=0.00D+00

      CALL BASIS_CONTRACT(1,BSORDER,BS,R,Y)

      DO I=1,POLORDER
        POT=POT+(Z(1)*Z(2)/R)*C(I)*Y**(DBLE(I))
      END DO

      RETURN
      END

!######################################################################################################
!POTENTIAL ENERGY CURVE OF GROUND STATE PO
!######################################################################################################
      SUBROUTINE CHIPR_PO(R,POT)
      IMPLICIT NONE
      INTEGER, PARAMETER :: NC=18
      INTEGER :: I,J
      INTEGER :: BSORDER
      INTEGER :: POLORDER
      INTEGER :: NCBAS,NCPOL
      DOUBLE PRECISION, DIMENSION(2) :: Z
      DOUBLE PRECISION, DIMENSION(NC) :: C
      DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:) :: BS
      DOUBLE PRECISION :: Y   
      DOUBLE PRECISION :: R,POT

      Z(  1)=  0.15000000000000000000000000000000000D+02
      Z(  2)=  0.80000000000000000000000000000000000D+01

       C(   1)= -0.13921521885916574978042659083143917D-03
       C(   2)=  0.21473995577522301744788357780180377D-02
       C(   3)= -0.16845647763439872135471375713677844D-01
       C(   4)=  0.21366229062655790749136741624170099D-01
       C(   5)= -0.12967870491261549933947883062046458D-01
       C(   6)=  0.42994035087634439526449448010225751D-02
       C(   7)= -0.73220989714741055616464837640933183D-03
       C(   8)=  0.49994109376612343588041492692397583D-04
       C(   9)=  0.46775014834989370626772142713889480D+02
       C(  10)= -0.16115875271719055206176562933251262D+02
       C(  11)= -0.24886487600430964306497116922400892D+02
       C(  12)=  0.72332217264324117422802373766899109D+03
       C(  13)=  0.34534300017000890692386860791884828D+00
       C(  14)=  0.65365556855440354322439588941051625D+00
       C(  15)=  0.33804790165236392462944081671594176D+00
       C(  16)=  0.19362918986665169640559724939521402D+01
       C(  17)=  0.24252707779935320786535157822072506D+01
       C(  18)=  0.31197990075241321950016981645603664D+00	  

      BSORDER=4

      POLORDER=8

      NCBAS=2*BSORDER+2

      NCPOL=POLORDER

      ALLOCATE(BS(NCBAS))

      DO I=1,NCBAS
        BS(I)=0.00D+00
      END DO

      DO I=1,NCBAS
        J=NCPOL+I
        BS(I)=C(J)
      END DO
 
      Y=0.00D+00
      POT=0.00D+00

      CALL BASIS_CONTRACT(1,BSORDER,BS,R,Y)

      DO I=1,POLORDER
        POT=POT+(Z(1)*Z(2)/R)*C(I)*Y**(DBLE(I))
      END DO

      DEALLOCATE(BS)

      RETURN
      END  

!######################################################################################################
!THREE-BODY TERM OF GROUND STATE PO2
!######################################################################################################
      SUBROUTINE CHIPR_TRIAT(R,POT)
      IMPLICIT NONE
      CHARACTER(LEN=3), PARAMETER :: MOLTYP="AB2"
      INTEGER, PARAMETER :: DEG=2
      INTEGER, PARAMETER :: NC=239
      INTEGER, PARAMETER :: NX=3
      INTEGER :: I,J,K,L,M,S,O,ID
      INTEGER :: POLORDER
      INTEGER, DIMENSION(DEG) :: BSORDER,NCBAS
      DOUBLE PRECISION, DIMENSION(NC) :: C
      DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:) :: POL,BS
      DOUBLE PRECISION, DIMENSION(3) :: R
      DOUBLE PRECISION :: POT,REPDAMP
      INTEGER :: NCPOL,NCTOTAL,SUMC
      DOUBLE PRECISION, DIMENSION(NX) :: Y
      INTEGER :: TOTNUM,MNUM
      INTEGER, DIMENSION(3,6) :: P

       C(   1)= -0.15039922008343279458131291903555393D+03
       C(   2)= -0.18924924819959045407813391648232937D+03
       C(   3)=  0.10061143262959127241629175841808319D+05
       C(   4)=  0.68990189199559797998517751693725586D+05
       C(   5)=  0.35008516177237484953366219997406006D+05
       C(   6)= -0.32706547760698533238610252737998962D+05
       C(   7)= -0.55983842944719048682600259780883789D+06
       C(   8)=  0.11887655133183146826922893524169922D+07
       C(   9)= -0.40551451206762627698481082916259766D+07
       C(  10)= -0.43554777238958422094583511352539062D+07
       C(  11)= -0.31640354275758815929293632507324219D+07
       C(  12)= -0.73899861288392916321754455566406250D+06
       C(  13)=  0.39863201095361229963600635528564453D+07
       C(  14)=  0.47195802618081800639629364013671875D+08
       C(  15)= -0.11316059575081752240657806396484375D+09
       C(  16)=  0.11131509909644570946693420410156250D+09
       C(  17)=  0.75219830213952973484992980957031250D+08
       C(  18)=  0.79555497393760994076728820800781250D+08
       C(  19)=  0.25694068731404763460159301757812500D+09
       C(  20)=  0.16814330430663785338401794433593750D+09
       C(  21)= -0.18792385802355483174324035644531250D+08
       C(  22)= -0.36446305096120186150074005126953125D+08
       C(  23)= -0.17263536930811345577239990234375000D+09
       C(  24)= -0.20087030369152812957763671875000000D+10
       C(  25)=  0.18044063844573352336883544921875000D+10
       C(  26)=  0.26530101447463150024414062500000000D+10
       C(  27)= -0.20984391135144870281219482421875000D+10
       C(  28)=  0.95872136012749958038330078125000000D+09
       C(  29)= -0.40551738907283334732055664062500000D+10
       C(  30)= -0.70829873057174568176269531250000000D+10
       C(  31)= -0.32521251149973936080932617187500000D+10
       C(  32)= -0.44566417739906936883926391601562500D+09
       C(  33)= -0.46641200408242845535278320312500000D+10
       C(  34)= -0.51850092592032938003540039062500000D+10
       C(  35)=  0.35075293829755020141601562500000000D+10
       C(  36)=  0.33352751340989694595336914062500000D+10
       C(  37)=  0.40142144835177111625671386718750000D+10
       C(  38)=  0.42258696308628387451171875000000000D+11
       C(  39)=  0.72610147588369607925415039062500000D+10
       C(  40)= -0.98268799711548233032226562500000000D+11
       C(  41)=  0.40374619505021362304687500000000000D+11
       C(  42)= -0.65137190796352294921875000000000000D+11
       C(  43)=  0.54203652618748405456542968750000000D+11
       C(  44)=  0.36708133143719215393066406250000000D+11
       C(  45)=  0.94808531549722946166992187500000000D+11
       C(  46)=  0.32137671189011844635009765625000000D+11
       C(  47)=  0.25790046551666053771972656250000000D+11
       C(  48)=  0.14778744172596337890625000000000000D+12
       C(  49)=  0.73981204373486892700195312500000000D+11
       C(  50)= -0.29002145566956715583801269531250000D+10
       C(  51)=  0.14923995964709192276000976562500000D+11
       C(  52)=  0.11018545675529035949707031250000000D+12
       C(  53)= -0.92825617818357315063476562500000000D+11
       C(  54)= -0.11322850188715907287597656250000000D+12
       C(  55)= -0.54530529057227951049804687500000000D+11
       C(  56)= -0.42193380931544921875000000000000000D+12
       C(  57)= -0.84660032392099182128906250000000000D+12
       C(  58)=  0.12095370731922551269531250000000000D+13
       C(  59)=  0.60977828604289648437500000000000000D+12
       C(  60)= -0.76072741456013403320312500000000000D+12
       C(  61)=  0.13247226573479619140625000000000000D+13
       C(  62)= -0.25086349365969244384765625000000000D+12
       C(  63)= -0.78273524165257434082031250000000000D+12
       C(  64)= -0.52166452885098248291015625000000000D+12
       C(  65)= -0.13797677980066351318359375000000000D+12
       C(  66)= -0.61428637649826916503906250000000000D+12
       C(  67)= -0.14023315807146374511718750000000000D+12
       C(  68)= -0.22310613143345844726562500000000000D+13
       C(  69)= -0.41357697227122760009765625000000000D+12
       C(  70)=  0.11521419779187867736816406250000000D+12
       C(  71)= -0.10219601132752954101562500000000000D+13
       C(  72)= -0.14066054156377507324218750000000000D+13
       C(  73)=  0.96789108032278106689453125000000000D+11
       C(  74)=  0.40586145533856860351562500000000000D+12
       C(  75)= -0.14462992889533056640625000000000000D+13
       C(  76)=  0.13307860136823090820312500000000000D+13
       C(  77)=  0.21316274963151811523437500000000000D+13
       C(  78)=  0.41148999873937756347656250000000000D+12
       C(  79)=  0.10782630200361719970703125000000000D+13
       C(  80)=  0.15473832313998683593750000000000000D+14
       C(  81)= -0.10043380032991767578125000000000000D+14
       C(  82)= -0.97296387166473769531250000000000000D+13
       C(  83)=  0.10136586191987707031250000000000000D+14
       C(  84)= -0.16211446046524716796875000000000000D+14
       C(  85)= -0.19075862824060339355468750000000000D+13
       C(  86)=  0.51008341175636718750000000000000000D+13
       C(  87)=  0.24975087512357124023437500000000000D+13
       C(  88)= -0.12892505786390961914062500000000000D+13
       C(  89)=  0.28510700345994565429687500000000000D+13
       C(  90)=  0.74585477878474287109375000000000000D+13
       C(  91)=  0.38970266804020800781250000000000000D+13
       C(  92)=  0.17944717597586019531250000000000000D+14
       C(  93)= -0.49763922950915527343750000000000000D+13
       C(  94)= -0.20953226319376103515625000000000000D+13
       C(  95)= -0.11524005781934221191406250000000000D+13
       C(  96)=  0.15720319601187095703125000000000000D+14
       C(  97)=  0.11935722365012285156250000000000000D+14
       C(  98)=  0.18055587503551333007812500000000000D+13
       C(  99)=  0.14764667564177705078125000000000000D+13
       C( 100)=  0.12397615890184730468750000000000000D+14
       C( 101)= -0.35560458075591342773437500000000000D+13
       C( 102)= -0.63199400214797304687500000000000000D+13
       C( 103)=  0.13685036138133914062500000000000000D+14
       C( 104)= -0.11629630862225810546875000000000000D+14
       C( 105)= -0.24450776953576695312500000000000000D+14
       C( 106)= -0.11759906155037465820312500000000000D+13
       C( 107)=  0.14361644111803193359375000000000000D+14
       C( 108)= -0.13512923108855210937500000000000000D+15
       C( 109)=  0.47805982270120328125000000000000000D+14
       C( 110)=  0.60293497199422460937500000000000000D+14
       C( 111)=  0.18004465225370207031250000000000000D+14
       C( 112)= -0.80937216457048671875000000000000000D+14
       C( 113)=  0.13073517320596692187500000000000000D+15
       C( 114)=  0.25414296731485144531250000000000000D+14
       C( 115)= -0.29686326841531527343750000000000000D+14
       C( 116)= -0.12062330138139062500000000000000000D+14
       C( 117)=  0.28986852819837246093750000000000000D+14
       C( 118)= -0.67201957674185664062500000000000000D+14
       C( 119)= -0.97378461181740097656250000000000000D+13
       C( 120)= -0.22745429074522855468750000000000000D+14
       C( 121)= -0.18876381206303539062500000000000000D+14
       C( 122)= -0.62152875984022132812500000000000000D+14
       C( 123)=  0.98500952422985812500000000000000000D+14
       C( 124)= -0.61251852203794921875000000000000000D+14
       C( 125)=  0.11038845670554638671875000000000000D+14
       C( 126)= -0.13925277260417092187500000000000000D+15
       C( 127)= -0.45719369752763710937500000000000000D+14
       C( 128)=  0.70329490357078390625000000000000000D+14
       C( 129)=  0.12930290597942187500000000000000000D+14
       C( 130)= -0.12531405004088625000000000000000000D+14
       C( 131)= -0.85156236026255546875000000000000000D+14
       C( 132)= -0.72384917562214484375000000000000000D+14
       C( 133)= -0.62517526382337900390625000000000000D+13
       C( 134)= -0.58775492911019390625000000000000000D+14
       C( 135)=  0.62789530910098828125000000000000000D+14
       C( 136)=  0.55605105872919757812500000000000000D+14
       C( 137)= -0.96238913416486984375000000000000000D+14
       C( 138)=  0.58358832681067835937500000000000000D+14
       C( 139)=  0.17077892438953081250000000000000000D+15
       C( 140)= -0.49821367416390273437500000000000000D+13
       C( 141)= -0.12307856534669607812500000000000000D+15
       C( 142)=  0.59536729077800137500000000000000000D+15
       C( 143)= -0.11498475015349715625000000000000000D+15
       C( 144)= -0.22037114546776709375000000000000000D+15
       C( 145)= -0.10447200112620257812500000000000000D+15
       C( 146)=  0.34605198587574600000000000000000000D+15
       C( 147)= -0.61709185953110525000000000000000000D+15
       C( 148)= -0.11550220412552685937500000000000000D+15
       C( 149)=  0.27638743102192062500000000000000000D+15
       C( 150)= -0.27539822070915090625000000000000000D+15
       C( 151)=  0.16811548499147471875000000000000000D+15
       C( 152)= -0.11075969238942700000000000000000000D+15
       C( 153)=  0.50692928113485900000000000000000000D+15
       C( 154)= -0.30898244435670368750000000000000000D+15
       C( 155)=  0.15814268863452803125000000000000000D+15
       C( 156)=  0.60819280185404562500000000000000000D+14
       C( 157)= -0.73653821389077871093750000000000000D+13
       C( 158)= -0.41378711548399275000000000000000000D+15
       C( 159)=  0.60673799163899500000000000000000000D+15
       C( 160)= -0.17546009809796700000000000000000000D+15
       C( 161)=  0.16706118820994543750000000000000000D+15
       C( 162)=  0.57259513921031675000000000000000000D+15
       C( 163)= -0.33752190793440893750000000000000000D+15
       C( 164)= -0.23948077766574246875000000000000000D+15
       C( 165)= -0.20894119300592834375000000000000000D+15
       C( 166)=  0.22192343341928453125000000000000000D+15
       C( 167)=  0.67183441873667125000000000000000000D+15
       C( 168)= -0.64944083222140921875000000000000000D+14
       C( 169)=  0.26227217033232343750000000000000000D+14
       C( 170)= -0.14355654454019878125000000000000000D+15
       C( 171)= -0.37242012470837679687500000000000000D+14
       C( 172)=  0.36071665204652475000000000000000000D+15
       C( 173)=  0.12773805352907154687500000000000000D+15
       C( 174)=  0.30163677046841606250000000000000000D+15
       C( 175)= -0.40562196727217031250000000000000000D+15
       C( 176)= -0.30447277231636181250000000000000000D+15
       C( 177)=  0.38496329093028593750000000000000000D+15
       C( 178)= -0.13615607090324450000000000000000000D+15
       C( 179)= -0.66400264013145762500000000000000000D+15
       C( 180)=  0.45212779828586898437500000000000000D+14
       C( 181)=  0.29572140149670825000000000000000000D+15
       C( 182)= -0.11045539185795787500000000000000000D+16
       C( 183)=  0.19803248344473478125000000000000000D+15
       C( 184)=  0.24015562849177406250000000000000000D+15
       C( 185)=  0.16729990253495212500000000000000000D+15
       C( 186)=  0.78207926539181265625000000000000000D+14
       C( 187)= -0.60985095405531375000000000000000000D+15
       C( 188)=  0.12265627291409567500000000000000000D+16
       C( 189)=  0.37718267393182343750000000000000000D+15
       C( 190)= -0.13730497607909762500000000000000000D+16
       C( 191)=  0.15702734142786057500000000000000000D+16
       C( 192)= -0.72059129603900025000000000000000000D+15
       C( 193)=  0.95781802473306093750000000000000000D+14
       C( 194)= -0.11921280679069150000000000000000000D+16
       C( 195)=  0.95297583102605987500000000000000000D+15
       C( 196)=  0.93676834017374093750000000000000000D+14
       C( 197)= -0.10161181724675146250000000000000000D+16
       C( 198)=  0.62153468579732250000000000000000000D+15
       C( 199)=  0.35095132935869343750000000000000000D+15
       C( 200)=  0.36849011250128643750000000000000000D+15
       C( 201)= -0.84330194233086975000000000000000000D+15
       C( 202)=  0.12902869023686721875000000000000000D+15
       C( 203)= -0.30961479619896725000000000000000000D+15
       C( 204)= -0.69177536376606112500000000000000000D+15
       C( 205)=  0.10950700238702368750000000000000000D+16
       C( 206)= -0.90006894263515087500000000000000000D+15
       C( 207)=  0.71068438026185937500000000000000000D+15
       C( 208)= -0.33566580663919893750000000000000000D+15
       C( 209)= -0.98262759657729337500000000000000000D+15
       C( 210)=  0.13923005903768609375000000000000000D+15
       C( 211)=  0.11344237823582880000000000000000000D+16
       C( 212)=  0.65853908880752487500000000000000000D+15
       C( 213)=  0.42195307376624343750000000000000000D+15
       C( 214)= -0.21238084521398615000000000000000000D+16
       C( 215)= -0.84000595614684075000000000000000000D+15
       C( 216)= -0.44162802078638862500000000000000000D+15
       C( 217)=  0.11287202865208868750000000000000000D+15
       C( 218)=  0.14781458119406907500000000000000000D+16
       C( 219)= -0.11811539664734587500000000000000000D+15
       C( 220)= -0.38227361172261318750000000000000000D+15
       C( 221)= -0.12164261850980157500000000000000000D+16
       C( 222)=  0.81975172577987062500000000000000000D+15
       C( 223)=  0.71900419528185362500000000000000000D+15
       C( 224)= -0.52076576006861087500000000000000000D+15
       C( 225)=  0.62182235189527835937500000000000000D+14
       C( 226)=  0.10886756452991636250000000000000000D+16
       C( 227)= -0.91755319870027781250000000000000000D+14
       C( 228)=  0.46554846512780856393476369703421369D-01
       C( 229)=  0.15781332266186996093892958015203476D+04
       C( 230)=  0.86600521547266984256907562667038292D+00
       C( 231)=  0.15671434487167557741971180007567455D-01
       C( 232)=  0.75306620552818125807759130907470535D-02
       C( 233)=  0.24162944487366200263522841851226985D+01
       C( 234)=  0.30199024226609017668154777425115753D-01
       C( 235)=  0.19528469604725362387398490682244301D+04
       C( 236)=  0.13895264834385914198833233967889100D+01
       C( 237)=  0.31917781464201189223217625112738460D+00
       C( 238)=  0.61795400375260634007190674310550094D+00
       C( 239)=  0.26363289288580875613376974797574803D+01	  


      BSORDER(1)=  2
      BSORDER(2)=  2

      POLORDER=  12

      DO I=1,DEG
        NCBAS(I)=0
        NCBAS(I)=2*BSORDER(I)+2
      END DO

      CALL POLNC(POLORDER,MOLTYP,NCPOL)

      IF (NC.NE.(NCPOL+SUM(NCBAS))) THEN 
        WRITE(*,*) "PROBLEMS IN DEFINING PROPER NUMBER OF COEFFICIENTS"
        WRITE(*,*) "TOTAL NUMBER OF COEFFS ARE NOT SUMMING UP CORRECTLY"
        STOP
      END IF

      ALLOCATE(POL(NCPOL))


      DO I=1,NCPOL
        POL(I)=0.00D+00
      END DO

      DO I=1,NX
        Y(I)=0.0D+00
      END DO

      SUMC=NCPOL
      DO I=1,DEG
        ALLOCATE(BS(NCBAS(I)))
        DO J=1,NCBAS(I)
          BS(J)=0.0D+00
        END DO
        K=SUMC
        DO J=1,NCBAS(I)
          K=K+1
          BS(J)=C(K)
        END DO

!######
! AB2-TYPE
!######
        IF (DEG.EQ.2) THEN
          IF (I.EQ.1) THEN
!
!           B-B BASIS
!
            CALL BASIS_CONTRACT(1,BSORDER(1),BS,R(1),Y(1))

          ELSE
!
!           A-B BASIS
!
            DO O=2,3 
              CALL BASIS_CONTRACT(2,BSORDER(2),BS,R(O),Y(O))

!######
            END DO
          END IF            
        END IF

        SUMC=SUMC+NCBAS(I)
        DEALLOCATE(BS)
      END DO

      TOTNUM=0
      S=0
      DO M=0,POLORDER
        MNUM=0
        DO I=0,M
          DO J=0,(M-I)
            K=M-I-J
            S=I+J+K
            IF (S.NE.I .AND. S.NE.J .AND. S.NE.K) THEN

              IF (MOLTYP.EQ."ABC") THEN  

                TOTNUM=TOTNUM+1
                MNUM=MNUM+1

                CALL PERMUTABC(I,J,K,P,ID)

                DO L=1,ID

                  POL(TOTNUM)=POL(TOTNUM)+
     &               (Y(1)**(P(1,L))*Y(2)**(P(2,L))*Y(3)**(P(3,L)))
       
                END DO

                POL(TOTNUM)=C(TOTNUM)*POL(TOTNUM)/DBLE(ID)

              ELSE IF (MOLTYP.EQ."AB2") THEN 

                IF (J.LE.K) THEN 

                  TOTNUM=TOTNUM+1
                  MNUM=MNUM+1

                  CALL PERMUTAB2(I,J,K,P,ID)
                   
                  DO L=1,ID

                    POL(TOTNUM)=POL(TOTNUM)+
     &                 (Y(1)**(P(1,L))*Y(2)**(P(2,L))*Y(3)**(P(3,L)))

                  END DO

                  POL(TOTNUM)=C(TOTNUM)*POL(TOTNUM)/DBLE(ID)

                END IF    
         
              ELSE IF (MOLTYP.EQ."A3") THEN

                IF (I.LE.J .AND. J.LE.K) THEN

                  TOTNUM=TOTNUM+1
                  MNUM=MNUM+1

                  CALL PERMUTA3(I,J,K,P,ID)
                   
                  DO L=1,ID

                    POL(TOTNUM)=POL(TOTNUM)+
     &                 (Y(1)**(P(1,L))*Y(2)**(P(2,L))*Y(3)**(P(3,L)))

                  END DO

                  POL(TOTNUM)=C(TOTNUM)*POL(TOTNUM)/DBLE(ID)

                END IF

              END IF

            END IF
          END DO
        END DO

      END DO

      POT=SUM(POL)*REPDAMP(NX,R)


      DEALLOCATE(POL)

      RETURN
      END

!################################################################################
      DOUBLE PRECISION FUNCTION REPDAMP(NX,R)
      IMPLICIT NONE
      INTEGER :: I,NX
      DOUBLE PRECISION, DIMENSION(NX) :: R,H
      DOUBLE PRECISION :: KAPPA, XI, R0
      R0=0.5D+00
      KAPPA=100.0D+00
      XI=10.0D+00
      DO I=1,NX
        H(I)=0.5D+00*(1.00D+00+TANH(KAPPA*(R(I)-R0)))
      END DO
      REPDAMP=(PRODUCT(H))**(XI)      
      END FUNCTION
!################################################################################           
      SUBROUTINE PERMUTABC(I,J,K,P,ID)
      IMPLICIT NONE
      INTEGER :: I,J,K
      INTEGER :: L,M,ID
      INTEGER, DIMENSION(3) :: INTER
      INTEGER, DIMENSION(3,6) :: P

      DO L=1,3 
        DO M=1,6
          P(L,M)=0
        END DO
      END DO

      INTER(1)=I
      INTER(2)=J
      INTER(3)=K

      ID=1

      P(1,1)=INTER(1)
      P(2,1)=INTER(2)
      P(3,1)=INTER(3) 

      RETURN
      END
!################################################################################           
      SUBROUTINE PERMUTAB2(I,J,K,P,ID)
      IMPLICIT NONE
      INTEGER :: I,J,K
      INTEGER :: L,M,ID
      INTEGER, DIMENSION(3) :: INTER
      INTEGER, DIMENSION(3,6) :: P

      DO L=1,3 
        DO M=1,6
          P(L,M)=0
        END DO
      END DO
      
      INTER(1)=I
      INTER(2)=J
      INTER(3)=K
      
      IF (J.NE.K) THEN  
 
        ID=2

        P(1,1)=INTER(1)
        P(2,1)=INTER(2)
        P(3,1)=INTER(3)      

        P(1,2)=INTER(1)
        P(2,2)=INTER(3)
        P(3,2)=INTER(2) 

       ELSE 

        ID=1

        P(1,1)=INTER(1)
        P(2,1)=INTER(2)
        P(3,1)=INTER(3)

       END IF

      RETURN 
      END 
!################################################################################          
      SUBROUTINE PERMUTA3(I,J,K,P,ID)
      IMPLICIT NONE
      INTEGER :: I,J,K
      INTEGER :: L,M,ID
      INTEGER, DIMENSION(3) :: INTER
      INTEGER, DIMENSION(3,6) :: P

      DO L=1,3 
        DO M=1,6
          P(L,M)=0
        END DO
      END DO
      
      INTER(1)=I
      INTER(2)=J
      INTER(3)=K
      
      IF (I.EQ.J.AND.J.EQ.K.AND.I.EQ.K) THEN
      
        ID=1

        P(1,1)=INTER(1)
        P(2,1)=INTER(2)
        P(3,1)=INTER(3)  
        
      ELSE IF (I.NE.J.AND.J.NE.K.AND.I.NE.K) THEN   

        ID=6

        P(1,1)=INTER(1)
        P(2,1)=INTER(2)
        P(3,1)=INTER(3)      

        P(1,2)=INTER(2)
        P(2,2)=INTER(1)
        P(3,2)=INTER(3)  

        P(1,3)=INTER(3)
        P(2,3)=INTER(2)
        P(3,3)=INTER(1) 

        P(1,4)=INTER(1)
        P(2,4)=INTER(3)
        P(3,4)=INTER(2) 

        P(1,5)=P(1,2)
        P(2,5)=P(3,2)
        P(3,5)=P(2,2)  

        P(1,6)=P(1,3)
        P(2,6)=P(3,3)
        P(3,6)=P(2,3)  
        
      ELSE IF (I.EQ.J) THEN       
     
        ID=3     

        P(1,1)=INTER(1)
        P(2,1)=INTER(2)
        P(3,1)=INTER(3) 

        P(1,2)=INTER(3)
        P(2,2)=INTER(2)
        P(3,2)=INTER(1) 

        P(1,3)=INTER(1)
        P(2,3)=INTER(3)
        P(3,3)=INTER(2)
        
      ELSE IF (J.EQ.K) THEN       
                    
        ID=3     

        P(1,1)=INTER(1)
        P(2,1)=INTER(2)
        P(3,1)=INTER(3)      

        P(1,2)=INTER(2)
        P(2,2)=INTER(1)
        P(3,2)=INTER(3)  

        P(1,3)=INTER(3)
        P(2,3)=INTER(2)
        P(3,3)=INTER(1) 
        
      ELSE IF (I.EQ.K) THEN    
  
        ID=3  

        P(1,1)=INTER(1)
        P(2,1)=INTER(2)
        P(3,1)=INTER(3)      

        P(1,2)=INTER(2)
        P(2,2)=INTER(1)
        P(3,2)=INTER(3)  

        P(1,3)=INTER(1)
        P(2,3)=INTER(3)
        P(3,3)=INTER(2)        
    
      END IF

      RETURN 
      END 
!################################################################################ 
      SUBROUTINE POLNC(ORDER,MOLTYP,NC)
      IMPLICIT NONE
      INTEGER :: I,J,K,L,M,S
      INTEGER :: NC,MNUM,ORDER
      CHARACTER(LEN=3) :: MOLTYP

      NC=0
      S=0

      DO M=0,ORDER
        MNUM=0
        DO I=0,M
          DO J=0,(M-I)
            K=M-I-J
            S=I+J+K
            IF (S.NE.I .AND. S.NE.J .AND. S.NE.K) THEN
 
              IF (MOLTYP.EQ."ABC") THEN  

                NC=NC+1
                MNUM=MNUM+1

              ELSE IF (MOLTYP.EQ."AB2") THEN 

                IF (J.LE.K) THEN 

                  NC=NC+1
                  MNUM=MNUM+1

                END IF    
        
              ELSE IF (MOLTYP.EQ."A3") THEN

                IF (I.LE.J .AND. J.LE.K) THEN

                  NC=NC+1
                  MNUM=MNUM+1

                END IF

              END IF

            END IF
          END DO
        END DO
      END DO

      RETURN
      END
!######################################################################################################
      SUBROUTINE BASIS_CONTRACT(DEG,M,C,R,YVAL)
      IMPLICIT NONE
      INTEGER :: I,J,DEG
      INTEGER :: M
      DOUBLE PRECISION :: RREF0,ZETA
      DOUBLE PRECISION, DIMENSION(2*M+2) :: C
      DOUBLE PRECISION, DIMENSION(M) :: GAMA,VAL
      DOUBLE PRECISION :: R,YVAL

      DO I=1,M
        GAMA(I)=C(M+I)
      END DO

      RREF0=C(2*M+1)
      ZETA=C(2*M+2)

      DO I=1,M-1
        CALL PHISECBASIS(DEG,I,RREF0,ZETA,GAMA(I),1,R,VAL(I))
      END DO

      DO I=M,M
        CALL PHICSECBASIS(DEG,I,RREF0,ZETA,GAMA(I),1,6,R,VAL(I))
      END DO

      YVAL=0.00D+00

      DO J=1,M
        YVAL=YVAL+C(J)*VAL(J)
      END DO

      RETURN
      END
!######################################################################################################
      SUBROUTINE PHISECBASIS(DEG,IND,RREF0,ZETA,GAMA,ETA,R,VAL)
      IMPLICIT NONE
      INTEGER :: DEG, IND, ETA
      DOUBLE PRECISION :: RREF0, ZETA, RREFIND 
      DOUBLE PRECISION :: GAMA, R, VAL, RHO
      DOUBLE PRECISION :: SECH, ORIG
      RREFIND=ORIG(IND,ZETA,RREF0)
      RHO=(R-RREFIND)
      VAL=(SECH(GAMA*RHO))**(DBLE(ETA))
      RETURN
      END
!######################################################################################################
      SUBROUTINE PHICSECBASIS(DEG,IND,RREF0,ZETA,GAMA,ETA,LR,R,VAL)
      IMPLICIT NONE
      INTEGER :: DEG, IND, LR, ETA
      DOUBLE PRECISION :: RREF0, ZETA, RREFIND 
      DOUBLE PRECISION :: GAMA, R, VAL, RHO
      DOUBLE PRECISION :: SECH, BETA, FAC, ORIG
      BETA=1.00D+00/5.0D+00
      RREFIND=ORIG(IND,ZETA,RREF0)
      RHO=(R-RREFIND)
      FAC=(TANH(BETA*R)/R)**(DBLE(LR))
      VAL=FAC*(SECH(GAMA*RHO))**(DBLE(ETA))
      RETURN
      END
!######################################################################################################
      DOUBLE PRECISION FUNCTION ORIG(IND,ZETA,RREF0)
      IMPLICIT NONE
      INTEGER :: IND
      DOUBLE PRECISION :: ZETA,RREF0
      ORIG=ZETA*(RREF0)**(DBLE(IND)-1.0D+00)
      RETURN
      END
!######################################################################################################
      DOUBLE PRECISION FUNCTION SECH(X)
      IMPLICIT NONE
      DOUBLE PRECISION :: X
      SECH=1.00D+00/(COSH(X))      
      RETURN
      END