! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.3_rs3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_Function.f90
! Time                 : Sat Nov 14 16:34:39 2020
! Working directory    : /home/caaba/caaba_3.8m_volc1/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_Function

  USE messy_mecca_kpp_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(414)*F(1)
  A(2) = RCT(2)*V(446)*F(1)
  A(3) = RCT(3)*V(386)*F(1)
  A(4) = RCT(4)*V(457)*V(466)
  A(5) = RCT(5)*V(395)*V(457)
  A(6) = RCT(6)*V(466)*V(469)
  A(7) = RCT(7)*V(457)*V(469)
  A(8) = RCT(8)*V(469)*V(469)
  A(9) = RCT(9)*V(414)*V(452)
  A(10) = 1.8e-12*V(440)*V(457)
  A(11) = RCT(11)*V(452)*V(452)
  A(12) = V(381)
  A(13) = RCT(13)*V(414)*F(2)
  A(14) = RCT(14)*V(466)*V(468)
  A(15) = RCT(15)*V(466)*V(471)
  A(16) = RCT(16)*V(454)*V(468)
  A(17) = RCT(17)*V(454)*V(471)
  A(18) = RCT(18)*V(423)
  A(19) = RCT(19)*V(457)*V(468)
  A(20) = RCT(20)*V(468)*V(469)
  A(21) = RCT(21)*V(457)*V(471)
  A(22) = RCT(22)*V(469)*V(471)
  A(23) = 3.5e-12*V(454)*V(469)
  A(24) = RCT(24)*V(409)*V(457)
  A(25) = RCT(25)*V(433)*V(457)
  A(26) = RCT(26)*V(403)
  A(27) = RCT(27)*V(403)*V(457)
  A(28) = RCT(28)*V(383)*V(457)
  A(29) = RCT(29)*V(426)*V(466)
  A(30) = RCT(30)*V(426)*V(469)
  A(31) = RCT(31)*V(426)*V(469)
  A(32) = RCT(32)*V(426)*V(468)
  A(33) = RCT(33)*V(426)*V(468)
  A(34) = RCT(34)*V(426)*V(471)
  A(35) = RCT(35)*V(426)*V(471)
  A(36) = 1.2e-14*V(396)*V(466)
  A(37) = 1300*V(396)
  A(38) = RCT(38)*V(424)*V(457)
  A(39) = RCT(39)*V(416)*V(424)
  A(40) = RCT(40)*V(424)*V(471)
  A(41) = 1.66e-12*V(416)*V(457)
  A(42) = RCT(42)*V(391)*V(457)
  A(43) = RCT(43)*V(424)*F(1)
  A(44) = RCT(44)*V(392)*V(457)
  A(45) = RCT(45)*V(408)*V(457)
  A(46) = RCT(46)*V(463)*V(469)
  A(47) = RCT(47)*V(463)*V(469)
  A(48) = RCT(48)*V(463)*V(468)
  A(49) = RCT(49)*V(463)*V(468)
  A(50) = 1.2e-12*V(454)*V(463)
  A(51) = RCT(51)*V(463)
  A(52) = RCT(52)*V(463)
  A(53) = RCT(53)*V(432)*V(457)
  A(54) = RCT(54)*V(453)*V(457)
  A(55) = RCT(55)*V(453)*V(454)
  A(56) = RCT(56)*V(436)*V(457)
  A(57) = RCT(57)*V(428)*V(457)
  A(58) = RCT(58)*V(463)*V(471)
  A(59) = RCT(59)*V(412)
  A(60) = 3e-14*V(412)*V(457)
  A(61) = RCT(61)*V(430)*V(457)
  A(62) = RCT(62)*V(449)
  A(63) = RCT(63)*V(449)*V(471)
  A(64) = RCT(64)*V(449)*V(471)
  A(65) = RCT(65)*V(449)*V(468)
  A(66) = RCT(66)*V(449)*V(468)
  A(67) = RCT(67)*V(463)*V(466)
  A(68) = RCT(68)*V(421)*V(457)
  A(69) = RCT(69)*V(453)*V(469)
  A(70) = RCT(70)*V(441)
  A(71) = RCT(71)*V(441)*V(469)
  A(72) = RCT(72)*V(441)*V(468)
  A(73) = 1.2e-12*V(441)*V(454)
  A(74) = RCT(74)*V(441)
  A(75) = RCT(75)*V(441)
  A(76) = RCT(76)*V(418)*V(457)
  A(77) = RCT(77)*V(418)*V(457)
  A(78) = RCT(78)*V(382)*V(457)
  A(79) = 1.4e-10*V(457)*V(463)
  A(80) = RCT(80)*V(455)
  A(81) = RCT(81)*V(452)*V(455)
  A(82) = 5.2e-12*V(381)*V(455)
  A(83) = 6e-14*V(455)*V(468)
  A(84) = RCT(84)*V(455)*V(471)
  A(85) = 3.6e-14*V(436)*V(455)
  A(86) = 1e-10*V(428)*V(455)
  A(87) = 1.7e-12*V(453)*V(455)
  A(88) = 5e-12*V(408)*V(455)
  A(89) = 5e-12*V(455)*V(463)
  A(90) = 5e-12*V(455)*V(469)
  A(91) = 1e-12*V(455)*V(466)
  A(92) = 6e-11*V(455)*V(455)
  A(93) = RCT(93)*V(441)*V(471)
  A(94) = RCT(94)*V(411)
  A(95) = RCT(95)*V(411)*V(457)
  A(96) = RCT(96)*V(434)*F(1)
  A(97) = RCT(97)*V(434)*V(466)
  A(98) = 1.3e-10*V(434)*V(446)
  A(99) = 2.53e-14*V(449)*V(466)
  A(100) = 2.5e-11*V(446)*V(449)
  A(101) = 4.3e-11*V(446)*V(463)
  A(102) = RCT(102)*V(446)*V(453)
  A(103) = RCT(103)*V(1)
  A(104) = RCT(104)*V(410)*V(457)
  A(105) = RCT(105)*V(410)*V(414)
  A(106) = RCT(106)*V(410)*V(414)
  A(107) = RCT(107)*V(410)*V(414)
  A(108) = RCT(108)*V(410)*V(446)
  A(109) = RCT(109)*V(384)*F(1)
  A(110) = RCT(110)*V(384)*F(1)
  A(111) = 7e-15*V(362)*F(1)
  A(112) = RCT(112)*V(458)*V(466)
  A(113) = RCT(113)*V(451)*V(451)
  A(114) = RCT(114)*V(451)*V(451)
  A(115) = RCT(115)*V(451)*V(451)
  A(116) = RCT(116)*V(451)*V(451)
  A(117) = RCT(117)*V(355)
  A(118) = RCT(118)*V(440)*V(458)
  A(119) = RCT(119)*V(451)*V(469)
  A(120) = RCT(120)*V(437)*V(457)
  A(121) = RCT(121)*V(451)*V(468)
  A(122) = RCT(122)*V(451)*V(471)
  A(123) = RCT(123)*V(442)
  A(124) = RCT(124)*V(442)*V(458)
  A(125) = RCT(125)*V(392)*V(458)
  A(126) = RCT(126)*V(453)*V(458)
  A(127) = 5.9e-11*V(432)*V(458)
  A(128) = RCT(128)*V(451)*V(463)
  A(129) = RCT(129)*V(430)*V(458)
  A(130) = 2.1e-12*V(421)*V(458)
  A(131) = 1.6e-10*V(458)*V(463)
  A(132) = RCT(132)*V(462)*V(466)
  A(133) = 2.7e-12*V(459)*V(459)
  A(134) = RCT(134)*V(459)*V(459)
  A(135) = RCT(135)*V(462)*V(469)
  A(136) = RCT(136)*V(459)*V(469)
  A(137) = RCT(137)*V(425)*V(457)
  A(138) = RCT(138)*V(445)*V(457)
  A(139) = 4.9e-11*V(438)*V(462)
  A(140) = RCT(140)*V(459)*V(468)
  A(141) = RCT(141)*V(459)*V(471)
  A(142) = RCT(142)*V(438)
  A(143) = RCT(143)*V(453)*V(462)
  A(144) = RCT(144)*V(432)*V(462)
  A(145) = RCT(145)*V(459)*V(463)
  A(146) = RCT(146)*V(357)*V(457)
  A(147) = RCT(147)*V(359)*V(457)
  A(148) = RCT(148)*V(358)*V(457)
  A(149) = 3.32e-15*V(427)*V(462)
  A(150) = 1.1e-15*V(417)*V(462)
  A(151) = RCT(151)*V(445)*V(458)
  A(152) = RCT(152)*V(451)*V(459)
  A(153) = RCT(153)*V(451)*V(459)
  A(154) = RCT(154)*V(451)*V(459)
  A(155) = 1.45e-11*V(427)*V(458)
  A(156) = RCT(156)*V(365)*V(457)
  A(157) = RCT(157)*V(366)*V(457)
  A(158) = RCT(158)*V(367)*V(457)
  A(159) = RCT(159)*V(450)*V(466)
  A(160) = 5e-11*V(413)*V(413)
  A(161) = RCT(161)*V(467)*V(467)
  A(162) = RCT(162)*V(450)*V(469)
  A(163) = RCT(163)*V(467)*V(469)
  A(164) = RCT(164)*V(401)*V(457)
  A(165) = RCT(165)*V(413)*V(457)
  A(166) = 2.1e-10*V(393)*V(457)
  A(167) = RCT(167)*V(450)*V(471)
  A(168) = 1e-10*V(450)*V(454)
  A(169) = RCT(169)*V(467)*V(468)
  A(170) = RCT(170)*V(467)*V(471)
  A(171) = RCT(171)*V(413)*V(468)
  A(172) = RCT(172)*V(368)
  A(173) = 0
  A(174) = 1.5e-12*V(393)*V(454)
  A(175) = 9e-12*V(454)*V(467)
  A(176) = 2e-12*V(463)*V(467)
  A(177) = 3.4e-17*V(380)*V(454)
  A(178) = RCT(178)*V(451)*V(467)
  A(179) = 1.2e-11*V(450)*V(459)
  A(180) = RCT(180)*V(459)*V(467)
  A(181) = RCT(181)*V(422)*V(457)
  A(182) = RCT(182)*V(369)
  A(183) = 3e-13*V(369)*V(466)
  A(184) = 5e-11*V(370)*V(469)
  A(185) = RCT(185)*V(422)*V(455)
  A(186) = RCT(186)*F(1)
  A(187) = RCT(187)*V(466)
  A(188) = RCT(188)*V(466)
  A(189) = RCT(189)*V(440)
  A(190) = RCT(190)*V(471)
  A(191) = RCT(191)*V(454)
  A(192) = RCT(192)*V(454)
  A(193) = RCT(193)*V(423)
  A(194) = RCT(194)*V(409)
  A(195) = RCT(195)*V(433)
  A(196) = RCT(196)*V(403)
  A(197) = RCT(197)*V(432)
  A(198) = RCT(198)*V(453)
  A(199) = RCT(199)*V(453)
  A(200) = RCT(200)*V(421)
  A(201) = RCT(201)*V(430)
  A(202) = RCT(202)*V(412)
  A(203) = RCT(203)*V(418)
  A(204) = RCT(204)*V(463)
  A(205) = RCT(205)*V(428)
  A(206) = RCT(206)*V(411)
  A(207) = RCT(207)*V(417)
  A(208) = RCT(208)*V(355)
  A(209) = RCT(209)*V(379)
  A(210) = RCT(210)*V(385)
  A(211) = RCT(211)*V(363)
  A(212) = RCT(212)*V(442)
  A(213) = RCT(213)*V(442)
  A(214) = RCT(214)*V(445)
  A(215) = RCT(215)*V(459)
  A(216) = RCT(216)*V(407)
  A(217) = RCT(217)*V(364)
  A(218) = RCT(218)*V(438)
  A(219) = RCT(219)*V(358)
  A(220) = RCT(220)*V(359)
  A(221) = RCT(221)*V(427)
  A(222) = RCT(222)*V(367)
  A(223) = RCT(223)*V(365)
  A(224) = RCT(224)*V(366)
  A(225) = RCT(225)*V(393)
  A(226) = RCT(226)*V(467)
  A(227) = RCT(227)*V(402)
  A(228) = RCT(228)*V(368)
  A(229) = RCT(229)*V(420)
  A(230) = RCT(230)*V(2)
  A(231) = RCT(231)*V(380)
  A(232) = RCT(232)*V(3)
  A(233) = RCT(233)*V(387)
  A(234) = RCT(234)*V(360)
  A(235) = RCT(235)*V(443)
  A(236) = RCT(236)*V(456)*V(460)*V(470)
  A(237) = RCT(237)*V(429)
  A(238) = RCT(238)*V(456)*V(461)*V(465)
  A(239) = RCT(239)*V(456)*V(461)*V(470)
  A(240) = RCT(240)*V(456)*V(460)*V(465)
  A(241) = RCT(241)*V(444)
  A(242) = RCT(242)*V(415)*V(464)
  A(243) = RCT(243)*V(373)*V(373)
  A(244) = RCT(244)*V(399)*V(419)
  A(245) = RCT(245)*V(447)*V(456)*V(464)
  A(246) = RCT(246)*V(419)*V(456)*V(464)
  A(247) = RCT(247)*V(439)
  A(248) = RCT(248)*V(456)*V(464)*V(470)
  A(249) = RCT(249)*V(447)*V(456)*V(460)
  A(250) = RCT(250)*V(431)
  A(251) = RCT(251)*V(464)*V(465)
  A(252) = RCT(252)*V(447)*V(456)*V(461)
  A(253) = RCT(253)*V(415)*V(435)
  A(254) = RCT(254)*V(415)*V(448)
  A(255) = RCT(255)*V(399)*V(448)
  A(256) = RCT(256)*V(435)*V(470)
  A(257) = RCT(257)*V(448)*V(470)
  A(258) = RCT(258)*V(435)*V(465)
  A(259) = RCT(259)*V(448)*V(465)
  A(260) = RCT(260)*V(466)
  A(261) = RCT(261)*V(415)
  A(262) = RCT(262)*V(440)
  A(263) = RCT(263)*V(399)
  A(264) = RCT(264)*V(383)
  A(265) = RCT(265)*V(375)
  A(266) = RCT(266)*V(423)
  A(267) = RCT(267)*V(433)
  A(268) = RCT(268)*V(404)
  A(269) = RCT(269)*F(3)
  A(270) = RCT(270)*V(371)
  A(271) = RCT(271)*V(417)
  A(272) = RCT(272)*V(443)
  A(273) = RCT(273)*V(437)
  A(274) = RCT(274)*V(388)
  A(275) = RCT(275)*V(385)
  A(276) = RCT(276)*V(470)
  A(277) = RCT(277)*V(423)*V(460)
  A(278) = RCT(278)*V(442)
  A(279) = RCT(279)*V(442)*V(460)
  A(280) = RCT(280)*V(445)
  A(281) = RCT(281)*V(429)
  A(282) = RCT(282)*V(425)
  A(283) = RCT(283)*V(389)
  A(284) = RCT(284)*V(407)
  A(285) = RCT(285)*V(465)
  A(286) = RCT(286)*V(423)*V(461)
  A(287) = RCT(287)*V(438)
  A(288) = RCT(288)*V(438)*V(461)
  A(289) = RCT(289)*V(427)
  A(290) = RCT(290)*V(444)
  A(291) = RCT(291)*V(442)*V(461)
  A(292) = RCT(292)*V(438)*V(460)
  A(293) = RCT(293)*V(467)
  A(294) = RCT(294)*V(373)
  A(295) = RCT(295)*V(402)
  A(296) = RCT(296)*V(447)
  A(297) = RCT(297)*V(401)
  A(298) = RCT(298)*V(420)
  A(299) = RCT(299)*V(387)
  A(300) = RCT(300)*V(439)
  A(301) = RCT(301)*V(360)
  A(302) = RCT(302)*V(431)
  A(303) = RCT(303)*V(422)
  A(304) = RCT(304)*V(390)
  A(305) = RCT(305)*V(361)
  A(306) = RCT(306)*V(356)
  A(307) = RCT(307)*F(4)
  A(308) = RCT(308)*V(378)*V(456)
  A(309) = RCT(309)*V(374)
  A(310) = RCT(310)*V(375)*V(456)
  A(311) = RCT(311)*V(404)
  A(312) = RCT(312)*V(400)*V(456)
  A(313) = RCT(313)*V(371)
  A(314) = RCT(314)*V(372)*V(456)
  A(315) = RCT(315)*V(388)
  A(316) = RCT(316)*V(456)*V(460)
  A(317) = RCT(317)*V(389)
  A(318) = RCT(318)*V(456)*V(461)
  A(319) = RCT(319)*V(444)*V(460)
  A(320) = RCT(320)*V(405)
  A(321) = RCT(321)*V(444)*V(461)
  A(322) = RCT(322)*V(406)
  A(323) = RCT(323)*V(429)*V(460)
  A(324) = RCT(324)*V(406)
  A(325) = RCT(325)*V(443)*V(461)
  A(326) = RCT(326)*V(405)
  A(327) = RCT(327)*V(439)*V(460)
  A(328) = RCT(328)*V(376)
  A(329) = RCT(329)*V(431)*V(461)
  A(330) = RCT(330)*V(377)
  A(331) = RCT(331)*V(439)*V(461)
  A(332) = RCT(332)*V(431)*V(460)
  A(333) = RCT(333)*V(390)
  A(334) = RCT(334)*V(448)*V(456)
  A(335) = RCT(335)*V(448)
  A(336) = RCT(336)*V(435)*V(456)
  A(337) = RCT(337)*V(398)
  A(338) = RCT(338)*V(397)*V(456)
  A(339) = RCT(339)*V(394)
  A(340) = RCT(340)*V(398)*V(456)
  A(341) = 0

! Aggregate function
  Vdot(1) = -A(103)
  Vdot(2) = -A(230)
  Vdot(3) = -A(232)
  Vdot(4) = -A(341)
  Vdot(5) = A(34)
  Vdot(6) = 2*A(87)+2*A(88)+2*A(89)+A(90)+A(146)+A(147)+A(148)+A(156)+A(157)+A(158)+A(219)+A(220)+A(222)+A(223)+A(224)
  Vdot(7) = 2*A(156)+A(157)+A(158)
  Vdot(8) = A(165)
  Vdot(9) = A(160)
  Vdot(10) = A(245)
  Vdot(11) = A(244)
  Vdot(12) = A(306)
  Vdot(13) = A(341)
  Vdot(14) = A(1)
  Vdot(15) = A(2)
  Vdot(16) = A(3)
  Vdot(17) = A(4)
  Vdot(18) = A(5)
  Vdot(19) = A(6)
  Vdot(20) = A(7)
  Vdot(21) = A(8)
  Vdot(22) = A(9)
  Vdot(23) = A(10)
  Vdot(24) = A(11)
  Vdot(25) = A(12)
  Vdot(26) = A(13)
  Vdot(27) = A(14)
  Vdot(28) = A(15)
  Vdot(29) = A(16)
  Vdot(30) = A(17)
  Vdot(31) = A(18)
  Vdot(32) = A(19)
  Vdot(33) = A(20)
  Vdot(34) = A(21)
  Vdot(35) = A(22)
  Vdot(36) = A(23)
  Vdot(37) = A(24)
  Vdot(38) = A(25)
  Vdot(39) = A(26)
  Vdot(40) = A(27)
  Vdot(41) = A(28)
  Vdot(42) = A(29)
  Vdot(43) = A(30)
  Vdot(44) = A(31)
  Vdot(45) = A(32)
  Vdot(46) = A(33)
  Vdot(47) = A(34)
  Vdot(48) = A(35)
  Vdot(49) = A(36)
  Vdot(50) = A(37)
  Vdot(51) = A(38)
  Vdot(52) = A(39)
  Vdot(53) = A(40)
  Vdot(54) = A(41)
  Vdot(55) = A(42)
  Vdot(56) = A(43)
  Vdot(57) = A(44)
  Vdot(58) = A(45)
  Vdot(59) = A(46)
  Vdot(60) = A(47)
  Vdot(61) = A(48)
  Vdot(62) = A(49)
  Vdot(63) = A(50)
  Vdot(64) = A(51)
  Vdot(65) = A(52)
  Vdot(66) = A(53)
  Vdot(67) = A(54)
  Vdot(68) = A(55)
  Vdot(69) = A(56)
  Vdot(70) = A(57)
  Vdot(71) = A(58)
  Vdot(72) = A(59)
  Vdot(73) = A(60)
  Vdot(74) = A(61)
  Vdot(75) = A(62)
  Vdot(76) = A(63)
  Vdot(77) = A(64)
  Vdot(78) = A(65)
  Vdot(79) = A(66)
  Vdot(80) = A(67)
  Vdot(81) = A(68)
  Vdot(82) = A(69)
  Vdot(83) = A(70)
  Vdot(84) = A(71)
  Vdot(85) = A(72)
  Vdot(86) = A(73)
  Vdot(87) = A(74)
  Vdot(88) = A(75)
  Vdot(89) = A(76)
  Vdot(90) = A(77)
  Vdot(91) = A(78)
  Vdot(92) = A(79)
  Vdot(93) = A(80)
  Vdot(94) = A(81)
  Vdot(95) = A(82)
  Vdot(96) = A(83)
  Vdot(97) = A(84)
  Vdot(98) = A(85)
  Vdot(99) = A(86)
  Vdot(100) = A(87)
  Vdot(101) = A(88)
  Vdot(102) = A(89)
  Vdot(103) = A(90)
  Vdot(104) = A(91)
  Vdot(105) = A(92)
  Vdot(106) = A(93)
  Vdot(107) = A(94)
  Vdot(108) = A(95)
  Vdot(109) = A(96)
  Vdot(110) = A(97)
  Vdot(111) = A(98)
  Vdot(112) = A(99)
  Vdot(113) = A(100)
  Vdot(114) = A(101)
  Vdot(115) = A(102)
  Vdot(116) = A(103)
  Vdot(117) = A(104)
  Vdot(118) = A(105)
  Vdot(119) = A(106)
  Vdot(120) = A(107)
  Vdot(121) = A(108)
  Vdot(122) = A(109)
  Vdot(123) = A(110)
  Vdot(124) = A(111)
  Vdot(125) = A(112)
  Vdot(126) = A(113)
  Vdot(127) = A(114)
  Vdot(128) = A(115)
  Vdot(129) = A(116)
  Vdot(130) = A(117)
  Vdot(131) = A(118)
  Vdot(132) = A(119)
  Vdot(133) = A(120)
  Vdot(134) = A(121)
  Vdot(135) = A(122)
  Vdot(136) = A(123)
  Vdot(137) = A(124)
  Vdot(138) = A(125)
  Vdot(139) = A(126)
  Vdot(140) = A(127)
  Vdot(141) = A(128)
  Vdot(142) = A(129)
  Vdot(143) = A(130)
  Vdot(144) = A(131)
  Vdot(145) = A(132)
  Vdot(146) = A(133)
  Vdot(147) = A(134)
  Vdot(148) = A(135)
  Vdot(149) = A(136)
  Vdot(150) = A(137)
  Vdot(151) = A(138)
  Vdot(152) = A(139)
  Vdot(153) = A(140)
  Vdot(154) = A(141)
  Vdot(155) = A(142)
  Vdot(156) = A(143)
  Vdot(157) = A(144)
  Vdot(158) = A(145)
  Vdot(159) = A(146)
  Vdot(160) = A(147)
  Vdot(161) = A(148)
  Vdot(162) = A(149)
  Vdot(163) = A(150)
  Vdot(164) = A(151)
  Vdot(165) = A(152)
  Vdot(166) = A(153)
  Vdot(167) = A(154)
  Vdot(168) = A(155)
  Vdot(169) = A(156)
  Vdot(170) = A(157)
  Vdot(171) = A(158)
  Vdot(172) = A(159)
  Vdot(173) = A(160)
  Vdot(174) = A(161)
  Vdot(175) = A(162)
  Vdot(176) = A(163)
  Vdot(177) = A(164)
  Vdot(178) = A(165)
  Vdot(179) = A(166)
  Vdot(180) = A(167)
  Vdot(181) = A(168)
  Vdot(182) = A(169)
  Vdot(183) = A(170)
  Vdot(184) = A(171)
  Vdot(185) = A(172)
  Vdot(186) = A(173)
  Vdot(187) = A(174)
  Vdot(188) = A(175)
  Vdot(189) = A(176)
  Vdot(190) = A(177)
  Vdot(191) = A(178)
  Vdot(192) = A(179)
  Vdot(193) = A(180)
  Vdot(194) = A(181)
  Vdot(195) = A(182)
  Vdot(196) = A(183)
  Vdot(197) = A(184)
  Vdot(198) = A(185)
  Vdot(199) = A(186)
  Vdot(200) = A(187)
  Vdot(201) = A(188)
  Vdot(202) = A(189)
  Vdot(203) = A(190)
  Vdot(204) = A(191)
  Vdot(205) = A(192)
  Vdot(206) = A(193)
  Vdot(207) = A(194)
  Vdot(208) = A(195)
  Vdot(209) = A(196)
  Vdot(210) = A(197)
  Vdot(211) = A(198)
  Vdot(212) = A(199)
  Vdot(213) = A(200)
  Vdot(214) = A(201)
  Vdot(215) = A(202)
  Vdot(216) = A(203)
  Vdot(217) = A(204)
  Vdot(218) = A(205)
  Vdot(219) = A(206)
  Vdot(220) = A(207)
  Vdot(221) = A(208)
  Vdot(222) = A(209)
  Vdot(223) = A(210)
  Vdot(224) = A(211)
  Vdot(225) = A(212)
  Vdot(226) = A(213)
  Vdot(227) = A(214)
  Vdot(228) = A(215)
  Vdot(229) = A(216)
  Vdot(230) = A(217)
  Vdot(231) = A(218)
  Vdot(232) = A(219)
  Vdot(233) = A(220)
  Vdot(234) = A(221)
  Vdot(235) = A(222)
  Vdot(236) = A(223)
  Vdot(237) = A(224)
  Vdot(238) = A(225)
  Vdot(239) = A(226)
  Vdot(240) = A(227)
  Vdot(241) = A(228)
  Vdot(242) = A(229)
  Vdot(243) = A(230)
  Vdot(244) = A(231)
  Vdot(245) = A(232)
  Vdot(246) = A(233)
  Vdot(247) = A(234)
  Vdot(248) = A(235)
  Vdot(249) = A(236)
  Vdot(250) = A(237)
  Vdot(251) = A(238)
  Vdot(252) = A(239)
  Vdot(253) = A(240)
  Vdot(254) = A(241)
  Vdot(255) = A(242)
  Vdot(256) = A(243)
  Vdot(257) = A(244)
  Vdot(258) = A(245)
  Vdot(259) = A(246)
  Vdot(260) = A(247)
  Vdot(261) = A(248)
  Vdot(262) = A(249)
  Vdot(263) = A(250)
  Vdot(264) = A(251)
  Vdot(265) = A(252)
  Vdot(266) = A(253)
  Vdot(267) = A(254)
  Vdot(268) = A(255)
  Vdot(269) = A(256)
  Vdot(270) = A(257)
  Vdot(271) = A(258)
  Vdot(272) = A(259)
  Vdot(273) = A(260)
  Vdot(274) = A(261)
  Vdot(275) = A(262)
  Vdot(276) = A(263)
  Vdot(277) = A(264)
  Vdot(278) = A(265)
  Vdot(279) = A(266)
  Vdot(280) = A(267)
  Vdot(281) = A(268)
  Vdot(282) = A(269)
  Vdot(283) = A(270)
  Vdot(284) = A(271)
  Vdot(285) = A(272)
  Vdot(286) = A(273)
  Vdot(287) = A(274)
  Vdot(288) = A(275)
  Vdot(289) = A(276)
  Vdot(290) = A(277)
  Vdot(291) = A(278)
  Vdot(292) = A(279)
  Vdot(293) = A(280)
  Vdot(294) = A(281)
  Vdot(295) = A(282)
  Vdot(296) = A(283)
  Vdot(297) = A(284)
  Vdot(298) = A(285)
  Vdot(299) = A(286)
  Vdot(300) = A(287)
  Vdot(301) = A(288)
  Vdot(302) = A(289)
  Vdot(303) = A(290)
  Vdot(304) = A(291)
  Vdot(305) = A(292)
  Vdot(306) = A(293)
  Vdot(307) = A(294)
  Vdot(308) = A(295)
  Vdot(309) = A(296)
  Vdot(310) = A(297)
  Vdot(311) = A(298)
  Vdot(312) = A(299)
  Vdot(313) = A(300)
  Vdot(314) = A(301)
  Vdot(315) = A(302)
  Vdot(316) = A(303)
  Vdot(317) = A(304)
  Vdot(318) = A(305)
  Vdot(319) = A(306)
  Vdot(320) = A(307)
  Vdot(321) = A(308)
  Vdot(322) = A(309)
  Vdot(323) = A(310)
  Vdot(324) = A(311)
  Vdot(325) = A(312)
  Vdot(326) = A(313)
  Vdot(327) = A(314)
  Vdot(328) = A(315)
  Vdot(329) = A(316)
  Vdot(330) = A(317)
  Vdot(331) = A(318)
  Vdot(332) = A(319)
  Vdot(333) = A(320)
  Vdot(334) = A(321)
  Vdot(335) = A(322)
  Vdot(336) = A(323)
  Vdot(337) = A(324)
  Vdot(338) = A(325)
  Vdot(339) = A(326)
  Vdot(340) = A(327)
  Vdot(341) = A(328)
  Vdot(342) = A(329)
  Vdot(343) = A(330)
  Vdot(344) = A(331)
  Vdot(345) = A(332)
  Vdot(346) = A(333)
  Vdot(347) = A(334)
  Vdot(348) = A(335)
  Vdot(349) = A(336)
  Vdot(350) = A(337)
  Vdot(351) = A(338)
  Vdot(352) = A(339)
  Vdot(353) = A(340)
  Vdot(354) = A(341)
  Vdot(355) = A(116)-A(117)-A(208)
  Vdot(356) = A(184)-A(306)
  Vdot(357) = -A(146)
  Vdot(358) = -A(148)-A(219)
  Vdot(359) = -A(147)-A(220)
  Vdot(360) = -A(234)-A(301)+A(302)
  Vdot(361) = A(181)+A(185)-A(305)
  Vdot(362) = A(106)+A(108)+A(109)-A(111)
  Vdot(363) = -A(211)+A(277)
  Vdot(364) = -A(217)+A(286)
  Vdot(365) = -A(156)-A(223)
  Vdot(366) = -A(157)-A(224)
  Vdot(367) = -A(158)-A(222)
  Vdot(368) = A(167)-A(172)-A(228)
  Vdot(369) = -A(182)-A(183)
  Vdot(370) = A(183)-A(184)
  Vdot(371) = A(269)-A(270)-A(313)+A(314)
  Vdot(372) = A(313)-A(314)
  Vdot(373) = -2*A(243)+A(293)-A(294)
  Vdot(374) = -A(309)+A(310)
  Vdot(375) = A(264)-A(265)+A(309)-A(310)
  Vdot(376) = A(327)-A(328)
  Vdot(377) = A(329)-A(330)
  Vdot(378) = A(242)+A(246)+A(251)+A(307)-A(308)
  Vdot(379) = A(115)+A(152)+0.55*A(178)-A(209)
  Vdot(380) = -A(177)-A(231)
  Vdot(381) = A(11)-A(12)-A(82)
  Vdot(382) = 0.5*A(75)-A(78)
  Vdot(383) = -A(28)-A(264)+A(265)
  Vdot(384) = A(104)+A(107)-A(109)-A(110)
  Vdot(385) = A(119)-A(210)-A(275)+A(276)
  Vdot(386) = -A(3)+A(5)+A(56)+0.956*A(97)+A(98)+0.3*A(102)+A(106)+A(108)+A(199)
  Vdot(387) = 0.2*A(178)-A(233)-A(299)+A(300)
  Vdot(388) = A(273)-A(274)-A(315)+A(316)
  Vdot(389) = A(282)-A(283)-A(317)+A(318)
  Vdot(390) = A(303)-A(304)-A(333)+A(334)
  Vdot(391) = A(39)-A(42)
  Vdot(392) = -A(44)-A(125)
  Vdot(393) = -A(166)-A(174)-A(225)
  Vdot(394) = A(305)-A(339)+A(340)
  Vdot(395) = -A(5)+0.17*A(98)+A(198)
  Vdot(396) = A(29)+A(30)+A(35)-A(36)-A(37)
  Vdot(397) = A(253)+A(254)+A(255)+A(337)-A(338)
  Vdot(398) = A(256)+A(257)+A(258)+A(259)-A(337)+A(338)+A(339)-A(340)
  Vdot(399) = -A(244)-A(255)+A(262)-A(263)
  Vdot(400) = A(277)+A(279)+A(286)+A(288)+A(291)+A(292)+A(311)-A(312)
  Vdot(401) = A(162)-A(164)-A(297)
  Vdot(402) = A(163)+A(166)-A(227)-A(295)+A(296)
  Vdot(403) = A(22)-A(26)-A(27)-A(196)
  Vdot(404) = 2*A(266)+A(267)-A(268)+A(278)+A(287)+A(298)-A(311)+A(312)
  Vdot(405) = A(319)-A(320)+A(325)-A(326)
  Vdot(406) = A(321)-A(322)+A(323)-A(324)
  Vdot(407) = A(136)+A(138)+A(145)-A(216)-A(284)+A(285)
  Vdot(408) = -A(45)+0.5*A(52)-A(88)
  Vdot(409) = A(19)-A(24)+A(40)+A(64)-A(194)
  Vdot(410) = -A(104)-A(106)-A(107)-A(108)
  Vdot(411) = A(93)-A(94)-A(95)-A(206)
  Vdot(412) = A(58)-A(59)-A(60)-A(202)
  Vdot(413) = -2*A(160)+0.38*A(161)-A(165)-A(171)+A(175)+0.6*A(176)+0.8*A(180)
  Vdot(414) = -A(1)-A(9)-A(13)-A(105)-A(106)-A(107)+A(187)
  Vdot(415) = -A(242)-A(253)-A(254)+A(260)-A(261)
  Vdot(416) = A(37)-A(39)-A(41)+A(42)
  Vdot(417) = A(113)+A(124)-A(150)+A(155)-A(207)-A(271)+A(272)
  Vdot(418) = 0.5*A(71)-A(76)-A(77)+A(81)+A(82)-A(203)
  Vdot(419) = A(243)-A(244)-A(246)
  Vdot(420) = A(170)-A(173)+A(174)-A(229)-A(298)
  Vdot(421) = A(65)-A(68)-A(130)-A(200)
  Vdot(422) = -A(181)+A(182)-A(185)-A(303)+A(304)
  Vdot(423) = A(17)-A(18)-A(193)-A(266)-A(277)-A(286)
  Vdot(424) = A(31)-A(38)-A(39)-A(40)+A(41)-A(43)+A(66)
  Vdot(425) = A(135)-A(137)+A(143)+A(144)-A(282)+A(283)
  Vdot(426) = A(28)-A(29)-A(30)-A(31)-A(32)-A(33)-A(34)-A(35)+A(36)
  Vdot(427) = -A(149)+A(150)+A(151)+A(154)-A(155)-A(221)-A(289)+A(290)
  Vdot(428) = -A(57)+0.5*A(71)+A(72)+A(73)+A(74)+0.5*A(75)+A(77)+A(78)+A(86)+A(95)+A(203)-A(205)+0.333*A(206)
  Vdot(429) = -A(237)+A(238)+A(280)-A(281)+A(288)-A(323)+A(324)
  Vdot(430) = A(49)-A(61)+A(63)-A(129)-A(201)
  Vdot(431) = -A(250)+A(251)+A(252)+A(301)-A(302)-A(329)+A(330)+A(331)-A(332)
  Vdot(432) = A(46)-A(53)-A(127)-A(144)-A(197)
  Vdot(433) = A(21)-A(25)+A(55)+A(177)-A(195)-A(267)+A(268)
  Vdot(434) = A(44)-A(96)-A(97)-A(98)+0.75*A(100)+A(125)+A(182)+A(231)
  Vdot(435) = -A(253)-A(256)-A(258)+A(335)-A(336)
  Vdot(436) = A(54)+A(55)-A(56)+A(80)-A(85)+0.17*A(98)+0.7*A(102)+0.63*A(103)+A(110)+A(126)+A(143)+A(198)+A(199)+A(205)&
                &+A(230)+A(232)
  Vdot(437) = A(118)-A(120)+A(125)+A(126)+A(127)+A(129)+A(130)+0.5*A(131)-A(273)+A(274)
  Vdot(438) = -A(139)+A(141)-A(142)-A(218)-A(287)-A(288)-A(292)
  Vdot(439) = -A(247)+A(248)+A(249)+A(299)-A(300)-A(327)+A(328)-A(331)+A(332)
  Vdot(440) = A(8)-A(10)-A(118)-A(189)-A(262)+A(263)
  Vdot(441) = A(69)-A(70)-A(71)-A(72)-A(73)-A(74)-A(75)+A(76)-A(93)+A(94)+0.667*A(206)
  Vdot(442) = A(122)-A(123)-A(124)-A(212)-A(213)-A(278)-A(279)-A(291)
  Vdot(443) = -A(235)+A(236)+A(271)-A(272)+A(279)-A(325)+A(326)
  Vdot(444) = A(239)+A(240)-A(241)+A(289)-A(290)+A(291)+A(292)-A(319)+A(320)-A(321)+A(322)
  Vdot(445) = A(134)-A(138)+A(139)+A(149)-A(151)-A(214)-A(280)+A(281)
  Vdot(446) = A(1)-A(2)+A(13)-A(98)-A(100)-A(101)-A(102)+A(105)-A(108)+A(109)+2*A(186)+A(188)+A(190)+A(191)+A(209)&
                &+A(215)+A(226)
  Vdot(447) = A(242)+A(243)-A(245)+2*A(246)+A(247)-A(249)+A(250)-A(252)+A(295)-A(296)+A(298)
  Vdot(448) = -A(254)-A(255)-A(257)-A(259)+A(333)-A(334)-A(335)+A(336)
  Vdot(449) = 0.15*A(45)+A(48)+A(50)+A(51)-A(62)-A(63)-A(64)-A(65)-A(66)+A(67)+A(79)+0.044*A(97)-A(99)-A(100)+A(101)+0.5&
                &*A(131)+A(197)+A(200)+A(201)+0.333*A(202)
  Vdot(450) = -A(159)+1.62*A(161)-A(162)+A(164)+A(166)-A(167)-A(168)+A(169)+A(172)+A(174)+0.4*A(176)+0.8*A(178)-A(179)&
                &+0.2*A(180)+2*A(225)+A(226)+A(227)+A(228)+A(229)+2*A(230)+A(231)+A(232)+A(233)+A(234)
  Vdot(451) = A(112)-2*A(113)-2*A(114)-2*A(115)-2*A(116)+2*A(117)-A(119)-A(121)-A(122)+A(123)-A(128)+0.5*A(131)-A(152)&
                &-A(153)-A(154)-A(178)+A(209)+A(213)
  Vdot(452) = A(5)+A(7)-A(9)+A(10)-2*A(11)+2*A(12)+A(24)+A(25)+A(27)+A(28)+A(31)+A(33)+A(34)+A(38)+A(41)+A(42)+A(44)&
                &+A(45)+A(47)+A(53)+A(54)+A(57)+A(60)+A(61)+A(68)+0.3*A(71)+A(76)+A(77)+A(78)-A(81)+A(82)+A(95)+0.47*A(103)&
                &+A(104)+A(120)+A(137)+A(146)+A(147)+A(148)+A(156)+A(157)+A(158)+A(164)
  Vdot(453) = 0.85*A(45)+A(47)+0.5*A(52)+0.4*A(53)-A(54)-A(55)+A(60)+A(61)+A(62)+A(64)+A(66)+A(68)-A(69)+A(70)+A(83)&
                &+A(84)+A(85)-A(87)+A(91)+2*A(92)+0.956*A(97)+0.83*A(98)+0.25*A(100)-A(102)-A(126)+A(127)+A(128)+A(129)&
                &+A(130)-A(143)+A(176)+A(177)+A(185)-A(198)-A(199)+A(204)
  Vdot(454) = A(15)-A(16)-A(17)+A(18)-A(23)+A(25)-A(50)-A(55)+A(60)-A(73)+A(84)+A(95)+A(124)+A(139)-A(168)-A(174)-A(175)&
                &-A(177)-A(191)-A(192)+A(193)+0.333*A(196)+0.333*A(202)+0.333*A(206)+A(212)+0.85*A(218)+A(229)
  Vdot(455) = -A(80)-A(81)-A(82)-A(83)-A(84)-A(85)-A(86)-A(87)-A(88)-A(89)-A(90)-A(91)-2*A(92)+0.37*A(103)+0.5*A(131)&
                &+A(145)-A(185)
  Vdot(456) = A(235)-A(236)+A(237)-A(238)-A(239)-A(240)+A(241)+A(243)-A(245)-A(246)+A(247)-A(248)-A(249)+A(250)-A(252)&
                &+A(254)+A(255)+A(257)+A(259)+A(297)+A(306)+A(307)-A(308)+A(309)-A(310)+A(311)-A(312)+A(313)-A(314)+A(315)&
                &-A(316)+A(317)-A(318)+A(333)-A(334)+A(335)-A(336)+A(337)-A(338)+A(339)-A(340)
  Vdot(457) = -A(4)-A(5)+A(6)-A(7)+2*A(9)-A(10)-A(19)+A(20)-A(21)+A(23)-A(24)-A(25)-A(27)-A(28)+A(30)+A(32)-A(38)-A(41)&
                &-A(42)-A(44)-A(45)-0.6*A(53)-A(54)-A(56)-A(57)-A(60)-A(61)-A(68)+0.2*A(71)-A(76)-A(78)-A(79)+A(80)-A(95)&
                &+0.25*A(100)+0.7*A(102)+0.16*A(103)-A(104)+A(107)-A(120)+A(127)-A(137)-A(138)-A(146)-A(147)-A(148)-A(156)&
                &-A(157)-A(158)-A(164)-A(165)-A(166)-A(181)+2*A(189)+A(194)+A(195)+0.333*A(196)+A(197)+A(203)+A(204)+A(205)&
                &+A(210)+A(216)+A(227)
  Vdot(458) = -A(112)+2*A(114)+A(115)-A(118)+A(120)+A(121)-A(124)-A(125)-A(126)-A(127)+A(128)-A(129)-A(130)-A(131)&
                &+A(149)+A(150)-A(151)+A(153)-A(155)+0.25*A(178)+2*A(207)+2*A(208)+A(210)+A(211)+A(212)+A(221)+A(222)+2&
                &*A(223)+A(224)+A(232)+A(233)
  Vdot(459) = A(132)-2*A(133)-2*A(134)-A(136)-A(140)-A(141)+A(142)-A(145)-A(152)-A(153)-A(154)-A(179)-A(180)-A(215)+0.15&
                &*A(218)
  Vdot(460) = A(235)-A(236)-A(240)+A(241)+A(247)-A(249)+A(256)+A(257)-A(277)-A(279)-A(292)+A(315)-A(316)-A(319)+A(320)&
                &-A(323)+A(324)-A(327)+A(328)+A(331)-A(332)
  Vdot(461) = A(237)-A(238)-A(239)+A(250)-A(252)+A(258)+A(259)-A(286)-A(288)-A(291)+A(317)-A(318)-A(321)+A(322)-A(325)&
                &+A(326)-A(329)+A(330)-A(331)+A(332)
  Vdot(462) = -A(132)+2*A(133)-A(135)+A(137)+A(138)-A(139)+A(140)-A(143)-A(144)+A(146)+3*A(147)+2*A(148)-A(149)-A(150)&
                &+A(151)+A(152)+A(153)+A(155)+A(156)+2*A(157)+A(158)+A(179)+A(180)+2*A(214)+A(215)+A(216)+A(217)+0.85*A(218)&
                &+2*A(219)+3*A(220)+A(221)+A(222)+A(223)+2*A(224)+A(234)
  Vdot(463) = -A(46)-A(47)-A(48)-A(49)-A(50)-A(51)-A(52)+0.6*A(53)-A(58)+A(59)-A(67)-A(79)-A(89)+A(96)+A(99)-A(101)&
                &-A(128)-A(131)+A(144)-A(145)-A(176)+0.667*A(202)-A(204)
  Vdot(464) = -A(242)-A(245)-A(246)-A(248)-A(251)+A(297)
  Vdot(465) = A(237)-A(238)-A(240)+A(241)-A(251)-A(258)-A(259)+A(284)-A(285)+A(287)
  Vdot(466) = A(2)-A(4)-A(6)-A(14)-A(15)-A(29)-A(36)-A(67)-A(91)-A(97)-A(99)-A(112)-A(132)-A(159)-A(183)-A(187)-A(188)&
                &-A(260)+A(261)
  Vdot(467) = A(159)-2*A(161)-A(163)+A(168)-A(169)-A(170)+A(171)+A(173)-A(175)-A(176)+A(177)-A(178)+A(179)-A(180)-A(226)&
                &-A(293)+A(294)
  Vdot(468) = -A(14)-A(16)-A(19)-A(20)-A(32)-A(33)+A(35)+A(38)+A(39)+A(40)+A(43)-A(48)-A(49)-A(65)-A(66)+A(68)-A(72)&
                &-A(83)+A(110)+A(111)-A(121)+A(130)-A(140)-A(169)-A(171)+A(190)+A(192)+A(194)+A(200)
  Vdot(469) = A(3)+A(4)-A(6)-A(7)-2*A(8)+A(10)-A(20)-A(22)-A(23)+A(26)-A(30)-A(31)+A(32)+A(43)+0.85*A(45)-A(46)-A(47)&
                &+A(54)+A(55)+A(57)+A(62)-A(69)+A(70)-0.8*A(71)+A(72)+A(73)+A(74)+A(78)+A(79)+A(80)-A(90)+A(102)+0.16*A(103)&
                &+A(118)-A(119)+A(126)+A(128)-A(135)-A(136)+A(143)-A(162)-A(163)+A(176)+A(181)-A(184)+0.667*A(196)+A(199)&
                &+A(203)+A(205)+0.333*A(206)+2*A(230)+2*A(232)
  Vdot(470) = A(235)-A(236)-A(239)-A(248)-A(256)-A(257)+A(275)-A(276)+A(278)
  Vdot(471) = A(14)-A(15)+2*A(16)-A(17)+A(18)+A(20)-A(21)-A(22)+A(23)+A(24)+A(26)+A(27)-A(34)-A(35)-A(40)+A(48)+A(50)&
                &-A(58)+A(59)+A(61)-A(63)-A(64)+A(72)+A(73)+A(83)-A(84)-A(93)+A(94)+A(121)-A(122)+A(123)+A(129)+A(140)&
                &-A(141)+A(142)-A(167)+A(168)+A(169)-A(170)+A(171)+A(172)+A(173)+A(175)-A(190)+A(191)+A(193)+A(195)+0.667&
                &*A(196)+A(201)+0.667*A(202)+0.667*A(206)+A(211)+A(213)+A(217)+0.15*A(218)+A(228)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun_SPLIT - time derivatives of variables - Split form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      P_VAR     - Production term
!      D_VAR     - Destruction term
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun_SPLIT ( V, F, RCT, P_VAR, D_VAR )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! P_VAR - Production term
  REAL(kind=dp) :: P_VAR(NVAR)
! D_VAR - Destruction term
  REAL(kind=dp) :: D_VAR(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(414)*F(1)
  A(2) = RCT(2)*V(446)*F(1)
  A(3) = RCT(3)*V(386)*F(1)
  A(4) = RCT(4)*V(457)*V(466)
  A(5) = RCT(5)*V(395)*V(457)
  A(6) = RCT(6)*V(466)*V(469)
  A(7) = RCT(7)*V(457)*V(469)
  A(8) = RCT(8)*V(469)*V(469)
  A(9) = RCT(9)*V(414)*V(452)
  A(10) = 1.8e-12*V(440)*V(457)
  A(11) = RCT(11)*V(452)*V(452)
  A(12) = V(381)
  A(13) = RCT(13)*V(414)*F(2)
  A(14) = RCT(14)*V(466)*V(468)
  A(15) = RCT(15)*V(466)*V(471)
  A(16) = RCT(16)*V(454)*V(468)
  A(17) = RCT(17)*V(454)*V(471)
  A(18) = RCT(18)*V(423)
  A(19) = RCT(19)*V(457)*V(468)
  A(20) = RCT(20)*V(468)*V(469)
  A(21) = RCT(21)*V(457)*V(471)
  A(22) = RCT(22)*V(469)*V(471)
  A(23) = 3.5e-12*V(454)*V(469)
  A(24) = RCT(24)*V(409)*V(457)
  A(25) = RCT(25)*V(433)*V(457)
  A(26) = RCT(26)*V(403)
  A(27) = RCT(27)*V(403)*V(457)
  A(28) = RCT(28)*V(383)*V(457)
  A(29) = RCT(29)*V(426)*V(466)
  A(30) = RCT(30)*V(426)*V(469)
  A(31) = RCT(31)*V(426)*V(469)
  A(32) = RCT(32)*V(426)*V(468)
  A(33) = RCT(33)*V(426)*V(468)
  A(34) = RCT(34)*V(426)*V(471)
  A(35) = RCT(35)*V(426)*V(471)
  A(36) = 1.2e-14*V(396)*V(466)
  A(37) = 1300*V(396)
  A(38) = RCT(38)*V(424)*V(457)
  A(39) = RCT(39)*V(416)*V(424)
  A(40) = RCT(40)*V(424)*V(471)
  A(41) = 1.66e-12*V(416)*V(457)
  A(42) = RCT(42)*V(391)*V(457)
  A(43) = RCT(43)*V(424)*F(1)
  A(44) = RCT(44)*V(392)*V(457)
  A(45) = RCT(45)*V(408)*V(457)
  A(46) = RCT(46)*V(463)*V(469)
  A(47) = RCT(47)*V(463)*V(469)
  A(48) = RCT(48)*V(463)*V(468)
  A(49) = RCT(49)*V(463)*V(468)
  A(50) = 1.2e-12*V(454)*V(463)
  A(51) = RCT(51)*V(463)
  A(52) = RCT(52)*V(463)
  A(53) = RCT(53)*V(432)*V(457)
  A(54) = RCT(54)*V(453)*V(457)
  A(55) = RCT(55)*V(453)*V(454)
  A(56) = RCT(56)*V(436)*V(457)
  A(57) = RCT(57)*V(428)*V(457)
  A(58) = RCT(58)*V(463)*V(471)
  A(59) = RCT(59)*V(412)
  A(60) = 3e-14*V(412)*V(457)
  A(61) = RCT(61)*V(430)*V(457)
  A(62) = RCT(62)*V(449)
  A(63) = RCT(63)*V(449)*V(471)
  A(64) = RCT(64)*V(449)*V(471)
  A(65) = RCT(65)*V(449)*V(468)
  A(66) = RCT(66)*V(449)*V(468)
  A(67) = RCT(67)*V(463)*V(466)
  A(68) = RCT(68)*V(421)*V(457)
  A(69) = RCT(69)*V(453)*V(469)
  A(70) = RCT(70)*V(441)
  A(71) = RCT(71)*V(441)*V(469)
  A(72) = RCT(72)*V(441)*V(468)
  A(73) = 1.2e-12*V(441)*V(454)
  A(74) = RCT(74)*V(441)
  A(75) = RCT(75)*V(441)
  A(76) = RCT(76)*V(418)*V(457)
  A(77) = RCT(77)*V(418)*V(457)
  A(78) = RCT(78)*V(382)*V(457)
  A(79) = 1.4e-10*V(457)*V(463)
  A(80) = RCT(80)*V(455)
  A(81) = RCT(81)*V(452)*V(455)
  A(82) = 5.2e-12*V(381)*V(455)
  A(83) = 6e-14*V(455)*V(468)
  A(84) = RCT(84)*V(455)*V(471)
  A(85) = 3.6e-14*V(436)*V(455)
  A(86) = 1e-10*V(428)*V(455)
  A(87) = 1.7e-12*V(453)*V(455)
  A(88) = 5e-12*V(408)*V(455)
  A(89) = 5e-12*V(455)*V(463)
  A(90) = 5e-12*V(455)*V(469)
  A(91) = 1e-12*V(455)*V(466)
  A(92) = 6e-11*V(455)*V(455)
  A(93) = RCT(93)*V(441)*V(471)
  A(94) = RCT(94)*V(411)
  A(95) = RCT(95)*V(411)*V(457)
  A(96) = RCT(96)*V(434)*F(1)
  A(97) = RCT(97)*V(434)*V(466)
  A(98) = 1.3e-10*V(434)*V(446)
  A(99) = 2.53e-14*V(449)*V(466)
  A(100) = 2.5e-11*V(446)*V(449)
  A(101) = 4.3e-11*V(446)*V(463)
  A(102) = RCT(102)*V(446)*V(453)
  A(103) = RCT(103)*V(1)
  A(104) = RCT(104)*V(410)*V(457)
  A(105) = RCT(105)*V(410)*V(414)
  A(106) = RCT(106)*V(410)*V(414)
  A(107) = RCT(107)*V(410)*V(414)
  A(108) = RCT(108)*V(410)*V(446)
  A(109) = RCT(109)*V(384)*F(1)
  A(110) = RCT(110)*V(384)*F(1)
  A(111) = 7e-15*V(362)*F(1)
  A(112) = RCT(112)*V(458)*V(466)
  A(113) = RCT(113)*V(451)*V(451)
  A(114) = RCT(114)*V(451)*V(451)
  A(115) = RCT(115)*V(451)*V(451)
  A(116) = RCT(116)*V(451)*V(451)
  A(117) = RCT(117)*V(355)
  A(118) = RCT(118)*V(440)*V(458)
  A(119) = RCT(119)*V(451)*V(469)
  A(120) = RCT(120)*V(437)*V(457)
  A(121) = RCT(121)*V(451)*V(468)
  A(122) = RCT(122)*V(451)*V(471)
  A(123) = RCT(123)*V(442)
  A(124) = RCT(124)*V(442)*V(458)
  A(125) = RCT(125)*V(392)*V(458)
  A(126) = RCT(126)*V(453)*V(458)
  A(127) = 5.9e-11*V(432)*V(458)
  A(128) = RCT(128)*V(451)*V(463)
  A(129) = RCT(129)*V(430)*V(458)
  A(130) = 2.1e-12*V(421)*V(458)
  A(131) = 1.6e-10*V(458)*V(463)
  A(132) = RCT(132)*V(462)*V(466)
  A(133) = 2.7e-12*V(459)*V(459)
  A(134) = RCT(134)*V(459)*V(459)
  A(135) = RCT(135)*V(462)*V(469)
  A(136) = RCT(136)*V(459)*V(469)
  A(137) = RCT(137)*V(425)*V(457)
  A(138) = RCT(138)*V(445)*V(457)
  A(139) = 4.9e-11*V(438)*V(462)
  A(140) = RCT(140)*V(459)*V(468)
  A(141) = RCT(141)*V(459)*V(471)
  A(142) = RCT(142)*V(438)
  A(143) = RCT(143)*V(453)*V(462)
  A(144) = RCT(144)*V(432)*V(462)
  A(145) = RCT(145)*V(459)*V(463)
  A(146) = RCT(146)*V(357)*V(457)
  A(147) = RCT(147)*V(359)*V(457)
  A(148) = RCT(148)*V(358)*V(457)
  A(149) = 3.32e-15*V(427)*V(462)
  A(150) = 1.1e-15*V(417)*V(462)
  A(151) = RCT(151)*V(445)*V(458)
  A(152) = RCT(152)*V(451)*V(459)
  A(153) = RCT(153)*V(451)*V(459)
  A(154) = RCT(154)*V(451)*V(459)
  A(155) = 1.45e-11*V(427)*V(458)
  A(156) = RCT(156)*V(365)*V(457)
  A(157) = RCT(157)*V(366)*V(457)
  A(158) = RCT(158)*V(367)*V(457)
  A(159) = RCT(159)*V(450)*V(466)
  A(160) = 5e-11*V(413)*V(413)
  A(161) = RCT(161)*V(467)*V(467)
  A(162) = RCT(162)*V(450)*V(469)
  A(163) = RCT(163)*V(467)*V(469)
  A(164) = RCT(164)*V(401)*V(457)
  A(165) = RCT(165)*V(413)*V(457)
  A(166) = 2.1e-10*V(393)*V(457)
  A(167) = RCT(167)*V(450)*V(471)
  A(168) = 1e-10*V(450)*V(454)
  A(169) = RCT(169)*V(467)*V(468)
  A(170) = RCT(170)*V(467)*V(471)
  A(171) = RCT(171)*V(413)*V(468)
  A(172) = RCT(172)*V(368)
  A(173) = 0
  A(174) = 1.5e-12*V(393)*V(454)
  A(175) = 9e-12*V(454)*V(467)
  A(176) = 2e-12*V(463)*V(467)
  A(177) = 3.4e-17*V(380)*V(454)
  A(178) = RCT(178)*V(451)*V(467)
  A(179) = 1.2e-11*V(450)*V(459)
  A(180) = RCT(180)*V(459)*V(467)
  A(181) = RCT(181)*V(422)*V(457)
  A(182) = RCT(182)*V(369)
  A(183) = 3e-13*V(369)*V(466)
  A(184) = 5e-11*V(370)*V(469)
  A(185) = RCT(185)*V(422)*V(455)
  A(186) = RCT(186)*F(1)
  A(187) = RCT(187)*V(466)
  A(188) = RCT(188)*V(466)
  A(189) = RCT(189)*V(440)
  A(190) = RCT(190)*V(471)
  A(191) = RCT(191)*V(454)
  A(192) = RCT(192)*V(454)
  A(193) = RCT(193)*V(423)
  A(194) = RCT(194)*V(409)
  A(195) = RCT(195)*V(433)
  A(196) = RCT(196)*V(403)
  A(197) = RCT(197)*V(432)
  A(198) = RCT(198)*V(453)
  A(199) = RCT(199)*V(453)
  A(200) = RCT(200)*V(421)
  A(201) = RCT(201)*V(430)
  A(202) = RCT(202)*V(412)
  A(203) = RCT(203)*V(418)
  A(204) = RCT(204)*V(463)
  A(205) = RCT(205)*V(428)
  A(206) = RCT(206)*V(411)
  A(207) = RCT(207)*V(417)
  A(208) = RCT(208)*V(355)
  A(209) = RCT(209)*V(379)
  A(210) = RCT(210)*V(385)
  A(211) = RCT(211)*V(363)
  A(212) = RCT(212)*V(442)
  A(213) = RCT(213)*V(442)
  A(214) = RCT(214)*V(445)
  A(215) = RCT(215)*V(459)
  A(216) = RCT(216)*V(407)
  A(217) = RCT(217)*V(364)
  A(218) = RCT(218)*V(438)
  A(219) = RCT(219)*V(358)
  A(220) = RCT(220)*V(359)
  A(221) = RCT(221)*V(427)
  A(222) = RCT(222)*V(367)
  A(223) = RCT(223)*V(365)
  A(224) = RCT(224)*V(366)
  A(225) = RCT(225)*V(393)
  A(226) = RCT(226)*V(467)
  A(227) = RCT(227)*V(402)
  A(228) = RCT(228)*V(368)
  A(229) = RCT(229)*V(420)
  A(230) = RCT(230)*V(2)
  A(231) = RCT(231)*V(380)
  A(232) = RCT(232)*V(3)
  A(233) = RCT(233)*V(387)
  A(234) = RCT(234)*V(360)
  A(235) = RCT(235)*V(443)
  A(236) = RCT(236)*V(456)*V(460)*V(470)
  A(237) = RCT(237)*V(429)
  A(238) = RCT(238)*V(456)*V(461)*V(465)
  A(239) = RCT(239)*V(456)*V(461)*V(470)
  A(240) = RCT(240)*V(456)*V(460)*V(465)
  A(241) = RCT(241)*V(444)
  A(242) = RCT(242)*V(415)*V(464)
  A(243) = RCT(243)*V(373)*V(373)
  A(244) = RCT(244)*V(399)*V(419)
  A(245) = RCT(245)*V(447)*V(456)*V(464)
  A(246) = RCT(246)*V(419)*V(456)*V(464)
  A(247) = RCT(247)*V(439)
  A(248) = RCT(248)*V(456)*V(464)*V(470)
  A(249) = RCT(249)*V(447)*V(456)*V(460)
  A(250) = RCT(250)*V(431)
  A(251) = RCT(251)*V(464)*V(465)
  A(252) = RCT(252)*V(447)*V(456)*V(461)
  A(253) = RCT(253)*V(415)*V(435)
  A(254) = RCT(254)*V(415)*V(448)
  A(255) = RCT(255)*V(399)*V(448)
  A(256) = RCT(256)*V(435)*V(470)
  A(257) = RCT(257)*V(448)*V(470)
  A(258) = RCT(258)*V(435)*V(465)
  A(259) = RCT(259)*V(448)*V(465)
  A(260) = RCT(260)*V(466)
  A(261) = RCT(261)*V(415)
  A(262) = RCT(262)*V(440)
  A(263) = RCT(263)*V(399)
  A(264) = RCT(264)*V(383)
  A(265) = RCT(265)*V(375)
  A(266) = RCT(266)*V(423)
  A(267) = RCT(267)*V(433)
  A(268) = RCT(268)*V(404)
  A(269) = RCT(269)*F(3)
  A(270) = RCT(270)*V(371)
  A(271) = RCT(271)*V(417)
  A(272) = RCT(272)*V(443)
  A(273) = RCT(273)*V(437)
  A(274) = RCT(274)*V(388)
  A(275) = RCT(275)*V(385)
  A(276) = RCT(276)*V(470)
  A(277) = RCT(277)*V(423)*V(460)
  A(278) = RCT(278)*V(442)
  A(279) = RCT(279)*V(442)*V(460)
  A(280) = RCT(280)*V(445)
  A(281) = RCT(281)*V(429)
  A(282) = RCT(282)*V(425)
  A(283) = RCT(283)*V(389)
  A(284) = RCT(284)*V(407)
  A(285) = RCT(285)*V(465)
  A(286) = RCT(286)*V(423)*V(461)
  A(287) = RCT(287)*V(438)
  A(288) = RCT(288)*V(438)*V(461)
  A(289) = RCT(289)*V(427)
  A(290) = RCT(290)*V(444)
  A(291) = RCT(291)*V(442)*V(461)
  A(292) = RCT(292)*V(438)*V(460)
  A(293) = RCT(293)*V(467)
  A(294) = RCT(294)*V(373)
  A(295) = RCT(295)*V(402)
  A(296) = RCT(296)*V(447)
  A(297) = RCT(297)*V(401)
  A(298) = RCT(298)*V(420)
  A(299) = RCT(299)*V(387)
  A(300) = RCT(300)*V(439)
  A(301) = RCT(301)*V(360)
  A(302) = RCT(302)*V(431)
  A(303) = RCT(303)*V(422)
  A(304) = RCT(304)*V(390)
  A(305) = RCT(305)*V(361)
  A(306) = RCT(306)*V(356)
  A(307) = RCT(307)*F(4)
  A(308) = RCT(308)*V(378)*V(456)
  A(309) = RCT(309)*V(374)
  A(310) = RCT(310)*V(375)*V(456)
  A(311) = RCT(311)*V(404)
  A(312) = RCT(312)*V(400)*V(456)
  A(313) = RCT(313)*V(371)
  A(314) = RCT(314)*V(372)*V(456)
  A(315) = RCT(315)*V(388)
  A(316) = RCT(316)*V(456)*V(460)
  A(317) = RCT(317)*V(389)
  A(318) = RCT(318)*V(456)*V(461)
  A(319) = RCT(319)*V(444)*V(460)
  A(320) = RCT(320)*V(405)
  A(321) = RCT(321)*V(444)*V(461)
  A(322) = RCT(322)*V(406)
  A(323) = RCT(323)*V(429)*V(460)
  A(324) = RCT(324)*V(406)
  A(325) = RCT(325)*V(443)*V(461)
  A(326) = RCT(326)*V(405)
  A(327) = RCT(327)*V(439)*V(460)
  A(328) = RCT(328)*V(376)
  A(329) = RCT(329)*V(431)*V(461)
  A(330) = RCT(330)*V(377)
  A(331) = RCT(331)*V(439)*V(461)
  A(332) = RCT(332)*V(431)*V(460)
  A(333) = RCT(333)*V(390)
  A(334) = RCT(334)*V(448)*V(456)
  A(335) = RCT(335)*V(448)
  A(336) = RCT(336)*V(435)*V(456)
  A(337) = RCT(337)*V(398)
  A(338) = RCT(338)*V(397)*V(456)
  A(339) = RCT(339)*V(394)
  A(340) = RCT(340)*V(398)*V(456)
  A(341) = 0

! Production function
  P_VAR(1) = 0
  P_VAR(2) = 0
  P_VAR(3) = 0
  P_VAR(4) = 0
  P_VAR(5) = A(34)
  P_VAR(6) = 2*A(87)+2*A(88)+2*A(89)+A(90)+A(146)+A(147)+A(148)+A(156)+A(157)+A(158)+A(219)+A(220)+A(222)+A(223)+A(224)
  P_VAR(7) = 2*A(156)+A(157)+A(158)
  P_VAR(8) = A(165)
  P_VAR(9) = A(160)
  P_VAR(10) = A(245)
  P_VAR(11) = A(244)
  P_VAR(12) = A(306)
  P_VAR(13) = A(341)
  P_VAR(14) = A(1)
  P_VAR(15) = A(2)
  P_VAR(16) = A(3)
  P_VAR(17) = A(4)
  P_VAR(18) = A(5)
  P_VAR(19) = A(6)
  P_VAR(20) = A(7)
  P_VAR(21) = A(8)
  P_VAR(22) = A(9)
  P_VAR(23) = A(10)
  P_VAR(24) = A(11)
  P_VAR(25) = A(12)
  P_VAR(26) = A(13)
  P_VAR(27) = A(14)
  P_VAR(28) = A(15)
  P_VAR(29) = A(16)
  P_VAR(30) = A(17)
  P_VAR(31) = A(18)
  P_VAR(32) = A(19)
  P_VAR(33) = A(20)
  P_VAR(34) = A(21)
  P_VAR(35) = A(22)
  P_VAR(36) = A(23)
  P_VAR(37) = A(24)
  P_VAR(38) = A(25)
  P_VAR(39) = A(26)
  P_VAR(40) = A(27)
  P_VAR(41) = A(28)
  P_VAR(42) = A(29)
  P_VAR(43) = A(30)
  P_VAR(44) = A(31)
  P_VAR(45) = A(32)
  P_VAR(46) = A(33)
  P_VAR(47) = A(34)
  P_VAR(48) = A(35)
  P_VAR(49) = A(36)
  P_VAR(50) = A(37)
  P_VAR(51) = A(38)
  P_VAR(52) = A(39)
  P_VAR(53) = A(40)
  P_VAR(54) = A(41)
  P_VAR(55) = A(42)
  P_VAR(56) = A(43)
  P_VAR(57) = A(44)
  P_VAR(58) = A(45)
  P_VAR(59) = A(46)
  P_VAR(60) = A(47)
  P_VAR(61) = A(48)
  P_VAR(62) = A(49)
  P_VAR(63) = A(50)
  P_VAR(64) = A(51)
  P_VAR(65) = A(52)
  P_VAR(66) = A(53)
  P_VAR(67) = A(54)
  P_VAR(68) = A(55)
  P_VAR(69) = A(56)
  P_VAR(70) = A(57)
  P_VAR(71) = A(58)
  P_VAR(72) = A(59)
  P_VAR(73) = A(60)
  P_VAR(74) = A(61)
  P_VAR(75) = A(62)
  P_VAR(76) = A(63)
  P_VAR(77) = A(64)
  P_VAR(78) = A(65)
  P_VAR(79) = A(66)
  P_VAR(80) = A(67)
  P_VAR(81) = A(68)
  P_VAR(82) = A(69)
  P_VAR(83) = A(70)
  P_VAR(84) = A(71)
  P_VAR(85) = A(72)
  P_VAR(86) = A(73)
  P_VAR(87) = A(74)
  P_VAR(88) = A(75)
  P_VAR(89) = A(76)
  P_VAR(90) = A(77)
  P_VAR(91) = A(78)
  P_VAR(92) = A(79)
  P_VAR(93) = A(80)
  P_VAR(94) = A(81)
  P_VAR(95) = A(82)
  P_VAR(96) = A(83)
  P_VAR(97) = A(84)
  P_VAR(98) = A(85)
  P_VAR(99) = A(86)
  P_VAR(100) = A(87)
  P_VAR(101) = A(88)
  P_VAR(102) = A(89)
  P_VAR(103) = A(90)
  P_VAR(104) = A(91)
  P_VAR(105) = A(92)
  P_VAR(106) = A(93)
  P_VAR(107) = A(94)
  P_VAR(108) = A(95)
  P_VAR(109) = A(96)
  P_VAR(110) = A(97)
  P_VAR(111) = A(98)
  P_VAR(112) = A(99)
  P_VAR(113) = A(100)
  P_VAR(114) = A(101)
  P_VAR(115) = A(102)
  P_VAR(116) = A(103)
  P_VAR(117) = A(104)
  P_VAR(118) = A(105)
  P_VAR(119) = A(106)
  P_VAR(120) = A(107)
  P_VAR(121) = A(108)
  P_VAR(122) = A(109)
  P_VAR(123) = A(110)
  P_VAR(124) = A(111)
  P_VAR(125) = A(112)
  P_VAR(126) = A(113)
  P_VAR(127) = A(114)
  P_VAR(128) = A(115)
  P_VAR(129) = A(116)
  P_VAR(130) = A(117)
  P_VAR(131) = A(118)
  P_VAR(132) = A(119)
  P_VAR(133) = A(120)
  P_VAR(134) = A(121)
  P_VAR(135) = A(122)
  P_VAR(136) = A(123)
  P_VAR(137) = A(124)
  P_VAR(138) = A(125)
  P_VAR(139) = A(126)
  P_VAR(140) = A(127)
  P_VAR(141) = A(128)
  P_VAR(142) = A(129)
  P_VAR(143) = A(130)
  P_VAR(144) = A(131)
  P_VAR(145) = A(132)
  P_VAR(146) = A(133)
  P_VAR(147) = A(134)
  P_VAR(148) = A(135)
  P_VAR(149) = A(136)
  P_VAR(150) = A(137)
  P_VAR(151) = A(138)
  P_VAR(152) = A(139)
  P_VAR(153) = A(140)
  P_VAR(154) = A(141)
  P_VAR(155) = A(142)
  P_VAR(156) = A(143)
  P_VAR(157) = A(144)
  P_VAR(158) = A(145)
  P_VAR(159) = A(146)
  P_VAR(160) = A(147)
  P_VAR(161) = A(148)
  P_VAR(162) = A(149)
  P_VAR(163) = A(150)
  P_VAR(164) = A(151)
  P_VAR(165) = A(152)
  P_VAR(166) = A(153)
  P_VAR(167) = A(154)
  P_VAR(168) = A(155)
  P_VAR(169) = A(156)
  P_VAR(170) = A(157)
  P_VAR(171) = A(158)
  P_VAR(172) = A(159)
  P_VAR(173) = A(160)
  P_VAR(174) = A(161)
  P_VAR(175) = A(162)
  P_VAR(176) = A(163)
  P_VAR(177) = A(164)
  P_VAR(178) = A(165)
  P_VAR(179) = A(166)
  P_VAR(180) = A(167)
  P_VAR(181) = A(168)
  P_VAR(182) = A(169)
  P_VAR(183) = A(170)
  P_VAR(184) = A(171)
  P_VAR(185) = A(172)
  P_VAR(186) = A(173)
  P_VAR(187) = A(174)
  P_VAR(188) = A(175)
  P_VAR(189) = A(176)
  P_VAR(190) = A(177)
  P_VAR(191) = A(178)
  P_VAR(192) = A(179)
  P_VAR(193) = A(180)
  P_VAR(194) = A(181)
  P_VAR(195) = A(182)
  P_VAR(196) = A(183)
  P_VAR(197) = A(184)
  P_VAR(198) = A(185)
  P_VAR(199) = A(186)
  P_VAR(200) = A(187)
  P_VAR(201) = A(188)
  P_VAR(202) = A(189)
  P_VAR(203) = A(190)
  P_VAR(204) = A(191)
  P_VAR(205) = A(192)
  P_VAR(206) = A(193)
  P_VAR(207) = A(194)
  P_VAR(208) = A(195)
  P_VAR(209) = A(196)
  P_VAR(210) = A(197)
  P_VAR(211) = A(198)
  P_VAR(212) = A(199)
  P_VAR(213) = A(200)
  P_VAR(214) = A(201)
  P_VAR(215) = A(202)
  P_VAR(216) = A(203)
  P_VAR(217) = A(204)
  P_VAR(218) = A(205)
  P_VAR(219) = A(206)
  P_VAR(220) = A(207)
  P_VAR(221) = A(208)
  P_VAR(222) = A(209)
  P_VAR(223) = A(210)
  P_VAR(224) = A(211)
  P_VAR(225) = A(212)
  P_VAR(226) = A(213)
  P_VAR(227) = A(214)
  P_VAR(228) = A(215)
  P_VAR(229) = A(216)
  P_VAR(230) = A(217)
  P_VAR(231) = A(218)
  P_VAR(232) = A(219)
  P_VAR(233) = A(220)
  P_VAR(234) = A(221)
  P_VAR(235) = A(222)
  P_VAR(236) = A(223)
  P_VAR(237) = A(224)
  P_VAR(238) = A(225)
  P_VAR(239) = A(226)
  P_VAR(240) = A(227)
  P_VAR(241) = A(228)
  P_VAR(242) = A(229)
  P_VAR(243) = A(230)
  P_VAR(244) = A(231)
  P_VAR(245) = A(232)
  P_VAR(246) = A(233)
  P_VAR(247) = A(234)
  P_VAR(248) = A(235)
  P_VAR(249) = A(236)
  P_VAR(250) = A(237)
  P_VAR(251) = A(238)
  P_VAR(252) = A(239)
  P_VAR(253) = A(240)
  P_VAR(254) = A(241)
  P_VAR(255) = A(242)
  P_VAR(256) = A(243)
  P_VAR(257) = A(244)
  P_VAR(258) = A(245)
  P_VAR(259) = A(246)
  P_VAR(260) = A(247)
  P_VAR(261) = A(248)
  P_VAR(262) = A(249)
  P_VAR(263) = A(250)
  P_VAR(264) = A(251)
  P_VAR(265) = A(252)
  P_VAR(266) = A(253)
  P_VAR(267) = A(254)
  P_VAR(268) = A(255)
  P_VAR(269) = A(256)
  P_VAR(270) = A(257)
  P_VAR(271) = A(258)
  P_VAR(272) = A(259)
  P_VAR(273) = A(260)
  P_VAR(274) = A(261)
  P_VAR(275) = A(262)
  P_VAR(276) = A(263)
  P_VAR(277) = A(264)
  P_VAR(278) = A(265)
  P_VAR(279) = A(266)
  P_VAR(280) = A(267)
  P_VAR(281) = A(268)
  P_VAR(282) = A(269)
  P_VAR(283) = A(270)
  P_VAR(284) = A(271)
  P_VAR(285) = A(272)
  P_VAR(286) = A(273)
  P_VAR(287) = A(274)
  P_VAR(288) = A(275)
  P_VAR(289) = A(276)
  P_VAR(290) = A(277)
  P_VAR(291) = A(278)
  P_VAR(292) = A(279)
  P_VAR(293) = A(280)
  P_VAR(294) = A(281)
  P_VAR(295) = A(282)
  P_VAR(296) = A(283)
  P_VAR(297) = A(284)
  P_VAR(298) = A(285)
  P_VAR(299) = A(286)
  P_VAR(300) = A(287)
  P_VAR(301) = A(288)
  P_VAR(302) = A(289)
  P_VAR(303) = A(290)
  P_VAR(304) = A(291)
  P_VAR(305) = A(292)
  P_VAR(306) = A(293)
  P_VAR(307) = A(294)
  P_VAR(308) = A(295)
  P_VAR(309) = A(296)
  P_VAR(310) = A(297)
  P_VAR(311) = A(298)
  P_VAR(312) = A(299)
  P_VAR(313) = A(300)
  P_VAR(314) = A(301)
  P_VAR(315) = A(302)
  P_VAR(316) = A(303)
  P_VAR(317) = A(304)
  P_VAR(318) = A(305)
  P_VAR(319) = A(306)
  P_VAR(320) = A(307)
  P_VAR(321) = A(308)
  P_VAR(322) = A(309)
  P_VAR(323) = A(310)
  P_VAR(324) = A(311)
  P_VAR(325) = A(312)
  P_VAR(326) = A(313)
  P_VAR(327) = A(314)
  P_VAR(328) = A(315)
  P_VAR(329) = A(316)
  P_VAR(330) = A(317)
  P_VAR(331) = A(318)
  P_VAR(332) = A(319)
  P_VAR(333) = A(320)
  P_VAR(334) = A(321)
  P_VAR(335) = A(322)
  P_VAR(336) = A(323)
  P_VAR(337) = A(324)
  P_VAR(338) = A(325)
  P_VAR(339) = A(326)
  P_VAR(340) = A(327)
  P_VAR(341) = A(328)
  P_VAR(342) = A(329)
  P_VAR(343) = A(330)
  P_VAR(344) = A(331)
  P_VAR(345) = A(332)
  P_VAR(346) = A(333)
  P_VAR(347) = A(334)
  P_VAR(348) = A(335)
  P_VAR(349) = A(336)
  P_VAR(350) = A(337)
  P_VAR(351) = A(338)
  P_VAR(352) = A(339)
  P_VAR(353) = A(340)
  P_VAR(354) = A(341)
  P_VAR(355) = A(116)
  P_VAR(356) = A(184)
  P_VAR(357) = 0
  P_VAR(358) = 0
  P_VAR(359) = 0
  P_VAR(360) = A(302)
  P_VAR(361) = A(181)+A(185)
  P_VAR(362) = A(106)+A(108)+A(109)
  P_VAR(363) = A(277)
  P_VAR(364) = A(286)
  P_VAR(365) = 0
  P_VAR(366) = 0
  P_VAR(367) = 0
  P_VAR(368) = A(167)
  P_VAR(369) = 0
  P_VAR(370) = A(183)
  P_VAR(371) = A(269)+A(314)
  P_VAR(372) = A(313)
  P_VAR(373) = A(293)
  P_VAR(374) = A(310)
  P_VAR(375) = A(264)+A(309)
  P_VAR(376) = A(327)
  P_VAR(377) = A(329)
  P_VAR(378) = A(242)+A(246)+A(251)+A(307)
  P_VAR(379) = A(115)+A(152)+0.55*A(178)
  P_VAR(380) = 0
  P_VAR(381) = A(11)
  P_VAR(382) = 0.5*A(75)
  P_VAR(383) = A(265)
  P_VAR(384) = A(104)+A(107)
  P_VAR(385) = A(119)+A(276)
  P_VAR(386) = A(5)+A(56)+0.956*A(97)+A(98)+0.3*A(102)+A(106)+A(108)+A(199)
  P_VAR(387) = 0.2*A(178)+A(300)
  P_VAR(388) = A(273)+A(316)
  P_VAR(389) = A(282)+A(318)
  P_VAR(390) = A(303)+A(334)
  P_VAR(391) = A(39)
  P_VAR(392) = 0
  P_VAR(393) = 0
  P_VAR(394) = A(305)+A(340)
  P_VAR(395) = 0.17*A(98)+A(198)
  P_VAR(396) = A(29)+A(30)+A(35)
  P_VAR(397) = A(253)+A(254)+A(255)+A(337)
  P_VAR(398) = A(256)+A(257)+A(258)+A(259)+A(338)+A(339)
  P_VAR(399) = A(262)
  P_VAR(400) = A(277)+A(279)+A(286)+A(288)+A(291)+A(292)+A(311)
  P_VAR(401) = A(162)
  P_VAR(402) = A(163)+A(166)+A(296)
  P_VAR(403) = A(22)
  P_VAR(404) = 2*A(266)+A(267)+A(278)+A(287)+A(298)+A(312)
  P_VAR(405) = A(319)+A(325)
  P_VAR(406) = A(321)+A(323)
  P_VAR(407) = A(136)+A(138)+A(145)+A(285)
  P_VAR(408) = 0.5*A(52)
  P_VAR(409) = A(19)+A(40)+A(64)
  P_VAR(410) = A(105)
  P_VAR(411) = A(93)
  P_VAR(412) = A(58)
  P_VAR(413) = 0.38*A(161)+A(175)+0.6*A(176)+0.8*A(180)
  P_VAR(414) = A(187)
  P_VAR(415) = A(260)
  P_VAR(416) = A(37)+A(42)
  P_VAR(417) = A(113)+A(124)+A(155)+A(272)
  P_VAR(418) = 0.5*A(71)+A(81)+A(82)
  P_VAR(419) = A(243)
  P_VAR(420) = A(170)+A(174)
  P_VAR(421) = A(65)
  P_VAR(422) = A(182)+A(304)
  P_VAR(423) = A(17)
  P_VAR(424) = A(31)+A(41)+A(66)
  P_VAR(425) = A(135)+A(143)+A(144)+A(283)
  P_VAR(426) = A(28)+A(36)
  P_VAR(427) = A(150)+A(151)+A(154)+A(290)
  P_VAR(428) = 0.5*A(71)+A(72)+A(73)+A(74)+0.5*A(75)+A(77)+A(78)+2*A(86)+A(95)+A(203)+0.333*A(206)
  P_VAR(429) = A(238)+A(280)+A(288)+A(324)
  P_VAR(430) = A(49)+A(63)
  P_VAR(431) = A(251)+A(252)+A(301)+A(330)+A(331)
  P_VAR(432) = A(46)
  P_VAR(433) = A(21)+A(55)+A(177)+A(268)
  P_VAR(434) = A(44)+0.75*A(100)+A(125)+A(182)+A(231)
  P_VAR(435) = A(335)
  P_VAR(436) = A(54)+A(55)+A(80)+0.17*A(98)+0.7*A(102)+0.63*A(103)+A(110)+A(126)+A(143)+A(198)+A(199)+A(205)+A(230)&
                 &+A(232)
  P_VAR(437) = A(118)+A(125)+A(126)+A(127)+A(129)+A(130)+0.5*A(131)+A(274)
  P_VAR(438) = A(141)
  P_VAR(439) = A(248)+A(249)+A(299)+A(328)+A(332)
  P_VAR(440) = A(8)+A(263)
  P_VAR(441) = A(69)+A(76)+A(94)+0.667*A(206)
  P_VAR(442) = A(122)
  P_VAR(443) = A(236)+A(271)+A(279)+A(326)
  P_VAR(444) = A(239)+A(240)+A(289)+A(291)+A(292)+A(320)+A(322)
  P_VAR(445) = A(134)+A(139)+A(149)+A(281)
  P_VAR(446) = A(1)+A(13)+A(105)+A(109)+2*A(186)+A(188)+A(190)+A(191)+A(209)+A(215)+A(226)
  P_VAR(447) = A(242)+A(243)+2*A(246)+A(247)+A(250)+A(295)+A(298)
  P_VAR(448) = A(333)+A(336)
  P_VAR(449) = 0.15*A(45)+A(48)+A(50)+A(51)+A(67)+A(79)+0.044*A(97)+A(101)+0.5*A(131)+A(197)+A(200)+A(201)+0.333*A(202)
  P_VAR(450) = 1.62*A(161)+A(164)+A(166)+A(169)+A(172)+A(174)+0.4*A(176)+0.8*A(178)+0.2*A(180)+2*A(225)+A(226)+A(227)&
                 &+A(228)+A(229)+2*A(230)+A(231)+A(232)+A(233)+A(234)
  P_VAR(451) = A(112)+2*A(117)+A(123)+0.5*A(131)+A(209)+A(213)
  P_VAR(452) = A(5)+A(7)+A(10)+2*A(12)+A(24)+A(25)+A(27)+A(28)+A(31)+A(33)+A(34)+A(38)+A(41)+A(42)+A(44)+A(45)+A(47)&
                 &+A(53)+A(54)+A(57)+A(60)+A(61)+A(68)+0.3*A(71)+A(76)+A(77)+A(78)+A(82)+A(95)+0.47*A(103)+A(104)+A(120)&
                 &+A(137)+A(146)+A(147)+A(148)+A(156)+A(157)+A(158)+A(164)
  P_VAR(453) = 0.85*A(45)+A(47)+0.5*A(52)+0.4*A(53)+A(60)+A(61)+A(62)+A(64)+A(66)+A(68)+A(70)+A(83)+A(84)+A(85)+A(91)+2&
                 &*A(92)+0.956*A(97)+0.83*A(98)+0.25*A(100)+A(127)+A(128)+A(129)+A(130)+A(176)+A(177)+A(185)+A(204)
  P_VAR(454) = A(15)+A(18)+A(25)+A(60)+A(84)+A(95)+A(124)+A(139)+A(193)+0.333*A(196)+0.333*A(202)+0.333*A(206)+A(212)&
                 &+0.85*A(218)+A(229)
  P_VAR(455) = 0.37*A(103)+0.5*A(131)+A(145)
  P_VAR(456) = A(235)+A(237)+A(241)+A(243)+A(247)+A(250)+A(254)+A(255)+A(257)+A(259)+A(297)+A(306)+A(307)+A(309)+A(311)&
                 &+A(313)+A(315)+A(317)+A(333)+A(335)+A(337)+A(339)
  P_VAR(457) = A(6)+2*A(9)+A(20)+A(23)+A(30)+A(32)+0.4*A(53)+0.2*A(71)+A(77)+A(80)+0.25*A(100)+0.7*A(102)+0.16*A(103)&
                 &+A(107)+A(127)+2*A(189)+A(194)+A(195)+0.333*A(196)+A(197)+A(203)+A(204)+A(205)+A(210)+A(216)+A(227)
  P_VAR(458) = 2*A(114)+A(115)+A(120)+A(121)+A(128)+A(149)+A(150)+A(153)+0.25*A(178)+2*A(207)+2*A(208)+A(210)+A(211)&
                 &+A(212)+A(221)+A(222)+2*A(223)+A(224)+A(232)+A(233)
  P_VAR(459) = A(132)+A(142)+0.15*A(218)
  P_VAR(460) = A(235)+A(241)+A(247)+A(256)+A(257)+A(315)+A(320)+A(324)+A(328)+A(331)
  P_VAR(461) = A(237)+A(250)+A(258)+A(259)+A(317)+A(322)+A(326)+A(330)+A(332)
  P_VAR(462) = 2*A(133)+A(137)+A(138)+A(140)+A(146)+3*A(147)+2*A(148)+A(151)+A(152)+A(153)+A(155)+A(156)+2*A(157)+A(158)&
                 &+A(179)+A(180)+2*A(214)+A(215)+A(216)+A(217)+0.85*A(218)+2*A(219)+3*A(220)+A(221)+A(222)+A(223)+2*A(224)&
                 &+A(234)
  P_VAR(463) = 0.6*A(53)+A(59)+A(96)+A(99)+A(144)+0.667*A(202)
  P_VAR(464) = A(297)
  P_VAR(465) = A(237)+A(241)+A(284)+A(287)
  P_VAR(466) = A(2)+A(261)
  P_VAR(467) = A(159)+A(168)+A(171)+A(173)+A(177)+A(179)+A(294)
  P_VAR(468) = A(35)+A(38)+A(39)+A(40)+A(43)+A(68)+A(110)+A(111)+A(130)+A(190)+A(192)+A(194)+A(200)
  P_VAR(469) = A(3)+A(4)+A(10)+A(26)+A(32)+A(43)+0.85*A(45)+A(54)+A(55)+A(57)+A(62)+A(70)+0.2*A(71)+A(72)+A(73)+A(74)&
                 &+A(78)+A(79)+A(80)+A(102)+0.16*A(103)+A(118)+A(126)+A(128)+A(143)+A(176)+A(181)+0.667*A(196)+A(199)+A(203)&
                 &+A(205)+0.333*A(206)+2*A(230)+2*A(232)
  P_VAR(470) = A(235)+A(275)+A(278)
  P_VAR(471) = A(14)+2*A(16)+A(18)+A(20)+A(23)+A(24)+A(26)+A(27)+A(48)+A(50)+A(59)+A(61)+A(72)+A(73)+A(83)+A(94)+A(121)&
                 &+A(123)+A(129)+A(140)+A(142)+A(168)+A(169)+A(171)+A(172)+A(173)+A(175)+A(191)+A(193)+A(195)+0.667*A(196)&
                 &+A(201)+0.667*A(202)+0.667*A(206)+A(211)+A(213)+A(217)+0.15*A(218)+A(228)

! Destruction function
  D_VAR(1) = RCT(103)
  D_VAR(2) = RCT(230)
  D_VAR(3) = RCT(232)
  D_VAR(4) = 0
  D_VAR(5) = 0
  D_VAR(6) = 0
  D_VAR(7) = 0
  D_VAR(8) = 0
  D_VAR(9) = 0
  D_VAR(10) = 0
  D_VAR(11) = 0
  D_VAR(12) = 0
  D_VAR(13) = 0
  D_VAR(14) = 0
  D_VAR(15) = 0
  D_VAR(16) = 0
  D_VAR(17) = 0
  D_VAR(18) = 0
  D_VAR(19) = 0
  D_VAR(20) = 0
  D_VAR(21) = 0
  D_VAR(22) = 0
  D_VAR(23) = 0
  D_VAR(24) = 0
  D_VAR(25) = 0
  D_VAR(26) = 0
  D_VAR(27) = 0
  D_VAR(28) = 0
  D_VAR(29) = 0
  D_VAR(30) = 0
  D_VAR(31) = 0
  D_VAR(32) = 0
  D_VAR(33) = 0
  D_VAR(34) = 0
  D_VAR(35) = 0
  D_VAR(36) = 0
  D_VAR(37) = 0
  D_VAR(38) = 0
  D_VAR(39) = 0
  D_VAR(40) = 0
  D_VAR(41) = 0
  D_VAR(42) = 0
  D_VAR(43) = 0
  D_VAR(44) = 0
  D_VAR(45) = 0
  D_VAR(46) = 0
  D_VAR(47) = 0
  D_VAR(48) = 0
  D_VAR(49) = 0
  D_VAR(50) = 0
  D_VAR(51) = 0
  D_VAR(52) = 0
  D_VAR(53) = 0
  D_VAR(54) = 0
  D_VAR(55) = 0
  D_VAR(56) = 0
  D_VAR(57) = 0
  D_VAR(58) = 0
  D_VAR(59) = 0
  D_VAR(60) = 0
  D_VAR(61) = 0
  D_VAR(62) = 0
  D_VAR(63) = 0
  D_VAR(64) = 0
  D_VAR(65) = 0
  D_VAR(66) = 0
  D_VAR(67) = 0
  D_VAR(68) = 0
  D_VAR(69) = 0
  D_VAR(70) = 0
  D_VAR(71) = 0
  D_VAR(72) = 0
  D_VAR(73) = 0
  D_VAR(74) = 0
  D_VAR(75) = 0
  D_VAR(76) = 0
  D_VAR(77) = 0
  D_VAR(78) = 0
  D_VAR(79) = 0
  D_VAR(80) = 0
  D_VAR(81) = 0
  D_VAR(82) = 0
  D_VAR(83) = 0
  D_VAR(84) = 0
  D_VAR(85) = 0
  D_VAR(86) = 0
  D_VAR(87) = 0
  D_VAR(88) = 0
  D_VAR(89) = 0
  D_VAR(90) = 0
  D_VAR(91) = 0
  D_VAR(92) = 0
  D_VAR(93) = 0
  D_VAR(94) = 0
  D_VAR(95) = 0
  D_VAR(96) = 0
  D_VAR(97) = 0
  D_VAR(98) = 0
  D_VAR(99) = 0
  D_VAR(100) = 0
  D_VAR(101) = 0
  D_VAR(102) = 0
  D_VAR(103) = 0
  D_VAR(104) = 0
  D_VAR(105) = 0
  D_VAR(106) = 0
  D_VAR(107) = 0
  D_VAR(108) = 0
  D_VAR(109) = 0
  D_VAR(110) = 0
  D_VAR(111) = 0
  D_VAR(112) = 0
  D_VAR(113) = 0
  D_VAR(114) = 0
  D_VAR(115) = 0
  D_VAR(116) = 0
  D_VAR(117) = 0
  D_VAR(118) = 0
  D_VAR(119) = 0
  D_VAR(120) = 0
  D_VAR(121) = 0
  D_VAR(122) = 0
  D_VAR(123) = 0
  D_VAR(124) = 0
  D_VAR(125) = 0
  D_VAR(126) = 0
  D_VAR(127) = 0
  D_VAR(128) = 0
  D_VAR(129) = 0
  D_VAR(130) = 0
  D_VAR(131) = 0
  D_VAR(132) = 0
  D_VAR(133) = 0
  D_VAR(134) = 0
  D_VAR(135) = 0
  D_VAR(136) = 0
  D_VAR(137) = 0
  D_VAR(138) = 0
  D_VAR(139) = 0
  D_VAR(140) = 0
  D_VAR(141) = 0
  D_VAR(142) = 0
  D_VAR(143) = 0
  D_VAR(144) = 0
  D_VAR(145) = 0
  D_VAR(146) = 0
  D_VAR(147) = 0
  D_VAR(148) = 0
  D_VAR(149) = 0
  D_VAR(150) = 0
  D_VAR(151) = 0
  D_VAR(152) = 0
  D_VAR(153) = 0
  D_VAR(154) = 0
  D_VAR(155) = 0
  D_VAR(156) = 0
  D_VAR(157) = 0
  D_VAR(158) = 0
  D_VAR(159) = 0
  D_VAR(160) = 0
  D_VAR(161) = 0
  D_VAR(162) = 0
  D_VAR(163) = 0
  D_VAR(164) = 0
  D_VAR(165) = 0
  D_VAR(166) = 0
  D_VAR(167) = 0
  D_VAR(168) = 0
  D_VAR(169) = 0
  D_VAR(170) = 0
  D_VAR(171) = 0
  D_VAR(172) = 0
  D_VAR(173) = 0
  D_VAR(174) = 0
  D_VAR(175) = 0
  D_VAR(176) = 0
  D_VAR(177) = 0
  D_VAR(178) = 0
  D_VAR(179) = 0
  D_VAR(180) = 0
  D_VAR(181) = 0
  D_VAR(182) = 0
  D_VAR(183) = 0
  D_VAR(184) = 0
  D_VAR(185) = 0
  D_VAR(186) = 0
  D_VAR(187) = 0
  D_VAR(188) = 0
  D_VAR(189) = 0
  D_VAR(190) = 0
  D_VAR(191) = 0
  D_VAR(192) = 0
  D_VAR(193) = 0
  D_VAR(194) = 0
  D_VAR(195) = 0
  D_VAR(196) = 0
  D_VAR(197) = 0
  D_VAR(198) = 0
  D_VAR(199) = 0
  D_VAR(200) = 0
  D_VAR(201) = 0
  D_VAR(202) = 0
  D_VAR(203) = 0
  D_VAR(204) = 0
  D_VAR(205) = 0
  D_VAR(206) = 0
  D_VAR(207) = 0
  D_VAR(208) = 0
  D_VAR(209) = 0
  D_VAR(210) = 0
  D_VAR(211) = 0
  D_VAR(212) = 0
  D_VAR(213) = 0
  D_VAR(214) = 0
  D_VAR(215) = 0
  D_VAR(216) = 0
  D_VAR(217) = 0
  D_VAR(218) = 0
  D_VAR(219) = 0
  D_VAR(220) = 0
  D_VAR(221) = 0
  D_VAR(222) = 0
  D_VAR(223) = 0
  D_VAR(224) = 0
  D_VAR(225) = 0
  D_VAR(226) = 0
  D_VAR(227) = 0
  D_VAR(228) = 0
  D_VAR(229) = 0
  D_VAR(230) = 0
  D_VAR(231) = 0
  D_VAR(232) = 0
  D_VAR(233) = 0
  D_VAR(234) = 0
  D_VAR(235) = 0
  D_VAR(236) = 0
  D_VAR(237) = 0
  D_VAR(238) = 0
  D_VAR(239) = 0
  D_VAR(240) = 0
  D_VAR(241) = 0
  D_VAR(242) = 0
  D_VAR(243) = 0
  D_VAR(244) = 0
  D_VAR(245) = 0
  D_VAR(246) = 0
  D_VAR(247) = 0
  D_VAR(248) = 0
  D_VAR(249) = 0
  D_VAR(250) = 0
  D_VAR(251) = 0
  D_VAR(252) = 0
  D_VAR(253) = 0
  D_VAR(254) = 0
  D_VAR(255) = 0
  D_VAR(256) = 0
  D_VAR(257) = 0
  D_VAR(258) = 0
  D_VAR(259) = 0
  D_VAR(260) = 0
  D_VAR(261) = 0
  D_VAR(262) = 0
  D_VAR(263) = 0
  D_VAR(264) = 0
  D_VAR(265) = 0
  D_VAR(266) = 0
  D_VAR(267) = 0
  D_VAR(268) = 0
  D_VAR(269) = 0
  D_VAR(270) = 0
  D_VAR(271) = 0
  D_VAR(272) = 0
  D_VAR(273) = 0
  D_VAR(274) = 0
  D_VAR(275) = 0
  D_VAR(276) = 0
  D_VAR(277) = 0
  D_VAR(278) = 0
  D_VAR(279) = 0
  D_VAR(280) = 0
  D_VAR(281) = 0
  D_VAR(282) = 0
  D_VAR(283) = 0
  D_VAR(284) = 0
  D_VAR(285) = 0
  D_VAR(286) = 0
  D_VAR(287) = 0
  D_VAR(288) = 0
  D_VAR(289) = 0
  D_VAR(290) = 0
  D_VAR(291) = 0
  D_VAR(292) = 0
  D_VAR(293) = 0
  D_VAR(294) = 0
  D_VAR(295) = 0
  D_VAR(296) = 0
  D_VAR(297) = 0
  D_VAR(298) = 0
  D_VAR(299) = 0
  D_VAR(300) = 0
  D_VAR(301) = 0
  D_VAR(302) = 0
  D_VAR(303) = 0
  D_VAR(304) = 0
  D_VAR(305) = 0
  D_VAR(306) = 0
  D_VAR(307) = 0
  D_VAR(308) = 0
  D_VAR(309) = 0
  D_VAR(310) = 0
  D_VAR(311) = 0
  D_VAR(312) = 0
  D_VAR(313) = 0
  D_VAR(314) = 0
  D_VAR(315) = 0
  D_VAR(316) = 0
  D_VAR(317) = 0
  D_VAR(318) = 0
  D_VAR(319) = 0
  D_VAR(320) = 0
  D_VAR(321) = 0
  D_VAR(322) = 0
  D_VAR(323) = 0
  D_VAR(324) = 0
  D_VAR(325) = 0
  D_VAR(326) = 0
  D_VAR(327) = 0
  D_VAR(328) = 0
  D_VAR(329) = 0
  D_VAR(330) = 0
  D_VAR(331) = 0
  D_VAR(332) = 0
  D_VAR(333) = 0
  D_VAR(334) = 0
  D_VAR(335) = 0
  D_VAR(336) = 0
  D_VAR(337) = 0
  D_VAR(338) = 0
  D_VAR(339) = 0
  D_VAR(340) = 0
  D_VAR(341) = 0
  D_VAR(342) = 0
  D_VAR(343) = 0
  D_VAR(344) = 0
  D_VAR(345) = 0
  D_VAR(346) = 0
  D_VAR(347) = 0
  D_VAR(348) = 0
  D_VAR(349) = 0
  D_VAR(350) = 0
  D_VAR(351) = 0
  D_VAR(352) = 0
  D_VAR(353) = 0
  D_VAR(354) = 0
  D_VAR(355) = RCT(117)+RCT(208)
  D_VAR(356) = RCT(306)
  D_VAR(357) = RCT(146)*V(457)
  D_VAR(358) = RCT(148)*V(457)+RCT(219)
  D_VAR(359) = RCT(147)*V(457)+RCT(220)
  D_VAR(360) = RCT(234)+RCT(301)
  D_VAR(361) = RCT(305)
  D_VAR(362) = 7e-15*F(1)
  D_VAR(363) = RCT(211)
  D_VAR(364) = RCT(217)
  D_VAR(365) = RCT(156)*V(457)+RCT(223)
  D_VAR(366) = RCT(157)*V(457)+RCT(224)
  D_VAR(367) = RCT(158)*V(457)+RCT(222)
  D_VAR(368) = RCT(172)+RCT(228)
  D_VAR(369) = RCT(182)+3e-13*V(466)
  D_VAR(370) = 5e-11*V(469)
  D_VAR(371) = RCT(270)+RCT(313)
  D_VAR(372) = RCT(314)*V(456)
  D_VAR(373) = RCT(243)*2*V(373)+RCT(294)
  D_VAR(374) = RCT(309)
  D_VAR(375) = RCT(265)+RCT(310)*V(456)
  D_VAR(376) = RCT(328)
  D_VAR(377) = RCT(330)
  D_VAR(378) = RCT(308)*V(456)
  D_VAR(379) = RCT(209)
  D_VAR(380) = 3.4e-17*V(454)+RCT(231)
  D_VAR(381) = 1+5.2e-12*V(455)
  D_VAR(382) = RCT(78)*V(457)
  D_VAR(383) = RCT(28)*V(457)+RCT(264)
  D_VAR(384) = RCT(109)*F(1)+RCT(110)*F(1)
  D_VAR(385) = RCT(210)+RCT(275)
  D_VAR(386) = RCT(3)*F(1)
  D_VAR(387) = RCT(233)+RCT(299)
  D_VAR(388) = RCT(274)+RCT(315)
  D_VAR(389) = RCT(283)+RCT(317)
  D_VAR(390) = RCT(304)+RCT(333)
  D_VAR(391) = RCT(42)*V(457)
  D_VAR(392) = RCT(44)*V(457)+RCT(125)*V(458)
  D_VAR(393) = 2.1e-10*V(457)+1.5e-12*V(454)+RCT(225)
  D_VAR(394) = RCT(339)
  D_VAR(395) = RCT(5)*V(457)
  D_VAR(396) = 1.2e-14*V(466)+1300
  D_VAR(397) = RCT(338)*V(456)
  D_VAR(398) = RCT(337)+RCT(340)*V(456)
  D_VAR(399) = RCT(244)*V(419)+RCT(255)*V(448)+RCT(263)
  D_VAR(400) = RCT(312)*V(456)
  D_VAR(401) = RCT(164)*V(457)+RCT(297)
  D_VAR(402) = RCT(227)+RCT(295)
  D_VAR(403) = RCT(26)+RCT(27)*V(457)+RCT(196)
  D_VAR(404) = RCT(268)+RCT(311)
  D_VAR(405) = RCT(320)+RCT(326)
  D_VAR(406) = RCT(322)+RCT(324)
  D_VAR(407) = RCT(216)+RCT(284)
  D_VAR(408) = RCT(45)*V(457)+5e-12*V(455)
  D_VAR(409) = RCT(24)*V(457)+RCT(194)
  D_VAR(410) = RCT(104)*V(457)+RCT(105)*V(414)+RCT(106)*V(414)+RCT(107)*V(414)+RCT(108)*V(446)
  D_VAR(411) = RCT(94)+RCT(95)*V(457)+RCT(206)
  D_VAR(412) = RCT(59)+3e-14*V(457)+RCT(202)
  D_VAR(413) = 5e-11*2*V(413)+RCT(165)*V(457)+RCT(171)*V(468)
  D_VAR(414) = RCT(1)*F(1)+RCT(9)*V(452)+RCT(13)*F(2)+RCT(105)*V(410)+RCT(106)*V(410)+RCT(107)*V(410)
  D_VAR(415) = RCT(242)*V(464)+RCT(253)*V(435)+RCT(254)*V(448)+RCT(261)
  D_VAR(416) = RCT(39)*V(424)+1.66e-12*V(457)
  D_VAR(417) = 1.1e-15*V(462)+RCT(207)+RCT(271)
  D_VAR(418) = RCT(76)*V(457)+RCT(77)*V(457)+RCT(203)
  D_VAR(419) = RCT(244)*V(399)+RCT(246)*V(456)*V(464)
  D_VAR(420) = RCT(229)+RCT(298)
  D_VAR(421) = RCT(68)*V(457)+2.1e-12*V(458)+RCT(200)
  D_VAR(422) = RCT(181)*V(457)+RCT(185)*V(455)+RCT(303)
  D_VAR(423) = RCT(18)+RCT(193)+RCT(266)+RCT(277)*V(460)+RCT(286)*V(461)
  D_VAR(424) = RCT(38)*V(457)+RCT(39)*V(416)+RCT(40)*V(471)+RCT(43)*F(1)
  D_VAR(425) = RCT(137)*V(457)+RCT(282)
  D_VAR(426) = RCT(29)*V(466)+RCT(30)*V(469)+RCT(31)*V(469)+RCT(32)*V(468)+RCT(33)*V(468)+RCT(34)*V(471)+RCT(35)*V(471)
  D_VAR(427) = 3.32e-15*V(462)+1.45e-11*V(458)+RCT(221)+RCT(289)
  D_VAR(428) = RCT(57)*V(457)+1e-10*V(455)+RCT(205)
  D_VAR(429) = RCT(237)+RCT(281)+RCT(323)*V(460)
  D_VAR(430) = RCT(61)*V(457)+RCT(129)*V(458)+RCT(201)
  D_VAR(431) = RCT(250)+RCT(302)+RCT(329)*V(461)+RCT(332)*V(460)
  D_VAR(432) = RCT(53)*V(457)+5.9e-11*V(458)+RCT(144)*V(462)+RCT(197)
  D_VAR(433) = RCT(25)*V(457)+RCT(195)+RCT(267)
  D_VAR(434) = RCT(96)*F(1)+RCT(97)*V(466)+1.3e-10*V(446)
  D_VAR(435) = RCT(253)*V(415)+RCT(256)*V(470)+RCT(258)*V(465)+RCT(336)*V(456)
  D_VAR(436) = RCT(56)*V(457)+3.6e-14*V(455)
  D_VAR(437) = RCT(120)*V(457)+RCT(273)
  D_VAR(438) = 4.9e-11*V(462)+RCT(142)+RCT(218)+RCT(287)+RCT(288)*V(461)+RCT(292)*V(460)
  D_VAR(439) = RCT(247)+RCT(300)+RCT(327)*V(460)+RCT(331)*V(461)
  D_VAR(440) = 1.8e-12*V(457)+RCT(118)*V(458)+RCT(189)+RCT(262)
  D_VAR(441) = RCT(70)+RCT(71)*V(469)+RCT(72)*V(468)+1.2e-12*V(454)+RCT(74)+RCT(75)+RCT(93)*V(471)
  D_VAR(442) = RCT(123)+RCT(124)*V(458)+RCT(212)+RCT(213)+RCT(278)+RCT(279)*V(460)+RCT(291)*V(461)
  D_VAR(443) = RCT(235)+RCT(272)+RCT(325)*V(461)
  D_VAR(444) = RCT(241)+RCT(290)+RCT(319)*V(460)+RCT(321)*V(461)
  D_VAR(445) = RCT(138)*V(457)+RCT(151)*V(458)+RCT(214)+RCT(280)
  D_VAR(446) = RCT(2)*F(1)+1.3e-10*V(434)+2.5e-11*V(449)+4.3e-11*V(463)+RCT(102)*V(453)+RCT(108)*V(410)
  D_VAR(447) = RCT(245)*V(456)*V(464)+RCT(249)*V(456)*V(460)+RCT(252)*V(456)*V(461)+RCT(296)
  D_VAR(448) = RCT(254)*V(415)+RCT(255)*V(399)+RCT(257)*V(470)+RCT(259)*V(465)+RCT(334)*V(456)+RCT(335)
  D_VAR(449) = RCT(62)+RCT(63)*V(471)+RCT(64)*V(471)+RCT(65)*V(468)+RCT(66)*V(468)+2.53e-14*V(466)+2.5e-11*V(446)
  D_VAR(450) = RCT(159)*V(466)+RCT(162)*V(469)+RCT(167)*V(471)+1e-10*V(454)+1.2e-11*V(459)
  D_VAR(451) = RCT(113)*2*V(451)+RCT(114)*2*V(451)+RCT(115)*2*V(451)+RCT(116)*2*V(451)+RCT(119)*V(469)+RCT(121)*V(468)&
                 &+RCT(122)*V(471)+RCT(128)*V(463)+RCT(152)*V(459)+RCT(153)*V(459)+RCT(154)*V(459)+RCT(178)*V(467)
  D_VAR(452) = RCT(9)*V(414)+RCT(11)*2*V(452)+RCT(81)*V(455)
  D_VAR(453) = RCT(54)*V(457)+RCT(55)*V(454)+RCT(69)*V(469)+1.7e-12*V(455)+RCT(102)*V(446)+RCT(126)*V(458)+RCT(143)&
                 &*V(462)+RCT(198)+RCT(199)
  D_VAR(454) = RCT(16)*V(468)+RCT(17)*V(471)+3.5e-12*V(469)+1.2e-12*V(463)+RCT(55)*V(453)+1.2e-12*V(441)+1e-10*V(450)&
                 &+1.5e-12*V(393)+9e-12*V(467)+3.4e-17*V(380)+RCT(191)+RCT(192)
  D_VAR(455) = RCT(80)+RCT(81)*V(452)+5.2e-12*V(381)+6e-14*V(468)+RCT(84)*V(471)+3.6e-14*V(436)+1e-10*V(428)+1.7e-12&
                 &*V(453)+5e-12*V(408)+5e-12*V(463)+5e-12*V(469)+1e-12*V(466)+6e-11*2*V(455)+RCT(185)*V(422)
  D_VAR(456) = RCT(236)*V(460)*V(470)+RCT(238)*V(461)*V(465)+RCT(239)*V(461)*V(470)+RCT(240)*V(460)*V(465)+RCT(245)&
                 &*V(447)*V(464)+RCT(246)*V(419)*V(464)+RCT(248)*V(464)*V(470)+RCT(249)*V(447)*V(460)+RCT(252)*V(447)*V(461)&
                 &+RCT(308)*V(378)+RCT(310)*V(375)+RCT(312)*V(400)+RCT(314)*V(372)+RCT(316)*V(460)+RCT(318)*V(461)+RCT(334)&
                 &*V(448)+RCT(336)*V(435)+RCT(338)*V(397)+RCT(340)*V(398)
  D_VAR(457) = RCT(4)*V(466)+RCT(5)*V(395)+RCT(7)*V(469)+1.8e-12*V(440)+RCT(19)*V(468)+RCT(21)*V(471)+RCT(24)*V(409)&
                 &+RCT(25)*V(433)+RCT(27)*V(403)+RCT(28)*V(383)+RCT(38)*V(424)+1.66e-12*V(416)+RCT(42)*V(391)+RCT(44)*V(392)&
                 &+RCT(45)*V(408)+RCT(53)*V(432)+RCT(54)*V(453)+RCT(56)*V(436)+RCT(57)*V(428)+3e-14*V(412)+RCT(61)*V(430)&
                 &+RCT(68)*V(421)+RCT(76)*V(418)+RCT(77)*V(418)+RCT(78)*V(382)+1.4e-10*V(463)+RCT(95)*V(411)+RCT(104)*V(410)&
                 &+RCT(120)*V(437)+RCT(137)*V(425)+RCT(138)*V(445)+RCT(146)*V(357)+RCT(147)*V(359)+RCT(148)*V(358)+RCT(156)&
                 &*V(365)+RCT(157)*V(366)+RCT(158)*V(367)+RCT(164)*V(401)+RCT(165)*V(413)+2.1e-10*V(393)+RCT(181)*V(422)
  D_VAR(458) = RCT(112)*V(466)+RCT(118)*V(440)+RCT(124)*V(442)+RCT(125)*V(392)+RCT(126)*V(453)+5.9e-11*V(432)+RCT(129)&
                 &*V(430)+2.1e-12*V(421)+1.6e-10*V(463)+RCT(151)*V(445)+1.45e-11*V(427)
  D_VAR(459) = 2.7e-12*2*V(459)+RCT(134)*2*V(459)+RCT(136)*V(469)+RCT(140)*V(468)+RCT(141)*V(471)+RCT(145)*V(463)&
                 &+RCT(152)*V(451)+RCT(153)*V(451)+RCT(154)*V(451)+1.2e-11*V(450)+RCT(180)*V(467)+RCT(215)
  D_VAR(460) = RCT(236)*V(456)*V(470)+RCT(240)*V(456)*V(465)+RCT(249)*V(447)*V(456)+RCT(277)*V(423)+RCT(279)*V(442)&
                 &+RCT(292)*V(438)+RCT(316)*V(456)+RCT(319)*V(444)+RCT(323)*V(429)+RCT(327)*V(439)+RCT(332)*V(431)
  D_VAR(461) = RCT(238)*V(456)*V(465)+RCT(239)*V(456)*V(470)+RCT(252)*V(447)*V(456)+RCT(286)*V(423)+RCT(288)*V(438)&
                 &+RCT(291)*V(442)+RCT(318)*V(456)+RCT(321)*V(444)+RCT(325)*V(443)+RCT(329)*V(431)+RCT(331)*V(439)
  D_VAR(462) = RCT(132)*V(466)+RCT(135)*V(469)+4.9e-11*V(438)+RCT(143)*V(453)+RCT(144)*V(432)+3.32e-15*V(427)+1.1e-15&
                 &*V(417)
  D_VAR(463) = RCT(46)*V(469)+RCT(47)*V(469)+RCT(48)*V(468)+RCT(49)*V(468)+1.2e-12*V(454)+RCT(51)+RCT(52)+RCT(58)*V(471)&
                 &+RCT(67)*V(466)+1.4e-10*V(457)+5e-12*V(455)+4.3e-11*V(446)+RCT(128)*V(451)+1.6e-10*V(458)+RCT(145)*V(459)&
                 &+2e-12*V(467)+RCT(204)
  D_VAR(464) = RCT(242)*V(415)+RCT(245)*V(447)*V(456)+RCT(246)*V(419)*V(456)+RCT(248)*V(456)*V(470)+RCT(251)*V(465)
  D_VAR(465) = RCT(238)*V(456)*V(461)+RCT(240)*V(456)*V(460)+RCT(251)*V(464)+RCT(258)*V(435)+RCT(259)*V(448)+RCT(285)
  D_VAR(466) = RCT(4)*V(457)+RCT(6)*V(469)+RCT(14)*V(468)+RCT(15)*V(471)+RCT(29)*V(426)+1.2e-14*V(396)+RCT(67)*V(463)&
                 &+1e-12*V(455)+RCT(97)*V(434)+2.53e-14*V(449)+RCT(112)*V(458)+RCT(132)*V(462)+RCT(159)*V(450)+3e-13*V(369)&
                 &+RCT(187)+RCT(188)+RCT(260)
  D_VAR(467) = RCT(161)*2*V(467)+RCT(163)*V(469)+RCT(169)*V(468)+RCT(170)*V(471)+9e-12*V(454)+2e-12*V(463)+RCT(178)&
                 &*V(451)+RCT(180)*V(459)+RCT(226)+RCT(293)
  D_VAR(468) = RCT(14)*V(466)+RCT(16)*V(454)+RCT(19)*V(457)+RCT(20)*V(469)+RCT(32)*V(426)+RCT(33)*V(426)+RCT(48)*V(463)&
                 &+RCT(49)*V(463)+RCT(65)*V(449)+RCT(66)*V(449)+RCT(72)*V(441)+6e-14*V(455)+RCT(121)*V(451)+RCT(140)*V(459)&
                 &+RCT(169)*V(467)+RCT(171)*V(413)
  D_VAR(469) = RCT(6)*V(466)+RCT(7)*V(457)+RCT(8)*2*V(469)+RCT(20)*V(468)+RCT(22)*V(471)+3.5e-12*V(454)+RCT(30)*V(426)&
                 &+RCT(31)*V(426)+RCT(46)*V(463)+RCT(47)*V(463)+RCT(69)*V(453)+RCT(71)*V(441)+5e-12*V(455)+RCT(119)*V(451)&
                 &+RCT(135)*V(462)+RCT(136)*V(459)+RCT(162)*V(450)+RCT(163)*V(467)+5e-11*V(370)
  D_VAR(470) = RCT(236)*V(456)*V(460)+RCT(239)*V(456)*V(461)+RCT(248)*V(456)*V(464)+RCT(256)*V(435)+RCT(257)*V(448)&
                 &+RCT(276)
  D_VAR(471) = RCT(15)*V(466)+RCT(17)*V(454)+RCT(21)*V(457)+RCT(22)*V(469)+RCT(34)*V(426)+RCT(35)*V(426)+RCT(40)*V(424)&
                 &+RCT(58)*V(463)+RCT(63)*V(449)+RCT(64)*V(449)+RCT(84)*V(455)+RCT(93)*V(441)+RCT(122)*V(451)+RCT(141)&
                 &*V(459)+RCT(167)*V(450)+RCT(170)*V(467)+RCT(190)
      
END SUBROUTINE Fun_SPLIT

! End of Fun_SPLIT function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! CalcStoichNum - calculate stoichiometric numbers
!   Arguments :
!      StoichNum - Stoichiometric numbers
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE CalcStoichNum ( StoichNum )

! StoichNum - Stoichiometric numbers
  REAL(kind=dp) :: StoichNum(NVAR,NREACT)

  StoichNum(:,:) = 0.
  StoichNum(1,103) = -1
  StoichNum(2,230) = -1
  StoichNum(3,232) = -1
  StoichNum(4,341) = -1
  StoichNum(5,34) = 1
  StoichNum(6,87) = 2
  StoichNum(6,88) = 2
  StoichNum(6,89) = 2
  StoichNum(6,90) = 1
  StoichNum(6,146) = 1
  StoichNum(6,147) = 1
  StoichNum(6,148) = 1
  StoichNum(6,156) = 1
  StoichNum(6,157) = 1
  StoichNum(6,158) = 1
  StoichNum(6,219) = 1
  StoichNum(6,220) = 1
  StoichNum(6,222) = 1
  StoichNum(6,223) = 1
  StoichNum(6,224) = 1
  StoichNum(7,156) = 2
  StoichNum(7,157) = 1
  StoichNum(7,158) = 1
  StoichNum(8,165) = 1
  StoichNum(9,160) = 1
  StoichNum(10,245) = 1
  StoichNum(11,244) = 1
  StoichNum(12,306) = 1
  StoichNum(13,341) = 1
  StoichNum(14,1) = 1
  StoichNum(15,2) = 1
  StoichNum(16,3) = 1
  StoichNum(17,4) = 1
  StoichNum(18,5) = 1
  StoichNum(19,6) = 1
  StoichNum(20,7) = 1
  StoichNum(21,8) = 1
  StoichNum(22,9) = 1
  StoichNum(23,10) = 1
  StoichNum(24,11) = 1
  StoichNum(25,12) = 1
  StoichNum(26,13) = 1
  StoichNum(27,14) = 1
  StoichNum(28,15) = 1
  StoichNum(29,16) = 1
  StoichNum(30,17) = 1
  StoichNum(31,18) = 1
  StoichNum(32,19) = 1
  StoichNum(33,20) = 1
  StoichNum(34,21) = 1
  StoichNum(35,22) = 1
  StoichNum(36,23) = 1
  StoichNum(37,24) = 1
  StoichNum(38,25) = 1
  StoichNum(39,26) = 1
  StoichNum(40,27) = 1
  StoichNum(41,28) = 1
  StoichNum(42,29) = 1
  StoichNum(43,30) = 1
  StoichNum(44,31) = 1
  StoichNum(45,32) = 1
  StoichNum(46,33) = 1
  StoichNum(47,34) = 1
  StoichNum(48,35) = 1
  StoichNum(49,36) = 1
  StoichNum(50,37) = 1
  StoichNum(51,38) = 1
  StoichNum(52,39) = 1
  StoichNum(53,40) = 1
  StoichNum(54,41) = 1
  StoichNum(55,42) = 1
  StoichNum(56,43) = 1
  StoichNum(57,44) = 1
  StoichNum(58,45) = 1
  StoichNum(59,46) = 1
  StoichNum(60,47) = 1
  StoichNum(61,48) = 1
  StoichNum(62,49) = 1
  StoichNum(63,50) = 1
  StoichNum(64,51) = 1
  StoichNum(65,52) = 1
  StoichNum(66,53) = 1
  StoichNum(67,54) = 1
  StoichNum(68,55) = 1
  StoichNum(69,56) = 1
  StoichNum(70,57) = 1
  StoichNum(71,58) = 1
  StoichNum(72,59) = 1
  StoichNum(73,60) = 1
  StoichNum(74,61) = 1
  StoichNum(75,62) = 1
  StoichNum(76,63) = 1
  StoichNum(77,64) = 1
  StoichNum(78,65) = 1
  StoichNum(79,66) = 1
  StoichNum(80,67) = 1
  StoichNum(81,68) = 1
  StoichNum(82,69) = 1
  StoichNum(83,70) = 1
  StoichNum(84,71) = 1
  StoichNum(85,72) = 1
  StoichNum(86,73) = 1
  StoichNum(87,74) = 1
  StoichNum(88,75) = 1
  StoichNum(89,76) = 1
  StoichNum(90,77) = 1
  StoichNum(91,78) = 1
  StoichNum(92,79) = 1
  StoichNum(93,80) = 1
  StoichNum(94,81) = 1
  StoichNum(95,82) = 1
  StoichNum(96,83) = 1
  StoichNum(97,84) = 1
  StoichNum(98,85) = 1
  StoichNum(99,86) = 1
  StoichNum(100,87) = 1
  StoichNum(101,88) = 1
  StoichNum(102,89) = 1
  StoichNum(103,90) = 1
  StoichNum(104,91) = 1
  StoichNum(105,92) = 1
  StoichNum(106,93) = 1
  StoichNum(107,94) = 1
  StoichNum(108,95) = 1
  StoichNum(109,96) = 1
  StoichNum(110,97) = 1
  StoichNum(111,98) = 1
  StoichNum(112,99) = 1
  StoichNum(113,100) = 1
  StoichNum(114,101) = 1
  StoichNum(115,102) = 1
  StoichNum(116,103) = 1
  StoichNum(117,104) = 1
  StoichNum(118,105) = 1
  StoichNum(119,106) = 1
  StoichNum(120,107) = 1
  StoichNum(121,108) = 1
  StoichNum(122,109) = 1
  StoichNum(123,110) = 1
  StoichNum(124,111) = 1
  StoichNum(125,112) = 1
  StoichNum(126,113) = 1
  StoichNum(127,114) = 1
  StoichNum(128,115) = 1
  StoichNum(129,116) = 1
  StoichNum(130,117) = 1
  StoichNum(131,118) = 1
  StoichNum(132,119) = 1
  StoichNum(133,120) = 1
  StoichNum(134,121) = 1
  StoichNum(135,122) = 1
  StoichNum(136,123) = 1
  StoichNum(137,124) = 1
  StoichNum(138,125) = 1
  StoichNum(139,126) = 1
  StoichNum(140,127) = 1
  StoichNum(141,128) = 1
  StoichNum(142,129) = 1
  StoichNum(143,130) = 1
  StoichNum(144,131) = 1
  StoichNum(145,132) = 1
  StoichNum(146,133) = 1
  StoichNum(147,134) = 1
  StoichNum(148,135) = 1
  StoichNum(149,136) = 1
  StoichNum(150,137) = 1
  StoichNum(151,138) = 1
  StoichNum(152,139) = 1
  StoichNum(153,140) = 1
  StoichNum(154,141) = 1
  StoichNum(155,142) = 1
  StoichNum(156,143) = 1
  StoichNum(157,144) = 1
  StoichNum(158,145) = 1
  StoichNum(159,146) = 1
  StoichNum(160,147) = 1
  StoichNum(161,148) = 1
  StoichNum(162,149) = 1
  StoichNum(163,150) = 1
  StoichNum(164,151) = 1
  StoichNum(165,152) = 1
  StoichNum(166,153) = 1
  StoichNum(167,154) = 1
  StoichNum(168,155) = 1
  StoichNum(169,156) = 1
  StoichNum(170,157) = 1
  StoichNum(171,158) = 1
  StoichNum(172,159) = 1
  StoichNum(173,160) = 1
  StoichNum(174,161) = 1
  StoichNum(175,162) = 1
  StoichNum(176,163) = 1
  StoichNum(177,164) = 1
  StoichNum(178,165) = 1
  StoichNum(179,166) = 1
  StoichNum(180,167) = 1
  StoichNum(181,168) = 1
  StoichNum(182,169) = 1
  StoichNum(183,170) = 1
  StoichNum(184,171) = 1
  StoichNum(185,172) = 1
  StoichNum(186,173) = 1
  StoichNum(187,174) = 1
  StoichNum(188,175) = 1
  StoichNum(189,176) = 1
  StoichNum(190,177) = 1
  StoichNum(191,178) = 1
  StoichNum(192,179) = 1
  StoichNum(193,180) = 1
  StoichNum(194,181) = 1
  StoichNum(195,182) = 1
  StoichNum(196,183) = 1
  StoichNum(197,184) = 1
  StoichNum(198,185) = 1
  StoichNum(199,186) = 1
  StoichNum(200,187) = 1
  StoichNum(201,188) = 1
  StoichNum(202,189) = 1
  StoichNum(203,190) = 1
  StoichNum(204,191) = 1
  StoichNum(205,192) = 1
  StoichNum(206,193) = 1
  StoichNum(207,194) = 1
  StoichNum(208,195) = 1
  StoichNum(209,196) = 1
  StoichNum(210,197) = 1
  StoichNum(211,198) = 1
  StoichNum(212,199) = 1
  StoichNum(213,200) = 1
  StoichNum(214,201) = 1
  StoichNum(215,202) = 1
  StoichNum(216,203) = 1
  StoichNum(217,204) = 1
  StoichNum(218,205) = 1
  StoichNum(219,206) = 1
  StoichNum(220,207) = 1
  StoichNum(221,208) = 1
  StoichNum(222,209) = 1
  StoichNum(223,210) = 1
  StoichNum(224,211) = 1
  StoichNum(225,212) = 1
  StoichNum(226,213) = 1
  StoichNum(227,214) = 1
  StoichNum(228,215) = 1
  StoichNum(229,216) = 1
  StoichNum(230,217) = 1
  StoichNum(231,218) = 1
  StoichNum(232,219) = 1
  StoichNum(233,220) = 1
  StoichNum(234,221) = 1
  StoichNum(235,222) = 1
  StoichNum(236,223) = 1
  StoichNum(237,224) = 1
  StoichNum(238,225) = 1
  StoichNum(239,226) = 1
  StoichNum(240,227) = 1
  StoichNum(241,228) = 1
  StoichNum(242,229) = 1
  StoichNum(243,230) = 1
  StoichNum(244,231) = 1
  StoichNum(245,232) = 1
  StoichNum(246,233) = 1
  StoichNum(247,234) = 1
  StoichNum(248,235) = 1
  StoichNum(249,236) = 1
  StoichNum(250,237) = 1
  StoichNum(251,238) = 1
  StoichNum(252,239) = 1
  StoichNum(253,240) = 1
  StoichNum(254,241) = 1
  StoichNum(255,242) = 1
  StoichNum(256,243) = 1
  StoichNum(257,244) = 1
  StoichNum(258,245) = 1
  StoichNum(259,246) = 1
  StoichNum(260,247) = 1
  StoichNum(261,248) = 1
  StoichNum(262,249) = 1
  StoichNum(263,250) = 1
  StoichNum(264,251) = 1
  StoichNum(265,252) = 1
  StoichNum(266,253) = 1
  StoichNum(267,254) = 1
  StoichNum(268,255) = 1
  StoichNum(269,256) = 1
  StoichNum(270,257) = 1
  StoichNum(271,258) = 1
  StoichNum(272,259) = 1
  StoichNum(273,260) = 1
  StoichNum(274,261) = 1
  StoichNum(275,262) = 1
  StoichNum(276,263) = 1
  StoichNum(277,264) = 1
  StoichNum(278,265) = 1
  StoichNum(279,266) = 1
  StoichNum(280,267) = 1
  StoichNum(281,268) = 1
  StoichNum(282,269) = 1
  StoichNum(283,270) = 1
  StoichNum(284,271) = 1
  StoichNum(285,272) = 1
  StoichNum(286,273) = 1
  StoichNum(287,274) = 1
  StoichNum(288,275) = 1
  StoichNum(289,276) = 1
  StoichNum(290,277) = 1
  StoichNum(291,278) = 1
  StoichNum(292,279) = 1
  StoichNum(293,280) = 1
  StoichNum(294,281) = 1
  StoichNum(295,282) = 1
  StoichNum(296,283) = 1
  StoichNum(297,284) = 1
  StoichNum(298,285) = 1
  StoichNum(299,286) = 1
  StoichNum(300,287) = 1
  StoichNum(301,288) = 1
  StoichNum(302,289) = 1
  StoichNum(303,290) = 1
  StoichNum(304,291) = 1
  StoichNum(305,292) = 1
  StoichNum(306,293) = 1
  StoichNum(307,294) = 1
  StoichNum(308,295) = 1
  StoichNum(309,296) = 1
  StoichNum(310,297) = 1
  StoichNum(311,298) = 1
  StoichNum(312,299) = 1
  StoichNum(313,300) = 1
  StoichNum(314,301) = 1
  StoichNum(315,302) = 1
  StoichNum(316,303) = 1
  StoichNum(317,304) = 1
  StoichNum(318,305) = 1
  StoichNum(319,306) = 1
  StoichNum(320,307) = 1
  StoichNum(321,308) = 1
  StoichNum(322,309) = 1
  StoichNum(323,310) = 1
  StoichNum(324,311) = 1
  StoichNum(325,312) = 1
  StoichNum(326,313) = 1
  StoichNum(327,314) = 1
  StoichNum(328,315) = 1
  StoichNum(329,316) = 1
  StoichNum(330,317) = 1
  StoichNum(331,318) = 1
  StoichNum(332,319) = 1
  StoichNum(333,320) = 1
  StoichNum(334,321) = 1
  StoichNum(335,322) = 1
  StoichNum(336,323) = 1
  StoichNum(337,324) = 1
  StoichNum(338,325) = 1
  StoichNum(339,326) = 1
  StoichNum(340,327) = 1
  StoichNum(341,328) = 1
  StoichNum(342,329) = 1
  StoichNum(343,330) = 1
  StoichNum(344,331) = 1
  StoichNum(345,332) = 1
  StoichNum(346,333) = 1
  StoichNum(347,334) = 1
  StoichNum(348,335) = 1
  StoichNum(349,336) = 1
  StoichNum(350,337) = 1
  StoichNum(351,338) = 1
  StoichNum(352,339) = 1
  StoichNum(353,340) = 1
  StoichNum(354,341) = 1
  StoichNum(355,116) = 1
  StoichNum(355,117) = -1
  StoichNum(355,208) = -1
  StoichNum(356,184) = 1
  StoichNum(356,306) = -1
  StoichNum(357,146) = -1
  StoichNum(358,148) = -1
  StoichNum(358,219) = -1
  StoichNum(359,147) = -1
  StoichNum(359,220) = -1
  StoichNum(360,234) = -1
  StoichNum(360,301) = -1
  StoichNum(360,302) = 1
  StoichNum(361,181) = 1
  StoichNum(361,185) = 1
  StoichNum(361,305) = -1
  StoichNum(362,106) = 1
  StoichNum(362,108) = 1
  StoichNum(362,109) = 1
  StoichNum(362,111) = -1
  StoichNum(363,211) = -1
  StoichNum(363,277) = 1
  StoichNum(364,217) = -1
  StoichNum(364,286) = 1
  StoichNum(365,156) = -1
  StoichNum(365,223) = -1
  StoichNum(366,157) = -1
  StoichNum(366,224) = -1
  StoichNum(367,158) = -1
  StoichNum(367,222) = -1
  StoichNum(368,167) = 1
  StoichNum(368,172) = -1
  StoichNum(368,228) = -1
  StoichNum(369,182) = -1
  StoichNum(369,183) = -1
  StoichNum(370,183) = 1
  StoichNum(370,184) = -1
  StoichNum(371,269) = 1
  StoichNum(371,270) = -1
  StoichNum(371,313) = -1
  StoichNum(371,314) = 1
  StoichNum(372,313) = 1
  StoichNum(372,314) = -1
  StoichNum(373,243) = -2
  StoichNum(373,293) = 1
  StoichNum(373,294) = -1
  StoichNum(374,309) = -1
  StoichNum(374,310) = 1
  StoichNum(375,264) = 1
  StoichNum(375,265) = -1
  StoichNum(375,309) = 1
  StoichNum(375,310) = -1
  StoichNum(376,327) = 1
  StoichNum(376,328) = -1
  StoichNum(377,329) = 1
  StoichNum(377,330) = -1
  StoichNum(378,242) = 1
  StoichNum(378,246) = 1
  StoichNum(378,251) = 1
  StoichNum(378,307) = 1
  StoichNum(378,308) = -1
  StoichNum(379,115) = 1
  StoichNum(379,152) = 1
  StoichNum(379,178) = 0.55
  StoichNum(379,209) = -1
  StoichNum(380,177) = -1
  StoichNum(380,231) = -1
  StoichNum(381,11) = 1
  StoichNum(381,12) = -1
  StoichNum(381,82) = -1
  StoichNum(382,75) = 0.5
  StoichNum(382,78) = -1
  StoichNum(383,28) = -1
  StoichNum(383,264) = -1
  StoichNum(383,265) = 1
  StoichNum(384,104) = 1
  StoichNum(384,107) = 1
  StoichNum(384,109) = -1
  StoichNum(384,110) = -1
  StoichNum(385,119) = 1
  StoichNum(385,210) = -1
  StoichNum(385,275) = -1
  StoichNum(385,276) = 1
  StoichNum(386,3) = -1
  StoichNum(386,5) = 1
  StoichNum(386,56) = 1
  StoichNum(386,97) = 0.956
  StoichNum(386,98) = 1
  StoichNum(386,102) = 0.3
  StoichNum(386,106) = 1
  StoichNum(386,108) = 1
  StoichNum(386,199) = 1
  StoichNum(387,178) = 0.2
  StoichNum(387,233) = -1
  StoichNum(387,299) = -1
  StoichNum(387,300) = 1
  StoichNum(388,273) = 1
  StoichNum(388,274) = -1
  StoichNum(388,315) = -1
  StoichNum(388,316) = 1
  StoichNum(389,282) = 1
  StoichNum(389,283) = -1
  StoichNum(389,317) = -1
  StoichNum(389,318) = 1
  StoichNum(390,303) = 1
  StoichNum(390,304) = -1
  StoichNum(390,333) = -1
  StoichNum(390,334) = 1
  StoichNum(391,39) = 1
  StoichNum(391,42) = -1
  StoichNum(392,44) = -1
  StoichNum(392,125) = -1
  StoichNum(393,166) = -1
  StoichNum(393,174) = -1
  StoichNum(393,225) = -1
  StoichNum(394,305) = 1
  StoichNum(394,339) = -1
  StoichNum(394,340) = 1
  StoichNum(395,5) = -1
  StoichNum(395,98) = 0.17
  StoichNum(395,198) = 1
  StoichNum(396,29) = 1
  StoichNum(396,30) = 1
  StoichNum(396,35) = 1
  StoichNum(396,36) = -1
  StoichNum(396,37) = -1
  StoichNum(397,253) = 1
  StoichNum(397,254) = 1
  StoichNum(397,255) = 1
  StoichNum(397,337) = 1
  StoichNum(397,338) = -1
  StoichNum(398,256) = 1
  StoichNum(398,257) = 1
  StoichNum(398,258) = 1
  StoichNum(398,259) = 1
  StoichNum(398,337) = -1
  StoichNum(398,338) = 1
  StoichNum(398,339) = 1
  StoichNum(398,340) = -1
  StoichNum(399,244) = -1
  StoichNum(399,255) = -1
  StoichNum(399,262) = 1
  StoichNum(399,263) = -1
  StoichNum(400,277) = 1
  StoichNum(400,279) = 1
  StoichNum(400,286) = 1
  StoichNum(400,288) = 1
  StoichNum(400,291) = 1
  StoichNum(400,292) = 1
  StoichNum(400,311) = 1
  StoichNum(400,312) = -1
  StoichNum(401,162) = 1
  StoichNum(401,164) = -1
  StoichNum(401,297) = -1
  StoichNum(402,163) = 1
  StoichNum(402,166) = 1
  StoichNum(402,227) = -1
  StoichNum(402,295) = -1
  StoichNum(402,296) = 1
  StoichNum(403,22) = 1
  StoichNum(403,26) = -1
  StoichNum(403,27) = -1
  StoichNum(403,196) = -1
  StoichNum(404,266) = 2
  StoichNum(404,267) = 1
  StoichNum(404,268) = -1
  StoichNum(404,278) = 1
  StoichNum(404,287) = 1
  StoichNum(404,298) = 1
  StoichNum(404,311) = -1
  StoichNum(404,312) = 1
  StoichNum(405,319) = 1
  StoichNum(405,320) = -1
  StoichNum(405,325) = 1
  StoichNum(405,326) = -1
  StoichNum(406,321) = 1
  StoichNum(406,322) = -1
  StoichNum(406,323) = 1
  StoichNum(406,324) = -1
  StoichNum(407,136) = 1
  StoichNum(407,138) = 1
  StoichNum(407,145) = 1
  StoichNum(407,216) = -1
  StoichNum(407,284) = -1
  StoichNum(407,285) = 1
  StoichNum(408,45) = -1
  StoichNum(408,52) = 0.5
  StoichNum(408,88) = -1
  StoichNum(409,19) = 1
  StoichNum(409,24) = -1
  StoichNum(409,40) = 1
  StoichNum(409,64) = 1
  StoichNum(409,194) = -1
  StoichNum(410,104) = -1
  StoichNum(410,106) = -1
  StoichNum(410,107) = -1
  StoichNum(410,108) = -1
  StoichNum(411,93) = 1
  StoichNum(411,94) = -1
  StoichNum(411,95) = -1
  StoichNum(411,206) = -1
  StoichNum(412,58) = 1
  StoichNum(412,59) = -1
  StoichNum(412,60) = -1
  StoichNum(412,202) = -1
  StoichNum(413,160) = -2
  StoichNum(413,161) = 0.38
  StoichNum(413,165) = -1
  StoichNum(413,171) = -1
  StoichNum(413,175) = 1
  StoichNum(413,176) = 0.6
  StoichNum(413,180) = 0.8
  StoichNum(414,1) = -1
  StoichNum(414,9) = -1
  StoichNum(414,13) = -1
  StoichNum(414,105) = -1
  StoichNum(414,106) = -1
  StoichNum(414,107) = -1
  StoichNum(414,187) = 1
  StoichNum(415,242) = -1
  StoichNum(415,253) = -1
  StoichNum(415,254) = -1
  StoichNum(415,260) = 1
  StoichNum(415,261) = -1
  StoichNum(416,37) = 1
  StoichNum(416,39) = -1
  StoichNum(416,41) = -1
  StoichNum(416,42) = 1
  StoichNum(417,113) = 1
  StoichNum(417,124) = 1
  StoichNum(417,150) = -1
  StoichNum(417,155) = 1
  StoichNum(417,207) = -1
  StoichNum(417,271) = -1
  StoichNum(417,272) = 1
  StoichNum(418,71) = 0.5
  StoichNum(418,76) = -1
  StoichNum(418,77) = -1
  StoichNum(418,81) = 1
  StoichNum(418,82) = 1
  StoichNum(418,203) = -1
  StoichNum(419,243) = 1
  StoichNum(419,244) = -1
  StoichNum(419,246) = -1
  StoichNum(420,170) = 1
  StoichNum(420,173) = -1
  StoichNum(420,174) = 1
  StoichNum(420,229) = -1
  StoichNum(420,298) = -1
  StoichNum(421,65) = 1
  StoichNum(421,68) = -1
  StoichNum(421,130) = -1
  StoichNum(421,200) = -1
  StoichNum(422,181) = -1
  StoichNum(422,182) = 1
  StoichNum(422,185) = -1
  StoichNum(422,303) = -1
  StoichNum(422,304) = 1
  StoichNum(423,17) = 1
  StoichNum(423,18) = -1
  StoichNum(423,193) = -1
  StoichNum(423,266) = -1
  StoichNum(423,277) = -1
  StoichNum(423,286) = -1
  StoichNum(424,31) = 1
  StoichNum(424,38) = -1
  StoichNum(424,39) = -1
  StoichNum(424,40) = -1
  StoichNum(424,41) = 1
  StoichNum(424,43) = -1
  StoichNum(424,66) = 1
  StoichNum(425,135) = 1
  StoichNum(425,137) = -1
  StoichNum(425,143) = 1
  StoichNum(425,144) = 1
  StoichNum(425,282) = -1
  StoichNum(425,283) = 1
  StoichNum(426,28) = 1
  StoichNum(426,29) = -1
  StoichNum(426,30) = -1
  StoichNum(426,31) = -1
  StoichNum(426,32) = -1
  StoichNum(426,33) = -1
  StoichNum(426,34) = -1
  StoichNum(426,35) = -1
  StoichNum(426,36) = 1
  StoichNum(427,149) = -1
  StoichNum(427,150) = 1
  StoichNum(427,151) = 1
  StoichNum(427,154) = 1
  StoichNum(427,155) = -1
  StoichNum(427,221) = -1
  StoichNum(427,289) = -1
  StoichNum(427,290) = 1
  StoichNum(428,57) = -1
  StoichNum(428,71) = 0.5
  StoichNum(428,72) = 1
  StoichNum(428,73) = 1
  StoichNum(428,74) = 1
  StoichNum(428,75) = 0.5
  StoichNum(428,77) = 1
  StoichNum(428,78) = 1
  StoichNum(428,86) = 1
  StoichNum(428,95) = 1
  StoichNum(428,203) = 1
  StoichNum(428,205) = -1
  StoichNum(428,206) = 0.333
  StoichNum(429,237) = -1
  StoichNum(429,238) = 1
  StoichNum(429,280) = 1
  StoichNum(429,281) = -1
  StoichNum(429,288) = 1
  StoichNum(429,323) = -1
  StoichNum(429,324) = 1
  StoichNum(430,49) = 1
  StoichNum(430,61) = -1
  StoichNum(430,63) = 1
  StoichNum(430,129) = -1
  StoichNum(430,201) = -1
  StoichNum(431,250) = -1
  StoichNum(431,251) = 1
  StoichNum(431,252) = 1
  StoichNum(431,301) = 1
  StoichNum(431,302) = -1
  StoichNum(431,329) = -1
  StoichNum(431,330) = 1
  StoichNum(431,331) = 1
  StoichNum(431,332) = -1
  StoichNum(432,46) = 1
  StoichNum(432,53) = -1
  StoichNum(432,127) = -1
  StoichNum(432,144) = -1
  StoichNum(432,197) = -1
  StoichNum(433,21) = 1
  StoichNum(433,25) = -1
  StoichNum(433,55) = 1
  StoichNum(433,177) = 1
  StoichNum(433,195) = -1
  StoichNum(433,267) = -1
  StoichNum(433,268) = 1
  StoichNum(434,44) = 1
  StoichNum(434,96) = -1
  StoichNum(434,97) = -1
  StoichNum(434,98) = -1
  StoichNum(434,100) = 0.75
  StoichNum(434,125) = 1
  StoichNum(434,182) = 1
  StoichNum(434,231) = 1
  StoichNum(435,253) = -1
  StoichNum(435,256) = -1
  StoichNum(435,258) = -1
  StoichNum(435,335) = 1
  StoichNum(435,336) = -1
  StoichNum(436,54) = 1
  StoichNum(436,55) = 1
  StoichNum(436,56) = -1
  StoichNum(436,80) = 1
  StoichNum(436,85) = -1
  StoichNum(436,98) = 0.17
  StoichNum(436,102) = 0.7
  StoichNum(436,103) = 0.63
  StoichNum(436,110) = 1
  StoichNum(436,126) = 1
  StoichNum(436,143) = 1
  StoichNum(436,198) = 1
  StoichNum(436,199) = 1
  StoichNum(436,205) = 1
  StoichNum(436,230) = 1
  StoichNum(436,232) = 1
  StoichNum(437,118) = 1
  StoichNum(437,120) = -1
  StoichNum(437,125) = 1
  StoichNum(437,126) = 1
  StoichNum(437,127) = 1
  StoichNum(437,129) = 1
  StoichNum(437,130) = 1
  StoichNum(437,131) = 0.5
  StoichNum(437,273) = -1
  StoichNum(437,274) = 1
  StoichNum(438,139) = -1
  StoichNum(438,141) = 1
  StoichNum(438,142) = -1
  StoichNum(438,218) = -1
  StoichNum(438,287) = -1
  StoichNum(438,288) = -1
  StoichNum(438,292) = -1
  StoichNum(439,247) = -1
  StoichNum(439,248) = 1
  StoichNum(439,249) = 1
  StoichNum(439,299) = 1
  StoichNum(439,300) = -1
  StoichNum(439,327) = -1
  StoichNum(439,328) = 1
  StoichNum(439,331) = -1
  StoichNum(439,332) = 1
  StoichNum(440,8) = 1
  StoichNum(440,10) = -1
  StoichNum(440,118) = -1
  StoichNum(440,189) = -1
  StoichNum(440,262) = -1
  StoichNum(440,263) = 1
  StoichNum(441,69) = 1
  StoichNum(441,70) = -1
  StoichNum(441,71) = -1
  StoichNum(441,72) = -1
  StoichNum(441,73) = -1
  StoichNum(441,74) = -1
  StoichNum(441,75) = -1
  StoichNum(441,76) = 1
  StoichNum(441,93) = -1
  StoichNum(441,94) = 1
  StoichNum(441,206) = 0.667
  StoichNum(442,122) = 1
  StoichNum(442,123) = -1
  StoichNum(442,124) = -1
  StoichNum(442,212) = -1
  StoichNum(442,213) = -1
  StoichNum(442,278) = -1
  StoichNum(442,279) = -1
  StoichNum(442,291) = -1
  StoichNum(443,235) = -1
  StoichNum(443,236) = 1
  StoichNum(443,271) = 1
  StoichNum(443,272) = -1
  StoichNum(443,279) = 1
  StoichNum(443,325) = -1
  StoichNum(443,326) = 1
  StoichNum(444,239) = 1
  StoichNum(444,240) = 1
  StoichNum(444,241) = -1
  StoichNum(444,289) = 1
  StoichNum(444,290) = -1
  StoichNum(444,291) = 1
  StoichNum(444,292) = 1
  StoichNum(444,319) = -1
  StoichNum(444,320) = 1
  StoichNum(444,321) = -1
  StoichNum(444,322) = 1
  StoichNum(445,134) = 1
  StoichNum(445,138) = -1
  StoichNum(445,139) = 1
  StoichNum(445,149) = 1
  StoichNum(445,151) = -1
  StoichNum(445,214) = -1
  StoichNum(445,280) = -1
  StoichNum(445,281) = 1
  StoichNum(446,1) = 1
  StoichNum(446,2) = -1
  StoichNum(446,13) = 1
  StoichNum(446,98) = -1
  StoichNum(446,100) = -1
  StoichNum(446,101) = -1
  StoichNum(446,102) = -1
  StoichNum(446,105) = 1
  StoichNum(446,108) = -1
  StoichNum(446,109) = 1
  StoichNum(446,186) = 2
  StoichNum(446,188) = 1
  StoichNum(446,190) = 1
  StoichNum(446,191) = 1
  StoichNum(446,209) = 1
  StoichNum(446,215) = 1
  StoichNum(446,226) = 1
  StoichNum(447,242) = 1
  StoichNum(447,243) = 1
  StoichNum(447,245) = -1
  StoichNum(447,246) = 2
  StoichNum(447,247) = 1
  StoichNum(447,249) = -1
  StoichNum(447,250) = 1
  StoichNum(447,252) = -1
  StoichNum(447,295) = 1
  StoichNum(447,296) = -1
  StoichNum(447,298) = 1
  StoichNum(448,254) = -1
  StoichNum(448,255) = -1
  StoichNum(448,257) = -1
  StoichNum(448,259) = -1
  StoichNum(448,333) = 1
  StoichNum(448,334) = -1
  StoichNum(448,335) = -1
  StoichNum(448,336) = 1
  StoichNum(449,45) = 0.15
  StoichNum(449,48) = 1
  StoichNum(449,50) = 1
  StoichNum(449,51) = 1
  StoichNum(449,62) = -1
  StoichNum(449,63) = -1
  StoichNum(449,64) = -1
  StoichNum(449,65) = -1
  StoichNum(449,66) = -1
  StoichNum(449,67) = 1
  StoichNum(449,79) = 1
  StoichNum(449,97) = 0.044
  StoichNum(449,99) = -1
  StoichNum(449,100) = -1
  StoichNum(449,101) = 1
  StoichNum(449,131) = 0.5
  StoichNum(449,197) = 1
  StoichNum(449,200) = 1
  StoichNum(449,201) = 1
  StoichNum(449,202) = 0.333
  StoichNum(450,159) = -1
  StoichNum(450,161) = 1.62
  StoichNum(450,162) = -1
  StoichNum(450,164) = 1
  StoichNum(450,166) = 1
  StoichNum(450,167) = -1
  StoichNum(450,168) = -1
  StoichNum(450,169) = 1
  StoichNum(450,172) = 1
  StoichNum(450,174) = 1
  StoichNum(450,176) = 0.4
  StoichNum(450,178) = 0.8
  StoichNum(450,179) = -1
  StoichNum(450,180) = 0.2
  StoichNum(450,225) = 2
  StoichNum(450,226) = 1
  StoichNum(450,227) = 1
  StoichNum(450,228) = 1
  StoichNum(450,229) = 1
  StoichNum(450,230) = 2
  StoichNum(450,231) = 1
  StoichNum(450,232) = 1
  StoichNum(450,233) = 1
  StoichNum(450,234) = 1
  StoichNum(451,112) = 1
  StoichNum(451,113) = -2
  StoichNum(451,114) = -2
  StoichNum(451,115) = -2
  StoichNum(451,116) = -2
  StoichNum(451,117) = 2
  StoichNum(451,119) = -1
  StoichNum(451,121) = -1
  StoichNum(451,122) = -1
  StoichNum(451,123) = 1
  StoichNum(451,128) = -1
  StoichNum(451,131) = 0.5
  StoichNum(451,152) = -1
  StoichNum(451,153) = -1
  StoichNum(451,154) = -1
  StoichNum(451,178) = -1
  StoichNum(451,209) = 1
  StoichNum(451,213) = 1
  StoichNum(452,5) = 1
  StoichNum(452,7) = 1
  StoichNum(452,9) = -1
  StoichNum(452,10) = 1
  StoichNum(452,11) = -2
  StoichNum(452,12) = 2
  StoichNum(452,24) = 1
  StoichNum(452,25) = 1
  StoichNum(452,27) = 1
  StoichNum(452,28) = 1
  StoichNum(452,31) = 1
  StoichNum(452,33) = 1
  StoichNum(452,34) = 1
  StoichNum(452,38) = 1
  StoichNum(452,41) = 1
  StoichNum(452,42) = 1
  StoichNum(452,44) = 1
  StoichNum(452,45) = 1
  StoichNum(452,47) = 1
  StoichNum(452,53) = 1
  StoichNum(452,54) = 1
  StoichNum(452,57) = 1
  StoichNum(452,60) = 1
  StoichNum(452,61) = 1
  StoichNum(452,68) = 1
  StoichNum(452,71) = 0.3
  StoichNum(452,76) = 1
  StoichNum(452,77) = 1
  StoichNum(452,78) = 1
  StoichNum(452,81) = -1
  StoichNum(452,82) = 1
  StoichNum(452,95) = 1
  StoichNum(452,103) = 0.47
  StoichNum(452,104) = 1
  StoichNum(452,120) = 1
  StoichNum(452,137) = 1
  StoichNum(452,146) = 1
  StoichNum(452,147) = 1
  StoichNum(452,148) = 1
  StoichNum(452,156) = 1
  StoichNum(452,157) = 1
  StoichNum(452,158) = 1
  StoichNum(452,164) = 1
  StoichNum(453,45) = 0.85
  StoichNum(453,47) = 1
  StoichNum(453,52) = 0.5
  StoichNum(453,53) = 0.4
  StoichNum(453,54) = -1
  StoichNum(453,55) = -1
  StoichNum(453,60) = 1
  StoichNum(453,61) = 1
  StoichNum(453,62) = 1
  StoichNum(453,64) = 1
  StoichNum(453,66) = 1
  StoichNum(453,68) = 1
  StoichNum(453,69) = -1
  StoichNum(453,70) = 1
  StoichNum(453,83) = 1
  StoichNum(453,84) = 1
  StoichNum(453,85) = 1
  StoichNum(453,87) = -1
  StoichNum(453,91) = 1
  StoichNum(453,92) = 2
  StoichNum(453,97) = 0.956
  StoichNum(453,98) = 0.83
  StoichNum(453,100) = 0.25
  StoichNum(453,102) = -1
  StoichNum(453,126) = -1
  StoichNum(453,127) = 1
  StoichNum(453,128) = 1
  StoichNum(453,129) = 1
  StoichNum(453,130) = 1
  StoichNum(453,143) = -1
  StoichNum(453,176) = 1
  StoichNum(453,177) = 1
  StoichNum(453,185) = 1
  StoichNum(453,198) = -1
  StoichNum(453,199) = -1
  StoichNum(453,204) = 1
  StoichNum(454,15) = 1
  StoichNum(454,16) = -1
  StoichNum(454,17) = -1
  StoichNum(454,18) = 1
  StoichNum(454,23) = -1
  StoichNum(454,25) = 1
  StoichNum(454,50) = -1
  StoichNum(454,55) = -1
  StoichNum(454,60) = 1
  StoichNum(454,73) = -1
  StoichNum(454,84) = 1
  StoichNum(454,95) = 1
  StoichNum(454,124) = 1
  StoichNum(454,139) = 1
  StoichNum(454,168) = -1
  StoichNum(454,174) = -1
  StoichNum(454,175) = -1
  StoichNum(454,177) = -1
  StoichNum(454,191) = -1
  StoichNum(454,192) = -1
  StoichNum(454,193) = 1
  StoichNum(454,196) = 0.333
  StoichNum(454,202) = 0.333
  StoichNum(454,206) = 0.333
  StoichNum(454,212) = 1
  StoichNum(454,218) = 0.85
  StoichNum(454,229) = 1
  StoichNum(455,80) = -1
  StoichNum(455,81) = -1
  StoichNum(455,82) = -1
  StoichNum(455,83) = -1
  StoichNum(455,84) = -1
  StoichNum(455,85) = -1
  StoichNum(455,86) = -1
  StoichNum(455,87) = -1
  StoichNum(455,88) = -1
  StoichNum(455,89) = -1
  StoichNum(455,90) = -1
  StoichNum(455,91) = -1
  StoichNum(455,92) = -2
  StoichNum(455,103) = 0.37
  StoichNum(455,131) = 0.5
  StoichNum(455,145) = 1
  StoichNum(455,185) = -1
  StoichNum(456,235) = 1
  StoichNum(456,236) = -1
  StoichNum(456,237) = 1
  StoichNum(456,238) = -1
  StoichNum(456,239) = -1
  StoichNum(456,240) = -1
  StoichNum(456,241) = 1
  StoichNum(456,243) = 1
  StoichNum(456,245) = -1
  StoichNum(456,246) = -1
  StoichNum(456,247) = 1
  StoichNum(456,248) = -1
  StoichNum(456,249) = -1
  StoichNum(456,250) = 1
  StoichNum(456,252) = -1
  StoichNum(456,254) = 1
  StoichNum(456,255) = 1
  StoichNum(456,257) = 1
  StoichNum(456,259) = 1
  StoichNum(456,297) = 1
  StoichNum(456,306) = 1
  StoichNum(456,307) = 1
  StoichNum(456,308) = -1
  StoichNum(456,309) = 1
  StoichNum(456,310) = -1
  StoichNum(456,311) = 1
  StoichNum(456,312) = -1
  StoichNum(456,313) = 1
  StoichNum(456,314) = -1
  StoichNum(456,315) = 1
  StoichNum(456,316) = -1
  StoichNum(456,317) = 1
  StoichNum(456,318) = -1
  StoichNum(456,333) = 1
  StoichNum(456,334) = -1
  StoichNum(456,335) = 1
  StoichNum(456,336) = -1
  StoichNum(456,337) = 1
  StoichNum(456,338) = -1
  StoichNum(456,339) = 1
  StoichNum(456,340) = -1
  StoichNum(457,4) = -1
  StoichNum(457,5) = -1
  StoichNum(457,6) = 1
  StoichNum(457,7) = -1
  StoichNum(457,9) = 2
  StoichNum(457,10) = -1
  StoichNum(457,19) = -1
  StoichNum(457,20) = 1
  StoichNum(457,21) = -1
  StoichNum(457,23) = 1
  StoichNum(457,24) = -1
  StoichNum(457,25) = -1
  StoichNum(457,27) = -1
  StoichNum(457,28) = -1
  StoichNum(457,30) = 1
  StoichNum(457,32) = 1
  StoichNum(457,38) = -1
  StoichNum(457,41) = -1
  StoichNum(457,42) = -1
  StoichNum(457,44) = -1
  StoichNum(457,45) = -1
  StoichNum(457,53) = -0.6
  StoichNum(457,54) = -1
  StoichNum(457,56) = -1
  StoichNum(457,57) = -1
  StoichNum(457,60) = -1
  StoichNum(457,61) = -1
  StoichNum(457,68) = -1
  StoichNum(457,71) = 0.2
  StoichNum(457,76) = -1
  StoichNum(457,78) = -1
  StoichNum(457,79) = -1
  StoichNum(457,80) = 1
  StoichNum(457,95) = -1
  StoichNum(457,100) = 0.25
  StoichNum(457,102) = 0.7
  StoichNum(457,103) = 0.16
  StoichNum(457,104) = -1
  StoichNum(457,107) = 1
  StoichNum(457,120) = -1
  StoichNum(457,127) = 1
  StoichNum(457,137) = -1
  StoichNum(457,138) = -1
  StoichNum(457,146) = -1
  StoichNum(457,147) = -1
  StoichNum(457,148) = -1
  StoichNum(457,156) = -1
  StoichNum(457,157) = -1
  StoichNum(457,158) = -1
  StoichNum(457,164) = -1
  StoichNum(457,165) = -1
  StoichNum(457,166) = -1
  StoichNum(457,181) = -1
  StoichNum(457,189) = 2
  StoichNum(457,194) = 1
  StoichNum(457,195) = 1
  StoichNum(457,196) = 0.333
  StoichNum(457,197) = 1
  StoichNum(457,203) = 1
  StoichNum(457,204) = 1
  StoichNum(457,205) = 1
  StoichNum(457,210) = 1
  StoichNum(457,216) = 1
  StoichNum(457,227) = 1
  StoichNum(458,112) = -1
  StoichNum(458,114) = 2
  StoichNum(458,115) = 1
  StoichNum(458,118) = -1
  StoichNum(458,120) = 1
  StoichNum(458,121) = 1
  StoichNum(458,124) = -1
  StoichNum(458,125) = -1
  StoichNum(458,126) = -1
  StoichNum(458,127) = -1
  StoichNum(458,128) = 1
  StoichNum(458,129) = -1
  StoichNum(458,130) = -1
  StoichNum(458,131) = -1
  StoichNum(458,149) = 1
  StoichNum(458,150) = 1
  StoichNum(458,151) = -1
  StoichNum(458,153) = 1
  StoichNum(458,155) = -1
  StoichNum(458,178) = 0.25
  StoichNum(458,207) = 2
  StoichNum(458,208) = 2
  StoichNum(458,210) = 1
  StoichNum(458,211) = 1
  StoichNum(458,212) = 1
  StoichNum(458,221) = 1
  StoichNum(458,222) = 1
  StoichNum(458,223) = 2
  StoichNum(458,224) = 1
  StoichNum(458,232) = 1
  StoichNum(458,233) = 1
  StoichNum(459,132) = 1
  StoichNum(459,133) = -2
  StoichNum(459,134) = -2
  StoichNum(459,136) = -1
  StoichNum(459,140) = -1
  StoichNum(459,141) = -1
  StoichNum(459,142) = 1
  StoichNum(459,145) = -1
  StoichNum(459,152) = -1
  StoichNum(459,153) = -1
  StoichNum(459,154) = -1
  StoichNum(459,179) = -1
  StoichNum(459,180) = -1
  StoichNum(459,215) = -1
  StoichNum(459,218) = 0.15
  StoichNum(460,235) = 1
  StoichNum(460,236) = -1
  StoichNum(460,240) = -1
  StoichNum(460,241) = 1
  StoichNum(460,247) = 1
  StoichNum(460,249) = -1
  StoichNum(460,256) = 1
  StoichNum(460,257) = 1
  StoichNum(460,277) = -1
  StoichNum(460,279) = -1
  StoichNum(460,292) = -1
  StoichNum(460,315) = 1
  StoichNum(460,316) = -1
  StoichNum(460,319) = -1
  StoichNum(460,320) = 1
  StoichNum(460,323) = -1
  StoichNum(460,324) = 1
  StoichNum(460,327) = -1
  StoichNum(460,328) = 1
  StoichNum(460,331) = 1
  StoichNum(460,332) = -1
  StoichNum(461,237) = 1
  StoichNum(461,238) = -1
  StoichNum(461,239) = -1
  StoichNum(461,250) = 1
  StoichNum(461,252) = -1
  StoichNum(461,258) = 1
  StoichNum(461,259) = 1
  StoichNum(461,286) = -1
  StoichNum(461,288) = -1
  StoichNum(461,291) = -1
  StoichNum(461,317) = 1
  StoichNum(461,318) = -1
  StoichNum(461,321) = -1
  StoichNum(461,322) = 1
  StoichNum(461,325) = -1
  StoichNum(461,326) = 1
  StoichNum(461,329) = -1
  StoichNum(461,330) = 1
  StoichNum(461,331) = -1
  StoichNum(461,332) = 1
  StoichNum(462,132) = -1
  StoichNum(462,133) = 2
  StoichNum(462,135) = -1
  StoichNum(462,137) = 1
  StoichNum(462,138) = 1
  StoichNum(462,139) = -1
  StoichNum(462,140) = 1
  StoichNum(462,143) = -1
  StoichNum(462,144) = -1
  StoichNum(462,146) = 1
  StoichNum(462,147) = 3
  StoichNum(462,148) = 2
  StoichNum(462,149) = -1
  StoichNum(462,150) = -1
  StoichNum(462,151) = 1
  StoichNum(462,152) = 1
  StoichNum(462,153) = 1
  StoichNum(462,155) = 1
  StoichNum(462,156) = 1
  StoichNum(462,157) = 2
  StoichNum(462,158) = 1
  StoichNum(462,179) = 1
  StoichNum(462,180) = 1
  StoichNum(462,214) = 2
  StoichNum(462,215) = 1
  StoichNum(462,216) = 1
  StoichNum(462,217) = 1
  StoichNum(462,218) = 0.85
  StoichNum(462,219) = 2
  StoichNum(462,220) = 3
  StoichNum(462,221) = 1
  StoichNum(462,222) = 1
  StoichNum(462,223) = 1
  StoichNum(462,224) = 2
  StoichNum(462,234) = 1
  StoichNum(463,46) = -1
  StoichNum(463,47) = -1
  StoichNum(463,48) = -1
  StoichNum(463,49) = -1
  StoichNum(463,50) = -1
  StoichNum(463,51) = -1
  StoichNum(463,52) = -1
  StoichNum(463,53) = 0.6
  StoichNum(463,58) = -1
  StoichNum(463,59) = 1
  StoichNum(463,67) = -1
  StoichNum(463,79) = -1
  StoichNum(463,89) = -1
  StoichNum(463,96) = 1
  StoichNum(463,99) = 1
  StoichNum(463,101) = -1
  StoichNum(463,128) = -1
  StoichNum(463,131) = -1
  StoichNum(463,144) = 1
  StoichNum(463,145) = -1
  StoichNum(463,176) = -1
  StoichNum(463,202) = 0.667
  StoichNum(463,204) = -1
  StoichNum(464,242) = -1
  StoichNum(464,245) = -1
  StoichNum(464,246) = -1
  StoichNum(464,248) = -1
  StoichNum(464,251) = -1
  StoichNum(464,297) = 1
  StoichNum(465,237) = 1
  StoichNum(465,238) = -1
  StoichNum(465,240) = -1
  StoichNum(465,241) = 1
  StoichNum(465,251) = -1
  StoichNum(465,258) = -1
  StoichNum(465,259) = -1
  StoichNum(465,284) = 1
  StoichNum(465,285) = -1
  StoichNum(465,287) = 1
  StoichNum(466,2) = 1
  StoichNum(466,4) = -1
  StoichNum(466,6) = -1
  StoichNum(466,14) = -1
  StoichNum(466,15) = -1
  StoichNum(466,29) = -1
  StoichNum(466,36) = -1
  StoichNum(466,67) = -1
  StoichNum(466,91) = -1
  StoichNum(466,97) = -1
  StoichNum(466,99) = -1
  StoichNum(466,112) = -1
  StoichNum(466,132) = -1
  StoichNum(466,159) = -1
  StoichNum(466,183) = -1
  StoichNum(466,187) = -1
  StoichNum(466,188) = -1
  StoichNum(466,260) = -1
  StoichNum(466,261) = 1
  StoichNum(467,159) = 1
  StoichNum(467,161) = -2
  StoichNum(467,163) = -1
  StoichNum(467,168) = 1
  StoichNum(467,169) = -1
  StoichNum(467,170) = -1
  StoichNum(467,171) = 1
  StoichNum(467,173) = 1
  StoichNum(467,175) = -1
  StoichNum(467,176) = -1
  StoichNum(467,177) = 1
  StoichNum(467,178) = -1
  StoichNum(467,179) = 1
  StoichNum(467,180) = -1
  StoichNum(467,226) = -1
  StoichNum(467,293) = -1
  StoichNum(467,294) = 1
  StoichNum(468,14) = -1
  StoichNum(468,16) = -1
  StoichNum(468,19) = -1
  StoichNum(468,20) = -1
  StoichNum(468,32) = -1
  StoichNum(468,33) = -1
  StoichNum(468,35) = 1
  StoichNum(468,38) = 1
  StoichNum(468,39) = 1
  StoichNum(468,40) = 1
  StoichNum(468,43) = 1
  StoichNum(468,48) = -1
  StoichNum(468,49) = -1
  StoichNum(468,65) = -1
  StoichNum(468,66) = -1
  StoichNum(468,68) = 1
  StoichNum(468,72) = -1
  StoichNum(468,83) = -1
  StoichNum(468,110) = 1
  StoichNum(468,111) = 1
  StoichNum(468,121) = -1
  StoichNum(468,130) = 1
  StoichNum(468,140) = -1
  StoichNum(468,169) = -1
  StoichNum(468,171) = -1
  StoichNum(468,190) = 1
  StoichNum(468,192) = 1
  StoichNum(468,194) = 1
  StoichNum(468,200) = 1
  StoichNum(469,3) = 1
  StoichNum(469,4) = 1
  StoichNum(469,6) = -1
  StoichNum(469,7) = -1
  StoichNum(469,8) = -2
  StoichNum(469,10) = 1
  StoichNum(469,20) = -1
  StoichNum(469,22) = -1
  StoichNum(469,23) = -1
  StoichNum(469,26) = 1
  StoichNum(469,30) = -1
  StoichNum(469,31) = -1
  StoichNum(469,32) = 1
  StoichNum(469,43) = 1
  StoichNum(469,45) = 0.85
  StoichNum(469,46) = -1
  StoichNum(469,47) = -1
  StoichNum(469,54) = 1
  StoichNum(469,55) = 1
  StoichNum(469,57) = 1
  StoichNum(469,62) = 1
  StoichNum(469,69) = -1
  StoichNum(469,70) = 1
  StoichNum(469,71) = -0.8
  StoichNum(469,72) = 1
  StoichNum(469,73) = 1
  StoichNum(469,74) = 1
  StoichNum(469,78) = 1
  StoichNum(469,79) = 1
  StoichNum(469,80) = 1
  StoichNum(469,90) = -1
  StoichNum(469,102) = 1
  StoichNum(469,103) = 0.16
  StoichNum(469,118) = 1
  StoichNum(469,119) = -1
  StoichNum(469,126) = 1
  StoichNum(469,128) = 1
  StoichNum(469,135) = -1
  StoichNum(469,136) = -1
  StoichNum(469,143) = 1
  StoichNum(469,162) = -1
  StoichNum(469,163) = -1
  StoichNum(469,176) = 1
  StoichNum(469,181) = 1
  StoichNum(469,184) = -1
  StoichNum(469,196) = 0.667
  StoichNum(469,199) = 1
  StoichNum(469,203) = 1
  StoichNum(469,205) = 1
  StoichNum(469,206) = 0.333
  StoichNum(469,230) = 2
  StoichNum(469,232) = 2
  StoichNum(470,235) = 1
  StoichNum(470,236) = -1
  StoichNum(470,239) = -1
  StoichNum(470,248) = -1
  StoichNum(470,256) = -1
  StoichNum(470,257) = -1
  StoichNum(470,275) = 1
  StoichNum(470,276) = -1
  StoichNum(470,278) = 1
  StoichNum(471,14) = 1
  StoichNum(471,15) = -1
  StoichNum(471,16) = 2
  StoichNum(471,17) = -1
  StoichNum(471,18) = 1
  StoichNum(471,20) = 1
  StoichNum(471,21) = -1
  StoichNum(471,22) = -1
  StoichNum(471,23) = 1
  StoichNum(471,24) = 1
  StoichNum(471,26) = 1
  StoichNum(471,27) = 1
  StoichNum(471,34) = -1
  StoichNum(471,35) = -1
  StoichNum(471,40) = -1
  StoichNum(471,48) = 1
  StoichNum(471,50) = 1
  StoichNum(471,58) = -1
  StoichNum(471,59) = 1
  StoichNum(471,61) = 1
  StoichNum(471,63) = -1
  StoichNum(471,64) = -1
  StoichNum(471,72) = 1
  StoichNum(471,73) = 1
  StoichNum(471,83) = 1
  StoichNum(471,84) = -1
  StoichNum(471,93) = -1
  StoichNum(471,94) = 1
  StoichNum(471,121) = 1
  StoichNum(471,122) = -1
  StoichNum(471,123) = 1
  StoichNum(471,129) = 1
  StoichNum(471,140) = 1
  StoichNum(471,141) = -1
  StoichNum(471,142) = 1
  StoichNum(471,167) = -1
  StoichNum(471,168) = 1
  StoichNum(471,169) = 1
  StoichNum(471,170) = -1
  StoichNum(471,171) = 1
  StoichNum(471,172) = 1
  StoichNum(471,173) = 1
  StoichNum(471,175) = 1
  StoichNum(471,190) = -1
  StoichNum(471,191) = 1
  StoichNum(471,193) = 1
  StoichNum(471,195) = 1
  StoichNum(471,196) = 0.667
  StoichNum(471,201) = 1
  StoichNum(471,202) = 0.667
  StoichNum(471,206) = 0.667
  StoichNum(471,211) = 1
  StoichNum(471,213) = 1
  StoichNum(471,217) = 1
  StoichNum(471,218) = 0.15
  StoichNum(471,228) = 1
      
END SUBROUTINE CalcStoichNum

! End of CalcStoichNum function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE messy_mecca_kpp_Function

