#!/usr/bin/env python
# -*- coding: utf-8 -*- Time-stamp: <2020-11-14 17:47:34 caaba>*-

# mecca: define parameters for mecca plots
# Rolf Sander, 2017

##############################################################################

class mecca(object):
    """ Define MECCA species
    """

    @classmethod
    def set_modelruns(cls):
        modelruns = []
        #modelruns.append(['..',                       'latest run'])
        # for radjimt:
        #modelruns.append(['../output/radjimt-00', 'equator'])
        #modelruns.append(['../output/radjimt-50', '50 degree N'])
        # other:
        #modelruns.append(['../output/new',            'new'])
        #modelruns.append(['../output/old',            'old'])
        # volcano:
        modelruns.append(['../output/volcano-2020-11-14/10_90_0030_airX-10-3e+09-3e-07/', 'with HSC'])
        modelruns.append(['../output/volcano-2020-11-14/10_90_0030_no-10-3e+09-3e-07/', 'without HSC'])
        modelruns.append(['../output/volcano-2020-11-14/10_90_0030_reduced-10-3e+09-3e-07/', 'without HSC_reduced'])
        return modelruns
    
    @classmethod
    # v = verbosity starts at 1 = very important
    def set_species(cls, v=1):
        species = []
        if (v >= 4): species.append('em')
        # O
        if (v >= 2): species.append('O1D')
        if (v >= 4): species.append('O3P')
        if (v >= 3): species.append('O2')
        if (v >= 1): species.append('O3')
        if (v >= 4): species.append('Op')
        if (v >= 4): species.append('O2p')
        # H
        if (v >= 3): species.append('H')
        if (v >= 3): species.append('H2')
        if (v >= 1): species.append('OH')
        if (v >= 1): species.append('HO2')
        if (v >= 3): species.append('H2O')
        if (v >= 1): species.append('H2O2')
        # N
        if (v >= 4): species.append('N')
        if (v >= 3): species.append('N2')
        if (v >= 2): species.append('NH3')
        if (v >= 3): species.append('N2O')
        if (v >= 1): species.append('NO')
        if (v >= 1): species.append('NO2')
        if (v >= 1): species.append('NO3')
        if (v >= 1): species.append('N2O5')
        if (v >= 1): species.append('HONO')
        if (v >= 1): species.append('HNO3')
        if (v >= 2): species.append('HNO4')
        if (v >= 4): species.append('NH2')
        if (v >= 4): species.append('HNO')
        if (v >= 4): species.append('NHOH')
        if (v >= 4): species.append('NH2O')
        if (v >= 4): species.append('NH2OH')
        if (v >= 4): species.append('Np')
        if (v >= 4): species.append('N2p')
        if (v >= 4): species.append('NOp')
        # 1C
        if (v >= 2): species.append('CO')
        if (v >= 2): species.append('CO2')
        if (v >= 2): species.append('HCHO')
        if (v >= 2): species.append('HCOOH')
        if (v >= 4): species.append('CH2OO')
        if (v >= 4): species.append('CH2OOA')
        if (v >= 4): species.append('CH3')
        if (v >= 4): species.append('CH3O')
        if (v >= 2): species.append('CH3O2')
        if (v >= 4): species.append('HOCH2O2')
        if (v >= 2): species.append('CH4')
        if (v >= 2): species.append('CH3OH')
        if (v >= 2): species.append('CH3OOH')
        if (v >= 4): species.append('HOCH2OOH')
        if (v >= 3): species.append('HOCH2OH')
        # 1C (CHON)
        if (v >= 4): species.append('CH3ONO')
        if (v >= 4): species.append('CH3NO3')
        if (v >= 3): species.append('CH3O2NO2')
        if (v >= 3): species.append('HOCH2O2NO2')
        if (v >= 3): species.append('HCN')
        if (v >= 4): species.append('CN')
        if (v >= 4): species.append('NCO')
        # 1C (lumped)
        if (v >= 4): species.append('LCARBON')
        # 2C (CHO)
        if (v >= 4): species.append('HCOCO3')
        if (v >= 4): species.append('HCOCO3A')
        if (v >= 4): species.append('HCOCO')
        if (v >= 2): species.append('C2H2')
        if (v >= 4): species.append('CH2CO')
        if (v >= 2): species.append('GLYOX')
        if (v >= 4): species.append('HCOCO2H')
        if (v >= 4): species.append('CHOOCHO')
        if (v >= 4): species.append('HCOCO3H')
        if (v >= 4): species.append('CH3CO')
        if (v >= 4): species.append('HOCH2CO')
        if (v >= 4): species.append('HOCHCHO')
        if (v >= 4): species.append('HCOCH2O2')
        if (v >= 4): species.append('CH3CO3')
        if (v >= 4): species.append('HOCH2CO3')
        if (v >= 4): species.append('HOOCH2CO3')
        if (v >= 2): species.append('C2H4')
        if (v >= 4): species.append('CH2CHOH')
        if (v >= 2): species.append('CH3CHO')
        if (v >= 3): species.append('CH3CO2H')
        if (v >= 3): species.append('HOCH2CHO')
        if (v >= 4): species.append('HOOCH2CHO')
        if (v >= 4): species.append('CH3CO3H')
        if (v >= 4): species.append('HOCH2CO2H')
        if (v >= 4): species.append('HOCH2CO3H')
        if (v >= 4): species.append('HOOCH2CO2H')
        if (v >= 4): species.append('HOOCH2CO3H')
        if (v >= 4): species.append('C2H5O2')
        if (v >= 4): species.append('HOCH2CH2O')
        if (v >= 4): species.append('HOCH2CH2O2')
        if (v >= 4): species.append('CH3CHOHO2')
        if (v >= 2): species.append('C2H6')
        if (v >= 4): species.append('C2H5OH')
        if (v >= 3): species.append('C2H5OOH')
        if (v >= 3): species.append('ETHGLY')
        if (v >= 4): species.append('HYETHO2H')
        if (v >= 4): species.append('CH3CHOHOOH')
        # 2C (CHON)
        if (v >= 4): species.append('NCCH2O2')
        if (v >= 4): species.append('NO3CH2CO3')
        if (v >= 4): species.append('NO3CH2PAN')
        if (v >= 4): species.append('CH3CN')
        if (v >= 4): species.append('NO3CH2CHO')
        if (v >= 2): species.append('PAN')
        if (v >= 4): species.append('PHAN')
        if (v >= 4): species.append('ETHOHNO3')
        if (v >= 4): species.append('C2H5NO3')
        if (v >= 4): species.append('C2H5O2NO2')
        # 3C (CHO)
        if (v >= 4): species.append('C33CO')
        if (v >= 4): species.append('CHOCOCH2O2')
        if (v >= 4): species.append('HCOCH2CO3')
        if (v >= 4): species.append('ALCOCH2OOH')
        if (v >= 3): species.append('MGLYOX')
        if (v >= 4): species.append('HOCH2COCHO')
        if (v >= 4): species.append('HCOCH2CHO')
        if (v >= 4): species.append('HCOCH2CO2H')
        if (v >= 4): species.append('HCOCH2CO3H')
        if (v >= 4): species.append('CH3COCH2O2')
        if (v >= 4): species.append('HOC2H4CO3')
        if (v >= 3): species.append('C3H6')
        if (v >= 4): species.append('CH3COCH3')
        if (v >= 3): species.append('ACETOL')
        if (v >= 3): species.append('HYPERACET')
        if (v >= 4): species.append('HOC2H4CO2H')
        if (v >= 4): species.append('HOC2H4CO3H')
        if (v >= 4): species.append('IC3H7O2')
        if (v >= 4): species.append('HYPROPO2')
        if (v >= 3): species.append('C3H8')
        if (v >= 4): species.append('IC3H7OOH')
        if (v >= 4): species.append('HYPROPO2H')
        if (v >= 4): species.append('CH3COCO3')
        if (v >= 4): species.append('CH3CHCO')
        if (v >= 4): species.append('CH3COCO2H')
        if (v >= 4): species.append('CH3COCO3H')
        if (v >= 4): species.append('HCOCOCH2OOH')
        if (v >= 4): species.append('C2H5CO3')
        if (v >= 4): species.append('HOCH2COCH2O2')
        if (v >= 4): species.append('C2H5CHO')
        if (v >= 3): species.append('PROPENOL')
        if (v >= 3): species.append('C2H5CO2H')
        if (v >= 4): species.append('C2H5CO3H')
        if (v >= 4): species.append('HOCH2COCH2OOH')
        if (v >= 4): species.append('NC3H7O2')
        if (v >= 4): species.append('IPROPOL')
        if (v >= 4): species.append('NPROPOL')
        if (v >= 4): species.append('NC3H7OOH')
        # 3C (CHO) aromatics
        if (v >= 4): species.append('C3DIALOOH')
        if (v >= 4): species.append('C3DIALO2')
        if (v >= 4): species.append('HCOCOHCO3')
        if (v >= 4): species.append('METACETHO')
        if (v >= 4): species.append('MGLOO')
        if (v >= 4): species.append('MGLYOO')
        if (v >= 4): species.append('C32OH13CO')
        if (v >= 4): species.append('HCOCOHCO3H')
        # 3C (CHON)
        if (v >= 4): species.append('C3PAN2')
        if (v >= 4): species.append('NOA')
        if (v >= 4): species.append('CH3COCH2O2NO2')
        if (v >= 4): species.append('PPN')
        if (v >= 4): species.append('C3PAN1')
        if (v >= 4): species.append('PRONO3BO2')
        if (v >= 4): species.append('NC3H7NO3')
        if (v >= 4): species.append('IC3H7NO3')
        if (v >= 4): species.append('PROPOLNO3')
        if (v >= 4): species.append('PR2O2HNO3')
        # 3C (CHON) aromatics
        if (v >= 4): species.append('HCOCOHPAN')
        # 4C (CHO)
        if (v >= 4): species.append('C312COCO3')
        if (v >= 4): species.append('HCOCCH3CO')
        if (v >= 4): species.append('CH3COCHCO')
        if (v >= 4): species.append('C4CODIAL')
        if (v >= 4): species.append('CO23C3CHO')
        if (v >= 4): species.append('C312COCO3H')
        if (v >= 4): species.append('MACO2')
        if (v >= 4): species.append('EZCH3CO2CHCHO')
        if (v >= 4): species.append('EZCHOCCH3CHO2')
        if (v >= 4): species.append('CO2H3CHO')
        if (v >= 4): species.append('MACO3')
        if (v >= 4): species.append('CH3COCHO2CHO')
        if (v >= 4): species.append('HCOCO2CH3CHO')
        if (v >= 4): species.append('BIACETO2')
        if (v >= 4): species.append('CHOC3COO2')
        if (v >= 4): species.append('C44O2')
        if (v >= 4): species.append('CO2H3CO3')
        if (v >= 4): species.append('MACR')
        if (v >= 2): species.append('MVK')
        if (v >= 4): species.append('BIACET')
        if (v >= 4): species.append('MACO2H')
        if (v >= 4): species.append('MVKOH')
        if (v >= 4): species.append('HVMK')
        if (v >= 4): species.append('HMAC')
        if (v >= 4): species.append('CO2C3CHO')
        if (v >= 4): species.append('IBUTDIAL')
        if (v >= 4): species.append('MACO3H')
        if (v >= 4): species.append('BIACETOH')
        if (v >= 4): species.append('CH3COOHCHCHO')
        if (v >= 4): species.append('HCOCCH3CHOOH')
        if (v >= 4): species.append('C413COOOH')
        if (v >= 4): species.append('BIACETOOH')
        if (v >= 4): species.append('CH3COCOCO2H')
        if (v >= 4): species.append('CO2H3CO2H')
        if (v >= 4): species.append('C44OOH')
        if (v >= 4): species.append('CO2H3CO3H')
        if (v >= 4): species.append('MACRO')
        if (v >= 4): species.append('IPRCO3')
        if (v >= 4): species.append('MACRO2')
        if (v >= 4): species.append('IPRHOCO3')
        if (v >= 4): species.append('MACRN')
        if (v >= 4): species.append('MVKNO3')
        if (v >= 4): species.append('PIPN')
        if (v >= 2): species.append('MEK')
        if (v >= 4): species.append('HO12CO3C4')
        if (v >= 4): species.append('MACROH')
        if (v >= 4): species.append('MACROOH')
        if (v >= 4): species.append('MEPROPENE')
        if (v >= 4): species.append('BUT1ENE')
        if (v >= 4): species.append('CBUT2ENE')
        if (v >= 4): species.append('TBUT2ENE')
        if (v >= 4): species.append('BUTENOL')
        if (v >= 4): species.append('C3H7CHO')
        if (v >= 4): species.append('IPRCHO')
        if (v >= 4): species.append('MPROPENOL')
        if (v >= 4): species.append('IBUTALOH')
        if (v >= 4): species.append('MBOOO')
        if (v >= 4): species.append('BUT2OLO')
        if (v >= 4): species.append('PERIBUACID')
        if (v >= 4): species.append('IPRHOCO2H')
        if (v >= 4): species.append('IPRHOCO3H')
        if (v >= 4): species.append('IBUTOLBO2')
        if (v >= 4): species.append('BUT2OLO2')
        if (v >= 4): species.append('TC4H9O2')
        if (v >= 4): species.append('IC4H9O2')
        if (v >= 4): species.append('IC4H9NO3')
        if (v >= 4): species.append('TC4H9NO3')
        if (v >= 4): species.append('BUT2OLNO3')
        if (v >= 4): species.append('NC4H10')
        if (v >= 4): species.append('IC4H10')
        if (v >= 4): species.append('TC4H9OOH')
        if (v >= 4): species.append('IC4H9OOH')
        if (v >= 4): species.append('IBUTOLBOOH')
        if (v >= 4): species.append('BUT2OLOOH')
        # 4C (CHO) aromatics
        if (v >= 4): species.append('MALANHY')
        if (v >= 4): species.append('CO2C4DIAL')
        if (v >= 4): species.append('MALNHYOHCO')
        if (v >= 4): species.append('MALDIALCO3')
        if (v >= 4): species.append('EPXDLCO3')
        if (v >= 4): species.append('MALANHYO2')
        if (v >= 4): species.append('BZFUONE')
        if (v >= 4): species.append('MALDIAL')
        if (v >= 4): species.append('MALDALCO2H')
        if (v >= 4): species.append('EPXC4DIAL')
        if (v >= 4): species.append('HOCOC4DIAL')
        if (v >= 4): species.append('MALDALCO3H')
        if (v >= 4): species.append('BZFUCO')
        if (v >= 4): species.append('EPXDLCO2H')
        if (v >= 4): species.append('CO14O3CHO')
        if (v >= 4): species.append('CO14O3CO2H')
        if (v >= 4): species.append('EPXDLCO3H')
        if (v >= 4): species.append('MALANHYOOH')
        if (v >= 4): species.append('BZFUO2')
        if (v >= 4): species.append('MECOACETO2')
        if (v >= 4): species.append('MALDIALO2')
        if (v >= 4): species.append('MALDIALOOH')
        if (v >= 4): species.append('BZFUOOH')
        if (v >= 4): species.append('MECOACEOOH')
        # 4C (CHON)
        if (v >= 4): species.append('C312COPAN')
        if (v >= 4): species.append('MPAN')
        if (v >= 4): species.append('IBUTOLBNO3')
        if (v >= 4): species.append('C4PAN5')
        # 4C (CHON) aromatics
        if (v >= 4): species.append('NC4DCO2H')
        if (v >= 4): species.append('MALDIALPAN')
        if (v >= 4): species.append('NBZFUONE')
        if (v >= 4): species.append('EPXDLPAN')
        if (v >= 4): species.append('NBZFUO2')
        if (v >= 4): species.append('NBZFUOOH')
        # 4C (CHO) (lumped)
        if (v >= 4): species.append('LMEKO2')
        if (v >= 4): species.append('LHMVKABO2')
        if (v >= 4): species.append('LMEKOOH')
        if (v >= 4): species.append('LHMVKABOOH')
        if (v >= 4): species.append('LMVKOHABOOH')
        if (v >= 4): species.append('LC4H9O2')
        if (v >= 4): species.append('LC4H9OOH')
        if (v >= 4): species.append('LBUT1ENO2')
        if (v >= 4): species.append('LBUT1ENOOH')
        # 4C (CHON) (lumped)
        if (v >= 4): species.append('LMEKNO3')
        if (v >= 4): species.append('LC4H9NO3')
        if (v >= 4): species.append('LBUT1ENNO3')
        # 5C (CHO)
        if (v >= 4): species.append('ZCO3C23DBCOD')
        if (v >= 4): species.append('CHOC3COCO3')
        if (v >= 4): species.append('CO23C4CO3')
        if (v >= 4): species.append('ME3FURAN')
        if (v >= 4): species.append('ZCODC23DBCOD')
        if (v >= 4): species.append('CO13C4CHO')
        if (v >= 4): species.append('CO23C4CHO')
        if (v >= 4): species.append('ZCO3HC23DBCOD')
        if (v >= 4): species.append('C513CO')
        if (v >= 4): species.append('CHOC3COOOH')
        if (v >= 4): species.append('CO23C4CO3H')
        if (v >= 4): species.append('C511O2')
        if (v >= 4): species.append('C512O2')
        if (v >= 4): species.append('C514O2')
        if (v >= 4): species.append('C1ODC2O2C4OD')
        if (v >= 4): species.append('C513O2')
        if (v >= 2): species.append('C5H8')
        if (v >= 4): species.append('HCOC5')
        if (v >= 4): species.append('ZCODC23DBCOOH')
        if (v >= 4): species.append('MBOCOCO')
        if (v >= 4): species.append('C511OOH')
        if (v >= 4): species.append('C514OOH')
        if (v >= 4): species.append('C512OOH')
        if (v >= 4): species.append('C1ODC2OOHC4OD')
        if (v >= 4): species.append('C513OOH')
        if (v >= 4): species.append('ISOPAB')
        if (v >= 4): species.append('ISOPCD')
        if (v >= 4): species.append('ISOPBO2')
        if (v >= 4): species.append('ISOPDO2')
        if (v >= 4): species.append('DB1O')
        if (v >= 4): species.append('DB1O2')
        if (v >= 4): species.append('C1ODC2O2C4OOH')
        if (v >= 4): species.append('C1OOHC3O2C4OD')
        if (v >= 4): species.append('C59O2')
        if (v >= 4): species.append('DB2O2')
        if (v >= 4): species.append('C1ODC3O2C4OOH')
        if (v >= 4): species.append('C1OOHC2O2C4OD')
        if (v >= 4): species.append('MBO')
        if (v >= 4): species.append('ISOPAOH')
        if (v >= 4): species.append('ISOPBOH')
        if (v >= 4): species.append('ISOPDOH')
        if (v >= 4): species.append('ISOPBOOH')
        if (v >= 4): species.append('ISOPDOOH')
        if (v >= 4): species.append('MBOACO')
        if (v >= 4): species.append('DB1OOH')
        if (v >= 4): species.append('C59OOH')
        if (v >= 4): species.append('C1OOHC2OOHC4OD')
        if (v >= 4): species.append('DB2OOH')
        # 5C aromatics (CHO)
        if (v >= 4): species.append('C4CO2DBCO3')
        if (v >= 4): species.append('MMALANHY')
        if (v >= 4): species.append('C54CO')
        if (v >= 4): species.append('C4CO2DCO3H')
        if (v >= 4): species.append('C5DIALCO')
        if (v >= 4): species.append('C5DIALO2')
        if (v >= 4): species.append('C5CO14O2')
        if (v >= 4): species.append('ACCOMECO3')
        if (v >= 4): species.append('MMALANHYO2')
        if (v >= 4): species.append('TLFUONE')
        if (v >= 4): species.append('C5DICARB')
        if (v >= 4): species.append('MC3ODBCO2H')
        if (v >= 4): species.append('C5CO14OH')
        if (v >= 4): species.append('C5134CO2OH')
        if (v >= 4): species.append('C5DIALOOH')
        if (v >= 4): species.append('ACCOMECHO')
        if (v >= 4): species.append('C5CO14OOH')
        if (v >= 4): species.append('C24O3CCO2H')
        if (v >= 4): species.append('TLFUONOO')
        if (v >= 4): species.append('MMALNHYOOH')
        if (v >= 4): species.append('ACCOMECO3H')
        if (v >= 4): species.append('C4M2ALOHO2')
        if (v >= 4): species.append('C5DICARBO2')
        if (v >= 4): species.append('TLFUO2')
        if (v >= 4): species.append('TLFUOOH')
        if (v >= 4): species.append('C5DICAROOH')
        if (v >= 4): species.append('C4MALOHOOH')
        # 5C (CHON)
        if (v >= 4): species.append('CHOC3COPAN')
        if (v >= 4): species.append('ZCPANC23DBCOD')
        if (v >= 4): species.append('C5PAN9')
        if (v >= 4): species.append('NC4CHO')
        if (v >= 4): species.append('C514NO3')
        if (v >= 4): species.append('NISOPO2')
        if (v >= 4): species.append('NC4OHCO3')
        if (v >= 4): species.append('NC4OHCPAN')
        if (v >= 4): species.append('ISOPBNO3')
        if (v >= 4): species.append('ISOPDNO3')
        if (v >= 4): species.append('NISOPOOH')
        if (v >= 4): species.append('NMBOBCO')
        if (v >= 4): species.append('C4MCONO3OH')
        if (v >= 4): species.append('DB1NO3')
        if (v >= 4): species.append('NC4OHCO3H')
        if (v >= 4): species.append('ISOPBDNO3O2')
        # 5C aromatics (CHON)
        if (v >= 4): species.append('C4CO2DBPAN')
        if (v >= 4): species.append('NC4MDCO2H')
        if (v >= 4): species.append('C5COO2NO2')
        if (v >= 4): species.append('ACCOMEPAN')
        if (v >= 4): species.append('MC3CODBPAN')
        if (v >= 4): species.append('C3MCODBPAN')
        if (v >= 4): species.append('NTLFUO2')
        if (v >= 4): species.append('NTLFUOOH')
        # 5C (CHO) (lumped)
        if (v >= 4): species.append('LME3FURANO2')
        if (v >= 4): species.append('LHC4ACCO3')
        if (v >= 4): species.append('LHC4ACCHO')
        if (v >= 4): species.append('LHC4ACCO2H')
        if (v >= 4): species.append('LHC4ACCO3H')
        if (v >= 4): species.append('LISOPACO')
        if (v >= 4): species.append('LDISOPACO')
        if (v >= 4): species.append('LISOPEFO')
        if (v >= 4): species.append('LISOPACO2')
        if (v >= 4): species.append('LDISOPACO2')
        if (v >= 4): species.append('LISOPEFO2')
        if (v >= 4): species.append('LC578O2')
        if (v >= 4): species.append('LIEPOX')
        if (v >= 4): species.append('LISOPACOOH')
        if (v >= 4): species.append('LC578OOH')
        if (v >= 4): species.append('LMBOABO2')
        if (v >= 4): species.append('LMBOABOOH')
        # 5C (CHON) (lumped)
        if (v >= 4): species.append('LC5PAN1719')
        if (v >= 4): species.append('LISOPACNO3')
        if (v >= 4): species.append('LNMBOABO2')
        if (v >= 4): species.append('LNMBOABOOH')
        if (v >= 4): species.append('LISOPACNO3O2')
        if (v >= 4): species.append('LMBOABNO3')
        if (v >= 4): species.append('LNISO3')
        if (v >= 4): species.append('LNISOOH')
        # 6C (CHO)
        if (v >= 4): species.append('CO235C5CHO')
        if (v >= 4): species.append('CO235C6O2')
        if (v >= 4): species.append('C614CO')
        if (v >= 4): species.append('CO235C6OOH')
        if (v >= 4): species.append('C614O2')
        if (v >= 4): species.append('C614OOH')
        # C6 (CHO) aromatics
        if (v >= 4): species.append('PBZQONE')
        if (v >= 4): species.append('CATECHOL')
        if (v >= 4): species.append('C6CO4DB')
        if (v >= 4): species.append('PBZQCO')
        if (v >= 4): species.append('C6H5O')
        if (v >= 4): species.append('CATEC1O')
        if (v >= 4): species.append('C6H5O2')
        if (v >= 4): species.append('CATEC1O2')
        if (v >= 4): species.append('C5CO2DBCO3')
        if (v >= 4): species.append('PBZQO2')
        if (v >= 4): species.append('BZEMUCCO3')
        if (v >= 4): species.append('C5CO2DCO3H')
        if (v >= 4): species.append('C5CO2OHCO3')
        if (v >= 4): species.append('BENZENE')
        if (v >= 4): species.append('PHENOL')
        if (v >= 4): species.append('C6H5OOH')
        if (v >= 4): species.append('BZEPOXMUC')
        if (v >= 4): species.append('C6125CO')
        if (v >= 4): species.append('CATEC1OOH')
        if (v >= 4): species.append('BZEMUCCO2H')
        if (v >= 4): species.append('BZOBIPEROH')
        if (v >= 4): species.append('BZEMUCCO')
        if (v >= 4): species.append('PBZQOOH')
        if (v >= 4): species.append('BZEMUCCO3H')
        if (v >= 4): species.append('C5COOHCO3H')
        if (v >= 4): species.append('C615CO2O2')
        if (v >= 4): species.append('BZBIPERO2')
        if (v >= 4): species.append('PHENO2')
        if (v >= 4): species.append('BZEMUCO2')
        if (v >= 4): species.append('C615CO2OOH')
        if (v >= 4): species.append('BZBIPEROOH')
        if (v >= 4): species.append('PHENOOH')
        if (v >= 4): species.append('BZEMUCOOH')
        if (v >= 4): species.append('CPDKETENE')
        # 6C (CHON)
        if (v >= 4): species.append('C614NO3')
        # C6 (CHON) aromatics
        if (v >= 4): species.append('NPHEN1O')
        if (v >= 4): species.append('NPHEN1O2')
        if (v >= 4): species.append('DNPHEN')
        if (v >= 4): species.append('NBZQO2')
        if (v >= 4): species.append('NDNPHENO2')
        if (v >= 4): species.append('HOC6H4NO2')
        if (v >= 4): species.append('NCATECHOL')
        if (v >= 4): species.append('NPHEN1OOH')
        if (v >= 4): species.append('BZEMUCPAN')
        if (v >= 4): species.append('C5CO2DBPAN')
        if (v >= 4): species.append('NBZQOOH')
        if (v >= 4): species.append('C5CO2OHPAN')
        if (v >= 4): species.append('DNPHENO2')
        if (v >= 4): species.append('NNCATECO2')
        if (v >= 4): species.append('NDNPHENOOH')
        if (v >= 4): species.append('NPHENO2')
        if (v >= 4): species.append('NCATECO2')
        if (v >= 4): species.append('DNPHENOOH')
        if (v >= 4): species.append('NNCATECOOH')
        if (v >= 4): species.append('BZBIPERNO3')
        if (v >= 4): species.append('BZEMUCNO3')
        if (v >= 4): species.append('NPHENOOH')
        if (v >= 4): species.append('NCATECOOH')
        # 7C (CHO)
        if (v >= 4): species.append('MCPDKETENE')
        if (v >= 4): species.append('CO235C6CO3')
        if (v >= 4): species.append('CO235C6CHO')
        if (v >= 4): species.append('C235C6CO3H')
        if (v >= 4): species.append('C716O2')
        if (v >= 4): species.append('C716OOH')
        if (v >= 4): species.append('ROO6R4P')
        if (v >= 4): species.append('ROO6R5P')
        if (v >= 4): species.append('ROO6R3O')
        if (v >= 4): species.append('C721O2')
        if (v >= 4): species.append('C722O2')
        if (v >= 4): species.append('ROO6R3O2')
        if (v >= 4): species.append('ROO6R5O2')
        if (v >= 4): species.append('C721OOH')
        if (v >= 4): species.append('C722OOH')
        if (v >= 4): species.append('ROO6R3OOH')
        # C7 (CHO) aromatics
        if (v >= 4): species.append('C6H5CO3')
        if (v >= 4): species.append('BENZAL')
        if (v >= 4): species.append('PHCOOH')
        if (v >= 4): species.append('PTLQONE')
        if (v >= 4): species.append('C6H5CO3H')
        if (v >= 4): species.append('C7CO4DB')
        if (v >= 4): species.append('PTLQCO')
        if (v >= 4): species.append('TOL1O')
        if (v >= 4): species.append('OXYL1O2')
        if (v >= 4): species.append('C6H5CH2O2')
        if (v >= 4): species.append('MCATEC1O')
        if (v >= 4): species.append('MCATEC1O2')
        if (v >= 4): species.append('PTLQO2')
        if (v >= 4): species.append('TLEMUCCO3')
        if (v >= 4): species.append('C6CO2OHCO3')
        if (v >= 4): species.append('TOLUENE')
        if (v >= 4): species.append('CRESOL')
        if (v >= 4): species.append('C6H5CH2OH')
        if (v >= 4): species.append('OXYL1OOH')
        if (v >= 4): species.append('C6H5CH2OOH')
        if (v >= 4): species.append('MCATECHOL')
        if (v >= 4): species.append('TLEPOXMUC')
        if (v >= 4): species.append('MCATEC1OOH')
        if (v >= 4): species.append('PTLQOH')
        if (v >= 4): species.append('TLEMUCCO2H')
        if (v >= 4): species.append('TLOBIPEROH')
        if (v >= 4): species.append('PTLQOOH')
        if (v >= 4): species.append('TLEMUCCO')
        if (v >= 4): species.append('TLEMUCCO3H')
        if (v >= 4): species.append('C6COOHCO3H')
        if (v >= 4): species.append('TLBIPERO2')
        if (v >= 4): species.append('TLEMUCO2')
        if (v >= 4): species.append('CRESO2')
        if (v >= 4): species.append('TLBIPER2OH')
        if (v >= 4): species.append('TLEMUCOH')
        if (v >= 4): species.append('CRESOH')
        if (v >= 4): species.append('TLBIPEROOH')
        if (v >= 4): species.append('CRESOOH')
        if (v >= 4): species.append('TLEMUCOOH')
        # 7C (CHON)
        if (v >= 4): species.append('C7PAN3')
        if (v >= 4): species.append('ROO6R3NO3')
        # C7 (CHON) aromatics
        if (v >= 4): species.append('NCRESOOH')
        if (v >= 4): species.append('PBZN')
        if (v >= 4): species.append('NDNCRESO2')
        if (v >= 4): species.append('NCRES1O')
        if (v >= 4): species.append('NCRES1O2')
        if (v >= 4): species.append('DNCRES')
        if (v >= 4): species.append('MNCPDKETENE')
        if (v >= 4): species.append('NPTLQO2')
        if (v >= 4): species.append('TOL1OHNO2')
        if (v >= 4): species.append('C6H5CH2NO3')
        if (v >= 4): species.append('MNCATECH')
        if (v >= 4): species.append('NCRES1OOH')
        if (v >= 4): species.append('NPTLQOOH')
        if (v >= 4): species.append('TLEMUCPAN')
        if (v >= 4): species.append('C6CO2OHPAN')
        if (v >= 4): species.append('DNCRESO2')
        if (v >= 4): species.append('MNNCATECO2')
        if (v >= 4): species.append('NDNCRESOOH')
        if (v >= 4): species.append('NCRESO2')
        if (v >= 4): species.append('MNCATECO2')
        if (v >= 4): species.append('DNCRESOOH')
        if (v >= 4): species.append('MNNCATCOOH')
        if (v >= 4): species.append('TLBIPERNO3')
        if (v >= 4): species.append('TLEMUCNO3')
        if (v >= 4): species.append('NCRESOH')
        if (v >= 4): species.append('MNCATECOOH')
        # 8C (CHO)
        if (v >= 4): species.append('C8BCO2')
        if (v >= 4): species.append('C721CO3')
        if (v >= 4): species.append('C8BCCO')
        if (v >= 4): species.append('C8BCOOH')
        if (v >= 4): species.append('C721CHO')
        if (v >= 4): species.append('NORPINIC')
        if (v >= 4): species.append('C721CO3H')
        if (v >= 4): species.append('C85O2')
        if (v >= 4): species.append('C89O2')
        if (v >= 4): species.append('C811O2')
        if (v >= 4): species.append('C86O2')
        if (v >= 4): species.append('C812O2')
        if (v >= 4): species.append('C813O2')
        if (v >= 4): species.append('C8BC')
        if (v >= 4): species.append('C85OOH')
        if (v >= 4): species.append('C811OOH')
        if (v >= 4): species.append('C86OOH')
        if (v >= 4): species.append('C812OOH')
        if (v >= 4): species.append('C813OOH')
        if (v >= 4): species.append('C89OOH')
        if (v >= 4): species.append('C810OOH')
        if (v >= 4): species.append('C810O2')
        # C8 (CHO) aromatics
        if (v >= 4): species.append('STYRENE')
        if (v >= 4): species.append('STYRENO2')
        if (v >= 4): species.append('LXYL')
        if (v >= 4): species.append('EBENZ')
        if (v >= 4): species.append('STYRENOOH')
        # 8C (CHON)
        if (v >= 4): species.append('C8BCNO3')
        if (v >= 4): species.append('C721PAN')
        if (v >= 4): species.append('C89NO3')
        if (v >= 4): species.append('C810NO3')
        # C8 (CHON) aromatics
        if (v >= 4): species.append('NSTYRENO2')
        if (v >= 4): species.append('NSTYRENOOH')
        # 9C (CHO)
        if (v >= 4): species.append('C85CO3')
        if (v >= 4): species.append('NOPINDCO')
        if (v >= 4): species.append('C85CO3H')
        if (v >= 4): species.append('NOPINDO2')
        if (v >= 4): species.append('C89CO3')
        if (v >= 4): species.append('C811CO3')
        if (v >= 4): species.append('NOPINONE')
        if (v >= 4): species.append('NOPINOO')
        if (v >= 4): species.append('NORPINAL')
        if (v >= 4): species.append('NORPINENOL')
        if (v >= 4): species.append('C89CO2H')
        if (v >= 4): species.append('NOPINDOOH')
        if (v >= 4): species.append('RO6R3P')
        if (v >= 4): species.append('C89CO3H')
        if (v >= 4): species.append('PINIC')
        if (v >= 4): species.append('C811CO3H')
        if (v >= 4): species.append('C96O2')
        if (v >= 4): species.append('C97O2')
        if (v >= 4): species.append('C98O2')
        if (v >= 4): species.append('C96OOH')
        if (v >= 4): species.append('C97OOH')
        if (v >= 4): species.append('C98OOH')
        # 9C (CHON)
        if (v >= 4): species.append('C89PAN')
        if (v >= 4): species.append('C9PAN2')
        if (v >= 4): species.append('C811PAN')
        if (v >= 4): species.append('C96NO3')
        if (v >= 4): species.append('C98NO3')
        # C9 aromatics (lumped)
        if (v >= 4): species.append('LTMB')
        # 10C (CHO)
        if (v >= 4): species.append('C109CO')
        if (v >= 4): species.append('PINALO2')
        if (v >= 4): species.append('PINALOOH')
        if (v >= 4): species.append('C109O2')
        if (v >= 4): species.append('C96CO3')
        if (v >= 4): species.append('C106O2')
        if (v >= 2): species.append('APINENE')
        if (v >= 2): species.append('BPINENE')
        if (v >= 4): species.append('CARENE')
        if (v >= 4): species.append('SABINENE')
        if (v >= 4): species.append('CAMPHENE')
        if (v >= 4): species.append('PINAL')
        if (v >= 4): species.append('PINENOL')
        if (v >= 4): species.append('APINAOO')
        if (v >= 4): species.append('APINBOO')
        if (v >= 4): species.append('MENTHEN6ONE')
        if (v >= 4): species.append('PINONIC')
        if (v >= 4): species.append('C109OOH')
        if (v >= 4): species.append('PERPINONIC')
        if (v >= 4): species.append('C106OOH')
        if (v >= 4): species.append('BPINAO2')
        if (v >= 4): species.append('OH2MENTHEN6ONE')
        if (v >= 4): species.append('RO6R1O2')
        if (v >= 4): species.append('ROO6R1O2')
        if (v >= 4): species.append('RO6R3O2')
        if (v >= 4): species.append('OHMENTHEN6ONEO2')
        if (v >= 4): species.append('BPINAOOH')
        if (v >= 4): species.append('RO6R1OOH')
        if (v >= 4): species.append('RO6R3OOH')
        if (v >= 4): species.append('ROO6R1OOH')
        # 10C (CHON)
        if (v >= 4): species.append('PINALNO3')
        if (v >= 4): species.append('C10PAN2')
        if (v >= 4): species.append('C106NO3')
        if (v >= 4): species.append('BPINANO3')
        if (v >= 4): species.append('RO6R1NO3')
        if (v >= 4): species.append('RO6R3NO3')
        if (v >= 4): species.append('ROO6R1NO3')
        # 10C (lumped)
        if (v >= 4): species.append('LAPINABO2')
        if (v >= 4): species.append('LAPINABOOH')
        if (v >= 4): species.append('LNAPINABO2')
        if (v >= 4): species.append('LNBPINABO2')
        if (v >= 4): species.append('LAPINABNO3')
        if (v >= 4): species.append('LNAPINABOOH')
        if (v >= 4): species.append('LNBPINABOOH')
        # C10 aromatics (lumped)
        if (v >= 4): species.append('LHAROM')
        # F
        # Cl
        if (v >= 1): species.append('Cl')
        if (v >= 1): species.append('Cl2')
        if (v >= 1): species.append('ClO')
        if (v >= 1): species.append('HCl')
        if (v >= 1): species.append('HOCl')
        if (v >= 3): species.append('Cl2O2')
        if (v >= 3): species.append('OClO')
        if (v >= 2): species.append('ClNO2')
        if (v >= 1): species.append('ClNO3')
        if (v >= 3): species.append('CCl4')
        if (v >= 3): species.append('CH3Cl')
        if (v >= 3): species.append('CH3CCl3')
        if (v >= 3): species.append('CF2Cl2')
        if (v >= 3): species.append('CFCl3')
        # Br
        if (v >= 1): species.append('Br')
        if (v >= 1): species.append('Br2')
        if (v >= 1): species.append('BrO')
        if (v >= 1): species.append('HBr')
        if (v >= 1): species.append('HOBr')
        if (v >= 2): species.append('BrNO2')
        if (v >= 1): species.append('BrNO3')
        if (v >= 1): species.append('BrCl')
        if (v >= 4): species.append('CH3Br')
        if (v >= 4): species.append('CF3Br')
        if (v >= 4): species.append('CF2ClBr')
        if (v >= 4): species.append('CHCl2Br')
        if (v >= 4): species.append('CHClBr2')
        if (v >= 4): species.append('CH2ClBr')
        if (v >= 4): species.append('CH2Br2')
        if (v >= 4): species.append('CHBr3')
        # I
        if (v >= 2): species.append('I')
        if (v >= 2): species.append('I2')
        if (v >= 2): species.append('IO')
        if (v >= 2): species.append('OIO')
        if (v >= 3): species.append('I2O2')
        if (v >= 2): species.append('HI')
        if (v >= 2): species.append('HOI')
        if (v >= 2): species.append('HIO3')
        if (v >= 3): species.append('INO2')
        if (v >= 2): species.append('INO3')
        if (v >= 3): species.append('CH3I')
        if (v >= 3): species.append('CH2I2')
        if (v >= 3): species.append('C3H7I')
        if (v >= 2): species.append('ICl')
        if (v >= 3): species.append('CH2ClI')
        if (v >= 1): species.append('IBr')
        if (v >= 3): species.append('IPART')
        # S
        if (v >= 4): species.append('S')
        if (v >= 4): species.append('SO')
        if (v >= 1): species.append('SO2')
        if (v >= 4): species.append('SH')
        if (v >= 1): species.append('H2SO4')
        if (v >= 2): species.append('CH3SO3H')
        if (v >= 1): species.append('DMS')
        if (v >= 1): species.append('DMSO')
        if (v >= 3): species.append('CH3SO2')
        if (v >= 3): species.append('CH3SO3')
        if (v >= 4): species.append('OCS')
        if (v >= 4): species.append('SF6')
        # Hg
        if (v >= 3): species.append('Hg')
        if (v >= 3): species.append('HgO')
        if (v >= 3): species.append('HgCl')
        if (v >= 3): species.append('HgCl2')
        if (v >= 3): species.append('HgBr')
        if (v >= 3): species.append('HgBr2')
        if (v >= 3): species.append('ClHgBr')
        if (v >= 3): species.append('BrHgOBr')
        if (v >= 3): species.append('ClHgOBr')

        return species

    @classmethod
    # v = verbosity starts at 1 = very important
    def set_jvalues(cls, v=1):
        jvalues = []
        if (v >=3): jvalues.append('J_O2')       # J1000
        if (v >=1): jvalues.append('J_O3P')      # J1001b
        if (v >=1): jvalues.append('J_O1D')      # J1001a

        if (v >=3): jvalues.append('J_H2O')      # J2100
        if (v >=1): jvalues.append('J_H2O2')     # J2101

        if (v >=3): jvalues.append('J_N2O')      # J3100
        if (v >=1): jvalues.append('J_NO2')      # J3101
        if (v >=3): jvalues.append('J_NO')       # J3102
        if (v >=1): jvalues.append('J_NO2O')     # J3103a
        if (v >=1): jvalues.append('J_NOO2')     # J3103b
        if (v >=1): jvalues.append('J_N2O5')     # J3104
        if (v >=3): jvalues.append('J_NO3NOO')
        if (v >=2): jvalues.append('J_HONO')     # J3200
        if (v >=1): jvalues.append('J_HNO3')     # J3201
        if (v >=2): jvalues.append('J_HNO4')     # J3202

        if (v >=3): jvalues.append('J_CH4')
        if (v >=1): jvalues.append('J_CH3OOH')   # J4100,J4200,J4300,J4304,J4400,J4402,J4404,J4500
        if (v >=1): jvalues.append('J_COH2')     # J4101a
        if (v >=1): jvalues.append('J_CHOH')     # J4101b,J4203,J4302,J4403
        if (v >=3): jvalues.append('J_CO2')      # J4102
        if (v >=2): jvalues.append('J_CH3CHO')   # J4201
        if (v >=2): jvalues.append('J_CH3CO3H')  # J4202
        if (v >=1): jvalues.append('J_PAN')      # J4204,J4305,J4306,J4406,J4501
        if (v >=3): jvalues.append('J_CH3COCH3') # J4301
        if (v >=3): jvalues.append('J_MGLYOX')   # J4303,J4401,J4405
        if (v >=3): jvalues.append('J_MVK')
        if (v >=3): jvalues.append('J_GLYOX')
        if (v >=3): jvalues.append('J_HOCH2CHO')
        if (v >=3): jvalues.append('J_MACR')

        if (v >=1): jvalues.append('J_Cl2')      # J6000
        if (v >=2): jvalues.append('J_Cl2O2')    # J6100,J8101
        if (v >=2): jvalues.append('J_OClO')     # J6101
        if (v >=3): jvalues.append('J_HCl')      # J6200
        if (v >=1): jvalues.append('J_HOCl')     # J6201
        if (v >=1): jvalues.append('J_ClNO2')    # J6300
        if (v >=1): jvalues.append('J_ClNO3')    # J6301
        if (v >=3): jvalues.append('J_ClONO2')
        if (v >=2): jvalues.append('J_CH3Cl')    # J6400
        if (v >=2): jvalues.append('J_CCl4')     # J6401
        if (v >=2): jvalues.append('J_CH3CCl3')  # J6402
        if (v >=3): jvalues.append('J_CFCl3')    # J6500
        if (v >=3): jvalues.append('J_CF2Cl2')   # J6501

        if (v >=1): jvalues.append('J_Br2')      # J7000
        if (v >=1): jvalues.append('J_BrO')      # J7100
        if (v >=1): jvalues.append('J_HOBr')     # J7200
        if (v >=1): jvalues.append('J_BrNO2')    # J7300
        if (v >=1): jvalues.append('J_BrNO3')    # J7301
        if (v >=1): jvalues.append('J_BrCl')     # J7600
        if (v >=3): jvalues.append('J_CH3Br')    # J7400
        if (v >=3): jvalues.append('J_CH2Br2')
        if (v >=3): jvalues.append('J_CHBr3')
        if (v >=3): jvalues.append('J_CHClBr2')
        if (v >=3): jvalues.append('J_CH2ClBr')
        if (v >=3): jvalues.append('J_CHCl2Br')
        if (v >=3): jvalues.append('J_CF3Br')    # J7500
        if (v >=3): jvalues.append('J_CF2ClBr')  # J7601

        if (v >=1): jvalues.append('J_I2')       # J8000
        if (v >=1): jvalues.append('J_IO')       # J8100
        if (v >=1): jvalues.append('J_HOI')      # J8200
        if (v >=1): jvalues.append('J_INO2')     # J8300
        if (v >=1): jvalues.append('J_INO3')     # J8301
        if (v >=1): jvalues.append('J_CH2I2')    # J8400
        if (v >=1): jvalues.append('J_CH3I')     # J8401
        if (v >=1): jvalues.append('J_C3H7I')    # J8402
        if (v >=1): jvalues.append('J_CH2ClI')   # J8403
        if (v >=1): jvalues.append('J_ICl')      # J8600
        if (v >=1): jvalues.append('J_IBr')      # J8700

        if (v >=3): jvalues.append('J_SO2')
        if (v >=3): jvalues.append('J_SO3')
        if (v >=3): jvalues.append('J_SF6')
        if (v >=3): jvalues.append('J_OCS')
        if (v >=3): jvalues.append('J_CS2')
        
        return jvalues

##############################################################################
