! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Auxiliary Routines File
! 
! Generated by KPP-2.2.3_rs3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_Util.f90
! Time                 : Sat Nov 14 16:34:39 2020
! Working directory    : /home/caaba/caaba_3.8m_volc1/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_Util

  USE messy_mecca_kpp_Parameters
  IMPLICIT NONE

CONTAINS



! User INLINED Utility Functions

! from xmecca:
SUBROUTINE initialize_indexarrays
  USE messy_mecca_kpp_global     ! ind_XYZ_a(:) arrays
  USE messy_mecca_kpp_parameters ! ind_XYZ_a## scalars
  IMPLICIT NONE
  ! from aerosol.awk:
  ind_O2_a(01)        = ind_O2_a01
  ind_O3_a(01)        = ind_O3_a01
  ind_OH_a(01)        = ind_OH_a01
  ind_HO2_a(01)       = ind_HO2_a01
  ind_H2O_a(01)       = ind_H2O_a01
  ind_H2O2_a(01)      = ind_H2O2_a01
  ind_NH3_a(01)       = ind_NH3_a01
  ind_NO_a(01)        = ind_NO_a01
  ind_NO2_a(01)       = ind_NO2_a01
  ind_NO3_a(01)       = ind_NO3_a01
  ind_HONO_a(01)      = ind_HONO_a01
  ind_HNO3_a(01)      = ind_HNO3_a01
  ind_HNO4_a(01)      = ind_HNO4_a01
  ind_CH3OH_a(01)     = ind_CH3OH_a01
  ind_HCOOH_a(01)     = ind_HCOOH_a01
  ind_HCHO_a(01)      = ind_HCHO_a01
  ind_CH3O2_a(01)     = ind_CH3O2_a01
  ind_CH3OOH_a(01)    = ind_CH3OOH_a01
  ind_CO2_a(01)       = ind_CO2_a01
  ind_CH3CO2H_a(01)   = ind_CH3CO2H_a01
  ind_PAN_a(01)       = ind_PAN_a01
  ind_CH3CHO_a(01)    = ind_CH3CHO_a01
  ind_CH3COCH3_a(01)  = ind_CH3COCH3_a01
  ind_Cl_a(01)        = ind_Cl_a01
  ind_Cl2_a(01)       = ind_Cl2_a01
  ind_HCl_a(01)       = ind_HCl_a01
  ind_HOCl_a(01)      = ind_HOCl_a01
  ind_Br_a(01)        = ind_Br_a01
  ind_Br2_a(01)       = ind_Br2_a01
  ind_HBr_a(01)       = ind_HBr_a01
  ind_HOBr_a(01)      = ind_HOBr_a01
  ind_BrCl_a(01)      = ind_BrCl_a01
  ind_I2_a(01)        = ind_I2_a01
  ind_IO_a(01)        = ind_IO_a01
  ind_HOI_a(01)       = ind_HOI_a01
  ind_ICl_a(01)       = ind_ICl_a01
  ind_IBr_a(01)       = ind_IBr_a01
  ind_SO2_a(01)       = ind_SO2_a01
  ind_H2SO4_a(01)     = ind_H2SO4_a01
  ind_DMS_a(01)       = ind_DMS_a01
  ind_DMSO_a(01)      = ind_DMSO_a01
  ind_Hg_a(01)        = ind_Hg_a01
  ind_HgO_a(01)       = ind_HgO_a01
  ind_HgOHOH_a(01)    = ind_HgOHOH_a01
  ind_HgOHCl_a(01)    = ind_HgOHCl_a01
  ind_HgCl2_a(01)     = ind_HgCl2_a01
  ind_HgBr2_a(01)     = ind_HgBr2_a01
  ind_HgSO3_a(01)     = ind_HgSO3_a01
  ind_ClHgBr_a(01)    = ind_ClHgBr_a01
  ind_BrHgOBr_a(01)   = ind_BrHgOBr_a01
  ind_ClHgOBr_a(01)   = ind_ClHgOBr_a01
  ind_O2m_a(01)       = ind_O2m_a01
  ind_OHm_a(01)       = ind_OHm_a01
  ind_Hp_a(01)        = ind_Hp_a01
  ind_NH4p_a(01)      = ind_NH4p_a01
  ind_NO2m_a(01)      = ind_NO2m_a01
  ind_NO3m_a(01)      = ind_NO3m_a01
  ind_NO4m_a(01)      = ind_NO4m_a01
  ind_CO3m_a(01)      = ind_CO3m_a01
  ind_HCOOm_a(01)     = ind_HCOOm_a01
  ind_HCO3m_a(01)     = ind_HCO3m_a01
  ind_CH3COOm_a(01)   = ind_CH3COOm_a01
  ind_Clm_a(01)       = ind_Clm_a01
  ind_Cl2m_a(01)      = ind_Cl2m_a01
  ind_ClOm_a(01)      = ind_ClOm_a01
  ind_ClOHm_a(01)     = ind_ClOHm_a01
  ind_Brm_a(01)       = ind_Brm_a01
  ind_Br2m_a(01)      = ind_Br2m_a01
  ind_BrOm_a(01)      = ind_BrOm_a01
  ind_BrOHm_a(01)     = ind_BrOHm_a01
  ind_BrCl2m_a(01)    = ind_BrCl2m_a01
  ind_Br2Clm_a(01)    = ind_Br2Clm_a01
  ind_Im_a(01)        = ind_Im_a01
  ind_IO2m_a(01)      = ind_IO2m_a01
  ind_IO3m_a(01)      = ind_IO3m_a01
  ind_ICl2m_a(01)     = ind_ICl2m_a01
  ind_IBr2m_a(01)     = ind_IBr2m_a01
  ind_SO3m_a(01)      = ind_SO3m_a01
  ind_SO3mm_a(01)     = ind_SO3mm_a01
  ind_SO4m_a(01)      = ind_SO4m_a01
  ind_SO4mm_a(01)     = ind_SO4mm_a01
  ind_SO5m_a(01)      = ind_SO5m_a01
  ind_HSO3m_a(01)     = ind_HSO3m_a01
  ind_HSO4m_a(01)     = ind_HSO4m_a01
  ind_HSO5m_a(01)     = ind_HSO5m_a01
  ind_CH3SO3m_a(01)   = ind_CH3SO3m_a01
  ind_CH2OHSO3m_a(01) = ind_CH2OHSO3m_a01
  ind_Hgp_a(01)       = ind_Hgp_a01
  ind_Hgpp_a(01)      = ind_Hgpp_a01
  ind_HgOHp_a(01)     = ind_HgOHp_a01
  ind_HgClp_a(01)     = ind_HgClp_a01
  ind_HgBrp_a(01)     = ind_HgBrp_a01
  ind_HgSO32mm_a(01)  = ind_HgSO32mm_a01
  ind_D1O_a(01)       = ind_D1O_a01
  ind_Nap_a(01)       = ind_Nap_a01
END SUBROUTINE initialize_indexarrays

! End INLINED Utility Functions

! Utility Functions from KPP_HOME/util/util
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! UTIL - Utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! ****************************************************************
!                            
! InitSaveData - Opens the data file for writing
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE InitSaveData ()

      USE messy_mecca_kpp_Parameters

      open(10, file='messy_mecca_kpp.dat')

      END SUBROUTINE InitSaveData

! End of InitSaveData function
! ****************************************************************

! ****************************************************************
!                            
! SaveData - Write LOOKAT species in the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE SaveData ()

      USE messy_mecca_kpp_Global
      USE messy_mecca_kpp_Monitor

      INTEGER i

      WRITE(10,999) (TIME-TSTART)/3600.D0,  &
                   (C(LOOKAT(i))/CFACTOR, i=1,NLOOKAT)
999   FORMAT(E24.16,100(1X,E24.16))

      END SUBROUTINE SaveData

! End of SaveData function
! ****************************************************************

! ****************************************************************
!                            
! CloseSaveData - Close the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE CloseSaveData ()

      USE messy_mecca_kpp_Parameters

      CLOSE(10)

      END SUBROUTINE CloseSaveData

! End of CloseSaveData function
! ****************************************************************

! ****************************************************************
!                            
! GenerateMatlab - Generates MATLAB file to load the data file 
!   Parameters : 
!                It will have a character string to prefix each 
!                species name with.                                                 
!
! ****************************************************************

      SUBROUTINE GenerateMatlab ( PREFIX )

      USE messy_mecca_kpp_Parameters
      USE messy_mecca_kpp_Global
      USE messy_mecca_kpp_Monitor

      
      CHARACTER(LEN=8) PREFIX 
      INTEGER i

      open(20, file='messy_mecca_kpp.m')
      write(20,*) 'load messy_mecca_kpp.dat;'
      write(20,990) PREFIX
990   FORMAT(A1,'c = messy_mecca_kpp;')
      write(20,*) 'clear messy_mecca_kpp;'
      write(20,991) PREFIX, PREFIX
991   FORMAT(A1,'t=',A1,'c(:,1);')
      write(20,992) PREFIX
992   FORMAT(A1,'c(:,1)=[];')

      do i=1,NLOOKAT
        write(20,993) PREFIX, SPC_NAMES(LOOKAT(i)), PREFIX, i
993     FORMAT(A1,A6,' = ',A1,'c(:,',I2,');')
      end do
      
      CLOSE(20)

      END SUBROUTINE GenerateMatlab

! End of GenerateMatlab function
! ****************************************************************


! ****************************************************************
!                            
! tag2num - convert equation tags to kpp reaction number
!   Arguments :
!      id        - string with the equation tag
!
! ****************************************************************

ELEMENTAL INTEGER FUNCTION tag2num ( id )

  USE messy_mecca_kpp_Monitor, ONLY: EQN_TAGS

  CHARACTER(LEN=*), INTENT(IN) :: id
  INTEGER i

  tag2num = 0 ! mz_rs_20050115
  DO i = 1, SIZE(EQN_TAGS)
    IF (TRIM(EQN_TAGS(i)) == TRIM(id)) THEN
      tag2num = i ! mz_rs_20050115
      EXIT
    ENDIF
  END DO

END FUNCTION tag2num

! End of tag2num function
! ****************************************************************

! End Utility Functions from KPP_HOME/util/util
! End of UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_user2kpp - function to copy concentrations from USER to KPP
!   Arguments :
!      V_USER    - Concentration of variable species in USER's order
!      V         - Concentrations of variable species (local)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_user2kpp ( V_USER, V )

! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)
! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)

  V(414) = V_USER(1)
  V(446) = V_USER(2)
  V(466) = V_USER(3)
  V(386) = V_USER(4)
  V(395) = V_USER(5)
  V(457) = V_USER(6)
  V(469) = V_USER(7)
  V(452) = V_USER(8)
  V(440) = V_USER(9)
  V(381) = V_USER(10)
  V(383) = V_USER(13)
  V(5) = V_USER(14)
  V(468) = V_USER(15)
  V(471) = V_USER(16)
  V(454) = V_USER(17)
  V(423) = V_USER(18)
  V(409) = V_USER(19)
  V(433) = V_USER(20)
  V(403) = V_USER(21)
  V(426) = V_USER(22)
  V(424) = V_USER(23)
  V(416) = V_USER(24)
  V(396) = V_USER(25)
  V(391) = V_USER(26)
  V(436) = V_USER(28)
  V(453) = V_USER(29)
  V(428) = V_USER(30)
  V(455) = V_USER(31)
  V(1) = V_USER(32)
  V(434) = V_USER(33)
  V(449) = V_USER(34)
  V(463) = V_USER(35)
  V(441) = V_USER(36)
  V(392) = V_USER(37)
  V(408) = V_USER(38)
  V(432) = V_USER(39)
  V(418) = V_USER(40)
  V(382) = V_USER(41)
  V(421) = V_USER(42)
  V(430) = V_USER(43)
  V(412) = V_USER(44)
  V(411) = V_USER(45)
  V(410) = V_USER(46)
  V(384) = V_USER(47)
  V(362) = V_USER(48)
  V(6) = V_USER(49)
      
END SUBROUTINE Shuffle_user2kpp

! End of Shuffle_user2kpp function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_kpp2user - function to restore concentrations from KPP to USER
!   Arguments :
!      V         - Concentrations of variable species (local)
!      V_USER    - Concentration of variable species in USER's order
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_kpp2user ( V, V_USER )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)

  V_USER(1) = V(414)
  V_USER(2) = V(446)
  V_USER(3) = V(466)
  V_USER(4) = V(386)
  V_USER(5) = V(395)
  V_USER(6) = V(457)
  V_USER(7) = V(469)
  V_USER(8) = V(452)
  V_USER(9) = V(440)
  V_USER(10) = V(381)
  V_USER(13) = V(383)
  V_USER(14) = V(5)
  V_USER(15) = V(468)
  V_USER(16) = V(471)
  V_USER(17) = V(454)
  V_USER(18) = V(423)
  V_USER(19) = V(409)
  V_USER(20) = V(433)
  V_USER(21) = V(403)
  V_USER(22) = V(426)
  V_USER(23) = V(424)
  V_USER(24) = V(416)
  V_USER(25) = V(396)
  V_USER(26) = V(391)
  V_USER(28) = V(436)
  V_USER(29) = V(453)
  V_USER(30) = V(428)
  V_USER(31) = V(455)
  V_USER(32) = V(1)
  V_USER(33) = V(434)
  V_USER(34) = V(449)
  V_USER(35) = V(463)
  V_USER(36) = V(441)
  V_USER(37) = V(392)
  V_USER(38) = V(408)
  V_USER(39) = V(432)
  V_USER(40) = V(418)
  V_USER(41) = V(382)
  V_USER(42) = V(421)
  V_USER(43) = V(430)
  V_USER(44) = V(412)
  V_USER(45) = V(411)
  V_USER(46) = V(410)
  V_USER(47) = V(384)
  V_USER(48) = V(362)
  V_USER(49) = V(6)
      
END SUBROUTINE Shuffle_kpp2user

! End of Shuffle_kpp2user function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! GetMass - compute total mass of selected atoms
!   Arguments :
!      CL        - Concentration of all species (local)
!      Mass      - value of mass balance
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE GetMass ( CL, Mass )

! CL - Concentration of all species (local)
  REAL(kind=dp) :: CL(NSPEC)
! Mass - value of mass balance
  REAL(kind=dp) :: Mass(1)

      
END SUBROUTINE GetMass

! End of GetMass function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE messy_mecca_kpp_Util

