#!/usr/bin/env python
# -*- coding: utf-8 -*-

# see also ~/python/graph-tool/maxflow.py and ~/python/graph-tool/Fe.py

##############################################################################

import re
import graph_tool.all as gt

HLINE =  '-' * 78
DEBUG = False #True
BIPART = True # create also bipartite graph for Gupta analysis?

##############################################################################

def load_and_plot(xmlgzfile):
    g = gt.load_graph(xmlgzfile)
    gt.graphviz_draw(g,
                     gprops={'concentrate':'true', 'rankdir':'LR',
                             'splines':'spline',
                             'size':'40,20'},
                     vprops={'shape':'oval',
                             'fontsize':10,
                             'style':'filled',
                             'label':g.vp.name},
                     eprops={'label':g.ep.eqntag,
                             'dir':'forward', # forward arrows
                             'arrowhead':'normal',
                             'arrowsize':1,
                             'fontsize':10,
                             'color':'blue',
                             'penwidth':1},
                     overlap='compress',
                     vcolor='yellow', # vertex fill color
                     output='define_graph.pdf')

##############################################################################

def n2v(species_name): # n2v = name to vertex
    vertex = gt.find_vertex(g, g.vp.name, species_name)
    if (len(vertex)==1):
        return vertex[0] # return a vertex
    else:
        print 'ERROR: %s is duplicate or missing' % (species_name)

##############################################################################

# some functions for bipartite graphs for Gupta analysis:

def bipart_insertEdges(reactants, products, eqntag):
    rxnnum = -1-rxnlist.index(eqntag)
    for reactant in reactants:
        if (not reactant=='hv'):
            print >> HPPFILE, 'G.insertEdges(%4d, %4d, 1); // %s: %s ->' % (
                spclist.index(reactant)+1, rxnnum, eqntag, reactant)
    for product in products:
        # remove stoichiometric factor:
        prod  = re.sub('^[0-9.]+', '', product)
        print >> HPPFILE, 'G.insertEdges(%4d, %4d, 2); // %s: -> %s' % (
            spclist.index(prod)+1, rxnnum, eqntag, prod)
    print >> HPPFILE, 'G.insertIrreversibleRxns(%4d, SLOW); // %s' % (
        rxnnum, eqntag)

def bipart_insertPairedRxns():
    print 'G.insertPairedRxns(%d, %d, %d);' % ()

def bipart_insertSpeciesName(spc_name):
    # if not hasattr(bipart_insertSpeciesName, 'counter'):
    #     bipart_insertSpeciesName.counter = 1
    # else:
    #     bipart_insertSpeciesName.counter += 1
    # spc_num = bipart_insertSpeciesName.counter
    # print >> HPPFILE, 'G.insertSpeciesName(%4d, "%s")' % (
    #     spc_num, spc_name)
    print >> HPPFILE, 'G.insertSpeciesName(%4d, "%s");' % (
        spclist.index(spc_name)+1, spc_name)
                
##############################################################################

if __name__ == '__main__':

    #-------------------------------------------------------------------------
    # init graph:
    g = gt.Graph()
    # make internal property maps:
    g.vp.name  = g.new_vertex_property('string')
    g.vp.atoms = g.new_vertex_property('string') 
    g.ep.reaction  = g.new_edge_property('string')
    g.ep.eqntag    = g.new_edge_property('string')
    g.ep.prodstoic = g.new_edge_property('double') # stoic factor of product
    if DEBUG: g.list_properties()
    if (BIPART): HPPFILE = open('mecca.hpp','w')
    #-------------------------------------------------------------------------
    # create a list of species; add only those species to the list that
    # actually occur in the mechanism, i.e. for which ind_XYZ is not zero:
    spclist = []
    PARAMFILE = open('messy_mecca_kpp_parameters.f90')
    for line in iter(PARAMFILE):
        # is current line something like 'INTEGER ... ind_XYZ = nnn' with nnn != 0 ?
        search_result = re.search( r'INTEGER.*ind_([A-Za-z0-9_]+) = [^0]', line)
        if (search_result): # skip lines that do not define a species
            species = search_result.group(1)
            if (species[0:2]!='RR'): # ignore RR* rxn rate pseudo-species:
                spclist.append(species)
        #if DEBUG: print '|%s|, |%s|' % (search_result.group(1), search_result.group())
    PARAMFILE.close()
    #if DEBUG: print spclist
    #-------------------------------------------------------------------------
    # get elemental composition from *.spc file:
    SPCFILE = open('mecca.spc')
    for line in iter(SPCFILE):
        search_result = re.search( r'^ *([A-z0-9_]+) *=([A-z0-9+ ]+);', line)
        if (not search_result): # skip lines that do not define a species
            #if DEBUG: print 'NO:  |%s|' % (line)
            continue
        #if DEBUG: print HLINE
        #if DEBUG: print '|%s|' % line
        spc_name = search_result.group(1)
        spc_composition = search_result.group(2).replace(' ','')
        # split composition into atoms and remove whitespace:
        atoms = [x.strip() for x in spc_composition.split('+')]
        #if DEBUG:
        #    print 'ALL: |%s|' % (line)
        #    print 'ALL: |%s|' % (search_result.group())
        #    print '1:   |%s|' % (spc_name)
        #    print '2:   |%s|' % (spc_composition)
        #    for atom in atoms:
        #        print '|%s|' % (atom)
        #---------------------------------------------------------------------
        # add vertex to graph describing this species
        # but ignore RR* rxn rate pseudo-species:
        if ((spc_name in spclist) and (spc_name[0:2]!='RR')):
            #if DEBUG: print 'adding:      %s' % (spc_name)
            newvertex = g.add_vertex()
            g.vp.name[newvertex]  = spc_name
            g.vp.atoms[newvertex] = spc_composition
            if (BIPART): bipart_insertSpeciesName(spc_name)
        #---------------------------------------------------------------------
    SPCFILE.close()
    #-------------------------------------------------------------------------
    # get reactions from *.eqn file:
    rxnlist = []
    EQNFILE = open('mecca.eqn')
    for line in iter(EQNFILE):
        # remove aerosol bin indicator from line:
        line = line.replace('_a##','').replace('##','')
        # delete all comments {...} from line:
        line = re.sub('{[^}]*}', '', line)
        search_result = re.search( r'<([A-Za-z_0-9]+)> *(.*)=(.*):.*;', line)
        if (not search_result): # skip lines that do not define a reaction
            #if DEBUG: print 'NO:  |%s|' % (line)
            continue
        #if DEBUG: print HLINE
        eqntag        = search_result.group(1)
        rxnlist.append(eqntag)
        reactants_str = search_result.group(2).replace(' ','')
        products_str  = search_result.group(3).replace(' ','')
        # remove 1st species if it is a reaction rate dummy RR*+:
        if DEBUG: print 'BEFORE: %s' % (products_str)
        products_str = re.sub('^RR[^+]*\+', '', products_str)
        if DEBUG: print 'AFTER:  %s' % (products_str)
        fullrxn = reactants_str + '->' + products_str
        if DEBUG: print 'FULL: %9s %s' % ('<'+eqntag+'>', fullrxn)
        reactants = reactants_str.split('+')
        #products  = [re.sub('^[0-9.]+', '', x) for x in products_str.split('+')]
        products  = products_str.split('+')
        if DEBUG: print '%10s %s -> %s' % ('<'+eqntag+'>', reactants_str, products_str)
        for reactant in reactants:
            if (reactant=='hv'): continue # ignore pseudo-reactant hv
            for product in products:
                # separate stoichiometric factor:
                search_result = re.search( '^([0-9.]*)(.*)', product)
                stoic = search_result.group(1)
                if (stoic==''):
                    stoic = 1
                else:
                    stoic = float(stoic)
                prod = search_result.group(2)
                if DEBUG: print eqntag, prod, stoic
                # add edge to graph describing this reaction:
                newedge = g.add_edge(g.vertex(n2v(reactant)), g.vertex(n2v(prod)))
                g.ep.reaction[newedge]  = fullrxn
                g.ep.prodstoic[newedge] = stoic
                g.ep.eqntag[newedge]    = eqntag
                if DEBUG: print 'edge: %9s %s -> %s' % ('<'+eqntag+'>', reactant, product)
        if (BIPART): bipart_insertEdges(reactants, products, eqntag)
        #qqq if (BIPART): bipart_insertPairedRxns()
        #---------------------------------------------------------------------
    EQNFILE.close()
    if (BIPART): HPPFILE.close()
    #-------------------------------------------------------------------------

    # save graph to file:
    g.save('mecca_graph.xml.gz')

    # check that saved graph is okay:
    #qqq load_and_plot('mecca_graph.xml.gz')

##############################################################################
