{Time-stamp: <2015-03-12 14:24:15 joec_pa>}

#INCLUDE atoms
Min; {minus (negative charge as pseudo-atom for charge balance)}
Pls; {plus  (positive charge as pseudo-atom for charge balance)}
{end of atom definitions}

{ Species are sorted by elements in the following order:                      }
{ O,H,N,C,Cl,Br,I,S                                                           }
{ organics are sorted by increasing number of C, H, O, N                      }

{ All peroxides are called ROOH, all peroxy radicals are called RO2           }

{ All species are defined here with #DEFVAR as VARIABLES. Some species        }
{ will be turned into FIXED species with #SETFIX in messy_mecca_kpp.kpp       }

{ Lumped species start with the letter "L".                                   }

{ The maximum length for the species name is 13 (15 may also be ok?).         }

{ The species name must not contain the underscore character "_".             }

{ The elemental composition is needed for graphviz (spc_extract.awk) and to   }
{ check the mass balance (check_conservation.pl). There must be spaces        }
{ around the "+" sign but no spaces between a number and the element symbol.  }

{ The name of the species in LaTeX sytax follows after the "@" sign.          }

#DEFVAR

{-----------------------------------------------------------------------------}
{--------------------------------- gas phase ---------------------------------}
{-----------------------------------------------------------------------------}

{------------------------------------- O -------------------------------------}

O1D             =  O                 ; {@O(^1D)}            {O singlet D}
O3P             =  O                 ; {@O(^3P)}            {O triplet P}
O2              = 2O                 ; {@O_2}               {oxygen}
O3              = 3O                 ; {@O_3}               {ozone}

{------------------------------------- H -------------------------------------}

H               =  H                 ; {@H}                 {hydrogen atom}
H2              = 2H                 ; {@H_2}               {hydrogen}
OH              =  H +  O            ; {@OH}                {hydroxyl radical}
HO2             =  H + 2O            ; {@HO_2}              {hydroperoxy radical}
H2O             = 2H +  O            ; {@H_2O}              {water}
H2O2            = 2H + 2O            ; {@H_2O_2}            {hydrogen peroxide}
H2OH2O          = 4H + 2O            ; {@(H_2O)_2}          {water dimer}

{------------------------------------- N -------------------------------------}

N               =            N       ; {@N}                 {nitrogen atom}
N2D             =            N       ; {@N(^2D)}            {N doublet D}
N2              =           2N       ; {@N_2}               {nitrogen}
NH3             = 3H      +  N       ; {@NH_3}              {ammonia}
N2O             =       O + 2N       ; {@N_2O}              {nitrous oxide}
NO              =       O +  N       ; {@NO}                {nitric oxide}
NO2             =      2O +  N       ; {@NO_2}              {nitrogen dioxide}
NO3             =      3O +  N       ; {@NO_3}              {nitrogen trioxide}
N2O5            =      5O + 2N       ; {@N_2O_5}            {dinitrogen pentoxide}
HONO            =  H + 2O +  N       ; {@HONO}              {nitrous acid}
HOONO           =  H + 3O +  N       ; {@HOONO}             {peroxy nitrous acid}
HNO3            =  H + 3O +  N       ; {@HNO_3}             {nitric acid}
HNO4            =  H + 4O +  N       ; {@HNO_4}             {peroxynitric acid}
NH2             = 2H      +  N       ; {@NH_2}              {}
HNO             =  H +  O +  N       ; {@HNO}               {}
NHOH            = 2H +  O +  N       ; {@NHOH}              {}
NH2O            = 2H +  O +  N       ; {@NH_2O}             {}
NH2OH           = 3H +  O +  N       ; {@NH_2OH}            {}

{------------------------------------- C -------------------------------------}

{1C}
CO              =  C       +  O      ; {@CO}                {carbon monoxide}
CO2             =  C       + 2O      ; {@CO_2}              {carbon dioxide}
HCHO            =  C +  2H +  O      ; {@HCHO}              {methanal (formaldehyde)}
HCOOH           =  C +  2H + 2O      ; {@HCOOH}             {formic acid}
CH2OO           =  C +  2H + 2O      ; {@CH_2OO}            {carbonyl oxide - stabilized Criegee Intermediate}
CH3             =  C +  3H           ; {@CH_3}              {methyl radical}
CH3O            =  C +  3H + O       ; {@CH_3O}             {methoxy radical}
CH3O2           =  C +  3H + 2O      ; {@CH_3O_2}           {methylperoxy radical}
HOCH2O2         =  C +  3H + 3O      ; {@HOCH_2O_2}         {hydroxy methyl peroxy radical}
CH4             =  C +  4H           ; {@CH_4}              {methane}
CH3OH           =  C +  4H +  O      ; {@CH_3OH}            {methanol}
CH3OOH          =  C +  4H + 2O      ; {@CH_3OOH}           {methyl peroxide}
HOCH2OOH        =  C +  4H + 3O      ; {@HOCH_2OOH}         {hydroxy methyl hydroperoxide}
HOCH2OH         =  C +  4H + 2O      ; {@HOCH_2OH}          {dyhydroxy methane}
{1C (CHON)}
CH3ONO          =  C +  3H + 2O + N  ; {@CH_3ONO}           {methylnitrite}
CH3NO3          =  C +  3H + 3O + N  ; {@CH_3ONO_2}         {methylnitrate}
CH3O2NO2        =  C +  3H + 4O + N  ; {@CH_3O_2NO_2}       {peroxy methylnitrate}
HOCH2O2NO2      =  C +  3H + 5O + N  ; {@HOCH_2O_2NO_2}     {hydroxy methyl peroxy nitrate}
{1C (lumped)}
LCARBON         =  C + IGNORE        ; {@LCARBON}           {lumped C1 species}
{2C (CHO)}
HCOCO3          = 2C +   H + 4O      ; {@HCOCO_3}           {MCM}
HCOCO3A         = 2C +   H + 4O      ; {@HCOCO_3^\ast}      {MIM3}
C2H2            = 2C +  2H           ; {@C_2H_2}            {MCM: ethyne}
GLYOX           = 2C +  2H + 2O      ; {@GLYOX}             {MCM: CHOCHO = glyoxal}
HCOCO2H         = 2C +  2H + 3O      ; {@HCOCO_2H}          {MCM: oxoethanoic acid}
CHOOCHO         = 2C +  2H + 3O      ; {@CHO(O)CHO}         {formic anhydride}
HCOCO3H         = 2C +  2H + 4O      ; {@HCOCO_3H}          {MCM}
HCOCH2O2        = 2C +  3H + 3O      ; {@HCOCH_2_O2}        {MCM: HCOCH2O2}
CH3CO3          = 2C +  3H + 3O      ; {@CH_3C(O)OO}        {MCM: peroxy acetyl radical}
HOCH2CO3        = 2C +  3H + 4O      ; {@HOCH_2CO_3}        {MCM}
HOOCH2CO3       = 2C +  3H + 5O      ; {@HOOCH_2CO_3}       {MIM3}
C2H4            = 2C +  4H           ; {@C_2H_4}            {MCM: ethene}
CH3CHO          = 2C +  4H +  O      ; {@CH_3CHO}           {MCM: acetaldehyde}
CH3CO2H         = 2C +  4H + 2O      ; {@CH_3COOH}          {MCM: acetic acid}
HOCH2CHO        = 2C +  4H + 2O      ; {@HOCH_2CHO}         {MCM: glycolaldehyde}
CH3CO3H         = 2C +  4H + 3O      ; {@CH_3C(O)OOH}       {MCM: peroxy acetic acid}
HOCH2CO2H       = 2C +  4H + 3O      ; {@HOCH_2CO_2H}       {MCM: hydroxyethanoic acid}
HOCH2CO3H       = 2C +  4H + 4O      ; {@HOCH_2CO_3H}       {MCM}
C2H5O2          = 2C +  5H + 2O      ; {@C_2H_5O_2}         {MCM: ethylperoxy radical}
HOCH2CH2O       = 2C +  5H + 2O      ; {@HOCH_2CH_2O}       {MCM}
HOCH2CH2O2      = 2C +  5H + 3O      ; {@HOCH_2CH_2O_2}     {MCM}
C2H6            = 2C +  6H           ; {@C_2H_6}            {MCM: ethane}
C2H5OOH         = 2C +  6H + 2O      ; {@C_2H_5OOH}         {MCM: ethyl hydro peroxide}
ETHGLY          = 2C +  6H + 2O      ; {@ETHGLY}            {MCM: HOCH2CH2OH}
HYETHO2H        = 2C +  6H + 3O      ; {@HYETHO2H}          {MCM: HOCH2CH2OOH}
{2C (CHON)}
PAN             = 2C +  3H + 5O + N  ; {@PAN}               {MCM: CH3C(O)OONO2 = peroxyacetylnitrate}
PHAN            = 2C +  3H + 6O + N  ; {@PHAN}              {MCM: HOCH2C(O)OONO2}
ETHOHNO3        = 2C +  5H + 4O + N  ; {@ETHOHNO3}          {MCM: HOCH2CH2ONO2}
{3C (CHO)}
C33CO           =  3C +  2H + 3O     ; {@HCOCOCHO}          {MCM}
CHOCOCH2O2      =  3C +  3H + 4O     ; {@HCOCOCH_2O_2}      {MCM}
HCOCH2CO3       =  3C +  3H + 5O     ; {@HCOCH2CO3}         {MCM: HCOCH2CO3}
ALCOCH2OOH      =  3C +  4H + 4O     ; {@HCOCOCH_2OOH}      {MCM}
MGLYOX          =  3C +  4H + 2O     ; {@MGLYOX}            {MCM: CH3COCHO = methylglyoxal}
HOCH2COCHO      =  3C +  4H + 3O     ; {@HOCH2COCHO}        {MCM}
HCOCH2CHO       =  3C +  4H + 3O     ; {@HCOCH2CHO}         {MCM: HCOCH2CHO}
HOCH2COCO2H     =  3C +  4H + 4O     ; {@HOCH2COCO2H}       {MCM}
HCOCH2CO2H      =  3C +  4H + 4O     ; {@HCOCH2CO2H}        {MCM: HCOCH2CO2H}
HCOCH2CO3H      =  3C +  4H + 5O     ; {@HCOCH2CO3H}        {MCM: HCOCH2CO3H}
CH3COCH2O2      =  3C +  5H + 3O     ; {@CH_3COCH_2O_2}     {MCM: peroxyradical from acetone}
HOC2H4CO3       =  3C +  5H + 4O     ; {@HOC_2H_4CO_3}      {MCM: HOC2H4CO3}
C3H6            =  3C +  6H          ; {@C_3H_6}            {MCM: propene}
CH3COCH3        =  3C +  6H +  O     ; {@CH_3COCH_3}        {MCM: acetone}
ACETOL          =  3C +  6H + 2O     ; {@CH_3COCH_2OH}      {MCM: HO-CH2-CO-CH3 = hydroxy acetone}
HYPERACET       =  3C +  6H + 3O     ; {@CH_3COCH_2O_2H}    {MCM: hydroperoxide from CH3COCH2O2}
HOC2H4CO2H      =  3C +  6H + 3O     ; {@HOC2H4CO2H}        {MCM: HOC2H4CO2H}
HOC2H4CO3H      =  3C +  6H + 4O     ; {@HOC2H4CO3H}        {MCM: HOC2H4CO3H}
IC3H7O2         =  3C +  7H + 2O     ; {@iC_3H_7O_2}        {MCM: isopropylperoxy radical}
HYPROPO2        =  3C +  7H + 3O     ; {@HYPROPO2}          {MCM: CH3CH(O2)CH2OH}
C3H8            =  3C +  8H          ; {@C_3H_8}            {MCM: propane}
IC3H7OOH        =  3C +  8H + 2O     ; {@iC_3H_7OOH}        {MCM: isopropyl hydro peroxide}
HYPROPO2H       =  3C +  8H + 3O     ; {@HYPROPO2H}         {MCM: CH3CH(OOH)CH2OH}
{3C (CHON)}
C3PAN2          =  3C +  3H + 6O + N ; {@C_3PAN2}           {MCM}
NOA             =  3C +  5H + 4O + N ; {@NOA}               {MCM: CH3-CO-CH2ONO2 = nitro-oxy-acetone}
C3PAN1          =  3C +  5H + 6O + N ; {@C_3PAN1}           {MCM}
PRONO3BO2       =  3C +  6H + 5O + N ; {@PRONO3BO2}         {MCM: CH3-CH(O2)-CH2ONO2}
IC3H7NO3        =  3C +  7H + 3O + N ; {@iC_3H_7ONO_2}      {MCM: isopropyl nitrate}
PR2O2HNO3       =  3C +  7H + 5O + N ; {@PR2O2HNO3}         {MCM: CH3-CH(OOH)-CH2ONO2}
{4C (CHO)}
C312COCO3       =  4C +  3H + 5O     ; {@C312COCO3}         {MCM}
C4CODIAL        =  4C +  4H + 3O     ; {@C4CODIAL}          {MCM}
CO23C3CHO       =  4C +  4H + 3O     ; {@CH_3COCOCHO}       {MCM}
C312COCO3H      =  4C +  4H + 5O     ; {@C312COCO3H}        {MCM}
CO2H3CHO        =  4C +  5H + 3O     ; {@CO2H3CHO}          {MCM: CH3-CO-CH(OH)-CHO}
MACO3           =  4C +  5H + 3O     ; {@MACO3}             {MCM: CH2=C(CH3)C(O)O2}
BIACETO2        =  4C +  5H + 4O     ; {@CH_3COCOCH_2O_2}   {MCM}
CHOC3COO2       =  4C +  5H + 4O     ; {@CHOC3COO2}         {MCM}
C44O2           =  4C +  5H + 5O     ; {@C44O2}             {MCM}
CO2H3CO3        =  4C +  5H + 5O     ; {@CO2H3CO3}          {MCM: CH3-CO-CH(OH)-C(O)O2}
MACR            =  4C +  6H +  O     ; {@MACR}              {MCM: CH2=C(CH3)CHO = methacrolein}
MVK             =  4C +  6H +  O     ; {@MVK}               {MCM: CH3-CO-CH=CH2 = methyl vinyl ketone}
BIACET          =  4C +  6H + 2O     ; {@BIACET}            {MCM: CH3-CO-CO-CH3}
MACO2H          =  4C +  6H + 2O     ; {@MACO2H}            {MCM: CH2=C(CH3)COOH}
MVKOH           =  4C +  6H + 2O     ; {@MVKOH}             {MCM: CH2=CHC(=O)CH2OH}
MACO3H          =  4C +  6H + 3O     ; {@MACO3H}            {MCM: CH2=C(CH3)C(O)OOH}
BIACETOH        =  4C +  6H + 3O     ; {@BIACETOH}          {MCM: CH3-CO-CO-CH2OH}
C413COOOH       =  4C +  6H + 4O     ; {@C413COOOH}         {MCM}
BIACETOOH       =  4C +  6H + 4O     ; {@CH_3COCOCH_2OOH}   {MCM}
C44OOH          =  4C +  6H + 5O     ; {@C44OOH}            {MCM}
CO2H3CO3H       =  4C +  6H + 5O     ; {@CO2H3CO3H}         {MCM: CH3-CO-CH(OH)-C(O)OOH}
MACRO2          =  4C +  7H + 4O     ; {@MACRO2}            {MCM: HOCH2C(OO)(CH3)CHO}
MEK             =  4C +  8H +  O     ; {@MEK}               {MCM: CH3-CO-CH2-CH3 = methyl ethyl ketone}
HO12CO3C4       =  4C +  8H + 3O     ; {@HO12CO3C4}         {MCM: CH3-CO-CH(OH)-CH2OH}
MACROH          =  4C +  8H + 3O     ; {@MACROH}            {MCM: HOCH2C(OH)(CH3)CHO}
MACROOH         =  4C +  8H + 4O     ; {@MACROOH}           {MCM: HOCH2C(OOH)(CH3)CHO}
NC4H10          =  4C + 10H          ; {@nC_4H_<10>}        {MCM: CH3-CH2-CH2-CH3 = n-butane}
{4C (CHON)}
C312COPAN       =  4C +  3H + 7O + N ; {@C312COPAN}         {MCM}
MPAN            =  4C +  5H + 5O + N ; {@MPAN}              {MCM: CH2=C(CH3)C(O)OONO2 = peroxymethacryloyl nitrate, peroxymethacrylic nitric anhydride}
{4C (lumped)}
LMEKO2          =  4C +  7H + 3O     ; {@LMEKO2}            {CH3-CO-CH2-CH2-OO}
LHMVKABO2       =  4C +  7H + 4O     ; {@LHMVKABO2}         {HOCH2-CH(O2)-CO-CH3 + CH2(O2)-CH(OH)-CO-CH3}
LMVKOHABO2      =  4C +  7H + 5O     ; {@LMVKOHABO2}        {HOCH2-CH(O2)-CO-CH2OH + CH2(O2)-CH(OH)-CO-CH2OH}
LMEKOOH         =  4C +  8H + 3O     ; {@LMEKOOH}           {CH3-CO-CH2-CH2-OOH}
LHMVKABOOH      =  4C +  8H + 4O     ; {@LHMVKABOOH}        {HOCH2-CH(OOH)-CO-CH3 + CH2(OOH)-CH(OH)-CO-CH3}
LMVKOHABOOH     =  4C +  8H + 5O     ; {@LMVKOHABOOH}       {HOCH2-CH(OOH)-CO-CH2OH + CH2(OOH)-CH(OH)-CO-CH2OH}
LC4H9O2         =  4C +  9H + 2O     ; {@LC_4H_9O_2}        {CH3-CH2-CH(O2)-CH3 + CH3-CH2-CH2-CH2O2 MCM: NC4H9O2 and SC4H9O2}
LC4H9OOH        =  4C + 10H + 2O     ; {@LC_4H_9OOH}        {CH3-CH2-CH(OOH)-CH3 + CH3-CH2-CH2-CH2OOH MCM: NC4H9OOH and SC4H9OOH}
LC4H9NO3        =  4C +  9H + 3O + N ; {@LC4H9NO3}          {MCM: NC4H9NO3 and SC4H9NO3}
{5C (CHO)}
CHOC3COCO3      =  5C +  5H + 5O     ; {@CHOC3COCO3}        {MCM}
CO23C4CO3       =  5C +  5H + 5O     ; {@CO23C4CO3}         {MCM}
CO13C4CHO       =  5C +  6H + 3O     ; {@CO13C4CHO}         {MCM}
CO23C4CHO       =  5C +  6H + 3O     ; {@CO23C4CHO}         {MCM}
C513CO          =  5C +  6H + 4O     ; {@C513CO}            {MCM}
CHOC3COOOH      =  5C +  6H + 4O     ; {@CHOC3COOOH}        {MCM}
CO23C4CO3H      =  5C +  6H + 5O     ; {@CO23C4CO3H}        {MCM}
C511O2          =  5C +  7H + 4O     ; {@C511O2}            {MCM}
C512O2          =  5C +  7H + 4O     ; {@C512O2}            {MCM}
C513O2          =  5C +  7H + 5O     ; {@C513O2}            {MCM}
C5H8            =  5C +  8H          ; {@C_5H_8}            {MCM: CH2=C(CH3)CH=CH2 = isoprene}
HCOC5           =  5C +  8H + 2O     ; {@HCOC5}             {MCM: HOCH2-CO-C(CH3)=CH2}
C511OOH         =  5C +  8H + 4O     ; {@C511OOH}           {MCM}
C512OOH         =  5C +  8H + 4O     ; {@C512OOH}           {MCM}
C513OOH         =  5C +  8H + 5O     ; {@C513OOH}           {MCM}
ISOPBO2         =  5C +  9H + 3O     ; {@ISOPBO2}           {MCM: HOCH2-C(CH3)(O2)-CH=CH2}
ISOPDO2         =  5C +  9H + 3O     ; {@ISOPDO2}           {MCM: CH2=C(CH3)CH(O2)-CH2OH}
C59O2           =  5C +  9H + 5O     ; {@C59O2}             {MCM: HOCH2-CO-C(CH3)(O2)-CH2OH}
ISOPAOH         =  5C + 10H + 2O     ; {@ISOPAOH}           {MCM: HOCH2-C(CH3)=CH-CH2OH}
ISOPBOH         =  5C + 10H + 2O     ; {@ISOPBOH}           {MCM: HOCH2-C(CH3)(OH)-CH=CH2}
ISOPDOH         =  5C + 10H + 2O     ; {@ISOPDOH}           {MCM: CH2=C(CH3)CH(OH)-CH2OH}
ISOPBOOH        =  5C + 10H + 3O     ; {@ISOPBOOH}          {MCM: HOCH2-C(CH3)(OOH)-CH=CH2}
ISOPDOOH        =  5C + 10H + 3O     ; {@ISOPDOOH}          {MCM: CH2=C(CH3)CH(OOH)-CH2OH}
C59OOH          =  5C + 10H + 5O     ; {@C59OOH}            {MCM: HOCH2-CO-C(CH3)(OOH)-CH2OH}
C514OOH         =  5C +  8H + 4O     ; {@C514OOH}           {MCM}
C514O2          =  5C +  7H + 4O     ; {@C514O2}            {MCM}
{5C (CHON)}
CHOC3COPAN      =  5C +  5H + 5O + N ; {@CHOC3COPAN}        {MCM}
C5PAN9          =  5C +  5H + 7O + N ; {@C5PAN9}            {MCM}
NC4CHO          =  5C +  7H + 4O + N ; {@NC4CHO}            {MCM: O2NOCH2-C(CH3)=CH-CHO}
NISOPO2         =  5C +  8H + 5O + N ; {@NISOPO2}           {MCM: O2NOCH2-C(CH3)=CH-CH2O2}
ISOPBNO3        =  5C +  9H + 4O + N ; {@ISOPBNO3}          {MCM: HOCH2-C(CH3)(ONO2)-CH=CH2}
ISOPDNO3        =  5C +  9H + 4O + N ; {@ISOPDNO3}          {MCM: CH2=C(CH3)CH(ONO2)-CH2OH}
NISOPOOH        =  5C +  9H + 5O + N ; {@NISOPOOH}          {MCM: O2NOCH2-C(CH3)=CH-CH2OOH}
C514NO3         =  5C +  7H + 5O + N ; {@C514NO3}           {MCM}
{5C (lumped)}
LHC4ACCO3       =  5C +  7H + 4O     ; {@LHC4ACCO3}         {HOCH2-C(CH3)=CH-C(O)O2 + HOCH2-CH=C(CH3)-C(O)O2}
LHC4ACCHO       =  5C +  8H + 2O     ; {@LHC4ACCHO}         {HOCH2-C(CH3)=CH-CHO + HOCH2-CH=C(CH3)-CHO}
LHC4ACCO2H      =  5C +  8H + 3O     ; {@LHC4ACCO2H}        {HOCH2-C(CH3)=CH-C(O)OH + HOCH2-CH=C(CH3)-C(O)OH}
LHC4ACCO3H      =  5C +  8H + 4O     ; {@LHC4ACCO3H}        {HOCH2-C(CH3)=CH-C(O)OOH + HOCH2-CH=C(CH3)-C(O)OOH}
LISOPACO2       =  5C +  9H + 3O     ; {@LISOPACO2}         {HOCH2-C(CH3)=CH-CH2O2 + HOCH2-CH=C(CH3)-CH2O2}
LC578O2         =  5C +  9H + 5O     ; {@LC578O2}           {HOCH2-CH(OH)C(CH3)(O2)-CHO + HOCH2-C(CH3)(O2)-CH(OH)-CHO}
LISOPACOOH      =  5C + 10H + 3O     ; {@LISOPACOOH}        {HOCH2-C(CH3)=CH-CH2OOH + HOCH2-CH=C(CH3)-CH2OOH}
LC578OOH        =  5C + 10H + 5O     ; {@LC578OOH}          {HOCH2-CH(OH)C(CH3)(OOH)-CHO + HOCH2-C(CH3)(OOH)-CH(OH)-CHO}
LC5PAN1719      =  5C +  7H + 6O + N ; {@LC5PAN1719}        {HOCH2-C(CH3)=CH-C(O)OONO2 + HOCH2-CH=C(CH3)C(O)OONO2}
LISOPACNO3      =  5C +  9H + 4O + N ; {@LISOPACNO3}        {HOCH2-C(CH3)=CH-CH2ONO2 + HOCH2-CH=C(CH3)-CH2ONO2}
LNISO3          =  5C + IGNORE   + N ; {@LNISO3}            {C510O2+NC4CO3 = CHO-CH(OH)-C(CH3)(O2)-CH2ONO2 + O2NOCH2-C(CH3)=CH-C(O)O2}
LNISOOH         =  5C + IGNORE   + N ; {@LNISOOH}           {CHO-CH(OH)-C(CH3)(OOH)-CH2ONO2 + O2NOCH2-C(CH3)=CH-C(O)OOH}
{6C (CHO)}
CO235C5CHO      =  6C +  6H + 4O     ; {@CO235C5CHO}        {MCM}
CO235C6O2       =  6C +  7H + 5O     ; {@CO235C6O2}         {MCM}
C614CO          =  6C +  8H + 4O     ; {@C614CO}            {MCM}
CO235C6OOH      =  6C +  8H + 5O     ; {@CO235C6OOH}        {MCM}
C614O2          =  6C +  9H + 5O     ; {@C614O2}            {MCM}
C614OOH         =  6C + 10H + 5O     ; {@C614OOH}           {MCM}
{6C (CHON)}
C614NO3         =  6C +  9H + 6O + N ; {@C614NO3}           {MCM}
{7C (CHO)}
CO235C6CO3      =  7C +  7H + 6O     ; {@CO235C6CO3}        {MCM}
CO235C6CHO      =  7C +  8H + 4O     ; {@CO235C6CHO}        {MCM}
C235C6CO3H      =  7C +  8H + 6O     ; {@C235C6CO3H}        {MCM}
C716O2          =  7C +  9H + 5O     ; {@C716O2}            {MCM}
C716OOH         =  7C + 10H + 5O     ; {@C716OOH}           {MCM}
ROO6R4P         =  7C + 10H + 5O     ; {@ROO6R4P}           {from ref3019}
ROO6R5P         =  7C + 10H + 6O     ; {@ROO6R5P}           {from ref3019}
ROO6R3O         =  7C + 11H + 4O     ; {@ROO6R3O}           {from ref3019}
C721O2          =  7C + 11H + 4O     ; {@C721O2}            {MCM}
C722O2          =  7C + 11H + 5O     ; {@C722O2}            {MCM}
ROO6R3O2        =  7C + 11H + 5O     ; {@ROO6R3O2}          {ROO6R3OO from ref3019}
ROO6R5O2        =  7C + 11H + 7O     ; {@ROO6R5O2}          {ROO6R5OO from ref3019}
C721OOH         =  7C + 12H + 4O     ; {@C721OOH}           {MCM}
C722OOH         =  7C + 12H + 5O     ; {@C722OOH}           {MCM}
ROO6R3OOH       =  7C + 12H + 5O     ; {@ROO6R3OOH}         {from ref3019}
{7C (CHON)}
C7PAN3          =  7C +  7H + 8O + N ; {@C7PAN3}            {MCM}
ROO6R3NO3       =  7C + 11H + 6O + N ; {@ROO6R3NO3}         {from ref3019}
{8C (CHO)}
C8BCO2          =  8C + 11H + 2O     ; {@C8BCO2}            {MCM}
C721CO3         =  8C + 11H + 5O     ; {@C721CO3}           {MCM}
C8BCCO          =  8C + 12H + O      ; {@C8BCCO}            {MCM}
C8BCOOH         =  8C + 12H + 2O     ; {@C8BCOOH}           {MCM}
C721CHO         =  8C + 12H + 3O     ; {@C721CHO}           {MCM}
NORPINIC        =  8C + 12H + 4O     ; {@NORPINIC}          {MCM}
C721CO3H        =  8C + 12H + 5O     ; {@C721CO3H}          {MCM}
C85O2           =  8C + 13H + 3O     ; {@C85O2}             {MCM}
C89O2           =  8C + 13H + 3O     ; {@C89O2}             {MCM}
C811O2          =  8C + 13H + 4O     ; {@C811O2}            {MCM}
C86O2           =  8C + 13H + 4O     ; {@C86O2}             {MCM}
C812O2          =  8C + 13H + 5O     ; {@C812O2}            {MCM}
C813O2          =  8C + 13H + 5O     ; {@C813O2}            {MCM}
C8BC            =  8C + 14H          ; {@C8BC}              {MCM}
C85OOH          =  8C + 14H + 3O     ; {@C85OOH}            {MCM}
C811OOH         =  8C + 14H + 4O     ; {@C811OOH}           {MCM}
C86OOH          =  8C + 14H + 4O     ; {@C86OOH}            {MCM}
C812OOH         =  8C + 14H + 5O     ; {@C812OOH}           {MCM}
C813OOH         =  8C + 14H + 5O     ; {@C813OOH}           {MCM}
C89OOH          =  8C + 14H + 3O     ; {@C89OOH}            {MCM}
C810OOH         =  8C + 14H + 4O     ; {@C810OOH}           {MCM}
C810O2          =  8C + 13H + 4O     ; {@C810O2}            {MCM}
{8C (CHON)}
C8BCNO3         =  8C + 11H + 3O + N ; {@C8BCNO3}           {MCM}
C721PAN         =  8C + 11H + 7O + N ; {@C721PAN}           {MCM}
C89NO3          =  8C + 13H + 4O + N ; {@C89NO3}            {MCM}
C810NO3         =  8C + 14H + 5O     ; {@C810NO3}           {MCM}
{9C (CHO)}
C85CO3          =  9C + 11H + 4O     ; {@C85CO3}            {MCM}
NOPINDCO        =  9C + 12H + 2O     ; {@NOPINDCO}          {MCM}
C85CO3H         =  9C + 12H + 4O     ; {@C85CO3H}           {MCM}
NOPINDO2        =  9C + 13H + 3O     ; {@NOPINDO2}          {MCM}
C89CO3          =  9C + 13H + 4O     ; {@C89CO3}            {MCM}
C811CO3         =  9C + 13H + 5O     ; {@C811CO3}           {MCM}
NOPINONE        =  9C + 14H +  O     ; {@NOPINONE}          {MCM: nopinone}
NOPINOO         =  9C + 14H + 2O     ; {@NOPINOO}           {MCM}
NORPINAL        =  9C + 14H + 2O     ; {@NORPINAL}          {MCM: norpinaldehyde}
C89CO2H         =  9C + 14H + 3O     ; {@C89CO2H}           {MCM}
NOPINDOOH       =  9C + 14H + 3O     ; {@NOPINDOOH}         {MCM}
RO6R3P          =  9C + 14H + 3O     ; {@RO6R3P}            {from ref3019}
C89CO3H         =  9C + 14H + 4O     ; {@C89CO3H}           {MCM}
PINIC           =  9C + 14H + 4O     ; {@PINIC}             {MCM: pinic acid}
C811CO3H        =  9C + 14H + 5O     ; {@C811CO3H}          {MCM}
C96O2           =  9C + 15H + 3O     ; {@C96O2}             {MCM}
C97O2           =  9C + 15H + 4O     ; {@C97O2}             {MCM}
C98O2           =  9C + 15H + 5O     ; {@C98O2}             {MCM}
C96OOH          =  9C + 16H + 3O     ; {@C96OOH}            {MCM}
C97OOH          =  9C + 16H + 4O     ; {@C97OOH}            {MCM}
C98OOH          =  9C + 16H + 5O     ; {@C98OOH}            {MCM}
{9C (CHON)}
C89PAN          =  9C + 13H + 5O + N ; {@C89PAN}            {MCM}
C9PAN2          =  9C + 13H + 6O + N ; {@C9PAN2}            {MCM}
C811PAN         =  9C + 13H + 7O + N ; {@C811PAN}           {MCM}
C96NO3          =  9C + 15H + 4O + N ; {@C96NO3}            {MCM}
C98NO3          =  9C + 15H + 6O + N ; {@C98NO3}            {MCM}
{10C (CHO)}
C109CO          = 10C + 10H + 3O     ; {@C109CO}            {MCM}
PINALO2         = 10C + 13H + 4O     ; {@PINALO2}           {MCM}
PINALOOH        = 10C + 14H + 4O     ; {@PINALOOH}          {MCM}
C109O2          = 10C + 15H + 4O     ; {@C109O2}            {MCM}
C96CO3          = 10C + 15H + 4O     ; {@C96CO3}            {MCM}
C106O2          = 10C + 15H + 5O     ; {@C106O2}            {MCM}
APINENE         = 10C + 16H          ; {@APINENE}           {MCM: alpha pinene}
BPINENE         = 10C + 16H          ; {@BPINENE}           {MCM: beta pinene}
PINAL           = 10C + 16H + 2O     ; {@PINAL}             {MCM: pinonaldehyde}
APINAOO         = 10C + 16H + 3O     ; {@APINAOO}           {stabilized APINOOA, not in MCM}
APINBOO         = 10C + 16H + 3O     ; {@APINBOO}           {MCM}
MENTHEN6ONE     = 10C + 16H + 3O     ; {@MENTHEN6ONE}       {8-OOH-menthen-6-one, Taraborrelli, pers. comm., not from MCM}
PINONIC         = 10C + 16H + 3O     ; {@PINONIC}           {MCM: pinonic acid}
C109OOH         = 10C + 16H + 4O     ; {@C109OOH}           {MCM}
PERPINONIC      = 10C + 16H + 4O     ; {@PERPINONIC}        {MCM}
C106OOH         = 10C + 16H + 5O     ; {@C106OOH}           {MCM}
BPINAO2         = 10C + 17H + 3O     ; {@BPINAO2}           {MCM}
OH2MENTHEN6ONE  = 10C + 17H + 4O     ; {@2OHMENTHEN6ONE}    {2-OH-8-OOH-menthen-6-one, Taraborrelli, pers. comm., not from MCM}
RO6R1O2         = 10C + 17H + 4O     ; {@RO6R1O2}           {cyclo-oxy peroxy radical from BPINENE, ref3019}
ROO6R1O2        = 10C + 17H + 5O     ; {@ROO6R1O2}          {cyclo-peroxy peroxy radical from BPINENE, ref3019}
RO6R3O2         = 10C + 17H + 5O     ; {@RO6R3O2}           {cyclo-oxy peroxy radical from BPINENE, ref3019}
OHMENTHEN6ONEO2 = 10C + 17H + 5O     ; {@OHMENTHEN6ONEO2}   {2-OH-8-OOH_menthen-6-peroxy radical, Taraborrelli, pers. comm., not from MCM}
BPINAOOH        = 10C + 18H + 3O     ; {@BPINAOOH}          {MCM}
RO6R1OOH        = 10C + 18H + 4O     ; {@RO6R1OOH}          {cyclo-oxy hydroperoxide from BPINENE, ref3019}
RO6R3OOH        = 10C + 18H + 5O     ; {@RO6R3OOH}          {cyclo-oxy hydroperoxide from BPINENE, ref3019}
ROO6R1OOH       = 10C + 18H + 5O     ; {@ROO6R1OOH}         {cyclo-peroxy hydroperoxide from BPINENE, ref3019}
{10C (CHON)}
PINALNO3        = 10C + 13H + 5O + N ; {@PINALNO3}          {MCM}
C10PAN2         = 10C + 15H + 6O + N ; {@C10PAN2}           {MCM}
C106NO3         = 10C + 15H + 6O + N ; {@C106NO3}           {MCM}
BPINANO3        = 10C + 17H + 4O + N ; {@BPINANO3}          {MCM}
RO6R1NO3        = 10C + 17H + 5O + N ; {@RO6R1NO3}          {nitrate from cyclo-oxy peroxy radical from BPINENE, ref3019}
RO6R3NO3        = 10C + 17H + 6O + N ; {@RO6R3NO3}          {nitrate from cyclo-oxy peroxy radical from BPINENE, ref3019}
ROO6R1NO3       = 10C + 17H + 6O + N ; {@ROO6R1NO3}         {nitrate from cyclo-peroxy peroxy radical from BPINENE, ref3019}
{10C (lumped)}
LAPINABO2       = 10C + 17H + 3O     ; {@LAPINABO2}         {APINAO2 and APINBO2 lumped (ratio 1:2)}
LAPINABOOH      = 10C + 18H + 3O     ; {@LAPINABOOH}        {APINAOOH and APINBOOH lumped (ratio 1:2)}
LNAPINABO2      = 10C + 16H + 5O + N ; {@LNAPINABO2}        {.65 NAPINAO2 + .35 NAPINBO2}
LNBPINABO2      = 10C + 16H + 5O + N ; {@LNBPINABO2}        {.8 NBPINAO2 + .2 NBPINBO2}
LAPINABNO3      = 10C + 17H + 4O + N ; {@LAPINABNO3}        {APINANO3 and APINBNO3 lumped (ratio 1:2)}
LNAPINABOOH     = 10C + 17H + 5O + N ; {@LNAPINABOOH}       {.65 NAPINAOOH + .35 NAPINBOOH}
LNBPINABOOH     = 10C + 17H + 5O + N ; {@LNBPINABOOH}       {.8 NBPINAO2 + .2 NBPINBO2}

{------------------------------------- F -------------------------------------}

{------------------------------------- Cl ------------------------------------}

Cl              = Cl                 ; {@Cl}                {chlorine atom}
Cl2             = 2Cl                ; {@Cl_2}              {chlorine}
ClO             = Cl + O             ; {@ClO}               {chlorine oxide}
HCl             = H + Cl             ; {@HCl}               {hydrochloric acid}
HOCl            = H + O + Cl         ; {@HOCl}              {hypochlorous acid}
Cl2O2           = 2Cl + 2O           ; {@Cl_2O_2}           {dichlorine dioxide}
OClO            = Cl + 2O            ; {@OClO}              {chlorine dioxide}
ClNO2           = Cl + 2O + N        ; {@ClNO_2}            {nitryl chloride}
ClNO3           = Cl + N + 3O        ; {@ClNO_3}            {chlorine nitrate}
CCl4            = C + 4Cl            ; {@CCl_4}             {tetrachloro methane}
CH3Cl           = C + 3H + Cl        ; {@CH_3Cl}            {chloromethane}
CH3CCl3         = 2C + 3H + 3Cl      ; {@CH_3CCl_3}         {1,1,1-trichloroethane = methyl chloroform = MCF}
CF2Cl2          = C + 2F + 2Cl       ; {@CF_2Cl_2}          {dichlorodifluoromethane = F12}
CFCl3           = C + F + 3Cl        ; {@CFCl_3}            {trichlorofluoromethane = F11}

{------------------------------------- Br ------------------------------------}

Br              = Br                 ; {@Br}                {bromine atom}
Br2             = 2Br                ; {@Br_2}              {bromine}
BrO             = Br + O             ; {@BrO}               {bromine oxide}
HBr             = H + Br             ; {@HBr}               {hydrobromic acid}
HOBr            = H + O + Br         ; {@HOBr}              {hypobromous acid}
BrNO2           = Br + N + 2O        ; {@BrNO_2}            {nitryl bromide}
BrNO3           = Br + N + 3O        ; {@BrNO_3}            {bromine nitrate}
BrCl            = Br + Cl            ; {@BrCl}              {bromine chloride}
CH3Br           = Br + C +3H         ; {@CH_3Br}            {bromomethane}
CF3Br           = Br + 3F + C        ; {@CF_3Br}            {Halon 1301}
CF2ClBr         = Br + 2F + Cl + C   ; {@CF_2ClBr}          {Halon 1211}
CHCl2Br         = C + H + 2Cl + Br   ; {@CHCl_2Br}          {}
CHClBr2         = C + H + Cl + 2Br   ; {@CHClBr_2}          {}
CH2ClBr         = C + 2H + Cl + Br   ; {@CH_2ClBr}          {}
CH2Br2          = C + 2H + 2Br       ; {@CH_2Br_2}          {}
CHBr3           = C + H + 3Br        ; {@CHBr_3}            {}

{------------------------------------- I -------------------------------------}

I               = I                  ; {@I}                 {iodine atomic ground state}
I2              = 2I                 ; {@I_2}               {molecular iodine}
IO              = I + O              ; {@IO}                {iodine monoxide radical}
OIO             = I + 2O             ; {@OIO}               {}
I2O2            = 2O + 2I            ; {@I_2O_2}            {}
HI              = H + I              ; {@HI}                {hydrogen iodide}
HOI             = H + O + I          ; {@HOI}               {hypoiodous acid}
HIO3            = H + I + 3O         ; {@HIO_3}             {}
INO2            = I + N + 2O         ; {@INO_2}             {iodine nitrite}
INO3            = I + N + 3O         ; {@INO_3}             {iodine nitrate}
CH3I            = C + 3H + I         ; {@CH_3I}             {iodomethane}
CH2I2           = C + 2H + 2I        ; {@CH_2I_2}           {diiodomethane}
C3H7I           = 3C + 7H + I        ; {@CH_3CHICH_3}       {2-iodopropane}
ICl             = I + Cl             ; {@ICl}               {iodine chloride}
CH2ClI          = C + 2H + Cl + I    ; {@CH_2ClI}           {chloroiodomethane}
IBr             = I + Br             ; {@IBr}               {iodine bromide}

{------------------------------------- S -------------------------------------}

S               = S                  ; {@S}                 {sulfur atomic ground state}
SO              = S + O              ; {@SO}                {sulfur monoxide}
SO2             = S + 2O             ; {@SO_2}              {sulfur dioxide}
SO3             = S + 3O             ; {@SO_3}              {sulfur trioxide}
SH              = S + H              ; {@SH}                {}
H2SO4           = 2H + S + 4O        ; {@H_2SO_4}           {sulfuric acid}
CH3SO3H         = C + 4H + S + 3O    ; {@CH_3SO_3H}         {MSA: methane sulfonic acid}
DMS             = 2C + 6H + S        ; {@DMS}               {dimethyl sulfide}
DMSO            = 2C + 6H + S + O    ; {@DMSO}              {dimethyl sulfoxide: CH3SOCH3}
CH3SO2          = C + 3H + S + 2O    ; {@CH_3SO_2}          {}
CH3SO3          = C + 3H + S + 3O    ; {@CH_3SO_3}          {}
OCS             = C + S + O          ; {@OCS}               {}
SF6             = S + 6F             ; {@SF_6}              {sulfur hexaflouride}

{--------------------------------- Hg ----------------------------------------}

Hg              = Hg                 ; {@Hg}                {}
HgO             = Hg + O             ; {@HgO}               {}
HgCl            = Hg + Cl            ; {@HgCl}              {}
HgCl2           = Hg + 2Cl           ; {@HgCl_2}            {}
HgBr            = Hg + Br            ; {@HgBr}              {}
HgBr2           = Hg + 2Br           ; {@HgBr_2}            {}
ClHgBr          = Hg + Cl + Br       ; {@ClHgBr}            {}
BrHgOBr         = Hg + O + 2Br       ; {@BrHgOBr}           {}
ClHgOBr         = Hg + O + Cl + Br   ; {@ClHgOBr}           {}

{--- mz_pj_20070209+}
{------------------------- Pseudo Aerosol ------------------------------------}
NO3m_cs         = N + 3O             ; {@NO_3^-\aq}         {}
Hp_cs           = H                  ; {@H^+\aq}            {}
RGM_cs          = Hg                 ; {@Hg\aq}             {from reactive gaseous Hg}
{--- mz_pj_20070209-}

{------------------------------- Dummies -------------------------------------}

IPART           = IGNORE             ; {@I_<part>}          {iodine particles}
Dummy           = IGNORE             ; {@\dots}             {just a dummy}

{ mz_pj_20070621+}
{------------------------- O3 Budget Tracers (via eval2.3.rpl) ---------------}
O3s             = 3O                 ; {@O_3(s)}            {strat. ozone}
LO3s            = IGNORE             ; {@LO_3(s)}           {lost strat. ozone}
{ mz_pj_20070621-}

{ mz_rs_20100227+}
{only for MIM1, not used in MIM2:}
LHOC3H6O2       = 3C + 7H + 3O       ; {@CH_3CH(O_2)CH_2OH} {hydroxyperoxyradical from propene+OH}
LHOC3H6OOH      = 3C + 8H + 3O       ; {@CH_3CH(OOH)CH_2OH} {C3H6OHOOH = hydroxyhydroperoxides from C3H6}
ISO2            = 5C + 9H + 3O       ; {@ISO2}              {isoprene (hydroxy) peroxy radicals}
ISON            = IGNORE + N         ; {@ISON}              {organic nitrates from ISO2 and C5H8+NO3}
ISOOH           = 5C + 10H + 3O      ; {@ISOOH}             {isoprene (hydro) peroxides}
MVKO2           = 4C + 7H + 4O       ; {@MVKO2}             {MVK/MACR peroxy radicals}
MVKOOH          = 4C + 8H + 4O       ; {@MVKOOH}            {MVK hydroperoxides}
NACA            = 2C + 3H + 4O + N   ; {@NACA}              {nitro-oxy acetaldehyde}
{ mz_rs_20100227-}

{--- mz_ab_20100908+}
{---------------------------------- ions -------------------------------------}
Op              =  O                 ; {@O^+}            {O+}
O2p             =  2O                ; {@O_2^+}          {O2+}
Np              =  N                 ; {@N^+}            {N+}
N2p             =  2N                ; {@N_2^+}          {N2+}
NOp             =  O + N             ; {@NO^+}           {NO+}
Hp              =  H                 ; {@H^+}            {H+}
em              =  IGNORE            ; {@e^-}            {electron}
//ep            =  IGNORE            ; {@e^*}            {photoelectron}
kJmol           =  IGNORE            ; {@kJ/mol}         {released energy}
{--- mz_ab_20100908-}

{ op_kg_20091208+}
{ application of L41 Upper Boundary Parameterisation}
RH2O            = 2H + O             ; {@RH2O}              {H2O reservoir}
RNOy            = N                  ; {@RNO_y}             {NOy reservoir}
RCly            = Cl                 ; {@RCl_y}             {Cly reservoir}
RBr             = Br                 ; {@RBr}               {Br reservoir}
{ op_kg_20091208-}
{ op_kg_20110808: diagnostic species [Loss* ...] are defined via gas_budgets_*.tex }

{ op_pj_20130723+}
{------------------------------ additional diagnostic tracers -----------------}
CFCl3_c         = C + F + 3Cl        ; {@(CFCl_3)_<c>}            {trichlorofluoromethane = F11}
CF2Cl2_c        = C + 2F + 2Cl       ; {@(CF_2Cl_2)_<c>}          {dichlorodifluoromethane = F12}
N2O_c           =       O + 2N       ; {@(N_2O)_<c>}              {nitrous oxide}
CH3CCl3_c       = 2C + 3H + 3Cl      ; {@(CH_3CCl_3)_<c>}         {1,1,1-trichloroethane = methyl chloroform = MCF}
CF2ClBr_c       = Br + 2F + Cl + C   ; {@(CF_2ClBr)_<c>}          {Halon 1211}
CF3Br_c         = Br + 3F + C        ; {@(CF_3Br)_<c>}            {Halon 1301}
{ op_pj_20130723-}

{ mz_at_20131015+ ORACLE rpl needed}
{-----------------------Organic Condesable Gases and VOCs---------------------}
LTERP            =  IGNORE    ; {@LTERP}          {Terpenes}
LALK4            =  IGNORE    ; {@LALK4}          {Alkanes}
LALK5            =  IGNORE    ; {@LALK5}          {Alkanes}
LARO1            =  IGNORE    ; {@LARO1}          {Aromatic VOC}
LARO2            =  IGNORE    ; {@LARO2}          {Aromatic VOC}
LOLE1            =  IGNORE    ; {@LOLE1}          {Olefins}
LOLE2            =  IGNORE    ; {@LOLE2}          {Olefins}
LfPOG01          =  IGNORE    ; {@LfPOG01}        {FF Condensable Gas  1}
LfPOG02          =  IGNORE    ; {@LfPOG02}        {FF Condensable Gas  2}
LfPOG03          =  IGNORE    ; {@LfPOG03}        {FF Condensable Gas  3}
LfPOG04          =  IGNORE    ; {@LfPOG04}        {FF Condensable Gas  4}
LbbPOG01         =  IGNORE    ; {@LbbPOG01}       {BB Condensable Gas  1}
LbbPOG02         =  IGNORE    ; {@LbbPOG02}       {BB Condensable Gas  2}
LbbPOG03         =  IGNORE    ; {@LbbPOG03}       {BB Condensable Gas  3}
LbbPOG04         =  IGNORE    ; {@LbbPOG04}       {BB Condensable Gas  4}
LfSOGsv01        =  IGNORE    ; {@LfSOGsv01}      {sFF Condensable Gas  1}
LbbSOGsv01       =  IGNORE    ; {@LbbSOGsv01}     {sBB Condensable Gas  1}
LfSOGiv01        =  IGNORE    ; {@LfSOGiv01}      {iFF Condensable Gas  1}
LfSOGiv02        =  IGNORE    ; {@LfSOGiv02}      {iFF Condensable Gas  2}
LfSOGiv03        =  IGNORE    ; {@LfSOGiv03}      {iFF Condensable Gas  3}
LbbSOGiv01       =  IGNORE    ; {@LbbSOGiv01}     {iBB Condensable Gas  1}
LbbSOGiv02       =  IGNORE    ; {@LbbSOGiv02}     {iBB Condensable Gas  2}
LbbSOGiv03       =  IGNORE    ; {@LbbSOGiv03}     {iBB Condensable Gas  3}
LbSOGv01         =  IGNORE    ; {@LbSOGv01}       {Bio Condensable Gas  1}
LbSOGv02         =  IGNORE    ; {@LbSOGv02}       {Bio Condensable Gas  2}
LbSOGv03         =  IGNORE    ; {@LbSOGv03}       {Bio Condensable Gas  3}
LbSOGv04         =  IGNORE    ; {@LbSOGv04}       {Bio Condensable Gas  4}
LbOSOGv01        =  IGNORE    ; {@LbOSOGv01}      {Bio Condensable Gas  1}
LbOSOGv02        =  IGNORE    ; {@LbOSOGv02}      {Bio Condensable Gas  2}
LbOSOGv03        =  IGNORE    ; {@LbOSOGv03}      {Bio Condensable Gas  3}
LaSOGv01         =  IGNORE    ; {@LaSOGv01}       {Ant Condensable Gas  1}
LaSOGv02         =  IGNORE    ; {@LaSOGv02}       {Ant Condensable Gas  2}
LaSOGv03         =  IGNORE    ; {@LaSOGv03}       {Ant Condensable Gas  3}
LaSOGv04         =  IGNORE    ; {@LaSOGv04}       {Ant Condensable Gas  4}
LaOSOGv01        =  IGNORE    ; {@LaOSOGv01}      {Ant Condensable Gas  1}
LaOSOGv02        =  IGNORE    ; {@LaOSOGv02}      {Ant Condensable Gas  2}
LaOSOGv03        =  IGNORE    ; {@LaOSOGv03}      {Ant Condensable Gas  3}
{ mz_at_20131015- ORACLE rpl needed}

{ mz_sg_20150919+ PM:PI_TANS experiment }

{ clim. Spivakovsky OH }
 OHc             =  H +  O    ; {@OH}             {Spivakovsky OH}
 OHc0            =  H +  O    ; {@OH}             {"holy" Spivakovsky OH}

{ modulated "interactive" EMAC OH }
 OHm             =  H +  O    ; {@OH}             {modulated Spivakovsky OH}

{ imported + modulated "interactive" EMAC j(ip_CH4) }
 jCH4            =  C + IGNORE; {@(CH_4+hv)}      {imported CH4 photolysis freq.}
 jCH4m           =  C + IGNORE; {@(CH_4+hv)}      {imported modulated CH4 photolysis freq.}

{ CH4 loss PTs }
 PTLO1D          =  C +  4H   ; {@CH_4}           {CH4 O1D sink PT}
 PTLOH           =  C +  4H   ; {@CH_4}           {CH4 O1D sink PT}
 PTLO3P          =  C +  4H   ; {@CH_4}           {CH4 O3P sink PT}
 PTLCl           =  C +  4H   ; {@CH_4}           {CH4 Cl  sink PT}
 PTLhv           =  C +  4H   ; {@CH_4}           {CH4 hv  sink PT}

CH4n             =  C +  4H   ; {@CH_4 C}         {nudged CH4}
 PTLO1Dn         =  C +  4H   ; {@CH_4}           {nudged CH4 O1D sink PT}
 PTLOHn          =  C +  4H   ; {@CH_4}           {nudged CH4 O1D sink PT}
 PTLO3Pn         =  C +  4H   ; {@CH_4}           {nudged CH4 O3P sink PT}
 PTLCln          =  C +  4H   ; {@CH_4}           {nudged CH4 Cl  sink PT}
 PTLhvn          =  C +  4H   ; {@CH_4}           {nudged CH4 hv  sink PT}

{ other methanes and resp. PTs }
CH4t             =  C +  4H   ; {@CH_4t (Tans)}   {Tans CH4}
 PTLOHt          =  C +  4H   ; {@CH_4t OH loss}  {CH4 O1D sink PT}

CH4c             =  C +  4H   ; {@CH_4 C}         {CH4 reacting with clim. "pathed" Spiv. OH}
 PTLO1Dc         =  C +  4H   ; {@CH_4}           {CH4 O1D sink PT}
 PTLOHc          =  C +  4H   ; {@CH_4}           {CH4 O1D sink PT}
 PTLO3Pc         =  C +  4H   ; {@CH_4}           {CH4 O3P sink PT}
 PTLClc          =  C +  4H   ; {@CH_4}           {CH4 Cl  sink PT}
 PTLhvc          =  C +  4H   ; {@CH_4}           {CH4 hv  sink PT}

CH4c0            =  C +  4H   ; {@CH_4 C0}        {CH4 reacting with clim. "holy"  Spiv. OH}
 PTLO1Dc0        =  C +  4H   ; {@CH_4}           {CH4 O1D sink PT}
 PTLOHc0         =  C +  4H   ; {@CH_4}           {CH4 O1D sink PT}
 PTLO3Pc0        =  C +  4H   ; {@CH_4}           {CH4 O3P sink PT}
 PTLClc0         =  C +  4H   ; {@CH_4}           {CH4 Cl  sink PT}
 PTLhvc0         =  C +  4H   ; {@CH_4}           {CH4 hv  sink PT}

CH4m             =  C +  4H   ; {@CH_4 M}         {CH4 reacting with diurnally modulated OH}
 PTLO1Dm         =  C +  4H   ; {@CH_4}           {CH4 O1D sink PT}
 PTLOHm          =  C +  4H   ; {@CH_4}           {CH4 O1D sink PT}
 PTLO3Pm         =  C +  4H   ; {@CH_4}           {CH4 O3P sink PT}
 PTLClm          =  C +  4H   ; {@CH_4}           {CH4 Cl  sink PT}
 PTLhvm          =  C +  4H   ; {@CH_4}           {CH4 hv  sink PT}

{ CH4 effective enrichment est. tracers }
CH4ee            =  C +  4H   ; {@CH_4 ee}        {CH4 eff. enrichment in sink}
 PTLO1Dee        =  C +  4H   ; {@CH_4}           {CH4 O1D sink PT}
 PTLOHee         =  C +  4H   ; {@CH_4}           {CH4 O1D sink PT}
 PTLO3Pee        =  C +  4H   ; {@CH_4}           {CH4 O3P sink PT}
 PTLClee         =  C +  4H   ; {@CH_4}           {CH4 Cl  sink PT}
 PTLhvee         =  C +  4H   ; {@CH_4}           {CH4 hv  sink PT}

{ mz_sg_20150919- PM:TANS experiment }
