# Authors: Sebastian Tauer, Hartwig Harder, Rolf Sander (MPI Mainz, 2017)

# input : only argument given is the input equation file,
# output of the adapted eqn file on is on stdout 

func BinarySearch(array,len,target){  


 	low=0;
 	high=len;
 	while(low<high){
             	    
        mid=int((low+high)/2);
             	    
        if(array[mid]==target) return mid;             		
        
        else if(array[mid]>target)high=mid-1;
        
        else low=mid+1;
    }
    return high;
}

BEGIN {
    dontedit = "This file was created automatically by mcm2mecca.awk, DO NOT EDIT!"
    printf "// %s\n", dontedit > unkfile
    printf "// %s\n", dontedit > eqnfile

    ERR=0
    EQUATION=0
    DEFVAR=0
    INLINE=0

    #init files
    print > photorecfile

    # read in J-Substitution table into array JMatrix
    # first line is header, skip 
    getline line < jsubstfile

    while ( (getline line < jsubstfile) > 0) {
        split(line, Jfeld);
        
        # make use of associative arrays in awk, index of array can be string
        # will be now MCM number, stored in second column
        JMatrix[Jfeld[2]] = Jfeld[1]
               
    }

    # loop rough all found indices in array
    #for (JNum in JMatrix) {
    #    print JNum, JMatrix[JNum]
    #}
    
}

{
    ERR=0
    PHOTO=0
    PHOTOIND=0
    outfile=unkfile;
    #remove leading white space in case of preprocessor command 
    if (match($1,"#")) $1=$1

    #check if reached section of def var
    if (match($0,"#DEFVAR")) {
        INLINE=0
        DEFVAR=1
        EQUATION=0

    }
    
    if(DEFVAR) {
        outfile=spcfile
        #only write if second element is ' = '
        if (match($2,"=")) {
        } else {
            ERR=1
        }
    }

    #check if reached inline global or rconst
    if (match($0,"#INLINE F90_GLOBAL")) {
        INLINE=1
        DEFVAR=0
        EQUATION=0
        ERR=0
   
    }
    if (match($0,"#INLINE F90_RCONST")) {
        INLINE=1
        DEFVAR=0
        EQUATION=0
        ERR=0
    }
    
    
    if(INLINE) {

        outfile=eqnfile;
        
        if (match($NF, "&")){
            multiline=1
        }

        if (multiline) {
            ERR=0
            multiline=0
        }
        if (match($2,"=")) {
            ERR=0
        }
        
        if (match($1,"=")) {
            ERR=1
        }

        if (match($1,"!")) {
            ERR=1
        }

    }

    if (match($0,"#EQUATIONS")) {
        DEFVAR=0
        INLINE=0
        EQUATION=1
        outfile=eqnfile;
    }
    
    #in case of equation section
    if (EQUATION) {
        if (match($1,"[0-9]+",Rnumber)) {
            outfile=eqnfile;
            # get reaction number from the number given by mcm
            gnum="<G_MCM_"Rnumber[0]">"
            
            for (i=1; i<NF;i++)
            {

                # in case of O2 as product missing
                if (match($0," = :")) {
                    gsub("=","= O2",$0)
                    }                
                
                # in case it's a photolysis 
                if (match($i,/J\((.*?)\)+\++J\((.*?)\)/,Jnumber)) {
                    #separating Js
                    gsub("+"," + ",$i)
                    #reassigning field
                    $0=$0
                    i=i-1
                } else {
                    if (match($i,/J\((.*?)\)/,Jnumber)) {
                        #we number the reaction starting with J
                        PHOTO=Jnumber[1]
                        gnum="<J_MCM_"Rnumber[0]">"
                        #we assign the photolysis index on ip_MCM_#
                        $i=JMatrix[PHOTO]
                        PHOTOIND=1
                        printf PHOTO " " >> photorecfile
                    }
                }
            }
            
            #replace the inital eq. number
            $1=gnum
            
            #append MCM as reference
            sub(";","; {\\&MCM}",$0)
            if (PHOTO>0) {
                #photolysis reaction get a hv as reaction partner
                sub("="," + hv =",$0)
                # and become J and Tr G as a eq attribute 
                sub(":",": {%TrGJ}",$0)
            } else {
                # normal gas phase reactions become Tr and G as a eq attribute 
                sub(":",": {%TrG}",$0)
            }
            if (PHOTOIND==1) {
                print  $0 >> photorecfile
                PHOTOIND=0
            }
        }        
    }

    #  mz_rs_20170529+
    if (match($0,"#INCLUDE atoms")) {
        ERR=1 # suppress standard output, atoms need manual modification
        print "#INCLUDE atoms" > spcfile
        print "Min;" > spcfile
        print "Pls;" > spcfile
    }
    #  mz_rs_20170529-

    if (ERR==0) { # in case no error we print the line
        print $0 >> outfile
    } else {
        outfile=unkfile
        print $0 >> outfile
    }
}


END { }
