{-----------------------------------------------------------------------------}
{------------------------------ aerosol mode: ### -----------------------------}
{-----------------------------------------------------------------------------}

{------------------------------- neutral species -----------------------------}

{------------------------------------- O -------------------------------------}

O2_a##         = 2O                   ; {@O_2\aq}          {oxygen}
O3_a##         = 3O                   ; {@O_3\aq}          {ozone}

{------------------------------------- H -------------------------------------}

OH_a##         =  H +  O              ; {@OH\aq}           {hydroxyl radical}
HO2_a##        =  H + 2O              ; {@HO_2\aq}         {perhydroxyl radical}
H2O_a##        = 2H +  O              ; {@H_2O\aq}         {water}
H2O2_a##       = 2H + 2O              ; {@H_2O_2\aq}       {hydrogen peroxide}

{------------------------------------- N -------------------------------------}

NH3_a##        = 3H      +  N         ; {@NH_3\aq}         {ammonia}
NO_a##         =       O +  N         ; {@NO\aq}           {nitric oxide}
NO2_a##        =      2O +  N         ; {@NO_2\aq}         {nitrogen dioxide}
NO3_a##        =      3O +  N         ; {@NO_3\aq}         {nitrogen trioxide}
HONO_a##       =  H + 2O +  N         ; {@HONO\aq}         {nitrous acid}
HNO3_a##       =  H + 3O +  N         ; {@HNO_3\aq}        {nitric acid}
HNO4_a##       =  H + 4O +  N         ; {@HNO_4\aq}        {pernitric acid}

{------------------------------------- C -------------------------------------}

{1C}
CH3OH_a##      =   C +  4H +   O      ; {@CH_3OH\aq}       {methanol}
HCOOH_a##      =   C +  2H +  2O      ; {@HCOOH\aq}        {formic acid}
HCHO_a##       =   C +  2H +   O      ; {@HCHO\aq}         {methanal (formaldehyde)}
CH3O2_a##      =   C +  3H +  2O      ; {@CH_3OO\aq}       {methylperoxy radical}
CH3OOH_a##     =   C +  4H +  2O      ; {@CH_3OOH\aq}      {}
CO2_a##        =   C       +  2O      ; {@CO_2\aq}         {carbon dioxide}

{2C}
CH3CO2H_a##    =  2C +  4H +  2O      ; {@CH_3COOH\aq}     {acetic acid}
PAN_a##        =  2C +  3H +  5O +  N ; {@PAN\aq}          {peroxyacetylnitrate}
CH3CHO_a##     =  2C +  4H +   O      ; {@CH_3CHO\aq}      {acetaldehyde}

{3C}
CH3COCH3_a##   =  3C +  6H +   O      ; {@CH_3COCH_3\aq}   {acetone}

{------------------------------------- Cl ------------------------------------}

Cl_a##         = Cl                   ; {@Cl\aq}           {chlorine atom}
Cl2_a##        = 2Cl                  ; {@Cl_2\aq}         {molecular chlorine}
HCl_a##        = H + Cl               ; {@HCl\aq}          {hydrogen chloride}
HOCl_a##       = H + O + Cl           ; {@HOCl\aq}         {hypochlorous acid}

{---------------------------------------------------------}

Br_a##         = Br                   ; {@Br\aq}           {bromine atom}
Br2_a##        = 2Br                  ; {@Br_2\aq}         {molecular bromine}
HBr_a##        = H + Br               ; {@HBr\aq}          {hydrogen bromide}
HOBr_a##       = H + O + Br           ; {@HOBr\aq}         {hypobromous acid}
BrCl_a##       = Br + Cl              ; {@BrCl\aq}         {bromine chloride}

{------------------------------------- I -------------------------------------}

I2_a##         = 2I                   ; {@I_2\aq}          {molecular iodine}
IO_a##         = I + O                ; {@IO\aq}           {iodine monoxide radical}
HOI_a##        = H + O + I            ; {@HOI\aq}          {hypoiodous acid}
ICl_a##        = I + Cl               ; {@ICl\aq}          {iodine chloride}
IBr_a##        = I + Br               ; {@IBr\aq}          {iodine bromide}

{------------------------------------- S -------------------------------------}

SO2_a##        = S + 2O               ; {@SO_2\aq}         {sulfur dioxide}
H2SO4_a##      = 2H + S + 4O          ; {@H_2SO_4\aq}      {sulfuric acid}
DMS_a##        = 2C + 6H + S          ; {@DMS\aq}          {dimethyl sulfide: CH3SCH3}
DMSO_a##       = 2C + 6H + S + O      ; {@DMSO\aq}         {dimethyl sulfoxide: CH3SOCH3}

{------------------------------------- Hg ------------------------------------}

Hg_a##         = Hg                   ; {@Hg\aq}           {mercury}
HgO_a##        = Hg + O               ; {@HgO\aq}          {} 
HgOHOH_a##     = Hg + 2O + 2H         ; {@Hg(OH)_2\aq}     {}
HgOHCl_a##     = Hg + O + H + Cl      ; {@Hg(OH)Cl\aq}     {}
HgCl2_a##      = Hg + 2Cl             ; {@HgCl_2\aq}       {}
HgBr2_a##      = Hg + 2Br             ; {@HgBr_2\aq}       {}
HgSO3_a##      = Hg + S + 3O          ; {@HgSO_3\aq}       {}
ClHgBr_a##     = Hg + Cl + Br         ; {@ClHgBr\aq}       {}
BrHgOBr_a##    = Hg + O + 2Br         ; {@BrHgOBr\aq}      {}
ClHgOBr_a##    = Hg + O + Cl + Br     ; {@ClHgOBr\aq}      {}

{----------------------------------- ions ------------------------------------}

{------------------------------------- O -------------------------------------}

O2m_a##        = 2O             + Min ; {@O_2^-\aq}        {}
OHm_a##        =  H +  O        + Min ; {@OH^-\aq}         {}

{------------------------------------- H -------------------------------------}

Hp_a##         =  H             + Pls ; {@H^+\aq}          {}

{------------------------------------- N -------------------------------------}

NH4p_a##       = N + 4H         + Pls ; {@NH_4^+\aq}       {ammonium}
NO2m_a##       =      2O +  N   + Min ; {@NO_2^-\aq}       {nitrite}
NO3m_a##       =      3O +  N   + Min ; {@NO_3^-\aq}       {nitrate}
NO4m_a##       =      4O +  N   + Min ; {@NO_4^-\aq}       {peroxy nitrate}

{------------------------------------- C -------------------------------------}

{1C}
CO3m_a##       = C + 3O         + Min ; {@CO_3^-\aq}       {}
HCOOm_a##      = H + C + 2O     + Min ; {@HCOO^-\aq}       {formate}
HCO3m_a##      = H + C + 3O     + Min ; {@HCO_3^-\aq}      {hydrogen carbonate}

{2C}
CH3COOm_a##    = 2C + 3H + 2O   + Min ; {@CH_3COO^-\aq}    {acetate}

{------------------------------------- Cl ------------------------------------}

Clm_a##        = Cl             + Min ; {@Cl^-\aq}         {chloride}
Cl2m_a##       = 2Cl            + Min ; {@Cl_2^-\aq}       {}
ClOm_a##       = Cl + O         + Min ; {@ClO^-\aq}        {}
ClOHm_a##      = H + O + Cl     + Min ; {@ClOH^-\aq}       {}

{------------------------------------- Br ------------------------------------}

Brm_a##        = Br             + Min ; {@Br^-\aq}         {bromide}
Br2m_a##       = 2Br            + Min ; {@Br_2^-\aq}       {}
BrOm_a##       = Br + O         + Min ; {@BrO^-\aq}        {}
BrOHm_a##      = H + O + Br     + Min ; {@BrOH^-\aq}       {}
BrCl2m_a##     = Br + 2Cl       + Min ; {@BrCl_2^-\aq}     {}
Br2Clm_a##     = 2Br + Cl       + Min ; {@Br_2Cl^-\aq}     {}

{------------------------------------- I -------------------------------------}

Im_a##         = I              + Min ; {@I^-\aq}          {iodide}
IO2m_a##       = I + 2O         + Min ; {@IO_2^-\aq}       {}
IO3m_a##       = I + 3O         + Min ; {@IO_3^-\aq}       {iodate}
ICl2m_a##      = I + 2Cl        + Min ; {@ICl_2^-\aq}      {}
IBr2m_a##      = I + 2Br        + Min ; {@IBr_2^-\aq}      {}

{------------------------------------- S -------------------------------------}

SO3m_a##       = S + 3O          + Min ; {@SO_3^-\aq}       {}
SO3mm_a##      = S + 3O         + 2Min ; {@SO_3^<2->\aq}    {sulfite}
SO4m_a##       = S + 4O          + Min ; {@SO_4^-\aq}       {}
SO4mm_a##      = S + 4O         + 2Min ; {@SO_4^<2->\aq}    {sulfate}
SO5m_a##       = S + 5O          + Min ; {@SO_5^-\aq}       {}
HSO3m_a##      = H + S + 3O      + Min ; {@HSO_3^-\aq}      {hydrogen sulfite}
HSO4m_a##      = H + S + 4O      + Min ; {@HSO_4^-\aq}      {hydrogen sulfate}
HSO5m_a##      = H + S + 5O      + Min ; {@HSO_5^-\aq}      {}
CH3SO3m_a##    = C + 3H + S + 3O + Min ; {@CH_3SO_3^-\aq}   {MSA anion}
CH2OHSO3m_a##  = C + 3H + S + 4O + Min ; {@CH_2OHSO_3^-\aq} {}

{------------------------------------Hg---------------------------------------}

Hgp_a##        = Hg                +  Pls ; {@Hg^+\aq}              {}
Hgpp_a##       = Hg                + 2Pls ; {@Hg^<2+>\aq}           {}
HgOHp_a##      = Hg + O + H        +  Pls ; {@HgOH^+\aq}            {}
HgClp_a##      = Hg + Cl           +  Pls ; {@HgCl^+\aq}            {}
HgBrp_a##      = Hg + Br           +  Pls ; {@HgBr^+\aq}            {}
HgSO32mm_a##   = Hg + 2S + 6O      + 2Min ; {@Hg(SO_3)_2^<2->\aq}   {}

{-----------------------------------------------------------------------------}
{------------------------------------ dummies --------------------------------}
{-----------------------------------------------------------------------------}

D1O_a##        = Ignore              ; {@D_1O\aq}         {}
Nap_a##        = Ignore              ; {@Na^+\aq}         {dummy cation}
