#!/usr/bin/env python
# -*- coding: utf-8 -*-

from os.path import splitext
import sys
import numpy as np
from netCDF4 import Dataset # http://unidata.github.io/netcdf4-python

def txt2nc(filename, verbose=False):
    # read data from *.txt file:
    txtdata = np.genfromtxt(filename+'.txt', names=True, comments='#')
    # write data to *.nc file:
    ncfile = Dataset(filename+'.nc', 'w', format='NETCDF3_CLASSIC')
    # Create dimensions:
    time = ncfile.createDimension('time', None)
    # Create coordinate variables:
    times = ncfile.createVariable('time', np.float64, ('time',))
    times.units = 'seconds since 2000-01-01 00:00:00' # dummy value
    times[:] = range(txtdata.size) # dummy time values 0,1,2,...
    for col,name in enumerate(txtdata.dtype.names):
        if verbose: print '%4d %-10s %e' % (col, name, txtdata[name])
        var = ncfile.createVariable(name, np.float32, ('time',))
        var[:] = txtdata[name]
        ## add some attibutes:
        var.units = 'mol/mol'
        var.long_name = name # a nice long name that describes the data
    ncfile.close()

if __name__ == '__main__':
    if len(sys.argv)>1:
        filename = splitext(sys.argv[1])[0] # without extension
    else:
        filename = 'example_init_spec'
    print 'Converting %s.txt to %s.nc' % (filename, filename)
    txt2nc(filename, verbose=True)
