
C***********************************************************************
C   Portions of Models-3/CMAQ software were developed or based on      *
C   information from various groups: Federal Government employees,     *
C   contractors working on a United States Government contract, and    *
C   non-Federal sources (including research institutions).  These      *
C   research institutions have given the Government permission to      *
C   use, prepare derivative works, and distribute copies of their      *
C   work in Models-3/CMAQ to the public and to permit others to do     *
C   so.  EPA therefore grants similar permissions for use of the       *
C   Models-3/CMAQ software, but users are requested to provide copies  *
C   of derivative works to the Government without restrictions as to   *
C   use by others.  Users are responsible for acquiring their own      *
C   copies of commercial software associated with Models-3/CMAQ and    *
C   for complying with vendor requirements.  Software copyrights by    *
C   the MCNC Environmental Modeling Center are used with their         *
C   permissions subject to the above restrictions.                     *
C***********************************************************************

C:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      SUBROUTINE OPCONC ( CGRID, JDATE, JTIME, TSTEP )

C-----------------------------------------------------------------------
C Function:
C   Create the IO/API netCDF header and open the output CONC file

C Revision history:
C   Jeff - Dec 00 - split out from initscen.F
C                 - move CGRID_MAP into f90 module
C   Jeff - Feb 01 - assumed shape arrays
C   30 Mar 01 J.Young: dyn alloc - Use HGRD_DEFN
C
C    3 Sep 01 David Wong
C     -- let PE 0 open CTM_CONC_1 as new and later on let the rest open
C        it for read and write
C     -- put an explicit barrier before opening a new netCDF file to avoid
C        NCOPEN error
C    7 May 03 J.Young: open and close conc file in processor 0; spin-wait to
C                      deal with nfs network latency for mpich cluster
C   28 Aug 03 J.Young: following Zion Wang at CERT, remove the spin-wait and
C                      simplify opening and closing CONC file (see initscen)
C   31 Jan 05 J.Young: dyn alloc - establish both horizontal & vertical
C                      domain specifications in one module
C
C This file was subsequently modified by Lucas A. J. Bastien. If any,
C parts of Lucas' additions to this code (or all of them) may be based
C on or inspired by pre-existing CMAQ and/or CMAQ adjoint code, with
C possibly some sections copied without modification.
C-----------------------------------------------------------------------

      USE GRID_CONF             ! horizontal & vertical domain specifications
      USE CGRID_SPCS            ! CGRID species number and offsets
      USE ADJPRM                ! Adjoint parameters

      USE SUBST_MODULES         ! stenex
!     USE SUBST_UTIL_MODULE     ! stenex

      IMPLICIT NONE

!     INCLUDE SUBST_HGRD_ID     ! horizontal dimensioning parameters
!     INCLUDE SUBST_VGRD_ID     ! vertical dimensioning parameters
      INCLUDE SUBST_GC_SPC      ! gas chemistry species table
      INCLUDE SUBST_AE_SPC      ! aerosol species table
      INCLUDE SUBST_NR_SPC      ! non-reactive species table
      INCLUDE SUBST_TR_SPC      ! tracer species table
      INCLUDE SUBST_GC_CONC     ! gas chem conc file species and map table
      INCLUDE SUBST_AE_CONC     ! aerosol conc file species and map table
      INCLUDE SUBST_IOPARMS     ! I/O parameters definitions
      INCLUDE SUBST_IOFDESC     ! file header data structure
      INCLUDE SUBST_GC_DIFF   ! gas chem diffusion species and map table
      INCLUDE SUBST_AE_DIFF   ! aerosol diffusion species and map table
      INCLUDE SUBST_NR_DIFF   ! non-react diffusion species and map table
      INCLUDE SUBST_TR_DIFF   ! tracer diffusion species and map table
#include      SUBST_IODECL      # I/O definitions and declarations
      INCLUDE SUBST_FILES_ID    ! file name parameters
!     INCLUDE SUBST_COORD_ID    ! coord. and domain definitions (req IOPARMS)

C Arguments:

!     REAL      :: CGRID( :,:,:,: )  ! for initial CONC
      REAL, POINTER :: CGRID( :,:,:,: )  ! for initial CONC
      INTEGER      JDATE        ! starting date (YYYYDDD)
      INTEGER      JTIME        ! starting time (HHMMSS)
      INTEGER      TSTEP        ! output timestep (HHMMSS)

C External Functions (not already declared by IODECL3.EXT):

      INTEGER, EXTERNAL :: TRIMLEN      !  string length, excl. trailing blanks

C Local Variables:

      REAL, ALLOCATABLE :: DBUFF( :,:,: )
      INTEGER      ALLOCSTAT

      CHARACTER( 16 ) :: PNAME = 'OPCONC'
      CHARACTER( 96 ) :: XMSG = ' '

      INTEGER      LOGDEV

      INTEGER      L, SPC, V    ! loop counters
      INTEGER      STRT, FINI   ! loop counters
      INTEGER      INDX

C     Local variables to temporarily store variable information when
C     creating L5CHK and AL5CHK

      INTEGER :: TMP_SDATE3D, TMP_STIME3D, TMP_TSTEP3D
      CHARACTER(16) :: TMP_UNITS3D(MXVARS3)

C-----------------------------------------------------------------------

C    There is nothing to be done if it is a restart run

      IF (RTO_FWD_RST .OR. RTO_BWD_RST) THEN
         RETURN
      END IF

C     Initialize IOAPI

      LOGDEV = INIT3()

C     Get CGRID offsets

      CALL CGRID_MAP( NSPCSD, GC_STRT, AE_STRT, NR_STRT, TR_STRT )

C     Set output file characteristics based on COORD.EXT and open it

      FTYPE3D = GRDDED3
      SDATE3D = JDATE
      STIME3D = JTIME
      TSTEP3D = TSTEP
!     CALL NEXTIME( SDATE3D, STIME3D, TSTEP3D )
      NVARS3D = N_GC_CONC + N_AE_CONC + N_NR_SPC + N_TR_SPC
      NCOLS3D = GL_NCOLS
      NROWS3D = GL_NROWS
      NLAYS3D = NLAYS
      NTHIK3D =     1
      GDTYP3D = GDTYP_GD
      P_ALP3D = P_ALP_GD
      P_BET3D = P_BET_GD
      P_GAM3D = P_GAM_GD
      XORIG3D = XORIG_GD
      YORIG3D = YORIG_GD
      XCENT3D = XCENT_GD
      YCENT3D = YCENT_GD
      XCELL3D = XCELL_GD
      YCELL3D = YCELL_GD
      VGTYP3D = VGTYP_GD
      VGTOP3D = VGTOP_GD
!     VGTPUN3D = VGTPUN_GD ! currently, not defined
      DO L = 1, NLAYS3D + 1
         VGLVS3D( L ) = VGLVS_GD( L )
      END DO
!     GDNAM3D = GDNAME_GD
      GDNAM3D = GRID_NAME       ! from HGRD_DEFN

      FDESC3D( 1 ) = 'Concentration file output'
      FDESC3D( 2 ) = 'From CMAQ model dyn alloc version CTM'
      DO SPC = 3, MXDESC3
         FDESC3D( SPC ) = ' '
      END DO

      V = 0
      STRT = 1
      FINI = N_GC_CONC
      DO SPC = STRT, FINI
         V = V + 1
         INDX = GC_CONC_MAP( V )
         VTYPE3D( SPC ) = M3REAL
         VNAME3D( SPC ) = GC_SPC( INDX )
         UNITS3D( SPC ) = 'ppmV'
         VDESC3D( SPC ) = 'Variable ' // VNAME3D( SPC )
      END DO

      V = 0
      STRT = FINI + 1           ! STRT = N_GC_CONC + 1
      FINI = N_GC_CONC + N_AE_CONC
      DO SPC = STRT, FINI
         V = V + 1
         INDX = AE_CONC_MAP( V )
         VTYPE3D( SPC ) = M3REAL
         VNAME3D( SPC ) = AE_SPC( INDX ) ! from include file
         IF ( VNAME3D( SPC )(1:3) .EQ. 'NUM' ) THEN
            UNITS3D( SPC ) = 'number/m**3'
         ELSE IF ( VNAME3D( SPC )(1:3) .EQ. 'SRF' ) THEN
            UNITS3D( SPC ) = 'm**2/m**3'
         ELSE
            UNITS3D( SPC ) = 'micrograms/m**3'
         END IF
         VDESC3D( SPC ) = 'Variable ' // VNAME3D( SPC )
      END DO

      V = 0
      STRT = FINI + 1           ! STRT = N_GC_CONC + N_AE_CONC + 1
      FINI = N_GC_CONC + N_AE_CONC + N_NR_SPC ! write all NR species
      DO SPC = STRT, FINI
         V = V + 1
         VTYPE3D( SPC ) = M3REAL
         VNAME3D( SPC ) = NR_SPC( V ) ! from include file
         UNITS3D( SPC ) = 'ppmV'
         VDESC3D( SPC ) = 'Variable ' // VNAME3D( SPC )
      END DO

      V = 0
      STRT = FINI + 1           ! STRT = N_GC_CONC + N_AE_CONC + N_NR_SPC + 1
      FINI = N_GC_CONC + N_AE_CONC + N_NR_SPC + N_TR_SPC ! write all
      DO SPC = STRT, FINI       ! TR species
         V = V + 1
         VTYPE3D( SPC ) = M3REAL
         VNAME3D( SPC ) = TR_SPC( V ) ! from include file
         UNITS3D( SPC ) = 'ppmV'
         VDESC3D( SPC ) = 'Variable ' // VNAME3D( SPC )
      END DO

C     If necessary, create CONC file and write first time step

      IF (.NOT. CHKPROC) THEN

C     Create header

         IF ( MYPE .EQ. 0 ) THEN ! open new
            IF ( .NOT. OPEN3( CTM_CONC_1, FSNEW3, PNAME ) ) THEN
               XMSG = 'Could not open ' // CTM_CONC_1 // ' file'
               CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
            END IF
         END IF

C     Create ACONC file if requested

         IF ((MYPE .EQ. 0) .AND. (TSTEP_ACONC .GT. 0)) THEN
            TMP_TSTEP3D = TSTEP3D
            TSTEP3D = TSTEP_ACONC
            IF (.NOT. OPEN3(A_CONC_1, FSNEW3, PNAME)) THEN
               XMSG = "Could not open " // A_CONC_1 // " file"
               CALL M3EXIT(PNAME, JDATE, JTIME, XMSG, XSTAT1)
            END IF
            TSTEP3D = TMP_TSTEP3D
         END IF

C     Write the initial concentrations as step 0 on the conc file
C     (inital data assumed to be in correct output units)

         ALLOCATE ( DBUFF( MY_NCOLS,MY_NROWS,NLAYS ), STAT = ALLOCSTAT )
         IF ( ALLOCSTAT .NE. 0 ) THEN
            XMSG = 'Failure allocating DBUFF'
            CALL M3EXIT ( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
         END IF

         DO SPC = 1, N_GC_CONC
            V = GC_STRT - 1 + GC_CONC_MAP( SPC )

            DBUFF = CGRID( 1:MY_NCOLS,1:MY_NROWS,1:NLAYS,V )

            IF ( .NOT. WRITE3( CTM_CONC_1, GC_CONC( SPC ),
     &           JDATE, JTIME, DBUFF ) ) THEN
               XMSG = 'Could not write ' //
     &              GC_CONC( SPC )(1:TRIMLEN( GC_CONC( SPC ) ) ) //
     &              ' to ' // CTM_CONC_1
               CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
            END IF

         END DO

         DO SPC = 1, N_AE_CONC
            V = AE_STRT - 1 + AE_CONC_MAP( SPC )

            DBUFF = CGRID( 1:MY_NCOLS,1:MY_NROWS,1:NLAYS,V )

            IF ( .NOT. WRITE3( CTM_CONC_1, AE_CONC( SPC ),
     &           JDATE, JTIME, DBUFF ) ) THEN
               XMSG = 'Could not write ' //
     &              AE_CONC( SPC )(1:TRIMLEN( AE_CONC( SPC ) ) ) //
     &              ' to ' // CTM_CONC_1
               CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
            END IF

         END DO

         V = NR_STRT - 1
         DO SPC = 1, N_NR_SPC
            V = V + 1

            DBUFF = CGRID( 1:MY_NCOLS,1:MY_NROWS,1:NLAYS,V )

            IF ( .NOT. WRITE3( CTM_CONC_1, NR_SPC( SPC ),
     &           JDATE, JTIME, DBUFF ) ) THEN
               XMSG = 'Could not write ' //
     &              NR_SPC( SPC )(1:TRIMLEN( NR_SPC( SPC ) ) ) //
     &              ' to ' // CTM_CONC_1
               CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
            END IF

         END DO

         V = TR_STRT - 1
         DO SPC = 1, N_TR_SPC
            V = V + 1

            DBUFF = CGRID( 1:MY_NCOLS,1:MY_NROWS,1:NLAYS,V )

            IF ( .NOT. WRITE3( CTM_CONC_1, TR_SPC( SPC ),
     &           JDATE, JTIME, DBUFF ) ) THEN
               XMSG = 'Could not write ' //
     &              TR_SPC( SPC )(1:TRIMLEN( TR_SPC( SPC ) ) ) //
     &              ' to ' // CTM_CONC_1
               CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
            END IF

         END DO

         DEALLOCATE ( DBUFF )

         WRITE( LOGDEV, '( /5X, 3( A, :, 1X ), I8, ":", I6.6 )' )
     &        'Timestep written to', CTM_CONC_1( 1:TRIMLEN( CTM_CONC_1 ) ),
     &        'for date and time', JDATE, JTIME
         WRITE( LOGDEV, '(  5X,  A, 1X, I8, ":", I6.6 )' )
     &        'from timestep on initial data files for date and time',
     &        JDATE, JTIME

      ELSE IF (MYPE .EQ. 0) THEN ! CHKPROC: create checkpoint files
                                 ! (first processor only)

         NVARS3D = NVARS3D + 1  ! for air in backward calculations
         SPC = NVARS3D
         VTYPE3D( SPC ) = M3REAL
         VNAME3D( SPC ) = 'RHOJ'
         UNITS3D( SPC ) = 'm'
         VDESC3D( SPC ) = 'advected air density X total Jacobian'

C     If backward loop, we may have to create CONC_L5CHK and/or
C     CONC_AL5CHK

         IF (RTO_BWD) THEN

C     The start date/time is the start date/time for the full
C     simulation, including restarts (save old values in TMP_* variables
C     and restore them afterwards. Units in the *L5CHK files are
C     different from the other CHK files, so follow the same procedure
C     with the units

            TMP_SDATE3D = SDATE3D
            TMP_STIME3D = STIME3D
            SDATE3D = ADJ_STDATE_TOT
            STIME3D = ADJ_STTIME_TOT
            DO SPC = 1, NVARS3D
               TMP_UNITS3D(SPC) = UNITS3D(SPC)
               UNITS3D(SPC) = ADJ_UNITS
            END DO

            IF (RTO_CHK) THEN

               IF ( .NOT. OPEN3( CONC_L5CHK, FSNEW3, PNAME ) ) THEN
                  XMSG = 'Could not open ' // CONC_L5CHK // ' file'
                  CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
               END IF

            END IF

            IF (TSTEP_AL5CHK .GT. 0) THEN

               TMP_TSTEP3D = TSTEP3D
               TSTEP3D = TSTEP_AL5CHK

               IF ( .NOT. OPEN3( CONC_AL5CHK, FSNEW3, PNAME ) ) THEN
                  XMSG = 'Could not open ' // CONC_AL5CHK // ' file'
                  CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
               END IF

               TSTEP3D = TMP_TSTEP3D

            END IF

            IF (L5FCHK_WRITE) THEN

               SDATE3D = L5FCHK_DATE
               STIME3D = L5FCHK_TIME

               IF ( .NOT. OPEN3( CONC_L5FCHK_W, FSNEW3, PNAME ) ) THEN
                  XMSG = 'Could not open ' // CONC_L5FCHK_W // ' file'
                  CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
               END IF

            END IF

            SDATE3D = TMP_SDATE3D
            STIME3D = TMP_STIME3D
            DO SPC = 1, NVARS3D
               UNITS3D(SPC) = TMP_UNITS3D(SPC)
            END DO

         END IF ! RTO_BWD (create L5CHK)

C     If forward loop, create CONC_CHK, CONC_L2CHK, and CONC_L4CHK

         IF (RTO_FWD .AND. RTO_CHK) THEN

            IF ( .NOT. OPEN3( CONC_CHK, FSNEW3, PNAME ) ) THEN
               XMSG = 'Could not open ' // CONC_CHK // ' file'
               CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
            END IF

            IF ( .NOT. OPEN3( CONC_L2CHK, FSNEW3, PNAME ) ) THEN
               XMSG = 'Could not open ' // CONC_L2CHK // ' file'
               CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
            END IF

C     L4CHK only contains variable RHOJ

            SPC = NVARS3D
            NVARS3D = 1
            VTYPE3D(1) = VTYPE3D(SPC)
            VNAME3D(1) = VNAME3D(SPC)
            UNITS3D(1) = UNITS3D(SPC)
            VDESC3D(1) = VDESC3D(SPC)

            IF ( .NOT. OPEN3( CONC_L4CHK, FSNEW3, PNAME ) ) THEN
               XMSG = 'Could not open ' // CONC_L4CHK // ' file'
               CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
            END IF

         END IF

      END IF ! CHKPROC

      RETURN

      END
