
C***********************************************************************
C   Portions of Models-3/CMAQ software were developed or based on      *
C   information from various groups: Federal Government employees,     *
C   contractors working on a United States Government contract, and    *
C   non-Federal sources (including research institutions).  These      *
C   research institutions have given the Government permission to      *
C   use, prepare derivative works, and distribute copies of their      *
C   work in Models-3/CMAQ to the public and to permit others to do     *
C   so.  EPA therefore grants similar permissions for use of the       *
C   Models-3/CMAQ software, but users are requested to provide copies  *
C   of derivative works to the Government without restrictions as to   *
C   use by others.  Users are responsible for acquiring their own      *
C   copies of commercial software associated with Models-3/CMAQ and    *
C   for complying with vendor requirements.  Software copyrights by    *
C   the MCNC Environmental Modeling Center are used with their         *
C   permissions subject to the above restrictions.                     *
C***********************************************************************

C:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      REAL FUNCTION ZFDBC (C1, C2, V1, V2)

c Zero Flux Divergence Boundary Condition (See Jon Pleim's JGR (1991) paper)
c To eliminate reflections and other boundary anomolies
C Problem if V1 is outflow, but V2 is inflow

      IMPLICIT NONE
      REAL SMALL
      PARAMETER (SMALL = 1.0E-03 )   ! for small wind speed (m/s)
      REAL C1, C2, V1, V2

      IF ( ABS( V1 ) .GE. SMALL ) THEN
         IF ( V1 * V2 .GT. 0.0 ) THEN
            ZFDBC = MAX (0.0, C1 - V2 / V1 * (C2 - C1))
            ELSE
            ZFDBC = C1         ! nothing changes for wind divergence at edge
            END IF
         ELSE
         ZFDBC = C1            ! nothing changes for small wind speed
         END IF

      RETURN
      END
