
C***********************************************************************
C   Portions of Models-3/CMAQ software were developed or based on      *
C   information from various groups: Federal Government employees,     *
C   contractors working on a United States Government contract, and    *
C   non-Federal sources (including research institutions).  These      *
C   research institutions have given the Government permission to      *
C   use, prepare derivative works, and distribute copies of their      *
C   work in Models-3/CMAQ to the public and to permit others to do     *
C   so.  EPA therefore grants similar permissions for use of the       *
C   Models-3/CMAQ software, but users are requested to provide copies  *
C   of derivative works to the Government without restrictions as to   *
C   use by others.  Users are responsible for acquiring their own      *
C   copies of commercial software associated with Models-3/CMAQ and    *
C   for complying with vendor requirements.  Software copyrights by    *
C   the MCNC Environmental Modeling Center are used with their         *
C   permissions subject to the above restrictions.                     *
C***********************************************************************

C:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      SUBROUTINE WR_L4CHK ( CGRID, JDATE, JTIME )

C-----------------------------------------------------------------------
C Function:
C     Subroutine to perform writing to the checkpoint file CONC_L4CHK
C
C INPUT:
C     CGRID
C
C Subroutines and functions called:
C     WRITE3() -> NetCDF basic subroutine to read from a file
C
C Revision History:
C     Kumaresh Singh & Sandu,A. Apr 07 - Added to write to CONC_L4CHK
C
C This file was subsequently modified by Lucas A. J. Bastien. If any,
C parts of Lucas' additions to this code (or all of them) may be based
C on or inspired by pre-existing CMAQ and/or CMAQ adjoint code, with
C possibly some sections copied without modification.
C-----------------------------------------------------------------------

      USE GRID_CONF             ! horizontal & vertical domain specifications
      USE CGRID_SPCS            ! CGRID species number and offsets

      IMPLICIT NONE

C     Include Files:

      INCLUDE SUBST_IOPARMS     ! I/O parameters definitions
#include      SUBST_IODECL      # I/O definitions and declarations
      INCLUDE SUBST_FILES_ID    ! I/O definitions and declarations

C     Dummy arguments

      REAL, POINTER, INTENT(IN) :: CGRID( :,:,:,: )
      INTEGER, INTENT(IN) :: JDATE ! current model date, coded YYYYDDD
      INTEGER, INTENT(IN) :: JTIME ! current model time, coded HHMMSS

C     Local variables:

      CHARACTER( 16 ) :: PNAME = "WR_L4CHK"
      CHARACTER( 96 ) :: XMSG = ' '
      INTEGER, SAVE :: LOGDEV ! FORTRAN unit number for log file
      LOGICAL, SAVE :: FIRSTIME = .TRUE.

      IF ( FIRSTIME ) THEN

         FIRSTIME = .FALSE.
         LOGDEV = INIT3 ()

         CALL CGRID_MAP( NSPCSD, GC_STRT, AE_STRT, NR_STRT, TR_STRT )

         IF ( .NOT. OPEN3( CONC_L4CHK, FSRDWR3, PNAME ) ) THEN
            XMSG = 'Could not open ' // CONC_L4CHK // ' file for update'
         END IF

      END IF

      IF ( .NOT. WRITE3( CONC_L4CHK, "RHOJ", JDATE, JTIME,
     &     CGRID( 1:MY_NCOLS,1:MY_NROWS,1:NLAYS,NSPCSD ) ) ) THEN
         XMSG = 'Could not write RHOJ to ' // CONC_L4CHK
         CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
      END IF

      WRITE( LOGDEV, '( /5X, 3( A, :, 1X ), I8, ":", I6.6 )' )
     &      'Timestep written to', CONC_L4CHK,
     &      'for date and time', JDATE, JTIME

      RETURN
      END SUBROUTINE WR_L4CHK
