
C***********************************************************************
C   Portions of Models-3/CMAQ software were developed or based on      *
C   information from various groups: Federal Government employees,     *
C   contractors working on a United States Government contract, and    *
C   non-Federal sources (including research institutions).  These      *
C   research institutions have given the Government permission to      *
C   use, prepare derivative works, and distribute copies of their      *
C   work in Models-3/CMAQ to the public and to permit others to do     *
C   so.  EPA therefore grants similar permissions for use of the       *
C   Models-3/CMAQ software, but users are requested to provide copies  *
C   of derivative works to the Government without restrictions as to   *
C   use by others.  Users are responsible for acquiring their own      *
C   copies of commercial software associated with Models-3/CMAQ and    *
C   for complying with vendor requirements.  Software copyrights by    *
C   the MCNC Environmental Modeling Center are used with their         *
C   permissions subject to the above restrictions.                     *
C***********************************************************************

      SUBROUTINE WALLTIME(TIME)

C     BY: Lucas A. J. Bastien. Parts of this code (or all of it) may be
C     based on or inspired by pre-existing CMAQ and/or CMAQ adjoint
C     code, with possibly some sections copied without modification.
C
C     PURPOSE: Get walltime. The walltime is relative to an arbitrary
C     reference so the usefull quantities are the differences between
C     the outputs of different calls to this routine.
C
C     NOTE: there are two versions of this routine: a serial version and
C     a parallel version.

C     ------------------------------------------------------------------

      IMPLICIT NONE

C     Include file

      INCLUDE SUBST_MPICH

C     Dummy argument

      DOUBLEPRECISION, INTENT(OUT) :: TIME ! walltime

C     ------------------------------------------------------------------

      TIME = MPI_WTIME()

      END SUBROUTINE WALLTIME
