
C***********************************************************************
C   Portions of Models-3/CMAQ software were developed or based on      *
C   information from various groups: Federal Government employees,     *
C   contractors working on a United States Government contract, and    *
C   non-Federal sources (including research institutions).  These      *
C   research institutions have given the Government permission to      *
C   use, prepare derivative works, and distribute copies of their      *
C   work in Models-3/CMAQ to the public and to permit others to do     *
C   so.  EPA therefore grants similar permissions for use of the       *
C   Models-3/CMAQ software, but users are requested to provide copies  *
C   of derivative works to the Government without restrictions as to   *
C   use by others.  Users are responsible for acquiring their own      *
C   copies of commercial software associated with Models-3/CMAQ and    *
C   for complying with vendor requirements.  Software copyrights by    *
C   the MCNC Environmental Modeling Center are used with their         *
C   permissions subject to the above restrictions.                     *
C***********************************************************************

      SUBROUTINE RD_RECEPTOR(RECEPTOR, JDATE, JTIME)

C     BY: Lucas A. J. Bastien. Parts of this code (or all of it) may be
C     based on or inspired by pre-existing CMAQ and/or CMAQ adjoint
C     code, with possibly some sections copied without modification.
C
C     PURPOSE: Read receptor.

C     ------------------------------------------------------------------

C     Modules

      USE GRID_CONF
      USE ADJPRM                ! Adjoint parameters

      IMPLICIT NONE

C     Include Files

      INCLUDE SUBST_IOPARMS     ! I/O parameters definitions
      INCLUDE SUBST_IODECL      ! I/O definitions and declarations
      INCLUDE SUBST_FILES_ID    ! Files logical names

C     Dummy arguments

      REAL, INTENT(INOUT) :: RECEPTOR(NCOLS, NROWS)
      INTEGER, INTENT(IN) :: JDATE ! current model date, coded YYYYDDD
      INTEGER, INTENT(IN) :: JTIME ! current model time, coded HHMMSS

C     Local variables

      CHARACTER(LEN=16) :: PNAME = "RD_RECEPTOR"
      LOGICAL, SAVE :: FIRSTIME = .TRUE.
      INTEGER, SAVE :: LOGDEV
      CHARACTER(LEN=96) :: MSG
      INTEGER, SAVE :: STRTCOL, ENDCOL, STRTROW, ENDROW ! For INTERPX
      INTEGER :: GXOFF, GYOFF                           ! For SUBHFILE

C     ------------------------------------------------------------------

      IF ( FIRSTIME ) THEN
         FIRSTIME = .FALSE.
         LOGDEV = INIT3()

         IF (.NOT. OPEN3(FIL_REC, FSREAD3, PNAME)) THEN
            MSG = "Could not open " // FIL_REC // " file for reading"
            CALL M3EXIT (PNAME, JDATE, JTIME, MSG, XSTAT1)
         END IF

         CALL SUBHFILE(FIL_REC, GXOFF, GYOFF,
     &        STRTCOL, ENDCOL, STRTROW, ENDROW)

      END IF ! FIRSTIME

      IF (.NOT. INTERPX(FIL_REC, REC_VAR, PNAME,
     &     STRTCOL, ENDCOL, STRTROW, ENDROW, 1, 1,
     &     JDATE, JTIME, RECEPTOR)) THEN
         MSG = "Could not read data from " // FIL_REC
         CALL M3EXIT(PNAME, JDATE, JTIME, MSG, XSTAT1)
      END IF

      END SUBROUTINE RD_RECEPTOR
