
C***********************************************************************
C   Portions of Models-3/CMAQ software were developed or based on      *
C   information from various groups: Federal Government employees,     *
C   contractors working on a United States Government contract, and    *
C   non-Federal sources (including research institutions).  These      *
C   research institutions have given the Government permission to      *
C   use, prepare derivative works, and distribute copies of their      *
C   work in Models-3/CMAQ to the public and to permit others to do     *
C   so.  EPA therefore grants similar permissions for use of the       *
C   Models-3/CMAQ software, but users are requested to provide copies  *
C   of derivative works to the Government without restrictions as to   *
C   use by others.  Users are responsible for acquiring their own      *
C   copies of commercial software associated with Models-3/CMAQ and    *
C   for complying with vendor requirements.  Software copyrights by    *
C   the MCNC Environmental Modeling Center are used with their         *
C   permissions subject to the above restrictions.                     *
C***********************************************************************

      SUBROUTINE FIND_LUN(LUN)

C     BY: Lucas A. J. Bastien. Parts of this code (or all of it) may be
C     based on or inspired by pre-existing CMAQ and/or CMAQ adjoint
C     code, with possibly some sections copied without modification.
C
C     This subroutine finds the first logical unit number (LUN) that is
C     not already associated to an opened file. This logical unit number
C     can then be used to open a new file. Note that this approach is
C     faulty in that it allows for race conditions to happen. There is
C     nothing to ensure that the logical unit number doesn't get
C     associated with a file between the moment this subroutine returns
C     and the moment its output LUN is used as intended to (i.e. to open
C     a file).

C     ------------------------------------------------------------------

      IMPLICIT NONE

      INTEGER, INTENT(OUT) :: LUN

      LOGICAL :: IS_OPENED

C     ------------------------------------------------------------------

      LUN = -1
      IS_OPENED = .TRUE.

      DO WHILE (IS_OPENED)

         LUN = LUN + 1
         INQUIRE (UNIT=LUN, OPENED=IS_OPENED)

      END DO

      RETURN

      END SUBROUTINE FIND_LUN
