! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
! Linear Algebra Data and Routines File
!
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
!
! File                 : saprc99ros_LinearAlgebra.f90
! Time                 : Mon Feb  9 17:20:52 2015
! Working directory    :
! Equation file        : saprc99ros.kpp
! Output root filename : saprc99ros
!
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE saprc99ros_LinearAlgebra

  USE saprc99ros_Parameters
  USE saprc99ros_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
! SPARSE_UTIL - SPARSE utility functions
!   Arguments :
!
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecomp( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE saprc99ros_Parameters
  USE saprc99ros_JacobianSP

      INTEGER  :: IER
      REAL(kind=dp) :: JVS(LU_NONZERO), W(NVAR), a
      INTEGER  :: k, kk, j, jj

      a = 0. ! mz_rs_20050606
      IER = 0
      DO k=1,NVAR
        ! mz_rs_20050606: don't check if real value == 0
        ! IF ( JVS( LU_DIAG(k) ) .EQ. 0. ) THEN
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(a) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecomp


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplx( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization, complex
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE saprc99ros_Parameters
  USE saprc99ros_JacobianSP

      INTEGER        :: IER
      DOUBLE COMPLEX :: JVS(LU_NONZERO), W(NVAR), a
      REAL(kind=dp)  :: b = 0.0
      INTEGER        :: k, kk, j, jj

      IER = 0
      DO k=1,NVAR
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(b) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecompCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplxR( JVSR, JVSI, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!    Sparse LU factorization, complex
!   (Real and Imaginary parts are used instead of complex data type)
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE saprc99ros_Parameters
  USE saprc99ros_JacobianSP

      INTEGER       :: IER
      REAL(kind=dp) :: JVSR(LU_NONZERO), JVSI(LU_NONZERO)
      REAL(kind=dp) :: WR(NVAR), WI(NVAR), ar, ai, den
      INTEGER       :: k, kk, j, jj

      IER = 0
      ar  = 0.0
      DO k=1,NVAR
        IF (  ( ABS(JVSR(LU_DIAG(k))) < TINY(ar) ) .AND. &
              ( ABS(JVSI(LU_DIAG(k))) < TINY(ar) ) )  THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              WR( LU_ICOL(kk) ) = JVSR(kk)
              WI( LU_ICOL(kk) ) = JVSI(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            den = JVSR(LU_DIAG(j))**2 + JVSI(LU_DIAG(j))**2
            ar = -(WR(j)*JVSR(LU_DIAG(j)) + WI(j)*JVSI(LU_DIAG(j)))/den
            ai = -(WI(j)*JVSR(LU_DIAG(j)) - WR(j)*JVSI(LU_DIAG(j)))/den
            WR(j) = -ar
            WI(j) = -ai
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               WR( LU_ICOL(jj) ) = WR( LU_ICOL(jj) ) + ar*JVSR(jj) - ai*JVSI(jj)
               WI( LU_ICOL(jj) ) = WI( LU_ICOL(jj) ) + ar*JVSI(jj) + ai*JVSR(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVSR(kk) = WR( LU_ICOL(kk) )
            JVSI(kk) = WI( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecompCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE saprc99ros_Parameters
  USE saprc99ros_JacobianSP

      INTEGER  :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO

END SUBROUTINE KppSolveIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE saprc99ros_Parameters
  USE saprc99ros_JacobianSP

      INTEGER       :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

END SUBROUTINE KppSolveTRIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE saprc99ros_Parameters
  USE saprc99ros_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO

END SUBROUTINE KppSolveCmplx

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE saprc99ros_Parameters
  USE saprc99ros_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), sumr, sumi, den

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1
             XR(i) = XR(i) - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
             XI(i) = XI(i) - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
         END DO
      END DO

      DO i=NVAR,1,-1
        sumr = XR(i); sumi = XI(i)
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
            sumr = sumr - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
            sumi = sumi - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
        END DO
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (sumr*JVSR(LU_DIAG(i)) + sumi*JVSI(LU_DIAG(i)))/den
        XI(i) = (sumi*JVSR(LU_DIAG(i)) - sumr*JVSI(LU_DIAG(i)))/den
      END DO

END SUBROUTINE KppSolveCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE saprc99ros_Parameters
  USE saprc99ros_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

END SUBROUTINE KppSolveTRCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve transpose subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE saprc99ros_Parameters
  USE saprc99ros_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), den

      DO i=1,NVAR
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (XR(i)*JVSR(LU_DIAG(i)) + XI(i)*JVSI(LU_DIAG(i)))/den
        XI(i) = (XI(i)*JVSR(LU_DIAG(i)) - XR(i)*JVSI(LU_DIAG(i)))/den
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO

END SUBROUTINE KppSolveTRCmplxR


!
! Next few commented subroutines perform sparse big linear algebra
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppDecompBig( JVS, IP, IER )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse LU factorization
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE saprc99ros_Parameters
!  USE saprc99ros_JacobianSP
!
!      INTEGER  :: IP3(3), IER, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), W(3,3,NVAR), a(3,3), E(3,3)
!      INTEGER  :: k, kk, j, jj
!
!      a = 0.0d0
!      IER = 0
!      DO k=1,NVAR
!        DO kk = LU_CROW(k), LU_CROW(k+1)-1
!              W( 1:3,1:3,LU_ICOL(kk) ) = JVS(1:3,1:3,kk)
!        END DO
!        DO kk = LU_CROW(k), LU_DIAG(k)-1
!            j = LU_ICOL(kk)
!            E(1:3,1:3) = JVS( 1:3,1:3,LU_DIAG(j) )
!            ! CALL DGETRF(3,3,E,3,IP3,IER)
!            CALL FAC3(E,IP3,IER)
!            IF ( IER /= 0 )  RETURN
!            ! a = W(j) / JVS( LU_DIAG(j) )
!            a(1:3,1:3) = W( 1:3,1:3,j )
!            ! CALL DGETRS ('N',3,3,E,3,IP3,a,3,IER)
!            CALL SOL3('N',E,IP3,a(1,1))
!            CALL SOL3('N',E,IP3,a(1,2))
!            CALL SOL3('N',E,IP3,a(1,3))
!            W(1:3,1:3,j) = a(1:3,1:3)
!            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
!               W( 1:3,1:3,LU_ICOL(jj) ) = W( 1:3,1:3,LU_ICOL(jj) ) &
!                        - MATMUL( a(1:3,1:3) , JVS(1:3,1:3,jj) )
!            END DO
!         END DO
!         DO kk = LU_CROW(k), LU_CROW(k+1)-1
!            JVS(1:3,1:3,kk) = W( 1:3,1:3,LU_ICOL(kk) )
!         END DO
!      END DO
!
!      DO k=1,NVAR
!         ! CALL WGEFA(JVS(1,1,LU_DIAG(k)),3,3,IP(1,k),IER)
!         ! CALL DGETRF(3,3,JVS(1,1,LU_DIAG(k)),3,IP(1,k),IER)
!         CALL FAC3(JVS(1,1,LU_DIAG(k)),IP(1,k),IER)
!         IF ( IER /= 0 )  RETURN
!      END DO
!
!END SUBROUTINE KppDecompBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBig( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse solve subroutine using indirect addressing
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE saprc99ros_Parameters
!  USE saprc99ros_JacobianSP
!
!      INTEGER  :: i, j, k, m, IP3(3), IP(3,NVAR), IER
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR), sum(3)
!
!      DO i=1,NVAR
!        DO j = LU_CROW(i), LU_DIAG(i)-1
!          !X(1:3,i) = X(1:3,i) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       X(k,i) = X(k,i) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO
!      END DO
!
!      DO i=NVAR,1,-1
!        sum(1:3) = X(1:3,i);
!        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
!          !sum(1:3) = sum(1:3) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       sum(k) = sum(k) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO
!        ! X(i) = sum/JVS(LU_DIAG(i));
!        ! CALL DGETRS ('N',3,1,JVS(1:3,1:3,LU_DIAG(i)),3,IP(1,i),sum,3,0)
!        ! CALL WGESL('N',JVS(1,1,LU_DIAG(i)),3,3,IP(1,i),sum)
!        CALL SOL3('N',JVS(1,1,LU_DIAG(i)),IP(1,i),sum)
!        X(1:3,i) = sum(1:3)
!      END DO
!
!END SUBROUTINE KppSolveBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBigTR( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Big sparse transpose solve using indirect addressing
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE saprc99ros_Parameters
!  USE saprc99ros_JacobianSP
!
!      INTEGER       :: i, j, k, m, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR)
!
!      DO i=1,NVAR
!        ! X(i) = X(i)/JVS(LU_DIAG(i))
!        CALL SOL3('T',JVS(1,1,LU_DIAG(i)),IP(1,i),X(1,i))
!        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !    - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!
!      DO i=NVAR, 1, -1
!        DO j=LU_CROW(i),LU_DIAG(i)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !   - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!
!END SUBROUTINE KppSolveBigTR
!
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE FAC3(A,IPVT,INFO)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     FAC3 FACTORS THE MATRIX A (3,3) BY
!!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!!     LINPACK - LIKE
!!
!!     Remove comments to perform pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!
!      REAL(kind=dp) :: A(3,3)
!      INTEGER       :: IPVT(3),INFO
!!      INTEGER       :: L
!!      REAL(kind=dp) :: t, dmax, da, TMP(3)
!      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0
!
!      info = 0
!!      t = TINY(da)
!!
!!      da = ABS(A(1,1)); L = 1
!!      IF ( ABS(A(2,1))>da ) THEN
!!        da = ABS(A(2,1)); L = 2
!!        IF ( ABS(A(3,1))>da ) THEN
!!          L = 3
!!        END IF
!!      END IF
!!      IPVT(1)  = L
!!      IF (L /=1 ) THEN
!!         TMP(1:3) = A(L,1:3)
!!         A(L,1:3) = A(1,1:3)
!!         A(1,1:3) = TMP(1:3)
!!      END IF
!!      IF (ABS(A(1,1)) < t) THEN
!!         info = 1
!!         return
!!      END IF
!!
!      A(2,1) = A(2,1)/A(1,1)
!      A(2,2) = A(2,2) - A(2,1)*A(1,2)
!      A(2,3) = A(2,3) - A(2,1)*A(1,3)
!      A(3,1) = A(3,1)/A(1,1)
!      A(3,2) = A(3,2) - A(3,1)*A(1,2)
!      A(3,3) = A(3,3) - A(3,1)*A(1,3)
!
!!      IPVT(2)  = 2
!!      IF (ABS(A(3,2))>ABS(A(2,2))) THEN
!!         IPVT(2)  = 3
!!         TMP(2:3) = A(3,2:3)
!!         A(3,2:3) = A(2,2:3)
!!         A(2,2:3) = TMP(2:3)
!!      END IF
!!      IF (ABS(A(2,2)) < t) THEN
!!         info = 1
!!         return
!!      END IF
!!
!      A(3,2)   = A(3,2)/A(2,2)
!      A(3,3)   = A(3,3) - A(3,2)*A(2,3)
!      IPVT(3)  = 3
!
!END SUBROUTINE FAC3
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE SOL3(Trans,A,IPVT,b)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     SOL3 solves the system 3x3
!!     A * x = b  or  trans(a) * x = b
!!     using the factors computed by WGEFA.
!!
!!     Trans      = 'N'   to solve  A*x = b ,
!!                = 'T'   to solve  transpose(A)*x = b
!!     LINPACK - LIKE
!!
!!     Remove comments to use pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!      CHARACTER     :: Trans
!      REAL(kind=dp) :: a(3,3),b(3)
!      INTEGER       :: IPVT(3)
!!      INTEGER       :: L
!!      REAL(kind=dp) :: TMP
!
!      SELECT CASE (Trans)
!
!      CASE ('n','N')  !  Solve  A * x = b
!
!!     Solve  L*y = b
!!         L = IPVT(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!         b(2) = b(2)-A(2,1)*b(1)
!         b(3) = b(3)-A(3,1)*b(1)
!
!!         L = IPVT(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(3) = b(3)-A(3,2)*b(2)
!
!!     Solve  U*x = y
!         b(3) = b(3)/A(3,3)
!         b(2) = (b(2)-A(2,3)*b(3))/A(2,2)
!         b(1) = (b(1)-A(1,3)*b(3)-A(1,2)*b(2))/A(1,1)
!
!
!      CASE ('t','T')  !  Solve transpose(A) * x = b
!
!!      Solve transpose(U)*y = b
!         b(1) = b(1)/A(1,1)
!         b(2) = (b(2)-A(1,2)*b(1))/A(2,2)
!         b(3) = (b(3)-A(1,3)*b(1)-A(2,3)*b(2))/A(3,3)
!
!!      Solve transpose(L)*x = y
!         b(2) = b(2)-A(3,2)*b(3)
!!         L = ipvt(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(1) = b(1)-A(3,1)*b(3)-A(2,1)*b(2)
!!         L = ipvt(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!
!      END SELECT
!
!END SUBROUTINE SOL3

! End of SPARSE_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
! KppSolve - sparse back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
!
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolve ( JVS, X )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)

  X(22) = X(22)-JVS(92)*X(21)
  X(32) = X(32)-JVS(126)*X(24)-JVS(127)*X(31)
  X(33) = X(33)-JVS(130)*X(24)-JVS(131)*X(31)
  X(34) = X(34)-JVS(134)*X(24)-JVS(135)*X(31)
  X(35) = X(35)-JVS(139)*X(24)-JVS(140)*X(31)
  X(36) = X(36)-JVS(144)*X(28)
  X(38) = X(38)-JVS(155)*X(24)-JVS(156)*X(31)
  X(39) = X(39)-JVS(162)*X(31)
  X(40) = X(40)-JVS(168)*X(20)-JVS(169)*X(30)-JVS(170)*X(32)-JVS(171)*X(33)-JVS(172)*X(35)
  X(41) = X(41)-JVS(191)*X(24)-JVS(192)*X(31)-JVS(193)*X(32)-JVS(194)*X(33)-JVS(195)*X(34)
  X(42) = X(42)-JVS(203)*X(20)-JVS(204)*X(21)-JVS(205)*X(22)-JVS(206)*X(23)-JVS(207)*X(30)
  X(43) = X(43)-JVS(217)*X(18)-JVS(218)*X(34)-JVS(219)*X(36)-JVS(220)*X(38)-JVS(221)*X(39)-JVS(222)*X(41)
  X(45) = X(45)-JVS(243)*X(20)-JVS(244)*X(24)-JVS(245)*X(31)-JVS(246)*X(32)-JVS(247)*X(33)-JVS(248)*X(35)-JVS(249)*X(39)&
            &-JVS(250)*X(44)
  X(46) = X(46)-JVS(260)*X(34)-JVS(261)*X(39)
  X(48) = X(48)-JVS(277)*X(21)-JVS(278)*X(23)-JVS(279)*X(30)-JVS(280)*X(32)-JVS(281)*X(33)-JVS(282)*X(42)-JVS(283)*X(47)
  X(50) = X(50)-JVS(311)*X(47)
  X(52) = X(52)-JVS(323)*X(47)
  X(54) = X(54)-JVS(335)*X(47)-JVS(336)*X(53)
  X(55) = X(55)-JVS(342)*X(11)-JVS(343)*X(21)-JVS(344)*X(23)-JVS(345)*X(30)-JVS(346)*X(44)-JVS(347)*X(51)-JVS(348)*X(52)&
            &-JVS(349)*X(53)
  X(56) = X(56)-JVS(364)*X(20)-JVS(365)*X(21)-JVS(366)*X(23)-JVS(367)*X(26)-JVS(368)*X(27)-JVS(369)*X(29)-JVS(370)*X(30)&
            &-JVS(371)*X(42)-JVS(372)*X(44)-JVS(373)*X(45)-JVS(374)*X(46)-JVS(375)*X(47)-JVS(376)*X(49)-JVS(377)*X(50)&
            &-JVS(378)*X(51)-JVS(379)*X(52)-JVS(380)*X(53)-JVS(381)*X(54)
  X(57) = X(57)-JVS(400)*X(22)-JVS(401)*X(49)-JVS(402)*X(51)-JVS(403)*X(52)-JVS(404)*X(53)
  X(58) = X(58)-JVS(413)*X(10)-JVS(414)*X(44)-JVS(415)*X(47)-JVS(416)*X(49)-JVS(417)*X(50)-JVS(418)*X(51)-JVS(419)*X(53)&
            &-JVS(420)*X(54)
  X(59) = X(59)-JVS(427)*X(20)-JVS(428)*X(21)-JVS(429)*X(23)-JVS(430)*X(30)-JVS(431)*X(32)-JVS(432)*X(33)-JVS(433)*X(35)&
            &-JVS(434)*X(37)-JVS(435)*X(44)-JVS(436)*X(49)-JVS(437)*X(50)-JVS(438)*X(51)-JVS(439)*X(52)-JVS(440)*X(53)&
            &-JVS(441)*X(54)-JVS(442)*X(57)-JVS(443)*X(58)
  X(60) = X(60)-JVS(455)*X(21)-JVS(456)*X(23)-JVS(457)*X(30)-JVS(458)*X(50)-JVS(459)*X(51)-JVS(460)*X(52)-JVS(461)*X(53)&
            &-JVS(462)*X(54)-JVS(463)*X(57)-JVS(464)*X(58)
  X(61) = X(61)-JVS(475)*X(23)-JVS(476)*X(30)-JVS(477)*X(31)-JVS(478)*X(47)-JVS(479)*X(49)-JVS(480)*X(51)-JVS(481)*X(52)&
            &-JVS(482)*X(53)-JVS(483)*X(54)-JVS(484)*X(57)-JVS(485)*X(58)
  X(62) = X(62)-JVS(498)*X(35)-JVS(499)*X(44)-JVS(500)*X(47)-JVS(501)*X(49)-JVS(502)*X(50)-JVS(503)*X(51)-JVS(504)*X(52)&
            &-JVS(505)*X(53)-JVS(506)*X(54)-JVS(507)*X(58)
  X(63) = X(63)-JVS(518)*X(9)-JVS(519)*X(17)-JVS(520)*X(19)-JVS(521)*X(20)-JVS(522)*X(24)-JVS(523)*X(25)-JVS(524)*X(26)&
            &-JVS(525)*X(27)-JVS(526)*X(28)-JVS(527)*X(29)-JVS(528)*X(31)-JVS(529)*X(32)-JVS(530)*X(33)-JVS(531)*X(35)&
            &-JVS(532)*X(36)-JVS(533)*X(37)-JVS(534)*X(40)-JVS(535)*X(41)-JVS(536)*X(44)-JVS(537)*X(45)-JVS(538)*X(46)&
            &-JVS(539)*X(47)-JVS(540)*X(49)-JVS(541)*X(50)-JVS(542)*X(51)-JVS(543)*X(52)-JVS(544)*X(53)-JVS(545)*X(54)&
            &-JVS(546)*X(55)-JVS(547)*X(56)-JVS(548)*X(57)-JVS(549)*X(58)-JVS(550)*X(59)-JVS(551)*X(60)-JVS(552)*X(61)&
            &-JVS(553)*X(62)
  X(64) = X(64)-JVS(566)*X(20)-JVS(567)*X(21)-JVS(568)*X(23)-JVS(569)*X(24)-JVS(570)*X(30)-JVS(571)*X(31)-JVS(572)*X(47)&
            &-JVS(573)*X(49)-JVS(574)*X(51)-JVS(575)*X(52)-JVS(576)*X(53)-JVS(577)*X(54)-JVS(578)*X(57)-JVS(579)*X(58)&
            &-JVS(580)*X(59)-JVS(581)*X(60)-JVS(582)*X(61)-JVS(583)*X(62)-JVS(584)*X(63)
  X(65) = X(65)-JVS(596)*X(16)-JVS(597)*X(47)-JVS(598)*X(50)-JVS(599)*X(52)-JVS(600)*X(53)-JVS(601)*X(54)-JVS(602)*X(58)&
            &-JVS(603)*X(62)-JVS(604)*X(63)-JVS(605)*X(64)
  X(66) = X(66)-JVS(616)*X(22)-JVS(617)*X(26)-JVS(618)*X(30)-JVS(619)*X(42)-JVS(620)*X(44)-JVS(621)*X(47)-JVS(622)*X(49)&
            &-JVS(623)*X(51)-JVS(624)*X(53)-JVS(625)*X(54)-JVS(626)*X(55)-JVS(627)*X(57)-JVS(628)*X(58)-JVS(629)*X(59)&
            &-JVS(630)*X(60)-JVS(631)*X(61)-JVS(632)*X(62)-JVS(633)*X(63)-JVS(634)*X(64)-JVS(635)*X(65)
  X(67) = X(67)-JVS(645)*X(15)-JVS(646)*X(38)-JVS(647)*X(53)-JVS(648)*X(58)-JVS(649)*X(62)-JVS(650)*X(63)-JVS(651)*X(64)&
            &-JVS(652)*X(65)-JVS(653)*X(66)
  X(68) = X(68)-JVS(662)*X(11)-JVS(663)*X(20)-JVS(664)*X(21)-JVS(665)*X(23)-JVS(666)*X(24)-JVS(667)*X(30)-JVS(668)*X(31)&
            &-JVS(669)*X(32)-JVS(670)*X(33)-JVS(671)*X(34)-JVS(672)*X(35)-JVS(673)*X(37)-JVS(674)*X(39)-JVS(675)*X(44)&
            &-JVS(676)*X(46)-JVS(677)*X(47)-JVS(678)*X(49)-JVS(679)*X(50)-JVS(680)*X(51)-JVS(681)*X(52)-JVS(682)*X(53)&
            &-JVS(683)*X(54)-JVS(684)*X(57)-JVS(685)*X(58)-JVS(686)*X(59)-JVS(687)*X(60)-JVS(688)*X(61)-JVS(689)*X(62)&
            &-JVS(690)*X(63)-JVS(691)*X(64)-JVS(692)*X(65)-JVS(693)*X(66)-JVS(694)*X(67)
  X(69) = X(69)-JVS(702)*X(19)-JVS(703)*X(27)-JVS(704)*X(48)-JVS(705)*X(49)-JVS(706)*X(51)-JVS(707)*X(53)-JVS(708)*X(54)&
            &-JVS(709)*X(56)-JVS(710)*X(57)-JVS(711)*X(58)-JVS(712)*X(60)-JVS(713)*X(61)-JVS(714)*X(62)-JVS(715)*X(63)&
            &-JVS(716)*X(64)-JVS(717)*X(65)-JVS(718)*X(66)-JVS(719)*X(67)-JVS(720)*X(68)
  X(70) = X(70)-JVS(727)*X(13)-JVS(728)*X(14)-JVS(729)*X(15)-JVS(730)*X(16)-JVS(731)*X(18)-JVS(732)*X(19)-JVS(733)*X(22)&
            &-JVS(734)*X(25)-JVS(735)*X(27)-JVS(736)*X(28)-JVS(737)*X(36)-JVS(738)*X(43)-JVS(739)*X(45)-JVS(740)*X(46)&
            &-JVS(741)*X(47)-JVS(742)*X(48)-JVS(743)*X(49)-JVS(744)*X(50)-JVS(745)*X(51)-JVS(746)*X(52)-JVS(747)*X(53)&
            &-JVS(748)*X(54)-JVS(749)*X(55)-JVS(750)*X(56)-JVS(751)*X(57)-JVS(752)*X(58)-JVS(753)*X(59)-JVS(754)*X(60)&
            &-JVS(755)*X(61)-JVS(756)*X(62)-JVS(757)*X(63)-JVS(758)*X(64)-JVS(759)*X(65)-JVS(760)*X(66)-JVS(761)*X(67)&
            &-JVS(762)*X(68)-JVS(763)*X(69)
  X(71) = X(71)-JVS(769)*X(18)-JVS(770)*X(25)-JVS(771)*X(34)-JVS(772)*X(36)-JVS(773)*X(38)-JVS(774)*X(39)-JVS(775)*X(41)&
            &-JVS(776)*X(43)-JVS(777)*X(44)-JVS(778)*X(45)-JVS(779)*X(46)-JVS(780)*X(47)-JVS(781)*X(48)-JVS(782)*X(49)&
            &-JVS(783)*X(50)-JVS(784)*X(51)-JVS(785)*X(52)-JVS(786)*X(53)-JVS(787)*X(54)-JVS(788)*X(55)-JVS(789)*X(56)&
            &-JVS(790)*X(57)-JVS(791)*X(58)-JVS(792)*X(59)-JVS(793)*X(60)-JVS(794)*X(61)-JVS(795)*X(62)-JVS(796)*X(63)&
            &-JVS(797)*X(64)-JVS(798)*X(65)-JVS(799)*X(66)-JVS(800)*X(67)-JVS(801)*X(68)-JVS(802)*X(69)-JVS(803)*X(70)
  X(72) = X(72)-JVS(808)*X(12)-JVS(809)*X(13)-JVS(810)*X(24)-JVS(811)*X(30)-JVS(812)*X(32)-JVS(813)*X(33)-JVS(814)*X(41)&
            &-JVS(815)*X(42)-JVS(816)*X(49)-JVS(817)*X(50)-JVS(818)*X(51)-JVS(819)*X(52)-JVS(820)*X(53)-JVS(821)*X(54)&
            &-JVS(822)*X(55)-JVS(823)*X(57)-JVS(824)*X(58)-JVS(825)*X(59)-JVS(826)*X(60)-JVS(827)*X(61)-JVS(828)*X(62)&
            &-JVS(829)*X(63)-JVS(830)*X(64)-JVS(831)*X(65)-JVS(832)*X(66)-JVS(833)*X(67)-JVS(834)*X(68)-JVS(835)*X(69)&
            &-JVS(836)*X(70)-JVS(837)*X(71)
  X(73) = X(73)-JVS(841)*X(14)-JVS(842)*X(45)-JVS(843)*X(46)-JVS(844)*X(49)-JVS(845)*X(50)-JVS(846)*X(52)-JVS(847)*X(53)&
            &-JVS(848)*X(54)-JVS(849)*X(58)-JVS(850)*X(59)-JVS(851)*X(60)-JVS(852)*X(61)-JVS(853)*X(62)-JVS(854)*X(63)&
            &-JVS(855)*X(64)-JVS(856)*X(65)-JVS(857)*X(66)-JVS(858)*X(67)-JVS(859)*X(68)-JVS(860)*X(69)-JVS(861)*X(70)&
            &-JVS(862)*X(71)-JVS(863)*X(72)
  X(74) = X(74)-JVS(866)*X(9)-JVS(867)*X(10)-JVS(868)*X(11)-JVS(869)*X(17)-JVS(870)*X(19)-JVS(871)*X(20)-JVS(872)*X(21)&
            &-JVS(873)*X(23)-JVS(874)*X(24)-JVS(875)*X(25)-JVS(876)*X(26)-JVS(877)*X(29)-JVS(878)*X(30)-JVS(879)*X(31)&
            &-JVS(880)*X(32)-JVS(881)*X(33)-JVS(882)*X(34)-JVS(883)*X(35)-JVS(884)*X(37)-JVS(885)*X(38)-JVS(886)*X(39)&
            &-JVS(887)*X(40)-JVS(888)*X(41)-JVS(889)*X(42)-JVS(890)*X(43)-JVS(891)*X(44)-JVS(892)*X(45)-JVS(893)*X(46)&
            &-JVS(894)*X(47)-JVS(895)*X(49)-JVS(896)*X(50)-JVS(897)*X(51)-JVS(898)*X(52)-JVS(899)*X(53)-JVS(900)*X(54)&
            &-JVS(901)*X(55)-JVS(902)*X(56)-JVS(903)*X(57)-JVS(904)*X(58)-JVS(905)*X(59)-JVS(906)*X(60)-JVS(907)*X(61)&
            &-JVS(908)*X(62)-JVS(909)*X(63)-JVS(910)*X(64)-JVS(911)*X(65)-JVS(912)*X(66)-JVS(913)*X(67)-JVS(914)*X(68)&
            &-JVS(915)*X(69)-JVS(916)*X(70)-JVS(917)*X(71)-JVS(918)*X(72)-JVS(919)*X(73)
  X(74) = X(74)/JVS(920)
  X(73) = (X(73)-JVS(865)*X(74))/(JVS(864))
  X(72) = (X(72)-JVS(839)*X(73)-JVS(840)*X(74))/(JVS(838))
  X(71) = (X(71)-JVS(805)*X(72)-JVS(806)*X(73)-JVS(807)*X(74))/(JVS(804))
  X(70) = (X(70)-JVS(765)*X(71)-JVS(766)*X(72)-JVS(767)*X(73)-JVS(768)*X(74))/(JVS(764))
  X(69) = (X(69)-JVS(722)*X(70)-JVS(723)*X(71)-JVS(724)*X(72)-JVS(725)*X(73)-JVS(726)*X(74))/(JVS(721))
  X(68) = (X(68)-JVS(696)*X(69)-JVS(697)*X(70)-JVS(698)*X(71)-JVS(699)*X(72)-JVS(700)*X(73)-JVS(701)*X(74))/(JVS(695))
  X(67) = (X(67)-JVS(655)*X(68)-JVS(656)*X(69)-JVS(657)*X(70)-JVS(658)*X(71)-JVS(659)*X(72)-JVS(660)*X(73)-JVS(661)&
            &*X(74))/(JVS(654))
  X(66) = (X(66)-JVS(637)*X(67)-JVS(638)*X(68)-JVS(639)*X(69)-JVS(640)*X(70)-JVS(641)*X(71)-JVS(642)*X(72)-JVS(643)&
            &*X(73)-JVS(644)*X(74))/(JVS(636))
  X(65) = (X(65)-JVS(607)*X(66)-JVS(608)*X(67)-JVS(609)*X(68)-JVS(610)*X(69)-JVS(611)*X(70)-JVS(612)*X(71)-JVS(613)&
            &*X(72)-JVS(614)*X(73)-JVS(615)*X(74))/(JVS(606))
  X(64) = (X(64)-JVS(586)*X(65)-JVS(587)*X(66)-JVS(588)*X(67)-JVS(589)*X(68)-JVS(590)*X(69)-JVS(591)*X(70)-JVS(592)&
            &*X(71)-JVS(593)*X(72)-JVS(594)*X(73)-JVS(595)*X(74))/(JVS(585))
  X(63) = (X(63)-JVS(555)*X(64)-JVS(556)*X(65)-JVS(557)*X(66)-JVS(558)*X(67)-JVS(559)*X(68)-JVS(560)*X(69)-JVS(561)&
            &*X(70)-JVS(562)*X(71)-JVS(563)*X(72)-JVS(564)*X(73)-JVS(565)*X(74))/(JVS(554))
  X(62) = (X(62)-JVS(509)*X(63)-JVS(510)*X(65)-JVS(511)*X(67)-JVS(512)*X(69)-JVS(513)*X(70)-JVS(514)*X(71)-JVS(515)&
            &*X(72)-JVS(516)*X(73)-JVS(517)*X(74))/(JVS(508))
  X(61) = (X(61)-JVS(487)*X(62)-JVS(488)*X(64)-JVS(489)*X(66)-JVS(490)*X(67)-JVS(491)*X(68)-JVS(492)*X(69)-JVS(493)&
            &*X(70)-JVS(494)*X(71)-JVS(495)*X(72)-JVS(496)*X(73)-JVS(497)*X(74))/(JVS(486))
  X(60) = (X(60)-JVS(466)*X(61)-JVS(467)*X(62)-JVS(468)*X(64)-JVS(469)*X(66)-JVS(470)*X(68)-JVS(471)*X(69)-JVS(472)&
            &*X(70)-JVS(473)*X(71)-JVS(474)*X(74))/(JVS(465))
  X(59) = (X(59)-JVS(445)*X(60)-JVS(446)*X(61)-JVS(447)*X(62)-JVS(448)*X(63)-JVS(449)*X(64)-JVS(450)*X(68)-JVS(451)&
            &*X(69)-JVS(452)*X(70)-JVS(453)*X(71)-JVS(454)*X(74))/(JVS(444))
  X(58) = (X(58)-JVS(422)*X(62)-JVS(423)*X(69)-JVS(424)*X(70)-JVS(425)*X(71)-JVS(426)*X(74))/(JVS(421))
  X(57) = (X(57)-JVS(406)*X(58)-JVS(407)*X(62)-JVS(408)*X(64)-JVS(409)*X(69)-JVS(410)*X(70)-JVS(411)*X(71)-JVS(412)&
            &*X(74))/(JVS(405))
  X(56) = (X(56)-JVS(383)*X(57)-JVS(384)*X(58)-JVS(385)*X(60)-JVS(386)*X(61)-JVS(387)*X(62)-JVS(388)*X(63)-JVS(389)&
            &*X(64)-JVS(390)*X(65)-JVS(391)*X(66)-JVS(392)*X(67)-JVS(393)*X(68)-JVS(394)*X(69)-JVS(395)*X(70)-JVS(396)*X(71)&
            &-JVS(397)*X(72)-JVS(398)*X(73)-JVS(399)*X(74))/(JVS(382))
  X(55) = (X(55)-JVS(351)*X(57)-JVS(352)*X(58)-JVS(353)*X(59)-JVS(354)*X(60)-JVS(355)*X(61)-JVS(356)*X(62)-JVS(357)&
            &*X(65)-JVS(358)*X(67)-JVS(359)*X(69)-JVS(360)*X(71)-JVS(361)*X(72)-JVS(362)*X(73)-JVS(363)*X(74))/(JVS(350))
  X(54) = (X(54)-JVS(338)*X(58)-JVS(339)*X(62)-JVS(340)*X(71)-JVS(341)*X(74))/(JVS(337))
  X(53) = (X(53)-JVS(331)*X(58)-JVS(332)*X(62)-JVS(333)*X(71)-JVS(334)*X(74))/(JVS(330))
  X(52) = (X(52)-JVS(325)*X(53)-JVS(326)*X(58)-JVS(327)*X(62)-JVS(328)*X(71)-JVS(329)*X(74))/(JVS(324))
  X(51) = (X(51)-JVS(319)*X(58)-JVS(320)*X(62)-JVS(321)*X(71)-JVS(322)*X(74))/(JVS(318))
  X(50) = (X(50)-JVS(313)*X(53)-JVS(314)*X(58)-JVS(315)*X(62)-JVS(316)*X(71)-JVS(317)*X(74))/(JVS(312))
  X(49) = (X(49)-JVS(307)*X(58)-JVS(308)*X(62)-JVS(309)*X(71)-JVS(310)*X(74))/(JVS(306))
  X(48) = (X(48)-JVS(285)*X(49)-JVS(286)*X(51)-JVS(287)*X(53)-JVS(288)*X(54)-JVS(289)*X(57)-JVS(290)*X(58)-JVS(291)&
            &*X(60)-JVS(292)*X(61)-JVS(293)*X(62)-JVS(294)*X(63)-JVS(295)*X(64)-JVS(296)*X(65)-JVS(297)*X(66)-JVS(298)*X(67)&
            &-JVS(299)*X(68)-JVS(300)*X(69)-JVS(301)*X(70)-JVS(302)*X(71)-JVS(303)*X(72)-JVS(304)*X(73)-JVS(305)*X(74))&
            &/(JVS(284))
  X(47) = (X(47)-JVS(273)*X(58)-JVS(274)*X(62)-JVS(275)*X(71)-JVS(276)*X(74))/(JVS(272))
  X(46) = (X(46)-JVS(263)*X(63)-JVS(264)*X(65)-JVS(265)*X(67)-JVS(266)*X(69)-JVS(267)*X(70)-JVS(268)*X(71)-JVS(269)&
            &*X(72)-JVS(270)*X(73)-JVS(271)*X(74))/(JVS(262))
  X(45) = (X(45)-JVS(252)*X(46)-JVS(253)*X(49)-JVS(254)*X(52)-JVS(255)*X(58)-JVS(256)*X(62)-JVS(257)*X(63)-JVS(258)&
            &*X(71)-JVS(259)*X(74))/(JVS(251))
  X(44) = (X(44)-JVS(239)*X(58)-JVS(240)*X(62)-JVS(241)*X(71)-JVS(242)*X(74))/(JVS(238))
  X(43) = (X(43)-JVS(224)*X(45)-JVS(225)*X(46)-JVS(226)*X(50)-JVS(227)*X(52)-JVS(228)*X(53)-JVS(229)*X(54)-JVS(230)&
            &*X(55)-JVS(231)*X(56)-JVS(232)*X(59)-JVS(233)*X(62)-JVS(234)*X(63)-JVS(235)*X(70)-JVS(236)*X(71)-JVS(237)&
            &*X(74))/(JVS(223))
  X(42) = (X(42)-JVS(209)*X(49)-JVS(210)*X(51)-JVS(211)*X(53)-JVS(212)*X(57)-JVS(213)*X(62)-JVS(214)*X(70)-JVS(215)&
            &*X(71)-JVS(216)*X(74))/(JVS(208))
  X(41) = (X(41)-JVS(197)*X(50)-JVS(198)*X(52)-JVS(199)*X(54)-JVS(200)*X(62)-JVS(201)*X(71)-JVS(202)*X(74))/(JVS(196))
  X(40) = (X(40)-JVS(174)*X(41)-JVS(175)*X(44)-JVS(176)*X(45)-JVS(177)*X(47)-JVS(178)*X(49)-JVS(179)*X(50)-JVS(180)&
            &*X(51)-JVS(181)*X(52)-JVS(182)*X(53)-JVS(183)*X(54)-JVS(184)*X(55)-JVS(185)*X(56)-JVS(186)*X(58)-JVS(187)*X(59)&
            &-JVS(188)*X(62)-JVS(189)*X(71)-JVS(190)*X(74))/(JVS(173))
  X(39) = (X(39)-JVS(164)*X(46)-JVS(165)*X(63)-JVS(166)*X(71)-JVS(167)*X(74))/(JVS(163))
  X(38) = (X(38)-JVS(158)*X(53)-JVS(159)*X(62)-JVS(160)*X(71)-JVS(161)*X(74))/(JVS(157))
  X(37) = (X(37)-JVS(151)*X(63)-JVS(152)*X(64)-JVS(153)*X(68)-JVS(154)*X(74))/(JVS(150))
  X(36) = (X(36)-JVS(146)*X(46)-JVS(147)*X(63)-JVS(148)*X(70)-JVS(149)*X(71))/(JVS(145))
  X(35) = (X(35)-JVS(142)*X(62)-JVS(143)*X(74))/(JVS(141))
  X(34) = (X(34)-JVS(137)*X(71)-JVS(138)*X(74))/(JVS(136))
  X(33) = (X(33)-JVS(133)*X(74))/(JVS(132))
  X(32) = (X(32)-JVS(129)*X(74))/(JVS(128))
  X(31) = (X(31)-JVS(125)*X(74))/(JVS(124))
  X(30) = (X(30)-JVS(123)*X(74))/(JVS(122))
  X(29) = (X(29)-JVS(118)*X(64)-JVS(119)*X(66)-JVS(120)*X(68)-JVS(121)*X(74))/(JVS(117))
  X(28) = (X(28)-JVS(113)*X(36)-JVS(114)*X(63)-JVS(115)*X(70)-JVS(116)*X(71))/(JVS(112))
  X(27) = (X(27)-JVS(109)*X(56)-JVS(110)*X(63)-JVS(111)*X(69))/(JVS(108))
  X(26) = (X(26)-JVS(105)*X(63)-JVS(106)*X(66)-JVS(107)*X(74))/(JVS(104))
  X(25) = (X(25)-JVS(101)*X(63)-JVS(102)*X(70)-JVS(103)*X(74))/(JVS(100))
  X(24) = (X(24)-JVS(99)*X(74))/(JVS(98))
  X(23) = (X(23)-JVS(97)*X(74))/(JVS(96))
  X(22) = (X(22)-JVS(94)*X(70)-JVS(95)*X(74))/(JVS(93))
  X(21) = (X(21)-JVS(91)*X(74))/(JVS(90))
  X(20) = (X(20)-JVS(89)*X(74))/(JVS(88))
  X(19) = (X(19)-JVS(86)*X(69)-JVS(87)*X(74))/(JVS(85))
  X(18) = (X(18)-JVS(83)*X(70)-JVS(84)*X(71))/(JVS(82))
  X(17) = (X(17)-JVS(80)*X(63)-JVS(81)*X(74))/(JVS(79))
  X(16) = (X(16)-JVS(77)*X(65)-JVS(78)*X(70))/(JVS(76))
  X(15) = (X(15)-JVS(74)*X(67)-JVS(75)*X(70))/(JVS(73))
  X(14) = (X(14)-JVS(71)*X(70)-JVS(72)*X(73))/(JVS(70))
  X(13) = (X(13)-JVS(68)*X(70)-JVS(69)*X(72))/(JVS(67))
  X(12) = (X(12)-JVS(63)*X(24)-JVS(64)*X(49)-JVS(65)*X(62)-JVS(66)*X(74))/(JVS(62))
  X(11) = (X(11)-JVS(61)*X(74))/(JVS(60))
  X(10) = (X(10)-JVS(59)*X(62))/(JVS(58))
  X(9) = (X(9)-JVS(57)*X(74))/(JVS(56))
  X(8) = (X(8)-JVS(53)*X(28)-JVS(54)*X(38)-JVS(55)*X(70))/(JVS(52))
  X(7) = (X(7)-JVS(50)*X(28)-JVS(51)*X(70))/(JVS(49))
  X(6) = (X(6)-JVS(45)*X(63)-JVS(46)*X(65)-JVS(47)*X(67)-JVS(48)*X(73))/(JVS(44))
  X(5) = (X(5)-JVS(42)*X(63)-JVS(43)*X(72))/(JVS(41))
  X(4) = (X(4)-JVS(28)*X(47)-JVS(29)*X(49)-JVS(30)*X(51)-JVS(31)*X(52)-JVS(32)*X(53)-JVS(33)*X(62)-JVS(34)*X(63)-JVS(35)&
           &*X(64)-JVS(36)*X(65)-JVS(37)*X(66)-JVS(38)*X(67)-JVS(39)*X(68)-JVS(40)*X(73))/(JVS(27))
  X(3) = (X(3)-JVS(19)*X(51)-JVS(20)*X(53)-JVS(21)*X(62)-JVS(22)*X(63)-JVS(23)*X(64)-JVS(24)*X(66)-JVS(25)*X(68)-JVS(26)&
           &*X(72))/(JVS(18))
  X(2) = (X(2)-JVS(5)*X(20)-JVS(6)*X(27)-JVS(7)*X(44)-JVS(8)*X(47)-JVS(9)*X(49)-JVS(10)*X(50)-JVS(11)*X(51)-JVS(12)&
           &*X(52)-JVS(13)*X(53)-JVS(14)*X(54)-JVS(15)*X(62)-JVS(16)*X(69)-JVS(17)*X(74))/(JVS(4))
  X(1) = (X(1)-JVS(2)*X(9)-JVS(3)*X(74))/(JVS(1))

END SUBROUTINE KppSolve

! End of KppSolve function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
! KppSolveTR - sparse, transposed back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
!      XX        - Vector for output variables
!
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolveTR ( JVS, X, XX )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)
! XX - Vector for output variables
  REAL(kind=dp) :: XX(NVAR)

  XX(1) = X(1)/JVS(1)
  XX(2) = X(2)/JVS(4)
  XX(3) = X(3)/JVS(18)
  XX(4) = X(4)/JVS(27)
  XX(5) = X(5)/JVS(41)
  XX(6) = X(6)/JVS(44)
  XX(7) = X(7)/JVS(49)
  XX(8) = X(8)/JVS(52)
  XX(9) = (X(9)-JVS(2)*XX(1))/(JVS(56))
  XX(10) = X(10)/JVS(58)
  XX(11) = X(11)/JVS(60)
  XX(12) = X(12)/JVS(62)
  XX(13) = X(13)/JVS(67)
  XX(14) = X(14)/JVS(70)
  XX(15) = X(15)/JVS(73)
  XX(16) = X(16)/JVS(76)
  XX(17) = X(17)/JVS(79)
  XX(18) = X(18)/JVS(82)
  XX(19) = X(19)/JVS(85)
  XX(20) = (X(20)-JVS(5)*XX(2))/(JVS(88))
  XX(21) = X(21)/JVS(90)
  XX(22) = X(22)/JVS(93)
  XX(23) = X(23)/JVS(96)
  XX(24) = (X(24)-JVS(63)*XX(12))/(JVS(98))
  XX(25) = X(25)/JVS(100)
  XX(26) = X(26)/JVS(104)
  XX(27) = (X(27)-JVS(6)*XX(2))/(JVS(108))
  XX(28) = (X(28)-JVS(50)*XX(7)-JVS(53)*XX(8))/(JVS(112))
  XX(29) = X(29)/JVS(117)
  XX(30) = X(30)/JVS(122)
  XX(31) = X(31)/JVS(124)
  XX(32) = X(32)/JVS(128)
  XX(33) = X(33)/JVS(132)
  XX(34) = X(34)/JVS(136)
  XX(35) = X(35)/JVS(141)
  XX(36) = (X(36)-JVS(113)*XX(28))/(JVS(145))
  XX(37) = X(37)/JVS(150)
  XX(38) = (X(38)-JVS(54)*XX(8))/(JVS(157))
  XX(39) = X(39)/JVS(163)
  XX(40) = X(40)/JVS(173)
  XX(41) = (X(41)-JVS(174)*XX(40))/(JVS(196))
  XX(42) = X(42)/JVS(208)
  XX(43) = X(43)/JVS(223)
  XX(44) = (X(44)-JVS(7)*XX(2)-JVS(175)*XX(40))/(JVS(238))
  XX(45) = (X(45)-JVS(176)*XX(40)-JVS(224)*XX(43))/(JVS(251))
  XX(46) = (X(46)-JVS(146)*XX(36)-JVS(164)*XX(39)-JVS(225)*XX(43)-JVS(252)*XX(45))/(JVS(262))
  XX(47) = (X(47)-JVS(8)*XX(2)-JVS(28)*XX(4)-JVS(177)*XX(40))/(JVS(272))
  XX(48) = X(48)/JVS(284)
  XX(49) = (X(49)-JVS(9)*XX(2)-JVS(29)*XX(4)-JVS(64)*XX(12)-JVS(178)*XX(40)-JVS(209)*XX(42)-JVS(253)*XX(45)-JVS(285)&
             &*XX(48))/(JVS(306))
  XX(50) = (X(50)-JVS(10)*XX(2)-JVS(179)*XX(40)-JVS(197)*XX(41)-JVS(226)*XX(43))/(JVS(312))
  XX(51) = (X(51)-JVS(11)*XX(2)-JVS(19)*XX(3)-JVS(30)*XX(4)-JVS(180)*XX(40)-JVS(210)*XX(42)-JVS(286)*XX(48))/(JVS(318))
  XX(52) = (X(52)-JVS(12)*XX(2)-JVS(31)*XX(4)-JVS(181)*XX(40)-JVS(198)*XX(41)-JVS(227)*XX(43)-JVS(254)*XX(45))&
             &/(JVS(324))
  XX(53) = (X(53)-JVS(13)*XX(2)-JVS(20)*XX(3)-JVS(32)*XX(4)-JVS(158)*XX(38)-JVS(182)*XX(40)-JVS(211)*XX(42)-JVS(228)&
             &*XX(43)-JVS(287)*XX(48)-JVS(313)*XX(50)-JVS(325)*XX(52))/(JVS(330))
  XX(54) = (X(54)-JVS(14)*XX(2)-JVS(183)*XX(40)-JVS(199)*XX(41)-JVS(229)*XX(43)-JVS(288)*XX(48))/(JVS(337))
  XX(55) = (X(55)-JVS(184)*XX(40)-JVS(230)*XX(43))/(JVS(350))
  XX(56) = (X(56)-JVS(109)*XX(27)-JVS(185)*XX(40)-JVS(231)*XX(43))/(JVS(382))
  XX(57) = (X(57)-JVS(212)*XX(42)-JVS(289)*XX(48)-JVS(351)*XX(55)-JVS(383)*XX(56))/(JVS(405))
  XX(58) = (X(58)-JVS(186)*XX(40)-JVS(239)*XX(44)-JVS(255)*XX(45)-JVS(273)*XX(47)-JVS(290)*XX(48)-JVS(307)*XX(49)&
             &-JVS(314)*XX(50)-JVS(319)*XX(51)-JVS(326)*XX(52)-JVS(331)*XX(53)-JVS(338)*XX(54)-JVS(352)*XX(55)-JVS(384)&
             &*XX(56)-JVS(406)*XX(57))/(JVS(421))
  XX(59) = (X(59)-JVS(187)*XX(40)-JVS(232)*XX(43)-JVS(353)*XX(55))/(JVS(444))
  XX(60) = (X(60)-JVS(291)*XX(48)-JVS(354)*XX(55)-JVS(385)*XX(56)-JVS(445)*XX(59))/(JVS(465))
  XX(61) = (X(61)-JVS(292)*XX(48)-JVS(355)*XX(55)-JVS(386)*XX(56)-JVS(446)*XX(59)-JVS(466)*XX(60))/(JVS(486))
  XX(62) = (X(62)-JVS(15)*XX(2)-JVS(21)*XX(3)-JVS(33)*XX(4)-JVS(59)*XX(10)-JVS(65)*XX(12)-JVS(142)*XX(35)-JVS(159)&
             &*XX(38)-JVS(188)*XX(40)-JVS(200)*XX(41)-JVS(213)*XX(42)-JVS(233)*XX(43)-JVS(240)*XX(44)-JVS(256)*XX(45)&
             &-JVS(274)*XX(47)-JVS(293)*XX(48)-JVS(308)*XX(49)-JVS(315)*XX(50)-JVS(320)*XX(51)-JVS(327)*XX(52)-JVS(332)&
             &*XX(53)-JVS(339)*XX(54)-JVS(356)*XX(55)-JVS(387)*XX(56)-JVS(407)*XX(57)-JVS(422)*XX(58)-JVS(447)*XX(59)&
             &-JVS(467)*XX(60)-JVS(487)*XX(61))/(JVS(508))
  XX(63) = (X(63)-JVS(22)*XX(3)-JVS(34)*XX(4)-JVS(42)*XX(5)-JVS(45)*XX(6)-JVS(80)*XX(17)-JVS(101)*XX(25)-JVS(105)*XX(26)&
             &-JVS(110)*XX(27)-JVS(114)*XX(28)-JVS(147)*XX(36)-JVS(151)*XX(37)-JVS(165)*XX(39)-JVS(234)*XX(43)-JVS(257)&
             &*XX(45)-JVS(263)*XX(46)-JVS(294)*XX(48)-JVS(388)*XX(56)-JVS(448)*XX(59)-JVS(509)*XX(62))/(JVS(554))
  XX(64) = (X(64)-JVS(23)*XX(3)-JVS(35)*XX(4)-JVS(118)*XX(29)-JVS(152)*XX(37)-JVS(295)*XX(48)-JVS(389)*XX(56)-JVS(408)&
             &*XX(57)-JVS(449)*XX(59)-JVS(468)*XX(60)-JVS(488)*XX(61)-JVS(555)*XX(63))/(JVS(585))
  XX(65) = (X(65)-JVS(36)*XX(4)-JVS(46)*XX(6)-JVS(77)*XX(16)-JVS(264)*XX(46)-JVS(296)*XX(48)-JVS(357)*XX(55)-JVS(390)&
             &*XX(56)-JVS(510)*XX(62)-JVS(556)*XX(63)-JVS(586)*XX(64))/(JVS(606))
  XX(66) = (X(66)-JVS(24)*XX(3)-JVS(37)*XX(4)-JVS(106)*XX(26)-JVS(119)*XX(29)-JVS(297)*XX(48)-JVS(391)*XX(56)-JVS(469)&
             &*XX(60)-JVS(489)*XX(61)-JVS(557)*XX(63)-JVS(587)*XX(64)-JVS(607)*XX(65))/(JVS(636))
  XX(67) = (X(67)-JVS(38)*XX(4)-JVS(47)*XX(6)-JVS(74)*XX(15)-JVS(265)*XX(46)-JVS(298)*XX(48)-JVS(358)*XX(55)-JVS(392)&
             &*XX(56)-JVS(490)*XX(61)-JVS(511)*XX(62)-JVS(558)*XX(63)-JVS(588)*XX(64)-JVS(608)*XX(65)-JVS(637)*XX(66))&
             &/(JVS(654))
  XX(68) = (X(68)-JVS(25)*XX(3)-JVS(39)*XX(4)-JVS(120)*XX(29)-JVS(153)*XX(37)-JVS(299)*XX(48)-JVS(393)*XX(56)-JVS(450)&
             &*XX(59)-JVS(470)*XX(60)-JVS(491)*XX(61)-JVS(559)*XX(63)-JVS(589)*XX(64)-JVS(609)*XX(65)-JVS(638)*XX(66)&
             &-JVS(655)*XX(67))/(JVS(695))
  XX(69) = (X(69)-JVS(16)*XX(2)-JVS(86)*XX(19)-JVS(111)*XX(27)-JVS(266)*XX(46)-JVS(300)*XX(48)-JVS(359)*XX(55)-JVS(394)&
             &*XX(56)-JVS(409)*XX(57)-JVS(423)*XX(58)-JVS(451)*XX(59)-JVS(471)*XX(60)-JVS(492)*XX(61)-JVS(512)*XX(62)&
             &-JVS(560)*XX(63)-JVS(590)*XX(64)-JVS(610)*XX(65)-JVS(639)*XX(66)-JVS(656)*XX(67)-JVS(696)*XX(68))/(JVS(721))
  XX(70) = (X(70)-JVS(51)*XX(7)-JVS(55)*XX(8)-JVS(68)*XX(13)-JVS(71)*XX(14)-JVS(75)*XX(15)-JVS(78)*XX(16)-JVS(83)*XX(18)&
             &-JVS(94)*XX(22)-JVS(102)*XX(25)-JVS(115)*XX(28)-JVS(148)*XX(36)-JVS(214)*XX(42)-JVS(235)*XX(43)-JVS(267)&
             &*XX(46)-JVS(301)*XX(48)-JVS(395)*XX(56)-JVS(410)*XX(57)-JVS(424)*XX(58)-JVS(452)*XX(59)-JVS(472)*XX(60)&
             &-JVS(493)*XX(61)-JVS(513)*XX(62)-JVS(561)*XX(63)-JVS(591)*XX(64)-JVS(611)*XX(65)-JVS(640)*XX(66)-JVS(657)&
             &*XX(67)-JVS(697)*XX(68)-JVS(722)*XX(69))/(JVS(764))
  XX(71) = (X(71)-JVS(84)*XX(18)-JVS(116)*XX(28)-JVS(137)*XX(34)-JVS(149)*XX(36)-JVS(160)*XX(38)-JVS(166)*XX(39)&
             &-JVS(189)*XX(40)-JVS(201)*XX(41)-JVS(215)*XX(42)-JVS(236)*XX(43)-JVS(241)*XX(44)-JVS(258)*XX(45)-JVS(268)&
             &*XX(46)-JVS(275)*XX(47)-JVS(302)*XX(48)-JVS(309)*XX(49)-JVS(316)*XX(50)-JVS(321)*XX(51)-JVS(328)*XX(52)&
             &-JVS(333)*XX(53)-JVS(340)*XX(54)-JVS(360)*XX(55)-JVS(396)*XX(56)-JVS(411)*XX(57)-JVS(425)*XX(58)-JVS(453)&
             &*XX(59)-JVS(473)*XX(60)-JVS(494)*XX(61)-JVS(514)*XX(62)-JVS(562)*XX(63)-JVS(592)*XX(64)-JVS(612)*XX(65)&
             &-JVS(641)*XX(66)-JVS(658)*XX(67)-JVS(698)*XX(68)-JVS(723)*XX(69)-JVS(765)*XX(70))/(JVS(804))
  XX(72) = (X(72)-JVS(26)*XX(3)-JVS(43)*XX(5)-JVS(69)*XX(13)-JVS(269)*XX(46)-JVS(303)*XX(48)-JVS(361)*XX(55)-JVS(397)&
             &*XX(56)-JVS(495)*XX(61)-JVS(515)*XX(62)-JVS(563)*XX(63)-JVS(593)*XX(64)-JVS(613)*XX(65)-JVS(642)*XX(66)&
             &-JVS(659)*XX(67)-JVS(699)*XX(68)-JVS(724)*XX(69)-JVS(766)*XX(70)-JVS(805)*XX(71))/(JVS(838))
  XX(73) = (X(73)-JVS(40)*XX(4)-JVS(48)*XX(6)-JVS(72)*XX(14)-JVS(270)*XX(46)-JVS(304)*XX(48)-JVS(362)*XX(55)-JVS(398)&
             &*XX(56)-JVS(496)*XX(61)-JVS(516)*XX(62)-JVS(564)*XX(63)-JVS(594)*XX(64)-JVS(614)*XX(65)-JVS(643)*XX(66)&
             &-JVS(660)*XX(67)-JVS(700)*XX(68)-JVS(725)*XX(69)-JVS(767)*XX(70)-JVS(806)*XX(71)-JVS(839)*XX(72))/(JVS(864))
  XX(74) = (X(74)-JVS(3)*XX(1)-JVS(17)*XX(2)-JVS(57)*XX(9)-JVS(61)*XX(11)-JVS(66)*XX(12)-JVS(81)*XX(17)-JVS(87)*XX(19)&
             &-JVS(89)*XX(20)-JVS(91)*XX(21)-JVS(95)*XX(22)-JVS(97)*XX(23)-JVS(99)*XX(24)-JVS(103)*XX(25)-JVS(107)*XX(26)&
             &-JVS(121)*XX(29)-JVS(123)*XX(30)-JVS(125)*XX(31)-JVS(129)*XX(32)-JVS(133)*XX(33)-JVS(138)*XX(34)-JVS(143)&
             &*XX(35)-JVS(154)*XX(37)-JVS(161)*XX(38)-JVS(167)*XX(39)-JVS(190)*XX(40)-JVS(202)*XX(41)-JVS(216)*XX(42)&
             &-JVS(237)*XX(43)-JVS(242)*XX(44)-JVS(259)*XX(45)-JVS(271)*XX(46)-JVS(276)*XX(47)-JVS(305)*XX(48)-JVS(310)&
             &*XX(49)-JVS(317)*XX(50)-JVS(322)*XX(51)-JVS(329)*XX(52)-JVS(334)*XX(53)-JVS(341)*XX(54)-JVS(363)*XX(55)&
             &-JVS(399)*XX(56)-JVS(412)*XX(57)-JVS(426)*XX(58)-JVS(454)*XX(59)-JVS(474)*XX(60)-JVS(497)*XX(61)-JVS(517)&
             &*XX(62)-JVS(565)*XX(63)-JVS(595)*XX(64)-JVS(615)*XX(65)-JVS(644)*XX(66)-JVS(661)*XX(67)-JVS(701)*XX(68)&
             &-JVS(726)*XX(69)-JVS(768)*XX(70)-JVS(807)*XX(71)-JVS(840)*XX(72)-JVS(865)*XX(73))/(JVS(920))
  XX(74) = XX(74)
  XX(73) = XX(73)-JVS(919)*XX(74)
  XX(72) = XX(72)-JVS(863)*XX(73)-JVS(918)*XX(74)
  XX(71) = XX(71)-JVS(837)*XX(72)-JVS(862)*XX(73)-JVS(917)*XX(74)
  XX(70) = XX(70)-JVS(803)*XX(71)-JVS(836)*XX(72)-JVS(861)*XX(73)-JVS(916)*XX(74)
  XX(69) = XX(69)-JVS(763)*XX(70)-JVS(802)*XX(71)-JVS(835)*XX(72)-JVS(860)*XX(73)-JVS(915)*XX(74)
  XX(68) = XX(68)-JVS(720)*XX(69)-JVS(762)*XX(70)-JVS(801)*XX(71)-JVS(834)*XX(72)-JVS(859)*XX(73)-JVS(914)*XX(74)
  XX(67) = XX(67)-JVS(694)*XX(68)-JVS(719)*XX(69)-JVS(761)*XX(70)-JVS(800)*XX(71)-JVS(833)*XX(72)-JVS(858)*XX(73)&
             &-JVS(913)*XX(74)
  XX(66) = XX(66)-JVS(653)*XX(67)-JVS(693)*XX(68)-JVS(718)*XX(69)-JVS(760)*XX(70)-JVS(799)*XX(71)-JVS(832)*XX(72)&
             &-JVS(857)*XX(73)-JVS(912)*XX(74)
  XX(65) = XX(65)-JVS(635)*XX(66)-JVS(652)*XX(67)-JVS(692)*XX(68)-JVS(717)*XX(69)-JVS(759)*XX(70)-JVS(798)*XX(71)&
             &-JVS(831)*XX(72)-JVS(856)*XX(73)-JVS(911)*XX(74)
  XX(64) = XX(64)-JVS(605)*XX(65)-JVS(634)*XX(66)-JVS(651)*XX(67)-JVS(691)*XX(68)-JVS(716)*XX(69)-JVS(758)*XX(70)&
             &-JVS(797)*XX(71)-JVS(830)*XX(72)-JVS(855)*XX(73)-JVS(910)*XX(74)
  XX(63) = XX(63)-JVS(584)*XX(64)-JVS(604)*XX(65)-JVS(633)*XX(66)-JVS(650)*XX(67)-JVS(690)*XX(68)-JVS(715)*XX(69)&
             &-JVS(757)*XX(70)-JVS(796)*XX(71)-JVS(829)*XX(72)-JVS(854)*XX(73)-JVS(909)*XX(74)
  XX(62) = XX(62)-JVS(553)*XX(63)-JVS(583)*XX(64)-JVS(603)*XX(65)-JVS(632)*XX(66)-JVS(649)*XX(67)-JVS(689)*XX(68)&
             &-JVS(714)*XX(69)-JVS(756)*XX(70)-JVS(795)*XX(71)-JVS(828)*XX(72)-JVS(853)*XX(73)-JVS(908)*XX(74)
  XX(61) = XX(61)-JVS(552)*XX(63)-JVS(582)*XX(64)-JVS(631)*XX(66)-JVS(688)*XX(68)-JVS(713)*XX(69)-JVS(755)*XX(70)&
             &-JVS(794)*XX(71)-JVS(827)*XX(72)-JVS(852)*XX(73)-JVS(907)*XX(74)
  XX(60) = XX(60)-JVS(551)*XX(63)-JVS(581)*XX(64)-JVS(630)*XX(66)-JVS(687)*XX(68)-JVS(712)*XX(69)-JVS(754)*XX(70)&
             &-JVS(793)*XX(71)-JVS(826)*XX(72)-JVS(851)*XX(73)-JVS(906)*XX(74)
  XX(59) = XX(59)-JVS(550)*XX(63)-JVS(580)*XX(64)-JVS(629)*XX(66)-JVS(686)*XX(68)-JVS(753)*XX(70)-JVS(792)*XX(71)&
             &-JVS(825)*XX(72)-JVS(850)*XX(73)-JVS(905)*XX(74)
  XX(58) = XX(58)-JVS(443)*XX(59)-JVS(464)*XX(60)-JVS(485)*XX(61)-JVS(507)*XX(62)-JVS(549)*XX(63)-JVS(579)*XX(64)&
             &-JVS(602)*XX(65)-JVS(628)*XX(66)-JVS(648)*XX(67)-JVS(685)*XX(68)-JVS(711)*XX(69)-JVS(752)*XX(70)-JVS(791)&
             &*XX(71)-JVS(824)*XX(72)-JVS(849)*XX(73)-JVS(904)*XX(74)
  XX(57) = XX(57)-JVS(442)*XX(59)-JVS(463)*XX(60)-JVS(484)*XX(61)-JVS(548)*XX(63)-JVS(578)*XX(64)-JVS(627)*XX(66)&
             &-JVS(684)*XX(68)-JVS(710)*XX(69)-JVS(751)*XX(70)-JVS(790)*XX(71)-JVS(823)*XX(72)-JVS(903)*XX(74)
  XX(56) = XX(56)-JVS(547)*XX(63)-JVS(709)*XX(69)-JVS(750)*XX(70)-JVS(789)*XX(71)-JVS(902)*XX(74)
  XX(55) = XX(55)-JVS(546)*XX(63)-JVS(626)*XX(66)-JVS(749)*XX(70)-JVS(788)*XX(71)-JVS(822)*XX(72)-JVS(901)*XX(74)
  XX(54) = XX(54)-JVS(381)*XX(56)-JVS(420)*XX(58)-JVS(441)*XX(59)-JVS(462)*XX(60)-JVS(483)*XX(61)-JVS(506)*XX(62)&
             &-JVS(545)*XX(63)-JVS(577)*XX(64)-JVS(601)*XX(65)-JVS(625)*XX(66)-JVS(683)*XX(68)-JVS(708)*XX(69)-JVS(748)&
             &*XX(70)-JVS(787)*XX(71)-JVS(821)*XX(72)-JVS(848)*XX(73)-JVS(900)*XX(74)
  XX(53) = XX(53)-JVS(336)*XX(54)-JVS(349)*XX(55)-JVS(380)*XX(56)-JVS(404)*XX(57)-JVS(419)*XX(58)-JVS(440)*XX(59)&
             &-JVS(461)*XX(60)-JVS(482)*XX(61)-JVS(505)*XX(62)-JVS(544)*XX(63)-JVS(576)*XX(64)-JVS(600)*XX(65)-JVS(624)&
             &*XX(66)-JVS(647)*XX(67)-JVS(682)*XX(68)-JVS(707)*XX(69)-JVS(747)*XX(70)-JVS(786)*XX(71)-JVS(820)*XX(72)&
             &-JVS(847)*XX(73)-JVS(899)*XX(74)
  XX(52) = XX(52)-JVS(348)*XX(55)-JVS(379)*XX(56)-JVS(403)*XX(57)-JVS(439)*XX(59)-JVS(460)*XX(60)-JVS(481)*XX(61)&
             &-JVS(504)*XX(62)-JVS(543)*XX(63)-JVS(575)*XX(64)-JVS(599)*XX(65)-JVS(681)*XX(68)-JVS(746)*XX(70)-JVS(785)&
             &*XX(71)-JVS(819)*XX(72)-JVS(846)*XX(73)-JVS(898)*XX(74)
  XX(51) = XX(51)-JVS(347)*XX(55)-JVS(378)*XX(56)-JVS(402)*XX(57)-JVS(418)*XX(58)-JVS(438)*XX(59)-JVS(459)*XX(60)&
             &-JVS(480)*XX(61)-JVS(503)*XX(62)-JVS(542)*XX(63)-JVS(574)*XX(64)-JVS(623)*XX(66)-JVS(680)*XX(68)-JVS(706)&
             &*XX(69)-JVS(745)*XX(70)-JVS(784)*XX(71)-JVS(818)*XX(72)-JVS(897)*XX(74)
  XX(50) = XX(50)-JVS(377)*XX(56)-JVS(417)*XX(58)-JVS(437)*XX(59)-JVS(458)*XX(60)-JVS(502)*XX(62)-JVS(541)*XX(63)&
             &-JVS(598)*XX(65)-JVS(679)*XX(68)-JVS(744)*XX(70)-JVS(783)*XX(71)-JVS(817)*XX(72)-JVS(845)*XX(73)-JVS(896)&
             &*XX(74)
  XX(49) = XX(49)-JVS(376)*XX(56)-JVS(401)*XX(57)-JVS(416)*XX(58)-JVS(436)*XX(59)-JVS(479)*XX(61)-JVS(501)*XX(62)&
             &-JVS(540)*XX(63)-JVS(573)*XX(64)-JVS(622)*XX(66)-JVS(678)*XX(68)-JVS(705)*XX(69)-JVS(743)*XX(70)-JVS(782)&
             &*XX(71)-JVS(816)*XX(72)-JVS(844)*XX(73)-JVS(895)*XX(74)
  XX(48) = XX(48)-JVS(704)*XX(69)-JVS(742)*XX(70)-JVS(781)*XX(71)
  XX(47) = XX(47)-JVS(283)*XX(48)-JVS(311)*XX(50)-JVS(323)*XX(52)-JVS(335)*XX(54)-JVS(375)*XX(56)-JVS(415)*XX(58)&
             &-JVS(478)*XX(61)-JVS(500)*XX(62)-JVS(539)*XX(63)-JVS(572)*XX(64)-JVS(597)*XX(65)-JVS(621)*XX(66)-JVS(677)&
             &*XX(68)-JVS(741)*XX(70)-JVS(780)*XX(71)-JVS(894)*XX(74)
  XX(46) = XX(46)-JVS(374)*XX(56)-JVS(538)*XX(63)-JVS(676)*XX(68)-JVS(740)*XX(70)-JVS(779)*XX(71)-JVS(843)*XX(73)&
             &-JVS(893)*XX(74)
  XX(45) = XX(45)-JVS(373)*XX(56)-JVS(537)*XX(63)-JVS(739)*XX(70)-JVS(778)*XX(71)-JVS(842)*XX(73)-JVS(892)*XX(74)
  XX(44) = XX(44)-JVS(250)*XX(45)-JVS(346)*XX(55)-JVS(372)*XX(56)-JVS(414)*XX(58)-JVS(435)*XX(59)-JVS(499)*XX(62)&
             &-JVS(536)*XX(63)-JVS(620)*XX(66)-JVS(675)*XX(68)-JVS(777)*XX(71)-JVS(891)*XX(74)
  XX(43) = XX(43)-JVS(738)*XX(70)-JVS(776)*XX(71)-JVS(890)*XX(74)
  XX(42) = XX(42)-JVS(282)*XX(48)-JVS(371)*XX(56)-JVS(619)*XX(66)-JVS(815)*XX(72)-JVS(889)*XX(74)
  XX(41) = XX(41)-JVS(222)*XX(43)-JVS(535)*XX(63)-JVS(775)*XX(71)-JVS(814)*XX(72)-JVS(888)*XX(74)
  XX(40) = XX(40)-JVS(534)*XX(63)-JVS(887)*XX(74)
  XX(39) = XX(39)-JVS(221)*XX(43)-JVS(249)*XX(45)-JVS(261)*XX(46)-JVS(674)*XX(68)-JVS(774)*XX(71)-JVS(886)*XX(74)
  XX(38) = XX(38)-JVS(220)*XX(43)-JVS(646)*XX(67)-JVS(773)*XX(71)-JVS(885)*XX(74)
  XX(37) = XX(37)-JVS(434)*XX(59)-JVS(533)*XX(63)-JVS(673)*XX(68)-JVS(884)*XX(74)
  XX(36) = XX(36)-JVS(219)*XX(43)-JVS(532)*XX(63)-JVS(737)*XX(70)-JVS(772)*XX(71)
  XX(35) = XX(35)-JVS(172)*XX(40)-JVS(248)*XX(45)-JVS(433)*XX(59)-JVS(498)*XX(62)-JVS(531)*XX(63)-JVS(672)*XX(68)&
             &-JVS(883)*XX(74)
  XX(34) = XX(34)-JVS(195)*XX(41)-JVS(218)*XX(43)-JVS(260)*XX(46)-JVS(671)*XX(68)-JVS(771)*XX(71)-JVS(882)*XX(74)
  XX(33) = XX(33)-JVS(171)*XX(40)-JVS(194)*XX(41)-JVS(247)*XX(45)-JVS(281)*XX(48)-JVS(432)*XX(59)-JVS(530)*XX(63)&
             &-JVS(670)*XX(68)-JVS(813)*XX(72)-JVS(881)*XX(74)
  XX(32) = XX(32)-JVS(170)*XX(40)-JVS(193)*XX(41)-JVS(246)*XX(45)-JVS(280)*XX(48)-JVS(431)*XX(59)-JVS(529)*XX(63)&
             &-JVS(669)*XX(68)-JVS(812)*XX(72)-JVS(880)*XX(74)
  XX(31) = XX(31)-JVS(127)*XX(32)-JVS(131)*XX(33)-JVS(135)*XX(34)-JVS(140)*XX(35)-JVS(156)*XX(38)-JVS(162)*XX(39)&
             &-JVS(192)*XX(41)-JVS(245)*XX(45)-JVS(477)*XX(61)-JVS(528)*XX(63)-JVS(571)*XX(64)-JVS(668)*XX(68)-JVS(879)&
             &*XX(74)
  XX(30) = XX(30)-JVS(169)*XX(40)-JVS(207)*XX(42)-JVS(279)*XX(48)-JVS(345)*XX(55)-JVS(370)*XX(56)-JVS(430)*XX(59)&
             &-JVS(457)*XX(60)-JVS(476)*XX(61)-JVS(570)*XX(64)-JVS(618)*XX(66)-JVS(667)*XX(68)-JVS(811)*XX(72)-JVS(878)&
             &*XX(74)
  XX(29) = XX(29)-JVS(369)*XX(56)-JVS(527)*XX(63)-JVS(877)*XX(74)
  XX(28) = XX(28)-JVS(144)*XX(36)-JVS(526)*XX(63)-JVS(736)*XX(70)
  XX(27) = XX(27)-JVS(368)*XX(56)-JVS(525)*XX(63)-JVS(703)*XX(69)-JVS(735)*XX(70)
  XX(26) = XX(26)-JVS(367)*XX(56)-JVS(524)*XX(63)-JVS(617)*XX(66)-JVS(876)*XX(74)
  XX(25) = XX(25)-JVS(523)*XX(63)-JVS(734)*XX(70)-JVS(770)*XX(71)-JVS(875)*XX(74)
  XX(24) = XX(24)-JVS(126)*XX(32)-JVS(130)*XX(33)-JVS(134)*XX(34)-JVS(139)*XX(35)-JVS(155)*XX(38)-JVS(191)*XX(41)&
             &-JVS(244)*XX(45)-JVS(522)*XX(63)-JVS(569)*XX(64)-JVS(666)*XX(68)-JVS(810)*XX(72)-JVS(874)*XX(74)
  XX(23) = XX(23)-JVS(206)*XX(42)-JVS(278)*XX(48)-JVS(344)*XX(55)-JVS(366)*XX(56)-JVS(429)*XX(59)-JVS(456)*XX(60)&
             &-JVS(475)*XX(61)-JVS(568)*XX(64)-JVS(665)*XX(68)-JVS(873)*XX(74)
  XX(22) = XX(22)-JVS(205)*XX(42)-JVS(400)*XX(57)-JVS(616)*XX(66)-JVS(733)*XX(70)
  XX(21) = XX(21)-JVS(92)*XX(22)-JVS(204)*XX(42)-JVS(277)*XX(48)-JVS(343)*XX(55)-JVS(365)*XX(56)-JVS(428)*XX(59)&
             &-JVS(455)*XX(60)-JVS(567)*XX(64)-JVS(664)*XX(68)-JVS(872)*XX(74)
  XX(20) = XX(20)-JVS(168)*XX(40)-JVS(203)*XX(42)-JVS(243)*XX(45)-JVS(364)*XX(56)-JVS(427)*XX(59)-JVS(521)*XX(63)&
             &-JVS(566)*XX(64)-JVS(663)*XX(68)-JVS(871)*XX(74)
  XX(19) = XX(19)-JVS(520)*XX(63)-JVS(702)*XX(69)-JVS(732)*XX(70)-JVS(870)*XX(74)
  XX(18) = XX(18)-JVS(217)*XX(43)-JVS(731)*XX(70)-JVS(769)*XX(71)
  XX(17) = XX(17)-JVS(519)*XX(63)-JVS(869)*XX(74)
  XX(16) = XX(16)-JVS(596)*XX(65)-JVS(730)*XX(70)
  XX(15) = XX(15)-JVS(645)*XX(67)-JVS(729)*XX(70)
  XX(14) = XX(14)-JVS(728)*XX(70)-JVS(841)*XX(73)
  XX(13) = XX(13)-JVS(727)*XX(70)-JVS(809)*XX(72)
  XX(12) = XX(12)-JVS(808)*XX(72)
  XX(11) = XX(11)-JVS(342)*XX(55)-JVS(662)*XX(68)-JVS(868)*XX(74)
  XX(10) = XX(10)-JVS(413)*XX(58)-JVS(867)*XX(74)
  XX(9) = XX(9)-JVS(518)*XX(63)-JVS(866)*XX(74)
  XX(8) = XX(8)
  XX(7) = XX(7)
  XX(6) = XX(6)
  XX(5) = XX(5)
  XX(4) = XX(4)
  XX(3) = XX(3)
  XX(2) = XX(2)
  XX(1) = XX(1)

END SUBROUTINE KppSolveTR

! End of KppSolveTR function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
! BLAS_UTIL - BLAS-LIKE utility functions
!   Arguments :
!
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!--------------------------------------------------------------
!
! BLAS/LAPACK-like subroutines used by the integration algorithms
! It is recommended to replace them by calls to the optimized
!      BLAS/LAPACK library for your machine
!
!  (C) Adrian Sandu, Aug. 2004
!      Virginia Polytechnic Institute and State University
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE WCOPY(N,X,incX,Y,incY)
!--------------------------------------------------------------
!     copies a vector, x, to a vector, y:  y <- x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL  SCOPY(N,X,1,Y,1)   or   CALL  DCOPY(N,X,1,Y,1)
!--------------------------------------------------------------
!     USE saprc99ros_Precision

      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N)

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = X(i)
        END DO
        IF( N .LT. 8 ) RETURN
      END IF
      MP1 = M+1
      DO i = MP1,N,8
        Y(i) = X(i)
        Y(i + 1) = X(i + 1)
        Y(i + 2) = X(i + 2)
        Y(i + 3) = X(i + 3)
        Y(i + 4) = X(i + 4)
        Y(i + 5) = X(i + 5)
        Y(i + 6) = X(i + 6)
        Y(i + 7) = X(i + 7)
      END DO

      END SUBROUTINE WCOPY


!--------------------------------------------------------------
      SUBROUTINE WAXPY(N,Alpha,X,incX,Y,incY)
!--------------------------------------------------------------
!     constant times a vector plus a vector: y <- y + Alpha*x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SAXPY(N,Alpha,X,1,Y,1) or  CALL DAXPY(N,Alpha,X,1,Y,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N),Alpha
      REAL(kind=dp), PARAMETER :: ZERO = 0.0_dp

      IF (Alpha .EQ. ZERO) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,4)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = Y(i) + Alpha*X(i)
        END DO
        IF( N .LT. 4 ) RETURN
      END IF
      MP1 = M + 1
      DO i = MP1,N,4
        Y(i) = Y(i) + Alpha*X(i)
        Y(i + 1) = Y(i + 1) + Alpha*X(i + 1)
        Y(i + 2) = Y(i + 2) + Alpha*X(i + 2)
        Y(i + 3) = Y(i + 3) + Alpha*X(i + 3)
      END DO

      END SUBROUTINE WAXPY



!--------------------------------------------------------------
      SUBROUTINE WSCAL(N,Alpha,X,incX)
!--------------------------------------------------------------
!     constant times a vector: x(1:N) <- Alpha*x(1:N)
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SSCAL(N,Alpha,X,1) or  CALL DSCAL(N,Alpha,X,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,M,MP1,N
      REAL(kind=dp)  :: X(N),Alpha
      REAL(kind=dp), PARAMETER  :: ZERO=0.0_dp, ONE=1.0_dp

      IF (Alpha .EQ. ONE) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,5)
      IF( M .NE. 0 ) THEN
        IF (Alpha .EQ. (-ONE)) THEN
          DO i = 1,M
            X(i) = -X(i)
          END DO
        ELSEIF (Alpha .EQ. ZERO) THEN
          DO i = 1,M
            X(i) = ZERO
          END DO
        ELSE
          DO i = 1,M
            X(i) = Alpha*X(i)
          END DO
        END IF
        IF( N .LT. 5 ) RETURN
      END IF
      MP1 = M + 1
      IF (Alpha .EQ. (-ONE)) THEN
        DO i = MP1,N,5
          X(i)     = -X(i)
          X(i + 1) = -X(i + 1)
          X(i + 2) = -X(i + 2)
          X(i + 3) = -X(i + 3)
          X(i + 4) = -X(i + 4)
        END DO
      ELSEIF (Alpha .EQ. ZERO) THEN
        DO i = MP1,N,5
          X(i)     = ZERO
          X(i + 1) = ZERO
          X(i + 2) = ZERO
          X(i + 3) = ZERO
          X(i + 4) = ZERO
        END DO
      ELSE
        DO i = MP1,N,5
          X(i)     = Alpha*X(i)
          X(i + 1) = Alpha*X(i + 1)
          X(i + 2) = Alpha*X(i + 2)
          X(i + 3) = Alpha*X(i + 3)
          X(i + 4) = Alpha*X(i + 4)
        END DO
      END IF

      END SUBROUTINE WSCAL

!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WLAMCH( C )
!--------------------------------------------------------------
!     returns epsilon machine
!     after LAPACK
!     replace this by the function from the optimized LAPACK implementation:
!          CALL SLAMCH('E') or CALL DLAMCH('E')
!--------------------------------------------------------------
!      USE saprc99ros_Precision

      CHARACTER ::  C
      INTEGER    :: i
      REAL(kind=dp), SAVE  ::  Eps
      REAL(kind=dp)  ::  Suma
      REAL(kind=dp), PARAMETER  ::  ONE=1.0_dp, HALF=0.5_dp
      LOGICAL, SAVE   ::  First=.TRUE.

      IF (First) THEN
        First = .FALSE.
        Eps = HALF**(16)
        DO i = 17, 80
          Eps = Eps*HALF
          CALL WLAMCH_ADD(ONE,Eps,Suma)
          IF (Suma.LE.ONE) GOTO 10
        END DO
        PRINT*,'ERROR IN WLAMCH. EPS < ',Eps
        RETURN
10      Eps = Eps*2
        i = i-1
      END IF

      WLAMCH = Eps

      END FUNCTION WLAMCH

      SUBROUTINE WLAMCH_ADD( A, B, Suma )
!      USE saprc99ros_Precision

      REAL(kind=dp) A, B, Suma
      Suma = A + B

      END SUBROUTINE WLAMCH_ADD
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE SET2ZERO(N,Y)
!--------------------------------------------------------------
!     copies zeros into the vector y:  y <- 0
!     after BLAS
!--------------------------------------------------------------

      INTEGER ::  i,M,MP1,N
      REAL(kind=dp) ::  Y(N)
      REAL(kind=dp), PARAMETER :: ZERO = 0.0d0

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = ZERO
        END DO
        IF( N .LT. 8 ) RETURN
      END IF
      MP1 = M+1
      DO i = MP1,N,8
        Y(i)     = ZERO
        Y(i + 1) = ZERO
        Y(i + 2) = ZERO
        Y(i + 3) = ZERO
        Y(i + 4) = ZERO
        Y(i + 5) = ZERO
        Y(i + 6) = ZERO
        Y(i + 7) = ZERO
      END DO

      END SUBROUTINE SET2ZERO


!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WDOT (N, DX, incX, DY, incY)
!--------------------------------------------------------------
!     dot produce: wdot = x(1:N)*y(1:N)
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SDOT(N,X,1,Y,1) or  CALL DDOT(N,X,1,Y,1)
!--------------------------------------------------------------
!      USE messy_mecca_kpp_Precision
!--------------------------------------------------------------
      IMPLICIT NONE
      INTEGER :: N, incX, incY
      REAL(kind=dp) :: DX(N), DY(N)

      INTEGER :: i, IX, IY, M, MP1, NS

      WDOT = 0.0D0
      IF (N .LE. 0) RETURN
      IF (incX .EQ. incY) IF (incX-1) 5,20,60
!
!     Code for unequal or nonpositive increments.
!
    5 IX = 1
      IY = 1
      IF (incX .LT. 0) IX = (-N+1)*incX + 1
      IF (incY .LT. 0) IY = (-N+1)*incY + 1
      DO i = 1,N
        WDOT = WDOT + DX(IX)*DY(IY)
        IX = IX + incX
        IY = IY + incY
      END DO
      RETURN
!
!     Code for both increments equal to 1.
!
!     Clean-up loop so remaining vector length is a multiple of 5.
!
   20 M = MOD(N,5)
      IF (M .EQ. 0) GO TO 40
      DO i = 1,M
         WDOT = WDOT + DX(i)*DY(i)
      END DO
      IF (N .LT. 5) RETURN
   40 MP1 = M + 1
      DO i = MP1,N,5
          WDOT = WDOT + DX(i)*DY(i) + DX(i+1)*DY(i+1) + DX(i+2)*DY(i+2) +  &
                   DX(i+3)*DY(i+3) + DX(i+4)*DY(i+4)
      END DO
      RETURN
!
!     Code for equal, positive, non-unit increments.
!
   60 NS = N*incX
      DO i = 1,NS,incX
        WDOT = WDOT + DX(i)*DY(i)
      END DO

      END FUNCTION WDOT


!--------------------------------------------------------------
      SUBROUTINE WADD(N,X,Y,Z)
!--------------------------------------------------------------
!     adds two vectors: z <- x + y
!     BLAS - like
!--------------------------------------------------------------
!     USE saprc99ros_Precision

      INTEGER :: i, M, MP1, N
      REAL(kind=dp) :: X(N),Y(N),Z(N)

      IF (N.LE.0) RETURN

      M = MOD(N,5)
      IF( M /= 0 ) THEN
         DO i = 1,M
            Z(i) = X(i) + Y(i)
         END DO
         IF( N < 5 ) RETURN
      END IF
      MP1 = M+1
      DO i = MP1,N,5
         Z(i)     = X(i)     + Y(i)
         Z(i + 1) = X(i + 1) + Y(i + 1)
         Z(i + 2) = X(i + 2) + Y(i + 2)
         Z(i + 3) = X(i + 3) + Y(i + 3)
         Z(i + 4) = X(i + 4) + Y(i + 4)
      END DO

      END SUBROUTINE WADD



!--------------------------------------------------------------
      SUBROUTINE WGEFA(N,A,Ipvt,info)
!--------------------------------------------------------------
!     WGEFA FACTORS THE MATRIX A (N,N) BY
!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!     LINPACK - LIKE
!--------------------------------------------------------------
!
      INTEGER       :: N,Ipvt(N),info
      REAL(kind=dp) :: A(N,N)
      REAL(kind=dp) :: t, dmax, da
      INTEGER       :: j,k,l
      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0

      info = 0

size: IF (n > 1) THEN

col:  DO k = 1, n-1

!        find l = pivot index
!        l = idamax(n-k+1,A(k,k),1) + k - 1
         l = k; dmax = abs(A(k,k))
         DO j = k+1,n
            da = ABS(A(j,k))
            IF (da > dmax) THEN
              l = j; dmax = da
            END IF
         END DO
         Ipvt(k) = l

!        zero pivot implies this column already triangularized
         IF (ABS(A(l,k)) < TINY(ZERO)) THEN
            info = k
            return
         ELSE
            IF (l /= k) THEN
               t = A(l,k); A(l,k) = A(k,k); A(k,k) = t
            END IF
            t = -ONE/A(k,k)
            CALL WSCAL(n-k,t,A(k+1,k),1)
            DO j = k+1, n
               t = A(l,j)
               IF (l /= k) THEN
                  A(l,j) = A(k,j); A(k,j) = t
               END IF
               CALL WAXPY(n-k,t,A(k+1,k),1,A(k+1,j),1)
            END DO
         END IF

       END DO col

      END IF size

      Ipvt(N) = N
      IF (ABS(A(N,N)) == ZERO) info = N

      END SUBROUTINE WGEFA


!--------------------------------------------------------------
      SUBROUTINE WGESL(Trans,N,A,Ipvt,b)
!--------------------------------------------------------------
!     WGESL solves the system
!     a * x = b  or  trans(a) * x = b
!     using the factors computed by WGEFA.
!
!     Trans      = 'N'   to solve  A*x = b ,
!                = 'T'   to solve  transpose(A)*x = b
!     LINPACK - LIKE
!--------------------------------------------------------------

      INTEGER       :: N,Ipvt(N)
      CHARACTER     :: trans
      REAL(kind=dp) :: A(N,N),b(N)
      REAL(kind=dp) :: t
      INTEGER       :: k,kb,l


      SELECT CASE (Trans)

      CASE ('n','N')  !  Solve  A * x = b

!        first solve  L*y = b
         IF (n >= 2) THEN
          DO k = 1, n-1
            l = Ipvt(k)
            t = b(l)
            IF (l /= k) THEN
               b(l) = b(k)
               b(k) = t
            END IF
            CALL WAXPY(n-k,t,a(k+1,k),1,b(k+1),1)
          END DO
         END IF
!        now solve  U*x = y
         DO kb = 1, n
            k = n + 1 - kb
            b(k) = b(k)/a(k,k)
            t = -b(k)
            CALL WAXPY(k-1,t,a(1,k),1,b(1),1)
         END DO

      CASE ('t','T')  !  Solve transpose(A) * x = b

!        first solve  trans(U)*y = b
         DO k = 1, n
            t = WDOT(k-1,a(1,k),1,b(1),1)
            b(k) = (b(k) - t)/a(k,k)
         END DO
!        now solve trans(L)*x = y
         IF (n >= 2) THEN
         DO kb = 1, n-1
            k = n - kb
            b(k) = b(k) + WDOT(n-k,a(k+1,k),1,b(k+1),1)
            l = Ipvt(k)
            IF (l /= k) THEN
               t = b(l); b(l) = b(k); b(k) = t
            END IF
         END DO
         END IF

      END SELECT

      END SUBROUTINE WGESL
! End of BLAS_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE saprc99ros_LinearAlgebra
