clear all
close all
clc

gf=1.0617; %growth factor
Na=6.022140857e23; %avagadro / molec mole-1
kb=1.38064852e-23; %boltzmann / J K-1
R=8.3144598; %gas constant / J K-1 mole-1
P=97500; %lab pressure / Pa
T=20+273.15; %flow tube temp / K
mole_air=P/R/T/1000; %mole L-1

m_ic=4
m_ca=76.6

m=m_ic+m_ca; %total mass / mg
m_wet=gf*m; %total humidified mass / mg
m_h2o=m_wet-m; %water mass / mg

M_ic=96.08;      % molar mass IC
M_ca=192.12;     % molar mass CA
M_h20=18.01528;  % molar mass water

n_ic=m_ic/1000./M_ic;     % moles IC
n_ca=m_ca/1000./M_ca;     % moles AC
n_h2o=m_h2o/1000./M_h20;  % moles water

f_ca=n_ca./(n_ic+n_ca);   
n=n_ic+n_ca+n_h2o;

den=0.9971+0.38804*f_ca+0.19537*f_ca.^2; %film density / g uL-1
V=m_wet./den; %film volume / uL
SA=188.49; %film surface area / cm2
q=1.5; %flow / L min-1
% 
ratio=1.7; %ratio between HO2 production and NO loss

ic=mean(n_ic./(V/1e6)); %average concentration / M or mole L-1
ca=mean(n_ca./(V/1e6));

ilen=100;       % length 
imin=-9;        % start point
imax=-2;        % finish point
i=10.^linspace(imin,imax,ilen)';
% i=10^-8;
%% Rate Coefficients
k_iIC3=5.33e9; % / M-1 s-1
k4=1e9; %radical and oxygen / M-1 s-1
k_IC=1e-3; % / s-1
k_IC3ca=90; % / M-1 s-1
k_iho2=0; % / M-1 s-1
k_Dho2=0; % / M-1 s-1
k_ho2ho2=8e5; % / M-1 s-1
k_rlx=6.5e5; % / s-1
% k_IC3o2=9.4e8; % / M-1 s-1
k_IC3o2=3e9; % / M-1 s-1
k_phot_h2o2=0
k5=0; % /M-1 s-1 HO2 + I-
k6=5e6; % /M-1 s-1 HO2 + I2- -> I2
k7=5e6; % /M-1 s-1 HO2 + I.
k8=1e5; % /M-1 s-1 HO2 + I2
k9=1.1e10; % /M-1 s-1 I. + I-
k10=1.9e10; % /M-1 s-1 I. + I. 
k11=8.4e9; % /M-1 s-1 I2- + I.
% k12=4e6; % /M-1 s-1 HO2 + I2- -> I2
k13=0.01

keff=[k_iIC3
k4
k_IC
k_IC3ca
k_iho2
k_Dho2
k_ho2ho2
k_rlx
k_IC3o2
k_phot_h2o2
k5
k6
k7
k8
k9
k10 
k11];

%%

o2=3.2e-3; %oxygen concentration, M

 % Steady state for triplet and ketyl radical
 
ic3=k_IC*ic./(k_rlx+k_iIC3.*i+ca*k_IC3ca+k_IC3o2*o2);
ich=(k_IC3ca*ca*ic3+k_iIC3*i.*ic3)./(k4*o2);

 % Diffusion coefficients
 
D=4.5e-12; %diffusion coefficient ho2 / m2 s-1
D2=2e-12; %diffusion coefficient i2 / m2 s-1
diff1=D/(3.4/1000000)^2; %diffusion rate constant / s-1
diff2=D2/(3.4/1000000)^2; %diffusion rate constant / s-1

%%

 % Set initial itetation parameters
 
options = optimoptions('fsolve','Display','iter-detailed','PlotFcn',@optimplotfirstorderopt);
% fun = @iodCalc;
x0 = [2.2e-7
    20.0965e-10
    3.5701e-10
    1.4e-3];


% sb0=iodCalc(x0,keff,i,ich,o2,ic3,diff1,diff2);

% x = fsolve(@(x) iodCalc(x,keff,i,ich,o2,ic3),x0,options)

 
X=zeros(length(x0),ilen);
j=1;
x = fsolve(@(x) iodCalc(x,keff,i(j),ich(j),o2,ic3(j),diff1,diff2),x0,options);
X(:,j)=x; 

 % Solve differential equations by iteration

for j=2:ilen
    x = fsolve(@(x) iodCalc(x,keff,i(j),ich(j),o2,ic3(j),diff1,diff2),x,options);
    X(:,j)=x; 
end  

% X(1,:)'
% X(2,:)'
% X(3,:)'
% X(4,:)'


%%

 % Definition of results from the iteration
 
ho2=X(1,:)'
ho2diff=ho2*diff1
X_rad=X(2,:)'
X2_neg=X(3,:)'
X2=X(4,:)'

 % Plots
 
c=log10(i);
ho2prod=(V/1000000)*Na*60*ho2diff/SA;

figure
plot(c,ho2prod,'x')
figure
subplot(2,2,1)
plot(c,ho2prod)
title('ho2')
subplot(2,2,2)
plot(c,X_rad)
title('Xrad')
subplot(2,2,3)
plot(c,X2_neg)
title('X2neg')
subplot(2,2,4)
plot(c,X2)
title('X2')


